/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.handler;

import com.google.common.collect.Lists;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.client.core.ClientAbstractions;
import fuzs.effectdescriptions.client.helper.EffectLinesHelper;
import fuzs.effectdescriptions.config.ClientConfig;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.client.screen.v2.ScreenTooltipFactory;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_8001;

public class InventoryTooltipHandler {
    public static EventResult onInventoryMobEffects(class_437 screen, int availableSpace, MutableBoolean smallWidgets, MutableInt horizontalOffset) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addDescriptionsToWidgetTooltips || ModLoaderEnvironment.INSTANCE.isModLoaded("jeed")) {
            return EventResult.PASS;
        }
        class_310 minecraft = ScreenHelper.INSTANCE.getMinecraft(screen);
        Collection activeEffects = minecraft.field_1724.method_6026();
        int verticalOffset = 33;
        if (activeEffects.size() > 5) {
            verticalOffset = 132 / (activeEffects.size() - 1);
        }
        int mouseX = ScreenHelper.INSTANCE.getMouseX(minecraft);
        int mouseY = ScreenHelper.INSTANCE.getMouseY(minecraft);
        int widgetWidth = !smallWidgets.getAsBoolean() ? 121 : 33;
        List<class_1293> filteredEffects = activeEffects.stream().filter(ClientAbstractions.INSTANCE::shouldRenderEffect).sorted().toList();
        if (mouseX >= horizontalOffset.getAsInt() && mouseX <= horizontalOffset.getAsInt() + widgetWidth) {
            int posY = ScreenHelper.INSTANCE.getTopPos((class_465)screen);
            class_1293 hovered = null;
            for (class_1293 mobEffectInstance : filteredEffects) {
                if (mouseY >= posY && mouseY <= posY + verticalOffset) {
                    hovered = mobEffectInstance;
                }
                posY += verticalOffset;
            }
            if (hovered != null) {
                ArrayList lines = Lists.newArrayList();
                EffectLinesHelper.tryAddDisplayName(lines, hovered, smallWidgets.getAsBoolean());
                EffectLinesHelper.getEffectDescriptionComponent(hovered.method_5586(), true).ifPresent(lines::add);
                EffectLinesHelper.tryAddAttributes(lines, hovered);
                EffectLinesHelper.tryAddInternalName(lines, hovered);
                EffectLinesHelper.tryAddModName(lines, hovered);
                if (!lines.isEmpty()) {
                    screen.method_47412(ScreenTooltipFactory.create((List)lines), class_8001.field_41687, true);
                }
            }
        }
        return EventResult.PASS;
    }
}

