/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class TankManipulationBehaviour
extends CapManipulationBehaviourBase<FluidVariant, TankManipulationBehaviour> {
    public static final BehaviourType<TankManipulationBehaviour> OBSERVE = new BehaviourType();
    private BehaviourType<TankManipulationBehaviour> behaviourType;

    public TankManipulationBehaviour(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(OBSERVE, be, target);
    }

    private TankManipulationBehaviour(BehaviourType<TankManipulationBehaviour> type, SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(be, target);
        this.behaviourType = type;
    }

    public FluidStack extractAny() {
        if (!this.hasInventory()) {
            return FluidStack.EMPTY;
        }
        Storage inventory = this.getInventory();
        Predicate<FluidStack> filterTest = this.getFilterTest((Predicate<FluidStack>)Predicates.alwaysTrue());
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : inventory) {
                if (view.isResourceBlank()) continue;
                FluidStack stack = new FluidStack(view);
                if (!filterTest.test(stack)) continue;
                long extracted = view.extract((Object)((FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)t);
                if (extracted == 0L) continue;
                if (!this.simulateNext) {
                    t.commit();
                }
                FluidStack fluidStack = stack.setAmount(extracted);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    protected Predicate<FluidStack> getFilterTest(Predicate<FluidStack> customFilter) {
        Predicate<FluidStack> test = customFilter;
        FilteringBehaviour filter = this.blockEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    protected StorageProvider<FluidVariant> getProvider(class_2338 pos, boolean bypassSided) {
        return bypassSided ? new UnsidedFluidStorageProvider(this.getWorld(), pos) : StorageProvider.createForFluids((class_1937)this.getWorld(), (class_2338)pos);
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    public static class UnsidedFluidStorageProvider
    extends CapManipulationBehaviourBase.UnsidedStorageProvider<FluidVariant> {
        protected UnsidedFluidStorageProvider(class_1937 level, class_2338 pos) {
            super(FluidStorage.SIDED, level, pos);
        }

        @Override
        @Nullable
        public Storage<FluidVariant> get() {
            return TransferUtil.getFluidStorage((class_1937)this.level, (class_2338)this.pos);
        }
    }
}

