/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.client.SchematicHotbarSlotOverlay;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.ToolSelectionScreen;
import com.simibubi.create.content.schematics.client.tools.ToolType;
import com.simibubi.create.content.schematics.packet.SchematicPlacePacket;
import com.simibubi.create.content.schematics.packet.SchematicSyncPacket;
import com.simibubi.create.foundation.outliner.AABBOutline;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5425;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class SchematicHandler {
    private String displayedSchematic;
    private SchematicTransformation transformation;
    private class_238 bounds;
    private boolean deployed;
    private boolean active;
    private ToolType currentTool;
    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private class_1799 activeSchematicItem;
    private AABBOutline outline;
    private Vector<SchematicRenderer> renderers = new Vector(3);
    private SchematicHotbarSlotOverlay overlay;
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        for (int i = 0; i < this.renderers.capacity(); ++i) {
            this.renderers.add(new SchematicRenderer());
        }
        this.overlay = new SchematicHotbarSlotOverlay();
        this.currentTool = ToolType.DEPLOY;
        this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        class_746 player;
        class_1799 stack;
        class_310 mc = class_310.method_1551();
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((class_1657)(player = mc.field_1724))) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((class_1657)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (!this.active || !stack.method_7969().method_10558("File").equals(this.displayedSchematic)) {
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        this.renderers.forEach(SchematicRenderer::tick);
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(class_746 player, class_1799 stack) {
        this.loadSettings(stack);
        this.displayedSchematic = stack.method_7969().method_10558("File");
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            ToolType toolBefore = this.currentTool;
            this.selectionScreen = new ToolSelectionScreen(ToolType.getTools(player.method_7337()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer() {
        class_638 clientWorld = class_310.method_1551().field_1687;
        class_3499 schematic = SchematicItem.loadSchematic((class_7871<class_2248>)clientWorld.method_45448(class_7924.field_41254), this.activeSchematicItem);
        class_2382 size = schematic.method_15160();
        if (size.equals((Object)class_2382.field_11176)) {
            return;
        }
        SchematicWorld w = new SchematicWorld((class_1937)clientWorld);
        SchematicWorld wMirroredFB = new SchematicWorld((class_1937)clientWorld);
        SchematicWorld wMirroredLR = new SchematicWorld((class_1937)clientWorld);
        class_3492 placementSettings = new class_3492();
        class_2338 pos = class_2338.field_10980;
        try {
            schematic.method_15172((class_5425)w, pos, pos, placementSettings, w.method_8409(), 2);
        }
        catch (Exception e) {
            class_310.method_1551().field_1724.method_7353((class_2561)Lang.translate("schematic.error", new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.method_15125(class_2415.field_11301);
        pos = class_2338.field_10980.method_10089(size.method_10263() - 1);
        schematic.method_15172((class_5425)wMirroredFB, pos, pos, placementSettings, wMirroredFB.method_8409(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.method_15134(), class_2350.class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        placementSettings.method_15125(class_2415.field_11300);
        pos = class_2338.field_10980.method_10077(size.method_10260() - 1);
        schematic.method_15172((class_5425)wMirroredLR, pos, pos, placementSettings, wMirroredFB.method_8409(), 2);
        transform = new StructureTransform(placementSettings.method_15134(), class_2350.class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.renderers.get(0).display(w);
        this.renderers.get(1).display(wMirroredFB);
        this.renderers.get(2).display(wMirroredLR);
    }

    public void render(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        boolean present;
        boolean bl = present = this.activeSchematicItem != null;
        if (!this.active && !present) {
            return;
        }
        if (this.active) {
            ms.method_22903();
            this.currentTool.getTool().renderTool(ms, buffer, camera);
            ms.method_22909();
        }
        ms.method_22903();
        this.transformation.applyTransformations(ms, camera);
        if (!this.renderers.isEmpty()) {
            boolean fb;
            float pt = AnimationTickHolder.getPartialTicks();
            boolean lr = this.transformation.getScaleLR().getValue(pt) < 0.0f;
            boolean bl2 = fb = this.transformation.getScaleFB().getValue(pt) < 0.0f;
            if (lr && !fb) {
                this.renderers.get(2).render(ms, buffer);
            } else if (fb && !lr) {
                this.renderers.get(1).render(ms, buffer);
            } else {
                this.renderers.get(0).render(ms, buffer);
            }
        }
        if (this.active) {
            this.currentTool.getTool().renderOnSchematic(ms, buffer);
        }
        ms.method_22909();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            renderer.update();
        }
    }

    public void renderOverlay(class_332 graphics, float partialTicks, class_1041 window) {
        if (class_310.method_1551().field_1690.field_1842 || !this.active) {
            return;
        }
        if (this.activeSchematicItem != null) {
            this.overlay.renderOn(graphics, this.activeHotbarSlot);
        }
        this.currentTool.getTool().renderOverlay(graphics, partialTicks, window.method_4486(), window.method_4502());
        this.selectionScreen.renderPassive(graphics, partialTicks);
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed || button != 1) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724.method_5715()) {
            return false;
        }
        if (mc.field_1765 instanceof class_3965) {
            class_3965 blockRayTraceResult = (class_3965)mc.field_1765;
            class_2680 clickedBlock = mc.field_1687.method_8320(blockRayTraceResult.method_17777());
            if (AllBlocks.SCHEMATICANNON.has(clickedBlock)) {
                return false;
            }
            if (AllBlocks.DEPLOYER.has(clickedBlock)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode()) {
            return;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.method_25419();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)delta);
            return true;
        }
        if (AllKeys.ctrlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private class_1799 findBlueprintInHand(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (!AllItems.SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.method_7985()) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.method_31548().field_7545;
        return stack;
    }

    private boolean itemLost(class_1657 player) {
        for (int i = 0; i < class_1661.method_7368(); ++i) {
            if (!class_1799.method_7973((class_1799)player.method_31548().method_5438(i), (class_1799)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        AllPackets.getChannel().sendToServer((C2SPacket)new SchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed));
    }

    public void equip(ToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(class_1799 blueprint) {
        class_2487 tag = blueprint.method_7969();
        class_2338 anchor = class_2338.field_10980;
        class_3492 settings = SchematicItem.getSettings(blueprint);
        this.transformation = new SchematicTransformation();
        this.deployed = tag.method_10577("Deployed");
        if (this.deployed) {
            anchor = class_2512.method_10691((class_2487)tag.method_10562("Anchor"));
        }
        class_2382 size = NBTHelper.readVec3i(tag.method_10554("Bounds", 3));
        this.bounds = new class_238(0.0, 0.0, 0.0, (double)size.method_10263(), (double)size.method_10264(), (double)size.method_10260());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(6850245).lineWidth(0.0625f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public void deploy() {
        if (!this.deployed) {
            List<ToolType> tools = ToolType.getTools(class_310.method_1551().field_1724.method_7337());
            this.selectionScreen = new ToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public void printInstantly() {
        AllPackets.getChannel().sendToServer((C2SPacket)new SchematicPlacePacket(this.activeSchematicItem.method_7972()));
        class_2487 nbt = this.activeSchematicItem.method_7969();
        nbt.method_10556("Deployed", false);
        this.activeSchematicItem.method_7980(nbt);
        SchematicInstances.clearHash(this.activeSchematicItem);
        this.renderers.forEach(r -> r.setActive(false));
        this.active = false;
        this.markDirty();
    }

    public boolean isActive() {
        return this.active;
    }

    public class_238 getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public class_1799 getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return this.outline;
    }
}

