/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class FilterItemStack {
    private class_1799 filterItemStack;
    private boolean fluidExtracted;
    private FluidStack filterFluidStack;

    public static FilterItemStack of(class_1799 filter) {
        if (filter.method_7985()) {
            if (AllItems.FILTER.isIn(filter)) {
                return new ListFilterItemStack(filter);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn(filter)) {
                return new AttributeFilterItemStack(filter);
            }
        }
        return new FilterItemStack(filter);
    }

    public static FilterItemStack of(class_2487 tag) {
        return FilterItemStack.of(class_1799.method_7915((class_2487)tag));
    }

    public static FilterItemStack empty() {
        return FilterItemStack.of(class_1799.field_8037);
    }

    public boolean isEmpty() {
        return this.filterItemStack.method_7960();
    }

    public class_2487 serializeNBT() {
        class_2487 ret = new class_2487();
        this.filterItemStack.method_7953(ret);
        return ret;
    }

    public class_1799 item() {
        return this.filterItemStack;
    }

    public FluidStack fluid(class_1937 level) {
        this.resolveFluid(level);
        return this.filterFluidStack;
    }

    public boolean isFilterItem() {
        return this.filterItemStack.method_7909() instanceof FilterItem;
    }

    public boolean test(class_1937 world, class_1799 stack) {
        return this.test(world, stack, false);
    }

    public boolean test(class_1937 world, FluidStack stack) {
        return this.test(world, stack, true);
    }

    public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        return FilterItem.testDirect(this.filterItemStack, stack, matchNBT);
    }

    public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        this.resolveFluid(world);
        if (this.filterFluidStack.isEmpty()) {
            return false;
        }
        if (!matchNBT) {
            return this.filterFluidStack.getFluid().method_15780(stack.getFluid());
        }
        return this.filterFluidStack.isFluidEqual(stack);
    }

    private void resolveFluid(class_1937 world) {
        if (!this.fluidExtracted) {
            this.fluidExtracted = true;
            if (GenericItemEmptying.canItemBeEmptied(world, this.filterItemStack)) {
                this.filterFluidStack = GenericItemEmptying.emptyItem(world, this.filterItemStack, true).getFirst();
            }
        }
    }

    protected FilterItemStack(class_1799 filter) {
        this.filterItemStack = filter;
        this.filterFluidStack = FluidStack.EMPTY;
        this.fluidExtracted = false;
    }

    public static class ListFilterItemStack
    extends FilterItemStack {
        public List<FilterItemStack> containedItems;
        public boolean shouldRespectNBT;
        public boolean isBlacklist;

        protected ListFilterItemStack(class_1799 filter) {
            super(filter);
            boolean defaults = !filter.method_7985();
            this.containedItems = new ArrayList<FilterItemStack>();
            ItemStackHandler items = FilterItem.getFilterItems(filter);
            for (int i = 0; i < items.getSlots().size(); ++i) {
                class_1799 stackInSlot = items.getStackInSlot(i);
                if (stackInSlot.method_7960()) continue;
                this.containedItems.add(FilterItemStack.of(stackInSlot));
            }
            this.shouldRespectNBT = !defaults ? false : filter.method_7969().method_10577("RespectNBT");
            this.isBlacklist = defaults ? false : filter.method_7969().method_10577("Blacklist");
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            if (this.containedItems.isEmpty()) {
                return super.test(world, stack, matchNBT);
            }
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }

    public static class AttributeFilterItemStack
    extends FilterItemStack {
        public WhitelistMode whitelistMode;
        public List<Pair<ItemAttribute, Boolean>> attributeTests;

        protected AttributeFilterItemStack(class_1799 filter) {
            super(filter);
            boolean defaults = !filter.method_7985();
            this.attributeTests = new ArrayList<Pair<ItemAttribute, Boolean>>();
            this.whitelistMode = WhitelistMode.values()[defaults ? 0 : filter.method_7969().method_10550("WhitelistMode")];
            class_2499 attributes = defaults ? new class_2499() : filter.method_7969().method_10554("MatchedAttributes", 10);
            for (class_2520 inbt : attributes) {
                class_2487 compound = (class_2487)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                this.attributeTests.add(Pair.of(attribute, compound.method_10577("Inverted")));
            }
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            return false;
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            if (this.attributeTests.isEmpty()) {
                return super.test(world, stack, matchNBT);
            }
            block15: for (Pair<ItemAttribute, Boolean> test : this.attributeTests) {
                boolean matches;
                ItemAttribute attribute = test.getFirst();
                boolean inverted = test.getSecond();
                boolean bl = matches = attribute.appliesTo(stack, world) != inverted;
                if (matches) {
                    switch (this.whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block15;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (this.whitelistMode) {
                    case BLACKLIST: {
                        continue block15;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                    case WHITELIST_DISJ: {
                        continue block15;
                    }
                }
            }
            switch (this.whitelistMode) {
                case BLACKLIST: {
                    return true;
                }
                case WHITELIST_CONJ: {
                    return true;
                }
                case WHITELIST_DISJ: {
                    return false;
                }
            }
            return false;
        }

        public static enum WhitelistMode {
            WHITELIST_DISJ,
            WHITELIST_CONJ,
            BLACKLIST;

        }
    }
}

