/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.content.contraptions.actors.psi.PortableFluidInterfaceBlockEntity;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class FluidNetwork {
    private static int CYCLES_PER_TICK = 16;
    class_1937 world;
    BlockFace start;
    Supplier<Storage<FluidVariant>> sourceSupplier;
    Storage<FluidVariant> source;
    int transferSpeed;
    int pauseBeforePropagation;
    List<BlockFace> queued;
    Set<Pair<BlockFace, PipeConnection>> frontier;
    Set<class_2338> visited;
    FluidStack fluid;
    List<Pair<BlockFace, Storage<FluidVariant>>> targets;
    Map<class_2338, WeakReference<FluidTransportBehaviour>> cache;

    public FluidNetwork(class_1937 world, BlockFace location, Supplier<Storage<FluidVariant>> sourceSupplier) {
        this.world = world;
        this.start = location;
        this.sourceSupplier = sourceSupplier;
        this.source = null;
        this.fluid = FluidStack.EMPTY;
        this.frontier = new HashSet<Pair<BlockFace, PipeConnection>>();
        this.visited = new HashSet<class_2338>();
        this.targets = new ArrayList<Pair<BlockFace, Storage<FluidVariant>>>();
        this.cache = new HashMap<class_2338, WeakReference<FluidTransportBehaviour>>();
        this.queued = new ArrayList<BlockFace>();
        this.reset();
    }

    public void tick() {
        if (this.pauseBeforePropagation > 0) {
            --this.pauseBeforePropagation;
            return;
        }
        for (int cycle = 0; cycle < CYCLES_PER_TICK; ++cycle) {
            boolean shouldContinue = false;
            Iterator<Pair> iterator = this.queued.iterator();
            while (iterator.hasNext()) {
                BlockFace blockFace = iterator.next();
                if (!this.isPresent(blockFace)) continue;
                PipeConnection pipeConnection = this.get(blockFace);
                if (pipeConnection != null) {
                    if (blockFace.equals(this.start)) {
                        this.transferSpeed = (int)Math.max(1.0f, pipeConnection.pressure.get(true).floatValue() / 2.0f) * 81;
                    }
                    this.frontier.add(Pair.of(blockFace, pipeConnection));
                }
                iterator.remove();
            }
            iterator = this.frontier.iterator();
            while (iterator.hasNext()) {
                Pair pair = iterator.next();
                BlockFace blockFace = (BlockFace)pair.getFirst();
                PipeConnection pipeConnection = (PipeConnection)pair.getSecond();
                if (!pipeConnection.hasFlow()) continue;
                PipeConnection.Flow flow = pipeConnection.flow.get();
                if (!this.fluid.isEmpty() && !flow.fluid.isFluidEqual(this.fluid)) {
                    iterator.remove();
                    continue;
                }
                if (!flow.inbound) {
                    if (!(pipeConnection.comparePressure() >= 0.0f)) continue;
                    iterator.remove();
                    continue;
                }
                if (!flow.complete) continue;
                if (this.fluid.isEmpty()) {
                    this.fluid = flow.fluid;
                }
                boolean canRemove = true;
                for (class_2350 side : Iterate.directions) {
                    BlockFace adjacentLocation;
                    PipeConnection adjacent;
                    if (side == blockFace.getFace() || (adjacent = this.get(adjacentLocation = new BlockFace(blockFace.getPos(), side))) == null) continue;
                    if (!adjacent.hasFlow()) {
                        if (!adjacent.hasPressure() || !(((Float)adjacent.pressure.getSecond()).floatValue() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    PipeConnection.Flow outFlow = adjacent.flow.get();
                    if (outFlow.inbound) {
                        if (!(adjacent.comparePressure() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    if (!outFlow.complete) {
                        canRemove = false;
                        continue;
                    }
                    if (!adjacent.source.isPresent() && !adjacent.determineSource(this.world, blockFace.getPos())) {
                        canRemove = false;
                        continue;
                    }
                    if (adjacent.source.isPresent() && adjacent.source.get().isEndpoint()) {
                        this.targets.add(Pair.of(adjacentLocation, adjacent.source.get().provideHandler()));
                        continue;
                    }
                    if (!this.visited.add(adjacentLocation.getConnectedPos())) continue;
                    this.queued.add(adjacentLocation.getOpposite());
                    shouldContinue = true;
                }
                if (!canRemove) continue;
                iterator.remove();
            }
            if (!shouldContinue) break;
        }
        if (this.source == null) {
            this.source = this.sourceSupplier.get();
        }
        if (this.source == null) {
            return;
        }
        this.keepPortableFluidInterfaceEngaged();
        if (this.targets.isEmpty()) {
            return;
        }
        for (Pair<BlockFace, Storage<FluidVariant>> pair : this.targets) {
            PipeConnection pipeConnection;
            if (pair.getSecond() != null && this.world.method_8510() % 40L != 0L || (pipeConnection = this.get(pair.getFirst())) == null) continue;
            pipeConnection.source.ifPresent(fs -> {
                if (fs.isEndpoint()) {
                    pair.setSecond(fs.provideHandler());
                }
            });
        }
        long flowSpeed = this.transferSpeed;
        try (Transaction t = TransferUtil.getTransaction();){
            Storage<FluidVariant> handler = this.source;
            if (handler == null) {
                return;
            }
            FluidStack transfer = FluidStack.EMPTY;
            long transferredAmount = 0L;
            try (Transaction test = t.openNested();){
                long extracted = handler.extract((Object)this.fluid.getType(), flowSpeed, (TransactionContext)test);
                if (extracted > 0L) {
                    transfer = new FluidStack(this.fluid.getType(), extracted);
                }
                if (transfer.isEmpty()) {
                    return;
                }
                test.abort();
            }
            ArrayList<Pair<BlockFace, Storage<FluidVariant>>> availableOutputs = new ArrayList<Pair<BlockFace, Storage<FluidVariant>>>(this.targets);
            block23: while (!availableOutputs.isEmpty() && transfer.getAmount() > 0L) {
                long dividedTransfer = transfer.getAmount() / (long)availableOutputs.size();
                long remainder = transfer.getAmount() % (long)availableOutputs.size();
                Iterator iterator = availableOutputs.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    long toTransfer = dividedTransfer;
                    if (remainder > 0L) {
                        ++toTransfer;
                        --remainder;
                    }
                    if (transfer.isEmpty()) continue block23;
                    Storage targetHandler = (Storage)pair.getSecond();
                    if (targetHandler == null) {
                        iterator.remove();
                        continue;
                    }
                    FluidStack divided = transfer.copy();
                    divided.setAmount(toTransfer);
                    long fill = targetHandler.insert((Object)divided.getType(), divided.getAmount(), (TransactionContext)t);
                    transfer.setAmount(transfer.getAmount() - fill);
                    transferredAmount += fill;
                    if (fill >= toTransfer) continue;
                    iterator.remove();
                }
            }
            try (Transaction extract = t.openNested();){
                handler.extract((Object)this.fluid.getType(), transferredAmount, (TransactionContext)extract);
                extract.commit();
            }
            t.commit();
        }
    }

    private void keepPortableFluidInterfaceEngaged() {
        Storage<FluidVariant> handler = this.source;
        if (!(handler instanceof PortableFluidInterfaceBlockEntity.InterfaceFluidHandler)) {
            return;
        }
        if (this.frontier.isEmpty()) {
            return;
        }
        ((PortableFluidInterfaceBlockEntity.InterfaceFluidHandler)handler).keepAlive();
    }

    public void reset() {
        this.frontier.clear();
        this.visited.clear();
        this.targets.clear();
        this.queued.clear();
        this.fluid = FluidStack.EMPTY;
        this.queued.add(this.start);
        this.pauseBeforePropagation = 2;
    }

    @Nullable
    private PipeConnection get(BlockFace location) {
        class_2338 pos = location.getPos();
        FluidTransportBehaviour fluidTransfer = this.getFluidTransfer(pos);
        if (fluidTransfer == null) {
            return null;
        }
        return fluidTransfer.getConnection(location.getFace());
    }

    private boolean isPresent(BlockFace location) {
        return this.world.method_8477(location.getPos());
    }

    @Nullable
    private FluidTransportBehaviour getFluidTransfer(class_2338 pos) {
        FluidTransportBehaviour behaviour;
        WeakReference<FluidTransportBehaviour> weakReference = this.cache.get(pos);
        FluidTransportBehaviour fluidTransportBehaviour = behaviour = weakReference != null ? (FluidTransportBehaviour)weakReference.get() : null;
        if (behaviour != null && behaviour.blockEntity.method_11015()) {
            behaviour = null;
        }
        if (behaviour == null && (behaviour = BlockEntityBehaviour.get((class_1922)this.world, pos, FluidTransportBehaviour.TYPE)) != null) {
            this.cache.put(pos, new WeakReference<FluidTransportBehaviour>(behaviour));
        }
        return behaviour;
    }
}

