/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.FluidTextUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public abstract class CreateRecipeCategory<T extends class_1860<?>>
implements IRecipeCategory<T> {
    private static final IDrawable BASIC_SLOT = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_SLOT);
    private static final IDrawable CHANCE_SLOT = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_CHANCE_SLOT);
    protected final RecipeType<T> type;
    protected final class_2561 title;
    protected final IDrawable background;
    protected final IDrawable icon;
    private final Supplier<List<T>> recipes;
    private final List<Supplier<? extends class_1799>> catalysts;

    public CreateRecipeCategory(Info<T> info) {
        this.type = info.recipeType();
        this.title = info.title();
        this.background = info.background();
        this.icon = info.icon();
        this.recipes = info.recipes();
        this.catalysts = info.catalysts();
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(this.type, this.recipes.get());
    }

    public void registerCatalysts(IRecipeCatalystRegistration registration) {
        this.catalysts.forEach(s -> registration.addRecipeCatalyst((class_1799)s.get(), new RecipeType[]{this.type}));
    }

    public static IDrawable getRenderedSlot() {
        return BASIC_SLOT;
    }

    public static IDrawable getRenderedSlot(ProcessingOutput output) {
        return CreateRecipeCategory.getRenderedSlot(output.getChance());
    }

    public static IDrawable getRenderedSlot(float chance) {
        if (chance == 1.0f) {
            return BASIC_SLOT;
        }
        return CHANCE_SLOT;
    }

    public static class_1799 getResultItem(class_1860<?> recipe) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(level.method_30349());
    }

    public static IRecipeSlotTooltipCallback addStochasticTooltip(ProcessingOutput output) {
        return (view, tooltip) -> {
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
            }
        };
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        long displayedAmount = (long)((float)stack.getAmount() * 0.75f) + 250L;
        display.setAmount(displayedAmount);
        return display;
    }

    public static FluidStack fromJei(IJeiFluidIngredient jei) {
        return new FluidStack(jei.getFluid(), jei.getAmount(), (class_2487)jei.getTag().orElse(null));
    }

    public static IJeiFluidIngredient toJei(final FluidStack stack) {
        return new IJeiFluidIngredient(){

            public class_3611 getFluid() {
                return stack.getFluid();
            }

            public long getAmount() {
                return stack.getAmount();
            }

            public Optional<class_2487> getTag() {
                return Optional.ofNullable(stack.getTag());
            }
        };
    }

    public static List<FluidStack> fromJei(List<IJeiFluidIngredient> stacks) {
        return stacks.stream().map(CreateRecipeCategory::fromJei).toList();
    }

    public static List<IJeiFluidIngredient> toJei(List<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::toJei).toList();
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip() {
        return CreateRecipeCategory.addFluidTooltip(-1L);
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(long mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)FabricTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = CreateRecipeCategory.fromJei((IJeiFluidIngredient)displayed.get());
            long amountToUse = mbAmount == -1L ? fluidStack.getAmount() : mbAmount;
            FluidUnit unit = (FluidUnit)AllConfigs.client().fluidUnitType.get();
            String amount = FluidTextUtil.getUnicodeMillibuckets((long)amountToUse, (FluidUnit)unit, (boolean)((Boolean)AllConfigs.client().simplifyFluidUnit.get()));
            class_5250 text = class_2561.method_43470((String)String.valueOf(amount)).method_10852((class_2561)Lang.translateDirect(unit.getTranslationKey(), new Object[0])).method_27692(class_124.field_1065);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                class_2561 name = (class_2561)tooltip.get(0);
                class_5250 nameWithAmount = name.method_27661().method_27693(" ").method_10852((class_2561)text);
                tooltip.set(0, nameWithAmount);
            }
        };
    }

    protected static IDrawable asDrawable(final AllGuiTextures texture) {
        return new IDrawable(){

            public int getWidth() {
                return texture.width;
            }

            public int getHeight() {
                return texture.height;
            }

            public void draw(class_332 graphics, int xOffset, int yOffset) {
                texture.render(graphics, xOffset, yOffset);
            }
        };
    }

    public record Info<T extends class_1860<?>>(RecipeType<T> recipeType, class_2561 title, IDrawable background, IDrawable icon, Supplier<List<T>> recipes, List<Supplier<? extends class_1799>> catalysts) {
    }

    public static interface Factory<T extends class_1860<?>> {
        public CreateRecipeCategory<T> create(Info<T> var1);
    }
}

