/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.reference.Resources;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_453;

public class BetterAdvancementTabType {
    public static final BetterAdvancementTabType ABOVE = new BetterAdvancementTabType(0, 0, 28, 32, class_453.field_2678);
    public static final BetterAdvancementTabType BELOW = new BetterAdvancementTabType(84, 0, 28, 32, class_453.field_2673);
    public static final BetterAdvancementTabType LEFT = new BetterAdvancementTabType(0, 64, 32, 28, class_453.field_2675);
    public static final BetterAdvancementTabType RIGHT = new BetterAdvancementTabType(96, 64, 32, 28, class_453.field_2677);
    public static final List<BetterAdvancementTabType> ALL = List.of(ABOVE, RIGHT, LEFT);
    public static boolean onlyUseAbove = false;
    private final int textureX;
    private final int textureY;
    private final int width;
    private final int height;
    private final class_453 tabType;

    public static BetterAdvancementTabType getTabType(int width, int height, int index) {
        int indexOnPage = index % BetterAdvancementTabType.getMaxTabs(width, height);
        int tabsAbove = ABOVE.getMax(width, height);
        int tabsRight = RIGHT.getMax(width, height);
        int tabsLeft = LEFT.getMax(width, height);
        if (indexOnPage < tabsAbove) {
            return ABOVE;
        }
        if (indexOnPage < tabsAbove + tabsRight) {
            return RIGHT;
        }
        if (indexOnPage < tabsAbove + tabsRight + tabsLeft) {
            return LEFT;
        }
        return null;
    }

    private BetterAdvancementTabType(int textureX, int textureY, int width, int height, class_453 tabType) {
        this.textureX = textureX;
        this.textureY = textureY;
        this.width = width;
        this.height = height;
        this.tabType = tabType;
    }

    public void draw(class_332 guiGraphics, int x, int y, int width, int height, boolean selected, int index) {
        int i = this.textureX;
        if ((index %= this.getMax(width, height)) > 0) {
            i += this.width;
        }
        if (x + this.width == width) {
            i += this.width;
        }
        int j = selected ? this.textureY + this.height : this.textureY;
        guiGraphics.method_25302(Resources.Gui.TABS, x + this.getX(index, width, height), y + this.getY(index, width, height), i, j, this.width, this.height);
    }

    public void drawIcon(class_332 guiGraphics, int left, int top, int width, int height, int index, class_1799 stack) {
        int i = left + this.getX(index, width, height);
        int j = top + this.getY(index, width, height);
        switch (this.tabType) {
            case field_2678: {
                i += 6;
                j += 9;
                break;
            }
            case field_2673: {
                i += 6;
                j += 6;
                break;
            }
            case field_2675: {
                i += 10;
                j += 5;
                break;
            }
            case field_2677: {
                i += 6;
                j += 5;
            }
        }
        guiGraphics.method_51445(stack, i, j);
    }

    public int getX(int index, int width, int height) {
        index %= this.getMax(width, height);
        return switch (this.tabType) {
            default -> throw new IncompatibleClassChangeError();
            case class_453.field_2678, class_453.field_2673 -> (this.width + 4) * index;
            case class_453.field_2675 -> -this.width + 4;
            case class_453.field_2677 -> width - 4;
        };
    }

    public int getY(int index, int width, int height) {
        index %= this.getMax(width, height);
        return switch (this.tabType) {
            default -> throw new IncompatibleClassChangeError();
            case class_453.field_2678 -> -this.height + 4;
            case class_453.field_2673 -> height - 4;
            case class_453.field_2675, class_453.field_2677 -> this.height * index;
        };
    }

    public boolean isMouseOver(int left, int top, int width, int height, int index, double mouseX, double mouseY) {
        int i = left + this.getX(index, width, height);
        int j = top + this.getY(index, width, height);
        return mouseX > (double)i && mouseX < (double)(i + this.width) && mouseY > (double)j && mouseY < (double)(j + this.height);
    }

    private int getMax(int width, int height) {
        return switch (this.tabType) {
            case class_453.field_2675, class_453.field_2677 -> height / 32;
            case class_453.field_2678, class_453.field_2673 -> width / 32;
            default -> this.tabType.method_2304();
        };
    }

    public static int getMaxTabs(int width, int height) {
        if (onlyUseAbove) {
            return ABOVE.getMax(width, height);
        }
        return ALL.stream().mapToInt(tab -> tab.getMax(width, height)).sum();
    }
}

