/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.mixin.plugin;

import dev.kikugie.elytratrims.common.ETReference;
import dev.kikugie.elytratrims.common.config.Tester;
import dev.kikugie.elytratrims.mixin.plugin.RequireMod;
import dev.kikugie.elytratrims.mixin.plugin.RequireTest;
import dev.kikugie.elytratrims.platform.ModStatus;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class ETMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.shouldApply(mixinClassName)) {
            return true;
        }
        String shortName = StringUtils.substringAfter((String)mixinClassName, (String)"mixin.");
        if (!shortName.startsWith("compat.")) {
            ETReference.LOGGER.info("Disabled mixin %s".formatted(shortName));
        }
        return false;
    }

    private boolean shouldApply(String mixin) {
        boolean modResult;
        AnnotationNode modRequirement = this.getAnnotation(mixin, RequireMod.class);
        boolean bl = modResult = modRequirement == null || ModStatus.INSTANCE.isLoaded((String)Annotations.getValue((AnnotationNode)modRequirement));
        if (!modResult) {
            return false;
        }
        AnnotationNode testerRequirement = this.getAnnotation(mixin, RequireTest.class);
        return testerRequirement == null || this.runTester((Type)Annotations.getValue((AnnotationNode)testerRequirement));
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean runTester(Type type) {
        try {
            return Tester.runTest(Class.forName(type.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private AnnotationNode getAnnotation(String className, Class<? extends Annotation> annotation) {
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
            return Annotations.getVisible((ClassNode)classNode, annotation);
        }
        catch (IOException | ClassNotFoundException e) {
            return null;
        }
    }
}

