/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_47;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class AnyStructure
implements IExtendedLootCondition {
    private final List<StructureLocator> structureLocators;
    private final boolean exact;

    public AnyStructure(List<StructureLocator> structureLocators, boolean exact) {
        this.structureLocators = structureLocators;
        this.exact = exact;
    }

    @Override
    public boolean test(class_47 context) {
        class_243 origin = (class_243)context.method_296(class_181.field_24424);
        if (origin != null) {
            class_2338 blockPos = new class_2338((int)origin.field_1352, (int)origin.field_1351, (int)origin.field_1350);
            class_5138 structureManager = context.method_299().method_27056();
            class_2378 registry = context.method_299().method_30349().method_30530(class_7924.field_41246);
            for (StructureLocator l : this.structureLocators) {
                class_3449 structureAt;
                class_3195 feature = l.getStructure((class_2378<class_3195>)registry, context.method_299(), blockPos);
                if (feature == null || !(structureAt = this.exact ? structureManager.method_38854(blockPos, feature) : structureManager.method_28388(blockPos, feature)).method_16657()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExact() {
        return this.exact;
    }

    public static interface StructureLocator {
        @Nullable
        public class_3195 getStructure(class_2378<class_3195> var1, class_3218 var2, class_2338 var3);
    }

    public static class Builder {
        private final List<class_5321<class_3195>> ids = new ArrayList<class_5321<class_3195>>();
        private final List<class_6862<class_3195>> tags = new ArrayList<class_6862<class_3195>>();

        public Builder add(String idOrTag) {
            if (idOrTag.startsWith("#")) {
                class_2960 rl = new class_2960(idOrTag.substring(1));
                this.tags.add((class_6862<class_3195>)class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)rl));
            } else {
                class_2960 rl = new class_2960(idOrTag);
                this.ids.add((class_5321<class_3195>)class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)rl));
            }
            return this;
        }

        public AnyStructure build(boolean exact) {
            ArrayList<StructureLocator> locators = new ArrayList<StructureLocator>();
            for (class_5321<class_3195> class_53212 : this.ids) {
                locators.add(new ById(class_53212));
            }
            for (class_6862 class_68622 : this.tags) {
                locators.add(new ByTag((class_6862<class_3195>)class_68622));
            }
            return new AnyStructure(locators, exact);
        }
    }

    public record ById(class_5321<class_3195> id) implements StructureLocator
    {
        @Override
        @Nullable
        public class_3195 getStructure(class_2378<class_3195> registry, class_3218 level, class_2338 pos) {
            return (class_3195)registry.method_29107(this.id);
        }
    }

    public record ByTag(class_6862<class_3195> tag) implements StructureLocator
    {
        @Override
        @Nullable
        public class_3195 getStructure(class_2378<class_3195> registry, class_3218 level, class_2338 pos) {
            return registry.method_40266(this.tag).map(h -> level.method_14178().method_12129().method_12103(level, (class_6885)h, pos, 1, false)).map(Pair::getSecond).map(class_6880::comp_349).orElse(null);
        }
    }
}

