/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.util.LootContextUtils;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class LootContextJS {
    protected final class_47 context;
    private final ILootContextData data;
    private BlockContainerJS cachedBlockContainer;

    public LootContextJS(class_47 context) {
        this.context = context;
        this.data = (ILootContextData)context.method_296(LootJSParamSets.DATA);
        assert (this.data != null);
    }

    public class_2960 getLootTableId() {
        return LootJSPlatform.INSTANCE.getQueriedLootTableId(this.context);
    }

    public LootContextType getType() {
        return this.data.getLootContextType();
    }

    public boolean isCanceled() {
        return this.data.isCanceled();
    }

    public void cancel() {
        this.data.setCanceled(true);
    }

    public Map<String, Object> getCustomData() {
        return this.data.getCustomData();
    }

    public class_243 getPosition() {
        class_243 vec = (class_243)this.context.method_296(class_181.field_24424);
        if (vec != null) {
            return vec;
        }
        class_1297 entity = (class_1297)this.context.method_296(class_181.field_1226);
        if (entity != null) {
            return entity.method_19538();
        }
        ConsoleJS.SERVER.warn((Object)"No position found. This should not happen");
        return class_243.field_1353;
    }

    public class_2338 getBlockPos() {
        class_243 position = this.getPosition();
        return new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350);
    }

    @Nullable
    public class_1297 getEntity() {
        return (class_1297)this.context.method_296(class_181.field_1226);
    }

    @Nullable
    public class_1297 getKillerEntity() {
        return (class_1297)this.context.method_296(class_181.field_1230);
    }

    @Nullable
    public class_3222 getPlayer() {
        return LootContextUtils.getPlayerOrNull(this.context);
    }

    @Nullable
    public class_1282 getDamageSource() {
        return (class_1282)this.context.method_296(class_181.field_1231);
    }

    public class_1799 getTool() {
        class_1799 tool = (class_1799)this.context.method_296(class_181.field_1229);
        if (tool == null) {
            return class_1799.field_8037;
        }
        return tool;
    }

    @Nullable
    public BlockContainerJS getDestroyedBlock() {
        if (this.cachedBlockContainer == null) {
            final class_2680 blockStateInContext = (class_2680)this.context.method_296(class_181.field_1224);
            if (blockStateInContext == null) {
                return null;
            }
            class_2338 blockPos = this.getBlockPos();
            this.cachedBlockContainer = new BlockContainerJS((class_1937)this.context.method_299(), blockPos){

                public class_2680 getBlockState() {
                    return blockStateInContext;
                }
            };
        }
        return this.cachedBlockContainer;
    }

    public boolean isExploded() {
        return this.context.method_300(class_181.field_1225);
    }

    public float getExplosionRadius() {
        Float f = (Float)this.context.method_296(class_181.field_1225);
        return f != null ? f.floatValue() : 0.0f;
    }

    public class_3218 getLevel() {
        return this.context.method_299();
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.getLevel().method_8503();
    }

    public float getLuck() {
        return this.context.method_302();
    }

    public int getLooting() {
        class_1297 killer = (class_1297)this.context.method_296(class_181.field_1230);
        if (killer instanceof class_1309) {
            class_1309 asLiving = (class_1309)killer;
            return class_1890.method_8226((class_1309)asLiving);
        }
        return 0;
    }

    public class_5819 getRandom() {
        return this.context.method_294();
    }

    public class_47 getVanillaContext() {
        return this.context;
    }

    public int lootSize() {
        return this.data.getGeneratedLoot().size();
    }

    public void addLoot(LootEntry lootEntry) {
        class_1799 item = lootEntry.createItem(this.context);
        if (item != null) {
            this.data.getGeneratedLoot().add(item);
        }
    }

    public void removeLoot(ItemFilter itemFilter) {
        this.data.getGeneratedLoot().removeIf(itemFilter);
    }

    public List<class_1799> findLoot(ItemFilter itemFilter) {
        return this.data.getGeneratedLoot().stream().filter(itemFilter).map(ItemStackJS::of).collect(Collectors.toList());
    }

    public List<class_1799> getLoot() {
        return this.data.getGeneratedLoot();
    }

    public boolean hasLoot(ItemFilter ingredient) {
        return !this.findLoot(ingredient).isEmpty();
    }

    public void forEachLoot(Consumer<class_1799> action) {
        this.data.getGeneratedLoot().forEach(itemStack -> action.accept(ItemStackJS.of((Object)itemStack)));
    }
}

