/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.relocated.jankson.impl.serializer;

import java.io.IOException;
import java.io.Writer;
import juuxel.adorn.relocated.jankson.JsonGrammar;

public class CommentSerializer {
    public static void print(Writer writer, String comment, int indent, JsonGrammar grammar) throws IOException {
        if (comment == null || comment.trim().isEmpty()) {
            return;
        }
        StringBuilder b = new StringBuilder(comment.length());
        CommentSerializer.print(b, comment, indent, grammar);
        writer.append(b);
    }

    public static void print(StringBuilder builder, String comment, int indent, JsonGrammar grammar) {
        boolean comments = grammar.hasComments();
        boolean whitespace = grammar.shouldOutputWhitespace();
        CommentSerializer.print(builder, comment, indent, comments, whitespace);
    }

    public static void print(StringBuilder builder, String comment, int indent, boolean comments, boolean whitespace) {
        if (!comments) {
            return;
        }
        if (comment == null || comment.trim().isEmpty()) {
            return;
        }
        if (whitespace) {
            if (comment.contains("\n")) {
                int i;
                builder.append("/* ");
                String[] lines = comment.split("\\n");
                for (i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (i != 0) {
                        builder.append("   ");
                    }
                    builder.append(line);
                    builder.append('\n');
                    for (int j = 0; j < indent + 1; ++j) {
                        builder.append('\t');
                    }
                }
                builder.append("*/\n");
                for (i = 0; i < indent + 1; ++i) {
                    builder.append('\t');
                }
            } else {
                builder.append("// ");
                builder.append(comment);
                builder.append('\n');
                for (int i = 0; i < indent + 1; ++i) {
                    builder.append('\t');
                }
            }
        } else if (comment.contains("\n")) {
            String[] lines = comment.split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                builder.append("/* ");
                builder.append(line);
                builder.append(" */ ");
            }
        } else {
            builder.append("/* ");
            builder.append(comment);
            builder.append(" */ ");
        }
    }
}

