/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.ImageManipulations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class ServerPaintingManager {
    public static MinecraftServer server;
    private static Map<class_2960, Painting> datapackPaintings;

    public static CustomServerPaintings get() {
        return (CustomServerPaintings)server.method_30002().method_17983().method_17924(CustomServerPaintings::fromNbt, CustomServerPaintings::new, "immersive_paintings");
    }

    public static Map<class_2960, Painting> getDatapackPaintings() {
        return datapackPaintings;
    }

    public static void setDatapackPaintings(Map<class_2960, Painting> datapackPaintings) {
        ServerPaintingManager.datapackPaintings = datapackPaintings;
    }

    public static Path getPaintingPath(class_2960 identifier) {
        return Path.of("immersive_paintings", identifier.toString().replace(":", "_") + ".png");
    }

    public static void registerPainting(class_2960 identifier, Painting painting) {
        Painting.Texture texture = painting.getTexture(Painting.Type.FULL);
        if (texture.image != null) {
            Path path = ServerPaintingManager.getPaintingPath(identifier);
            new File(path.getParent().toString()).mkdirs();
            texture.image.write(path.toFile());
        }
        ServerPaintingManager.get().getCustomServerPaintings().put(identifier, painting);
        ServerPaintingManager.get().method_78(true);
    }

    public static void deregisterPainting(class_2960 identifier) {
        ServerPaintingManager.get().getCustomServerPaintings().remove(identifier);
        ServerPaintingManager.get().method_78(true);
        ServerPaintingManager.getPaintingPath(identifier).toFile().delete();
    }

    public static Painting getPainting(class_2960 i) {
        if (datapackPaintings.containsKey(i)) {
            return datapackPaintings.get(i);
        }
        return ServerPaintingManager.get().customServerPaintings.getOrDefault(i, Painting.DEFAULT);
    }

    public static Optional<ByteImage> getImage(class_2960 i, Painting.Type type) {
        Optional<byte[]> data = ServerPaintingManager.getImageData(i, type);
        if (data.isPresent()) {
            try {
                return Optional.of(ByteImage.read(data.get()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<byte[]> getImageData(class_2960 i, Painting.Type type) {
        Painting painting = ServerPaintingManager.getPainting(i);
        Painting.Texture texture = painting.getTexture(type);
        byte[] data = null;
        if (type == Painting.Type.FULL) {
            if (texture.image == null) {
                try {
                    if (texture.resource != null) {
                        data = texture.getResource();
                        return Optional.ofNullable(data);
                    }
                    if (!ServerPaintingManager.get().customServerPaintings.containsKey(i)) return Optional.ofNullable(data);
                    try (FileInputStream stream = new FileInputStream(ServerPaintingManager.getPaintingPath(i).toString());){
                        data = stream.readAllBytes();
                        return Optional.ofNullable(data);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                data = texture.image.encode();
            }
            return Optional.ofNullable(data);
        } else {
            Optional<byte[]> imageData = Cache.getData(texture);
            if (imageData.isPresent()) {
                data = imageData.get();
                return Optional.ofNullable(data);
            } else {
                int h;
                int w;
                Optional<ByteImage> optionalByteImage = ServerPaintingManager.getImage(i, Painting.Type.FULL);
                if (!optionalByteImage.isPresent()) return Optional.ofNullable(data);
                ByteImage image = optionalByteImage.get();
                if (type == Painting.Type.THUMBNAIL) {
                    float zoom = Math.min((float)Config.getInstance().thumbnailSize / (float)image.getWidth(), (float)Config.getInstance().thumbnailSize / (float)image.getHeight());
                    if (zoom >= 1.0f) {
                        return ServerPaintingManager.getImageData(i, Painting.Type.FULL);
                    }
                    w = (int)((float)image.getWidth() * zoom);
                    h = (int)((float)image.getHeight() * zoom);
                } else if (type == Painting.Type.HALF) {
                    w = image.getWidth() / 2;
                    h = image.getHeight() / 2;
                } else if (type == Painting.Type.QUARTER) {
                    w = image.getWidth() / 4;
                    h = image.getHeight() / 4;
                } else {
                    w = image.getWidth() / 8;
                    h = image.getHeight() / 8;
                }
                ByteImage target = new ByteImage(w, h);
                ImageManipulations.resize(target, image, (double)image.getWidth() / (double)w, 0, 0);
                texture.image = target;
                data = texture.image.encode();
                Cache.set(texture, data);
            }
        }
        return Optional.ofNullable(data);
    }

    static {
        datapackPaintings = new HashMap<class_2960, Painting>();
    }

    public static class CustomServerPaintings
    extends class_18 {
        final Map<class_2960, Painting> customServerPaintings = new HashMap<class_2960, Painting>();

        public static CustomServerPaintings fromNbt(class_2487 nbt) {
            CustomServerPaintings c = new CustomServerPaintings();
            for (String key : nbt.method_10541()) {
                c.customServerPaintings.put(new class_2960(key), Painting.fromNbt(nbt.method_10562(key)));
            }
            return c;
        }

        public class_2487 method_75(class_2487 nbt) {
            class_2487 c = new class_2487();
            for (Map.Entry<class_2960, Painting> entry : this.customServerPaintings.entrySet()) {
                c.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().toNbt());
            }
            return c;
        }

        public Map<class_2960, Painting> getCustomServerPaintings() {
            return this.customServerPaintings;
        }
    }
}

