/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.compat;

import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.util.TriConsumer;

public class XercaPaintCompat {
    public static boolean interactWithPainting(ImmersivePaintingEntity painting, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (id.method_12836().equals("xercapaint")) {
            int w = 0;
            int h = 0;
            if (id.method_12832().equals("item_canvas")) {
                w = 16;
                h = 16;
            } else if (id.method_12832().equals("item_canvas_large")) {
                w = 32;
                h = 32;
            } else if (id.method_12832().equals("item_canvas_long")) {
                w = 32;
                h = 16;
            } else if (id.method_12832().equals("item_canvas_tall")) {
                w = 16;
                h = 32;
            }
            class_2487 nbt = stack.method_7969();
            if (w > 0 && nbt != null && nbt.method_10545("pixels")) {
                int[] pixels = nbt.method_10561("pixels");
                BufferedImage bufferedImage = new BufferedImage(w, h, 1);
                int x = 0;
                int y = 0;
                for (int n : pixels) {
                    bufferedImage.setRGB(x, y, n);
                    if (++x < w) continue;
                    x = 0;
                    ++y;
                }
                String title = nbt.method_10545("title") ? nbt.method_10558("title") : (nbt.method_10545("ip_title") ? nbt.method_10558("ip_title") : "Unnamed Painting #" + player.method_6051().method_43048(0x100000));
                nbt.method_10582("ip_title", title);
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", stream);
                    Utils.processByteArrayInChunks(stream.toByteArray(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(title, new Painting(null, w / 16, h / 16, 16, false, false)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String name = Utils.escapeString(player.method_7334().getName()) + "/" + Utils.escapeString(title);
                class_2960 identifier = Main.locate(name);
                painting.setMotive(identifier);
                LazyNetworkManager.sendToServer(new PaintingModifyRequest(painting));
                return true;
            }
        }
        return false;
    }
}

