/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.tom.storagemod.Content;
import com.tom.storagemod.gui.CraftingTerminalMenu;
import com.tom.storagemod.jei.PlatformRecipeTransferHandler;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.StoredItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler<C extends class_1703>
implements PlatformRecipeTransferHandler<C> {
    private final Class<C> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    private static final List<Class<? extends class_1703>> containerClasses = new ArrayList<Class<? extends class_1703>>();
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }
    };

    public CraftingTerminalTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, class_3955 recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IAutoFillTerminal) {
            class_2499 list;
            IAutoFillTerminal term = (IAutoFillTerminal)container;
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList<class_2499> inputs = new ArrayList<class_2499>();
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                list = (class_2499)view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toArray(class_1799[]::new);
                if (((class_2499)list).length == 0) {
                    inputs.add(null);
                    continue;
                }
                inputs.add(list);
                boolean found = false;
                for (class_2499 stack : list) {
                    if (stack == null || player.method_31548().method_7395((class_1799)stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (class_2499 stack : list) {
                        StoredItemStack s = new StoredItemStack((class_1799)stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer) {
                class_1799[][] stacks = (class_1799[][])inputs.toArray((T[])new class_1799[0][]);
                class_2487 compound = new class_2487();
                list = new class_2499();
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i] == null) continue;
                    class_2487 CompoundNBT = new class_2487();
                    CompoundNBT.method_10567("s", (byte)i);
                    int k = 0;
                    for (int j = 0; j < stacks[i].length && k < 9; ++j) {
                        StoredItemStack s;
                        if (stacks[i][j] == null || stacks[i][j].method_7960() || !stored.contains(s = new StoredItemStack(stacks[i][j])) && player.method_31548().method_7395(stacks[i][j]) == -1) continue;
                        class_2487 tag = new class_2487();
                        stacks[i][j].method_7953(tag);
                        CompoundNBT.method_10566("i" + k++, (class_2520)tag);
                    }
                    CompoundNBT.method_10567("l", (byte)Math.min(9, k));
                    list.add((Object)CompoundNBT);
                }
                compound.method_10566("i", (class_2520)list);
                term.sendMessage(compound);
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.helper.createUserErrorForMissingSlots((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.items_missing"), missing));
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (int i = 0; i < containerClasses.size(); ++i) {
            recipeTransferRegistry.addRecipeTransferHandler(new CraftingTerminalTransferHandler<class_1703>(containerClasses.get(i), recipeTransferRegistry.getTransferHelper()), RecipeTypes.CRAFTING);
        }
    }

    public Optional<class_3917<C>> getMenuType() {
        return Optional.ofNullable(Content.craftingTerminalCont.get());
    }

    static {
        containerClasses.add(CraftingTerminalMenu.class);
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(class_332 guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
            this.parent.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeX, recipeY);
        }
    }
}

