/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawGenerator;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6017;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import org.jetbrains.annotations.NotNull;

public class AlternateJigsawStructure
extends class_3195 {
    public static final Codec<AlternateJigsawStructure> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)AlternateJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(AlternateJigsawStructure::startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(AlternateJigsawStructure::startJigsawName), (App)class_6017.method_35004((int)0, (int)20).fieldOf("size").forGetter(AlternateJigsawStructure::size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(AlternateJigsawStructure::startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(AlternateJigsawStructure::useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(AlternateJigsawStructure::projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(AlternateJigsawStructure::maxDistanceFromCenter)).apply((Applicative)instance, AlternateJigsawStructure::new)), AlternateJigsawStructure::validate).codec();
    public static final class_7151<AlternateJigsawStructure> ALTERNATE_JIGSAW_TYPE = () -> CODEC;
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final class_6017 size;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<AlternateJigsawStructure> validate(AlternateJigsawStructure structure) {
        int i = switch (structure.method_42701()) {
            default -> throw new IncompatibleClassChangeError();
            case class_5847.field_28922 -> 0;
            case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432 -> 12;
        };
        return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    protected AlternateJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, class_6017 size, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public class_6880<class_3785> startPool() {
        return this.startPool;
    }

    public Optional<class_2960> startJigsawName() {
        return this.startJigsawName;
    }

    public class_6017 size() {
        return this.size;
    }

    public class_6122 startHeight() {
        return this.startHeight;
    }

    public boolean useExpansionHack() {
        return this.useExpansionHack;
    }

    public Optional<class_2902.class_2903> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public int maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        return AlternateJigsawGenerator.generate(context, this.startPool, this.startJigsawName, this.size.method_35008((class_5819)context.comp_566()), blockPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    @NotNull
    public class_7151<?> method_41618() {
        return ALTERNATE_JIGSAW_TYPE;
    }
}

