/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class ReplaceEffectsModifier
extends Modifier {
    public static final Codec<ReplaceEffectsModifier> CODEC = RecordCodecBuilder.create(instance -> ReplaceEffectsModifier.addModifierFields(instance).and(instance.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ReplaceEffectsModifier::biomes), (App)ModdedBiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsModifier::effects))).apply((Applicative)instance, ReplaceEffectsModifier::new));
    private final class_6885<class_1959> biomes;
    private final ModdedBiomeEffects effects;

    public ReplaceEffectsModifier(ModifierPredicate predicate, class_6885<class_1959> biomes, ModdedBiomeEffects effects) {
        super(predicate, Modifier.ModifierPhase.MODIFY);
        this.biomes = biomes;
        this.effects = effects;
    }

    public class_6885<class_1959> biomes() {
        return this.biomes;
    }

    public ModdedBiomeEffects effects() {
        return this.effects;
    }

    public void applyModifier(class_1959 biome) {
        class_4967 ambientAdditionsSettings;
        class_4968 ambientMoodSettings;
        class_6880<class_3414> ambientLoopSound;
        class_4761 ambientParticleSettings;
        Integer foliageColorOverride;
        class_4763 originalEffects = ((BiomeAccessor)biome).getSpecialEffects();
        class_4763.class_4764 mergedEffectsBuilder = new class_4763.class_4764().method_30820(this.effects().skyColor().orElse(originalEffects.method_30810()).intValue()).method_24392(this.effects().fogColor().orElse(originalEffects.method_24387()).intValue()).method_24395(this.effects().waterColor().orElse(originalEffects.method_24388()).intValue()).method_24397(this.effects().waterFogColor().orElse(originalEffects.method_24389()).intValue()).method_30818(this.effects().grassColorModifier().orElse(originalEffects.method_30814())).method_27346(this.effects().backgroundMusic().orElse(originalEffects.method_27345().orElse(null)));
        Integer grassColorOverride = this.effects.grassColorOverride().orElse(originalEffects.method_30812().orElse(null));
        if (grassColorOverride != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_30822(grassColorOverride.intValue());
        }
        if ((foliageColorOverride = this.effects.foliageColorOverride().orElse(originalEffects.method_30811().orElse(null))) != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_30821(foliageColorOverride.intValue());
        }
        if ((ambientParticleSettings = this.effects.ambientParticleSettings().orElse(originalEffects.method_24390().orElse(null))) != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_24393(ambientParticleSettings);
        }
        if ((ambientLoopSound = this.effects.ambientLoopSoundEvent().orElse((class_6880<class_3414>)((class_6880)originalEffects.method_24939().orElse(null)))) != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_24942(ambientLoopSound);
        }
        if ((ambientMoodSettings = this.effects.ambientMoodSettings().orElse(originalEffects.method_24940().orElse(null))) != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_24943(ambientMoodSettings);
        }
        if ((ambientAdditionsSettings = this.effects.ambientAdditionsSettings().orElse(originalEffects.method_24941().orElse(null))) != null) {
            mergedEffectsBuilder = mergedEffectsBuilder.method_24944(ambientAdditionsSettings);
        }
        ((BiomeAccessor)biome).setSpecialEffects(mergedEffectsBuilder.method_24391());
    }

    @Override
    public void applyModifier() {
        List biomes = this.biomes().method_40239().toList();
        for (class_6880 entry : biomes.stream().toList()) {
            this.applyModifier((class_1959)entry.comp_349());
        }
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    private record ModdedBiomeEffects(Optional<Integer> skyColor, Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<class_4763.class_5486> grassColorModifier, Optional<class_4761> ambientParticleSettings, Optional<class_6880<class_3414>> ambientLoopSoundEvent, Optional<class_4968> ambientMoodSettings, Optional<class_4967> ambientAdditionsSettings, Optional<class_5195> backgroundMusic) {
        public static final Codec<ModdedBiomeEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("sky_color").forGetter(ModdedBiomeEffects::skyColor), (App)Codec.INT.optionalFieldOf("fog_color").forGetter(ModdedBiomeEffects::fogColor), (App)Codec.INT.optionalFieldOf("water_color").forGetter(ModdedBiomeEffects::waterColor), (App)Codec.INT.optionalFieldOf("water_fog_color").forGetter(ModdedBiomeEffects::waterFogColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(ModdedBiomeEffects::foliageColorOverride), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(ModdedBiomeEffects::grassColorOverride), (App)class_4763.class_5486.field_26429.optionalFieldOf("grass_color_modifier").forGetter(ModdedBiomeEffects::grassColorModifier), (App)class_4761.field_24675.optionalFieldOf("particle").forGetter(ModdedBiomeEffects::ambientParticleSettings), (App)class_3414.field_41699.optionalFieldOf("ambient_sound").forGetter(ModdedBiomeEffects::ambientLoopSoundEvent), (App)class_4968.field_24674.optionalFieldOf("mood_sound").forGetter(ModdedBiomeEffects::ambientMoodSettings), (App)class_4967.field_24673.optionalFieldOf("additions_sound").forGetter(ModdedBiomeEffects::ambientAdditionsSettings), (App)class_5195.field_24627.optionalFieldOf("music").forGetter(ModdedBiomeEffects::backgroundMusic)).apply((Applicative)instance, ModdedBiomeEffects::new));
    }
}

