/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class RemoveStructuresFromStructureSetModifier
extends Modifier {
    public static final Codec<RemoveStructuresFromStructureSetModifier> CODEC = RecordCodecBuilder.create(instance -> RemoveStructuresFromStructureSetModifier.addModifierFields(instance).and(instance.group((App)class_2960.field_25139.fieldOf("structure_set").forGetter(RemoveStructuresFromStructureSetModifier::rawStructureSetLocation), (App)class_3195.field_37745.listOf().fieldOf("structures").forGetter(RemoveStructuresFromStructureSetModifier::entries), (App)class_6903.method_46636((class_5321)class_7924.field_41248))).apply((Applicative)instance, RemoveStructuresFromStructureSetModifier::new));
    private final class_5321<class_7059> EMPTY_STRUCTURE_SET = class_5321.method_29179((class_5321)class_7924.field_41248, (class_2960)new class_2960("lithostitched", "empty"));
    private final class_2960 rawStructureSetLocation;
    private final class_6880<class_7059> structureSet;
    private final List<class_6880<class_3195>> entries;

    public RemoveStructuresFromStructureSetModifier(ModifierPredicate predicate, class_2960 rawStructureSetLocation, List<class_6880<class_3195>> entries, class_7871<class_7059> getter) {
        super(predicate, Modifier.ModifierPhase.REMOVE);
        this.rawStructureSetLocation = rawStructureSetLocation;
        Optional structureSetEntry = getter.method_46746(predicate.test() ? class_5321.method_29179((class_5321)class_7924.field_41248, (class_2960)rawStructureSetLocation) : this.EMPTY_STRUCTURE_SET);
        this.structureSet = (class_6880)structureSetEntry.get();
        this.entries = entries;
    }

    public class_2960 rawStructureSetLocation() {
        return this.rawStructureSetLocation;
    }

    public class_6880<class_7059> structureSet() {
        return this.structureSet;
    }

    public List<class_6880<class_3195>> entries() {
        return this.entries;
    }

    @Override
    public void applyModifier() {
        if (this.structureSet.method_40225(this.EMPTY_STRUCTURE_SET)) {
            return;
        }
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)this.structureSet().comp_349();
        ArrayList structureSelectionEntries = new ArrayList(((class_7059)this.structureSet().comp_349()).comp_510());
        structureSetAccessor.setStructures(structureSelectionEntries.stream().filter(setEntry -> !this.entries.contains(setEntry.comp_512())).collect(Collectors.toList()));
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

