/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.displaystate.AgingDisplayState;
import net.darkhax.botanypots.data.displaystate.DisplayStateSerializer;
import net.darkhax.botanypots.data.displaystate.SimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.TransitionalDisplayState;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public abstract class DisplayState {
    private static final Map<class_2960, ISerializer<? extends DisplayState>> DISPLAY_TYPES = new HashMap<class_2960, ISerializer<? extends DisplayState>>();
    public static final ISerializer<DisplayState> SERIALIZER = new Serializer();

    @Nullable
    public static ISerializer<? extends DisplayState> getSerializer(class_2960 id) {
        return DISPLAY_TYPES.get(id);
    }

    public abstract DisplayStateSerializer<?> getSerializer();

    public static void init() {
        DISPLAY_TYPES.put(SimpleDisplayState.ID, SimpleDisplayState.SERIALIZER);
        DISPLAY_TYPES.put(TransitionalDisplayState.ID, TransitionalDisplayState.SERIALIZER);
        DISPLAY_TYPES.put(AgingDisplayState.ID, AgingDisplayState.SERIALIZER);
    }

    public static class Serializer
    implements ISerializer<DisplayState> {
        public DisplayState fromJSON(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                class_2960 id = (class_2960)Serializers.RESOURCE_LOCATION.fromJSON(obj, "type", (Object)SimpleDisplayState.ID);
                ISerializer<? extends DisplayState> serializer = DISPLAY_TYPES.get(id);
                if (serializer != null) {
                    return (DisplayState)serializer.fromJSON(json);
                }
                throw new JsonParseException("The serializer " + id.toString() + " is unknown.");
            }
            throw new JsonParseException("Expected display state to be a JSON object.");
        }

        public JsonElement toJSON(DisplayState toWrite) {
            JsonElement jsonElement = toWrite.getSerializer().toJSON(toWrite);
            if (jsonElement instanceof JsonObject) {
                JsonObject obj = (JsonObject)jsonElement;
                Serializers.RESOURCE_LOCATION.toJSON(obj, "type", (Object)toWrite.getSerializer().getId());
            }
            return toWrite.getSerializer().toJSON(toWrite);
        }

        public DisplayState fromByteBuf(class_2540 buffer) {
            class_2960 id = (class_2960)Serializers.RESOURCE_LOCATION.fromByteBuf(buffer);
            ISerializer<? extends DisplayState> serializer = DISPLAY_TYPES.get(id);
            if (serializer != null) {
                return (DisplayState)serializer.fromByteBuf(buffer);
            }
            throw new JsonParseException("The serializer " + id.toString() + " is unknown.");
        }

        public void toByteBuf(class_2540 buffer, DisplayState toWrite) {
            Serializers.RESOURCE_LOCATION.toByteBuf(buffer, (Object)toWrite.getSerializer().getId());
            toWrite.getSerializer().toByteBuf(buffer, toWrite);
        }

        public class_2520 toNBT(DisplayState toWrite) {
            return null;
        }

        public DisplayState fromNBT(class_2520 nbt) {
            return null;
        }
    }
}

