/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.darkhax.botanypots.Constants;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BotanyPotVariantGenerator {
    public static File blockDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/models/block");
    public static File itemDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/models/item");
    public static File stateDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/blockstates");
    public static File lootDir = BotanyPotVariantGenerator.makeDir("data/botanypots/loot_tables/blocks");
    public static File craftingDir = BotanyPotVariantGenerator.makeDir("data/botanypots/recipes/crafting");

    public static void generate() {
        BotanyPotVariantGenerator.generatePot(class_2246.field_10415);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10611);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10184);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10015);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10325);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10143);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10014);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10444);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10349);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10590);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10235);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10570);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10409);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10123);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10526);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10328);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10626);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10595);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10280);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10538);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10345);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10096);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10046);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10567);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10220);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10052);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10078);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10426);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10550);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10004);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10475);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10383);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10501);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10107);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10210);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10585);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10242);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10542);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10421);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10434);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10038);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10172);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10308);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10206);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10011);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10439);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10367);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10058);
        BotanyPotVariantGenerator.generatePot(class_2246.field_10458);
    }

    public static void generatePot(class_2248 block) {
        try {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            Constants.LOG.info("botanypots:" + blockId.method_12832() + "_botany_pot");
            Constants.LOG.info("botanypots:" + blockId.method_12832() + "_hopper_botany_pot");
            BotanyPotVariantGenerator.generateBlockState(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateBlockModel(blockId, "botany_pot", false);
            BotanyPotVariantGenerator.generateItemModel(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateLootTable(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateBasicCrafting(blockId);
            BotanyPotVariantGenerator.generateBlockState(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateBlockModel(blockId, "hopper_botany_pot", true);
            BotanyPotVariantGenerator.generateItemModel(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateLootTable(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateHopperCrafting(blockId);
            BotanyPotVariantGenerator.generateCompactHopperCrafting(blockId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateCompactHopperCrafting(class_2960 blockId) throws IOException {
        String potId = "botanypots:" + blockId.method_12832() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.method_12832() + "_compact_hopper_botany_pot.json"));){
            writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SHS\",\n        \"SPS\",\n        \" S \"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateHopperCrafting(class_2960 blockId) throws IOException {
        String potId = "botanypots:" + blockId.method_12832() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.method_12832() + "_hopper_botany_pot.json"));){
            writer.append("{\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"ingredients\": [\n        {\n            \"item\": \"botanypots:" + blockId.method_12832() + "_botany_pot\"\n        },\n        {\n            \"item\": \"minecraft:hopper\"\n        }\n    ],\n    \"result\": {\n        \"item\": \"" + potId + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateBasicCrafting(class_2960 blockId) throws IOException {
        String potId = "botanypots:" + blockId.method_12832() + "_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.method_12832() + "_botany_pot.json"));){
            writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"S S\",\n        \"SPS\",\n        \" S \"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateLootTable(class_2960 blockId, String suffix) throws IOException {
        String potId = blockId.method_12832() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(lootDir, potId + ".json"));){
            writer.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:copy_name\",\n              \"source\": \"block_entity\"\n            }\n          ],\n          \"name\": \"botanypots:" + potId + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
        }
    }

    public static void generateBlockState(class_2960 blockId, String suffix) throws IOException {
        String potId = blockId.method_12832() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(stateDir, potId + ".json"));){
            writer.append("{\n    \"variants\": {\n        \"\": {\n            \"model\": \"botanypots:block/" + potId + "\"\n        }\n    }\n}");
        }
    }

    public static void generateItemModel(class_2960 blockId, String suffix) throws IOException {
        String potId = blockId.method_12832() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(itemDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypots:block/" + potId + "\"\n}");
        }
    }

    public static void generateBlockModel(class_2960 blockId, String suffix, boolean hopper) throws IOException {
        String potId = blockId.method_12832() + "_" + suffix;
        String parent = hopper ? "hopper_botany_pot_base" : "botany_pot_base";
        try (FileWriter writer = new FileWriter(new File(blockDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypots:block/" + parent + "\",\n    \"textures\": {\n        \"terracotta\": \"minecraft:block/" + blockId.method_12832() + "\",\n        \"particle\": \"minecraft:block/" + blockId.method_12832() + "\"\n    }\n}");
        }
    }

    private static File makeDir(String path) {
        File dir = new File(new File("datagen_out"), path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

