declare class BlockPos extends Vec3i {
    constructor($$0: Vec3i_)
    constructor($$0: number, $$1: number, $$2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset($$0: number, $$1: number, $$2: number): this;
    offset($$0: Vec3i_): this;
    static getY($$0: number): number;
    static betweenClosed($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Iterable<BlockPos>;
    static betweenClosedStream($$0: BlockPos_, $$1: BlockPos_): Internal.Stream<BlockPos>;
    multiply($$0: number): this;
    asLong(): number;
    static offset($$0: number, $$1: number, $$2: number, $$3: number): number;
    west(): this;
    static spiralAround($$0: BlockPos_, $$1: number, $$2: Internal.Direction_, $$3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    west(distance: number): this;
    south(distance: number): this;
    below(distance: number): this;
    static betweenClosedStream($$0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative($$0: Internal.Direction_): this;
    static randomInCube($$0: Internal.RandomSource_, $$1: number, $$2: BlockPos_, $$3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal($$0: BlockPos_, $$1: number, $$2: number, $$3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, $$4: Internal.Predicate_<BlockPos>): number;
    static betweenClosed($$0: BlockPos_, $$1: BlockPos_): Internal.Iterable<BlockPos>;
    static offset($$0: number, $$1: Internal.Direction_): number;
    getCenter(): Vec3d;
    static containing($$0: Internal.Position_): BlockPos;
    cross($$0: Vec3i_): this;
    east(distance: number): this;
    above(distance: number): this;
    static getX($$0: number): number;
    below(): this;
    east(): this;
    static getZ($$0: number): number;
    static findClosestMatch($$0: BlockPos_, $$1: number, $$2: number, $$3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    north(distance: number): this;
    atY($$0: number): this;
    rotate($$0: Internal.Rotation_): this;
    relative($$0: Internal.Direction_, $$1: number): this;
    static betweenClosedStream($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Stream<BlockPos>;
    static randomBetweenClosed($$0: Internal.RandomSource_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): Internal.Iterable<BlockPos>;
    north(): this;
    static withinManhattanStream($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    static asLong($$0: number, $$1: number, $$2: number): number;
    static getFlatIndex($$0: number): number;
    static of($$0: number): BlockPos;
    /**
     * @deprecated
    */
    static squareOutSouthEast($$0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Iterable<BlockPos>;
    static containing($$0: number, $$1: number, $$2: number): BlockPos;
    static betweenClosedStream($$0: Internal.AABB_): Internal.Stream<BlockPos>;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    subtract($$0: Vec3i_): this;
    get center(): Vec3d
    static readonly PACKED_Y_LENGTH: 12;
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: BlockPos;
}
type BlockPos_ = BlockPos;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    asRuleTest(): Internal.RuleTest;
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: ResourceLocation;
}
type BlockStatePredicate_ = RegExp | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
}
type Block_ = Block;
declare class PonderPointing extends Internal.Enum<PonderPointing> implements Internal.StringRepresentable {
    static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
    static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
    static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
    getSerializedName(): string;
    static valueOf(name: string): PonderPointing;
    getXRotation(): number;
    getCombinedDirection(direction: Internal.Direction_): Internal.Direction;
    static values(): PonderPointing[];
    get serializedName(): string
    get XRotation(): number
    static readonly LEFT: PonderPointing;
    static readonly RIGHT: PonderPointing;
    static readonly UP: PonderPointing;
    static readonly DOWN: PonderPointing;
}
type PonderPointing_ = "up" | "down" | PonderPointing | "right" | "left";
declare class Vec3d implements Internal.Position {
    constructor($$0: number, $$1: number, $$2: number)
    constructor($$0: Vec3f_)
    get($$0: Internal.Direction$Axis_): number;
    normalize(): this;
    horizontalDistance(): number;
    lerp($$0: Vec3d_, $$1: number): this;
    lengthSqr(): number;
    distanceToSqr($$0: Vec3d_): number;
    relative($$0: Internal.Direction_, $$1: number): this;
    add($$0: number, $$1: number, $$2: number): this;
    static directionFromRotation($$0: Internal.Vec2_): Vec3d;
    static atCenterOf($$0: Vec3i_): Vec3d;
    cross($$0: Vec3d_): this;
    add($$0: Vec3d_): this;
    yRot($$0: number): this;
    z(): number;
    "with"($$0: Internal.Direction$Axis_, $$1: number): this;
    static atBottomCenterOf($$0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    xRot($$0: number): this;
    dot($$0: Vec3d_): number;
    multiply($$0: number, $$1: number, $$2: number): this;
    y(): number;
    align($$0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    x(): number;
    closerThan($$0: Internal.Position_, $$1: number): boolean;
    offsetRandom($$0: Internal.RandomSource_, $$1: number): this;
    vectorTo($$0: Vec3d_): this;
    static atLowerCornerWithOffset($$0: Vec3i_, $$1: number, $$2: number, $$3: number): Vec3d;
    static atLowerCornerOf($$0: Vec3i_): Vec3d;
    subtract($$0: Vec3d_): this;
    static fromRGB24($$0: number): Vec3d;
    distanceTo($$0: Vec3d_): number;
    multiply($$0: Vec3d_): this;
    static upFromBottomCenterOf($$0: Vec3i_, $$1: number): Vec3d;
    reverse(): this;
    scale($$0: number): this;
    toVector3f(): Vec3f;
    length(): number;
    distanceToSqr($$0: number, $$1: number, $$2: number): number;
    static directionFromRotation($$0: number, $$1: number): Vec3d;
    zRot($$0: number): this;
    subtract($$0: number, $$1: number, $$2: number): this;
    readonly z: number;
    static readonly ZERO: Vec3d;
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = Vec3d;
declare class KMath {
    constructor()
    static lerp(value: number, min0: number, max0: number, min1: number, max1: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    static rad(value: number): number;
    static wrapDegrees(d: number): number;
    static degreesDifference(current: number, target: number): number;
    static m3f(): Matrix3f;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    static floor(value: number): number;
    static poseStack(): Internal.PoseStack;
    static approach(current: number, target: number, speed: number): number;
    static lerp(value: number, min: number, max: number): number;
    static isPowerOfTwo(value: number): boolean;
    static readonly PI: 3.141592653589793;
    static readonly RADIANS_TO_DEGREES: 57.29577951308232;
    static readonly DEGREES_TO_RADIANS: 0.017453292519943295;
    static readonly E: 2.718281828459045;
}
type KMath_ = KMath;
declare class PonderInputWindowElement extends Internal.AnimatedOverlayElement {
    constructor(sceneSpace: Vec3d_, direction: PonderPointing_)
    clone(): any;
    scroll(): this;
    whileCTRL(): this;
    withWrench(): this;
    showing(icon: PonderIcons_): this;
    rightClick(): this;
    leftClick(): this;
    withItem(stack: Internal.ItemStack_): this;
    whileSneaking(): this;
}
type PonderInputWindowElement_ = PonderInputWindowElement;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static values(): RotationAxis[];
    rad(f: number): Quaternionf;
    static valueOf(name: string): RotationAxis;
    static readonly XN: RotationAxis;
    static readonly ZP: RotationAxis;
    static readonly YN: RotationAxis;
    static readonly XP: RotationAxis;
    static readonly YP: RotationAxis;
    static readonly ZN: RotationAxis;
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation>, Internal.ResourceLocationExtensions {
    constructor($$0: string, $$1: string)
    constructor($$0: string)
    compareTo($$0: ResourceLocation_): number;
    toLanguageKey($$0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static read($$0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild($$0: string, $$1: string): ResourceLocation;
    static isAllowedInResourceLocation($$0: string): boolean;
    withPath($$0: string): this;
    static tryParse($$0: string): ResourceLocation;
    static validPathChar($$0: string): boolean;
    toLanguageKey($$0: string, $$1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of($$0: string, $$1: string): ResourceLocation;
    compareNamespaced(o: ResourceLocation_): number;
    withSuffix($$0: string): this;
    specialEquals(o: any, shallow: boolean): boolean;
    static read($$0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation($$0: string): boolean;
    setNamespace(arg0: string): void;
    withPath($$0: Internal.UnaryOperator_<string>): this;
    withPrefix($$0: string): this;
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: "realms";
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: ":";
    static readonly DEFAULT_NAMESPACE: "minecraft";
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class Items {
    constructor()
    static registerItem($$0: ResourceLocation_, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.Block_, ...$$1: Internal.Block_[]): Internal.Item;
    static registerBlock($$0: Internal.Block_, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.Block_): Internal.Item;
    static registerItem($$0: string, $$1: Internal.Item_): Internal.Item;
    static registerItem($$0: Internal.ResourceKey_<Internal.Item>, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.BlockItem_): Internal.Item;
    static readonly POWERED_RAIL: Internal.BlockItem;
    static readonly GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ: Internal.Item;
    static readonly TUBE_CORAL: Internal.BlockItem;
    static readonly TURTLE_EGG: Internal.BlockItem;
    static readonly HANGING_ROOTS: Internal.BlockItem;
    static readonly CYAN_DYE: Internal.DyeItem;
    static readonly WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly CRACKED_DEEPSLATE_TILES: Internal.BlockItem;
    static readonly OAK_PLANKS: Internal.BlockItem;
    static readonly BLAZE_ROD: Internal.Item;
    static readonly GRASS_BLOCK: Internal.BlockItem;
    static readonly DRIED_KELP: Internal.Item;
    static readonly TURTLE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GRAY_BANNER: Internal.BannerItem;
    static readonly MAGENTA_CONCRETE: Internal.BlockItem;
    static readonly WARPED_FUNGUS: Internal.BlockItem;
    static readonly DEEPSLATE_BRICKS: Internal.BlockItem;
    static readonly BEETROOT: Internal.Item;
    static readonly LIGHT_GRAY_TERRACOTTA: Internal.BlockItem;
    static readonly GRAY_BED: Internal.BedItem;
    static readonly MUDDY_MANGROVE_ROOTS: Internal.BlockItem;
    static readonly OAK_SIGN: Internal.SignItem;
    static readonly ACACIA_LEAVES: Internal.BlockItem;
    static readonly BIRCH_SLAB: Internal.BlockItem;
    static readonly CHAIN: Internal.BlockItem;
    static readonly LIGHT_GRAY_DYE: Internal.DyeItem;
    static readonly STRIPPED_SPRUCE_LOG: Internal.BlockItem;
    static readonly LIGHT_GRAY_CANDLE: Internal.BlockItem;
    static readonly PURPUR_BLOCK: Internal.BlockItem;
    static readonly NETHERITE_LEGGINGS: Internal.ArmorItem;
    static readonly DEBUG_STICK: Internal.DebugStickItem;
    static readonly DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly MUSIC_DISC_CAT: Internal.RecordItem;
    static readonly GOLDEN_SWORD: Internal.SwordItem;
    static readonly VERDANT_FROGLIGHT: Internal.BlockItem;
    static readonly WARPED_NYLIUM: Internal.BlockItem;
    static readonly TIPPED_ARROW: Internal.TippedArrowItem;
    static readonly MILK_BUCKET: Internal.MilkBucketItem;
    static readonly LAPIS_ORE: Internal.BlockItem;
    static readonly WEEPING_VINES: Internal.BlockItem;
    static readonly BLAZE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TORCHFLOWER: Internal.BlockItem;
    static readonly LODESTONE: Internal.BlockItem;
    static readonly IRON_HELMET: Internal.ArmorItem;
    static readonly MANGROVE_DOOR: Internal.DoubleHighBlockItem;
    static readonly INFESTED_STONE: Internal.BlockItem;
    static readonly OAK_LOG: Internal.BlockItem;
    static readonly SMOOTH_QUARTZ: Internal.BlockItem;
    static readonly BIRCH_STAIRS: Internal.BlockItem;
    static readonly BRUSH: Internal.BrushItem;
    static readonly END_PORTAL_FRAME: Internal.BlockItem;
    static readonly AZURE_BLUET: Internal.BlockItem;
    static readonly NETHER_QUARTZ_ORE: Internal.BlockItem;
    static readonly COBBLESTONE: Internal.BlockItem;
    static readonly DARK_OAK_HANGING_SIGN: Internal.HangingSignItem;
    static readonly SPRUCE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly PUMPKIN: Internal.BlockItem;
    static readonly COBWEB: Internal.BlockItem;
    static readonly YELLOW_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly DARK_OAK_WOOD: Internal.BlockItem;
    static readonly BLUE_CARPET: Internal.BlockItem;
    static readonly CARROT: Internal.ItemNameBlockItem;
    static readonly GOLDEN_BOOTS: Internal.ArmorItem;
    static readonly BLACKSTONE_SLAB: Internal.BlockItem;
    static readonly SUNFLOWER: Internal.DoubleHighBlockItem;
    static readonly COPPER_ORE: Internal.BlockItem;
    static readonly CHEST: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL: Internal.BlockItem;
    static readonly POLISHED_GRANITE_SLAB: Internal.BlockItem;
    static readonly PURPLE_CANDLE: Internal.BlockItem;
    static readonly SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static readonly RESPAWN_ANCHOR: Internal.BlockItem;
    static readonly BUCKET: Internal.BucketItem;
    static readonly ZOMBIFIED_PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GLASS: Internal.BlockItem;
    static readonly BIRCH_CHEST_BOAT: Internal.BoatItem;
    static readonly FIRE_CORAL: Internal.BlockItem;
    static readonly LAVA_BUCKET: Internal.BucketItem;
    static readonly ENDER_PEARL: Internal.EnderpearlItem;
    static readonly DRIED_KELP_BLOCK: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static readonly WILD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly JUNGLE_SLAB: Internal.BlockItem;
    static readonly BOOKSHELF: Internal.BlockItem;
    static readonly DIAMOND_LEGGINGS: Internal.ArmorItem;
    static readonly COBBLESTONE_WALL: Internal.BlockItem;
    static readonly TWISTING_VINES: Internal.BlockItem;
    static readonly GRINDSTONE: Internal.BlockItem;
    static readonly DARK_OAK_LEAVES: Internal.BlockItem;
    static readonly PHANTOM_MEMBRANE: Internal.Item;
    static readonly BRICK: Internal.Item;
    static readonly ARCHER_POTTERY_SHERD: Internal.Item;
    static readonly JUNGLE_LEAVES: Internal.BlockItem;
    static readonly TINTED_GLASS: Internal.BlockItem;
    static readonly OAK_TRAPDOOR: Internal.BlockItem;
    static readonly GOLD_ORE: Internal.BlockItem;
    static readonly FLOWERING_AZALEA: Internal.BlockItem;
    static readonly POPPED_CHORUS_FRUIT: Internal.Item;
    static readonly PRISMARINE_CRYSTALS: Internal.Item;
    static readonly LAPIS_LAZULI: Internal.Item;
    static readonly SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TERRACOTTA: Internal.BlockItem;
    static readonly NETHERITE_INGOT: Internal.Item;
    static readonly DEEPSLATE_EMERALD_ORE: Internal.BlockItem;
    static readonly CHAINMAIL_BOOTS: Internal.ArmorItem;
    static readonly NETHERITE_CHESTPLATE: Internal.ArmorItem;
    static readonly CHICKEN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BEEHIVE: Internal.BlockItem;
    static readonly SPYGLASS: Internal.SpyglassItem;
    static readonly NETHERITE_AXE: Internal.AxeItem;
    static readonly ELDER_GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_OAK_SLAB: Internal.BlockItem;
    static readonly BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly MULE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ORANGE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_BUTTON: Internal.BlockItem;
    static readonly FIREWORK_STAR: Internal.FireworkStarItem;
    static readonly SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_OAK_LOG: Internal.BlockItem;
    static readonly SKULL_POTTERY_SHERD: Internal.Item;
    static readonly FROG_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DEAD_BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static readonly DIRT: Internal.BlockItem;
    static readonly DARK_OAK_CHEST_BOAT: Internal.BoatItem;
    static readonly WOODEN_SHOVEL: Internal.ShovelItem;
    static readonly GLOWSTONE_DUST: Internal.Item;
    static readonly ITEM_FRAME: Internal.ItemFrameItem;
    static readonly MUSIC_DISC_RELIC: Internal.RecordItem;
    static readonly SANDSTONE: Internal.BlockItem;
    static readonly BIRCH_FENCE: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_WALL: Internal.BlockItem;
    static readonly REDSTONE: Internal.ItemNameBlockItem;
    static readonly CARROT_ON_A_STICK: Internal.Item;
    static readonly SOUL_TORCH: Internal.StandingAndWallBlockItem;
    static readonly LIME_CARPET: Internal.BlockItem;
    static readonly MANGROVE_PLANKS: Internal.BlockItem;
    static readonly SUGAR_CANE: Internal.BlockItem;
    static readonly COMMAND_BLOCK_MINECART: Internal.MinecartItem;
    static readonly SMOOTH_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly CHEST_MINECART: Internal.MinecartItem;
    static readonly DEAD_BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly SCUTE: Internal.Item;
    static readonly FEATHER: Internal.Item;
    static readonly JUNGLE_TRAPDOOR: Internal.BlockItem;
    static readonly CUT_SANDSTONE: Internal.BlockItem;
    static readonly CHISELED_QUARTZ_BLOCK: Internal.BlockItem;
    static readonly WHITE_TERRACOTTA: Internal.BlockItem;
    static readonly COPPER_INGOT: Internal.Item;
    static readonly SWEET_BERRIES: Internal.ItemNameBlockItem;
    static readonly GREEN_TERRACOTTA: Internal.BlockItem;
    static readonly BUBBLE_CORAL: Internal.BlockItem;
    static readonly BELL: Internal.BlockItem;
    static readonly WAXED_EXPOSED_COPPER: Internal.BlockItem;
    static readonly WHITE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PITCHER_POD: Internal.ItemNameBlockItem;
    static readonly BLACK_DYE: Internal.DyeItem;
    static readonly WHITE_WOOL: Internal.BlockItem;
    static readonly DETECTOR_RAIL: Internal.BlockItem;
    static readonly TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly LIME_CONCRETE: Internal.BlockItem;
    static readonly PIGLIN_HEAD: Internal.StandingAndWallBlockItem;
    static readonly CHORUS_FLOWER: Internal.BlockItem;
    static readonly WARPED_HYPHAE: Internal.BlockItem;
    static readonly WARDEN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHISELED_NETHER_BRICKS: Internal.BlockItem;
    static readonly SNOWBALL: Internal.SnowballItem;
    static readonly LANTERN: Internal.BlockItem;
    static readonly CYAN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly MAP: Internal.EmptyMapItem;
    static readonly WHITE_SHULKER_BOX: Internal.BlockItem;
    static readonly DEEPSLATE_COPPER_ORE: Internal.BlockItem;
    static readonly CUT_STANDSTONE_SLAB: Internal.BlockItem;
    static readonly BLACK_CANDLE: Internal.BlockItem;
    static readonly BLAST_FURNACE: Internal.BlockItem;
    static readonly BIRCH_PLANKS: Internal.BlockItem;
    static readonly QUARTZ_BRICKS: Internal.BlockItem;
    static readonly CYAN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly IRON_INGOT: Internal.Item;
    static readonly PINK_BANNER: Internal.BannerItem;
    static readonly MAGMA_CUBE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WHITE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE: Internal.BlockItem;
    static readonly TRADER_LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TNT: Internal.BlockItem;
    static readonly OAK_DOOR: Internal.DoubleHighBlockItem;
    static readonly CHERRY_PRESSURE_PLATE: Internal.BlockItem;
    static readonly GREEN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly CHERRY_FENCE: Internal.BlockItem;
    static readonly YELLOW_BANNER: Internal.BannerItem;
    static readonly ROTTEN_FLESH: Internal.Item;
    static readonly RIB_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WRITTEN_BOOK: Internal.WrittenBookItem;
    static readonly DISC_FRAGMENT_5: Internal.DiscFragmentItem;
    static readonly SNIFFER_EGG: Internal.BlockItem;
    static readonly MAGENTA_DYE: Internal.DyeItem;
    static readonly CLAY: Internal.BlockItem;
    static readonly CHERRY_PLANKS: Internal.BlockItem;
    static readonly MAGENTA_CONCRETE_POWDER: Internal.BlockItem;
    static readonly CHERRY_FENCE_GATE: Internal.BlockItem;
    static readonly BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly SPAWNER: Internal.BlockItem;
    static readonly LIME_SHULKER_BOX: Internal.BlockItem;
    static readonly CRIMSON_TRAPDOOR: Internal.BlockItem;
    static readonly NETHERITE_SCRAP: Internal.Item;
    static readonly NETHER_BRICK_SLAB: Internal.BlockItem;
    static readonly STONE: Internal.BlockItem;
    static readonly WITHER_SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly AMETHYST_BLOCK: Internal.BlockItem;
    static readonly BIRCH_SAPLING: Internal.BlockItem;
    static readonly JUNGLE_BUTTON: Internal.BlockItem;
    static readonly HOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ZOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIME_DYE: Internal.DyeItem;
    static readonly IRON_TRAPDOOR: Internal.BlockItem;
    static readonly CHERRY_CHEST_BOAT: Internal.BoatItem;
    static readonly MAGENTA_CANDLE: Internal.BlockItem;
    static readonly PETRIFIED_OAK_SLAB: Internal.BlockItem;
    static readonly PRISMARINE_SHARD: Internal.Item;
    static readonly NETHER_GOLD_ORE: Internal.BlockItem;
    static readonly POLISHED_BASALT: Internal.BlockItem;
    static readonly MANGROVE_STAIRS: Internal.BlockItem;
    static readonly ORANGE_BANNER: Internal.BannerItem;
    static readonly CHERRY_DOOR: Internal.DoubleHighBlockItem;
    static readonly SANDSTONE_WALL: Internal.BlockItem;
    static readonly ORANGE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly ENDER_DRAGON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STRIPPED_OAK_LOG: Internal.BlockItem;
    static readonly POLISHED_GRANITE_STAIRS: Internal.BlockItem;
    static readonly DEEPSLATE_GOLD_ORE: Internal.BlockItem;
    static readonly OBSERVER: Internal.BlockItem;
    static readonly GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DIAMOND_SWORD: Internal.SwordItem;
    static readonly FOX_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHERRY_STAIRS: Internal.BlockItem;
    static readonly MAGENTA_WOOL: Internal.BlockItem;
    static readonly CALCITE: Internal.BlockItem;
    static readonly PUMPKIN_SEEDS: Internal.ItemNameBlockItem;
    static readonly FERMENTED_SPIDER_EYE: Internal.Item;
    static readonly HEART_POTTERY_SHERD: Internal.Item;
    static readonly PURPLE_CONCRETE: Internal.BlockItem;
    static readonly MUTTON: Internal.Item;
    static readonly PURPLE_STAINED_GLASS: Internal.BlockItem;
    static readonly GOLDEN_PICKAXE: Internal.PickaxeItem;
    static readonly ZOMBIE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSIC_DISC_PIGSTEP: Internal.RecordItem;
    static readonly REDSTONE_TORCH: Internal.StandingAndWallBlockItem;
    static readonly LEATHER_LEGGINGS: Internal.DyeableArmorItem;
    static readonly PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly RED_SHULKER_BOX: Internal.BlockItem;
    static readonly COD: Internal.Item;
    static readonly MUSIC_DISC_11: Internal.RecordItem;
    static readonly AZALEA_LEAVES: Internal.BlockItem;
    static readonly NETHER_WART: Internal.ItemNameBlockItem;
    static readonly NAME_TAG: Internal.NameTagItem;
    static readonly CYAN_CARPET: Internal.BlockItem;
    static readonly BAMBOO_TRAPDOOR: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE: Internal.BlockItem;
    static readonly NETHER_BRICK_WALL: Internal.BlockItem;
    static readonly JACK_O_LANTERN: Internal.BlockItem;
    static readonly JUNGLE_SAPLING: Internal.BlockItem;
    static readonly WARPED_SLAB: Internal.BlockItem;
    static readonly FURNACE: Internal.BlockItem;
    static readonly ACACIA_SLAB: Internal.BlockItem;
    static readonly RED_CONCRETE: Internal.BlockItem;
    static readonly YELLOW_CARPET: Internal.BlockItem;
    static readonly POWDER_SNOW_BUCKET: Internal.SolidBucketItem;
    static readonly BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly WHITE_STAINED_GLASS: Internal.BlockItem;
    static readonly BRICK_WALL: Internal.BlockItem;
    static readonly BOOK: Internal.BookItem;
    static readonly RED_STAINED_GLASS: Internal.BlockItem;
    static readonly DARK_PRISMARINE_STAIRS: Internal.BlockItem;
    static readonly LIGHT_BLUE_BANNER: Internal.BannerItem;
    static readonly CRIMSON_BUTTON: Internal.BlockItem;
    static readonly PURPLE_WOOL: Internal.BlockItem;
    static readonly PURPLE_BED: Internal.BedItem;
    static readonly EMERALD_ORE: Internal.BlockItem;
    static readonly BLUE_TERRACOTTA: Internal.BlockItem;
    static readonly CRACKED_STONE_BRICKS: Internal.BlockItem;
    static readonly COD_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DIAMOND: Internal.Item;
    static readonly AZALEA: Internal.BlockItem;
    static readonly JUNGLE_BOAT: Internal.BoatItem;
    static readonly SPRUCE_TRAPDOOR: Internal.BlockItem;
    static readonly MELON_SEEDS: Internal.ItemNameBlockItem;
    static readonly WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly CANDLE: Internal.BlockItem;
    static readonly PURPLE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSIC_DISC_13: Internal.RecordItem;
    static readonly LIGHT_GRAY_CARPET: Internal.BlockItem;
    static readonly BIRCH_WOOD: Internal.BlockItem;
    static readonly FLOWER_POT: Internal.BlockItem;
    static readonly ACACIA_WOOD: Internal.BlockItem;
    static readonly WARPED_FENCE: Internal.BlockItem;
    static readonly CHISELED_POLISHED_BLACKSTONE: Internal.BlockItem;
    static readonly SEA_PICKLE: Internal.BlockItem;
    static readonly LARGE_FERN: Internal.DoubleHighBlockItem;
    static readonly AMETHYST_SHARD: Internal.Item;
    static readonly CHICKEN: Internal.Item;
    static readonly GRAY_CONCRETE: Internal.BlockItem;
    static readonly ACACIA_PRESSURE_PLATE: Internal.BlockItem;
    static readonly TOTEM_OF_UNDYING: Internal.Item;
    static readonly STONE_BRICKS: Internal.BlockItem;
    static readonly GREEN_BED: Internal.BedItem;
    static readonly DROPPER: Internal.BlockItem;
    static readonly LIME_STAINED_GLASS: Internal.BlockItem;
    static readonly KNOWLEDGE_BOOK: Internal.KnowledgeBookItem;
    static readonly LOOM: Internal.BlockItem;
    static readonly LIGHT_BLUE_WOOL: Internal.BlockItem;
    static readonly NETHERITE_BLOCK: Internal.BlockItem;
    static readonly ORANGE_CARPET: Internal.BlockItem;
    static readonly FISHING_ROD: Internal.FishingRodItem;
    static readonly BROWN_DYE: Internal.DyeItem;
    static readonly MEDIUM_AMETHYST_BUD: Internal.BlockItem;
    static readonly ROOTED_DIRT: Internal.BlockItem;
    static readonly SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly WARPED_STEM: Internal.BlockItem;
    static readonly SHEAF_POTTERY_SHERD: Internal.Item;
    static readonly RED_SAND: Internal.BlockItem;
    static readonly END_STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SHEARS: Internal.ShearsItem;
    static readonly PANDA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly POTATO: Internal.ItemNameBlockItem;
    static readonly LAPIS_BLOCK: Internal.BlockItem;
    static readonly COMPOSTER: Internal.BlockItem;
    static readonly NETHERITE_HELMET: Internal.ArmorItem;
    static readonly TROPICAL_FISH: Internal.Item;
    static readonly POTION: Internal.PotionItem;
    static readonly MANGROVE_ROOTS: Internal.BlockItem;
    static readonly JIGSAW: Internal.GameMasterBlockItem;
    static readonly PRISMARINE_BRICK_STAIRS: Internal.BlockItem;
    static readonly TROPICAL_FISH_BUCKET: Internal.MobBucketItem;
    static readonly WARPED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_TERRACOTTA: Internal.BlockItem;
    static readonly BROWN_CARPET: Internal.BlockItem;
    static readonly CRIMSON_HANGING_SIGN: Internal.HangingSignItem;
    static readonly LIGHT_BLUE_CANDLE: Internal.BlockItem;
    static readonly LEATHER_CHESTPLATE: Internal.DyeableArmorItem;
    static readonly RED_BED: Internal.BedItem;
    static readonly STONE_HOE: Internal.HoeItem;
    static readonly JUNGLE_LOG: Internal.BlockItem;
    static readonly GLOW_SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly EYE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly BROWN_WOOL: Internal.BlockItem;
    static readonly PUFFERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GLASS_PANE: Internal.BlockItem;
    static readonly CHAINMAIL_LEGGINGS: Internal.ArmorItem;
    static readonly GREEN_WOOL: Internal.BlockItem;
    static readonly BREAD: Internal.Item;
    static readonly COOKED_CHICKEN: Internal.Item;
    static readonly BIRCH_FENCE_GATE: Internal.BlockItem;
    static readonly MANGROVE_TRAPDOOR: Internal.BlockItem;
    static readonly CRIMSON_SLAB: Internal.BlockItem;
    static readonly GOLD_NUGGET: Internal.Item;
    static readonly PHANTOM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ_STAIRS: Internal.BlockItem;
    static readonly WHITE_CONCRETE: Internal.BlockItem;
    static readonly WAXED_WEATHERED_COPPER: Internal.BlockItem;
    static readonly BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly WHEAT_SEEDS: Internal.ItemNameBlockItem;
    static readonly DEEPSLATE_TILES: Internal.BlockItem;
    static readonly PORKCHOP: Internal.Item;
    static readonly SCAFFOLDING: Internal.ScaffoldingBlockItem;
    static readonly END_ROD: Internal.BlockItem;
    static readonly ANDESITE: Internal.BlockItem;
    static readonly PACKED_MUD: Internal.BlockItem;
    static readonly STONE_BRICK_WALL: Internal.BlockItem;
    static readonly ORANGE_WOOL: Internal.BlockItem;
    static readonly REINFORCED_DEEPSLATE: Internal.BlockItem;
    static readonly ACACIA_FENCE_GATE: Internal.BlockItem;
    static readonly LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly LILY_OF_THE_VALLEY: Internal.BlockItem;
    static readonly VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STONE_SHOVEL: Internal.ShovelItem;
    static readonly PARROT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WHEAT: Internal.Item;
    static readonly JUNGLE_PLANKS: Internal.BlockItem;
    static readonly BROWN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_SLAB: Internal.BlockItem;
    static readonly DIAMOND_AXE: Internal.AxeItem;
    static readonly WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WARPED_PLANKS: Internal.BlockItem;
    static readonly NETHERRACK: Internal.BlockItem;
    static readonly DIAMOND_CHESTPLATE: Internal.ArmorItem;
    static readonly GRAY_WOOL: Internal.BlockItem;
    static readonly COPPER_BLOCK: Internal.BlockItem;
    static readonly WEATHERED_CUT_COPPER: Internal.BlockItem;
    static readonly PURPUR_PILLAR: Internal.BlockItem;
    static readonly STONE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_NETHER_BRICK_STAIRS: Internal.BlockItem;
    static readonly CAKE: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE: Internal.BlockItem;
    static readonly MANGROVE_FENCE: Internal.BlockItem;
    static readonly FARMLAND: Internal.BlockItem;
    static readonly LIGHT_GRAY_CONCRETE: Internal.BlockItem;
    static readonly NETHERITE_SHOVEL: Internal.ShovelItem;
    static readonly PUMPKIN_PIE: Internal.Item;
    static readonly SHULKER_SHELL: Internal.Item;
    static readonly OAK_LEAVES: Internal.BlockItem;
    static readonly BIRCH_HANGING_SIGN: Internal.HangingSignItem;
    static readonly RABBIT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly APPLE: Internal.Item;
    static readonly DIAMOND_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly POLISHED_BLACKSTONE_SLAB: Internal.BlockItem;
    static readonly WARPED_ROOTS: Internal.BlockItem;
    static readonly BIRCH_LOG: Internal.BlockItem;
    static readonly ELYTRA: Internal.ElytraItem;
    static readonly WARPED_SIGN: Internal.SignItem;
    static readonly GREEN_CANDLE: Internal.BlockItem;
    static readonly BIRCH_TRAPDOOR: Internal.BlockItem;
    static readonly BEE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PINK_DYE: Internal.DyeItem;
    static readonly PLAYER_HEAD: Internal.PlayerHeadItem;
    static readonly GLOW_LICHEN: Internal.BlockItem;
    static readonly STONE_STAIRS: Internal.BlockItem;
    static readonly ROSE_BUSH: Internal.DoubleHighBlockItem;
    static readonly GLOW_ITEM_FRAME: Internal.ItemFrameItem;
    static readonly WHITE_TULIP: Internal.BlockItem;
    static readonly JUNGLE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly OBSIDIAN: Internal.BlockItem;
    static readonly BLADE_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_SHULKER_BOX: Internal.BlockItem;
    static readonly EGG: Internal.EggItem;
    static readonly WITCH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly OCELOT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly HORN_CORAL_BLOCK: Internal.BlockItem;
    static readonly NETHER_SPROUTS: Internal.BlockItem;
    static readonly MUD_BRICK_SLAB: Internal.BlockItem;
    static readonly DEAD_BRAIN_CORAL: Internal.BlockItem;
    static readonly TALL_GRASS: Internal.DoubleHighBlockItem;
    static readonly BLACK_STAINED_GLASS: Internal.BlockItem;
    static readonly SPIDER_EYE: Internal.Item;
    static readonly FILLED_MAP: Internal.MapItem;
    static readonly MUD_BRICK_STAIRS: Internal.BlockItem;
    static readonly AXOLOTL_BUCKET: Internal.MobBucketItem;
    static readonly ZOMBIE_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_PRISMARINE_SLAB: Internal.BlockItem;
    static readonly MANGROVE_SIGN: Internal.SignItem;
    static readonly STRIPPED_JUNGLE_WOOD: Internal.BlockItem;
    static readonly MUSHROOM_STEM: Internal.BlockItem;
    static readonly LILAC: Internal.DoubleHighBlockItem;
    static readonly BAMBOO_RAFT: Internal.BoatItem;
    static readonly SUSPICIOUS_STEW: Internal.SuspiciousStewItem;
    static readonly SUSPICIOUS_GRAVEL: Internal.BlockItem;
    static readonly GOLDEN_LEGGINGS: Internal.ArmorItem;
    static readonly IRON_PICKAXE: Internal.PickaxeItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static readonly CRACKED_DEEPSLATE_BRICKS: Internal.BlockItem;
    static readonly SHULKER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly LIGHT_GRAY_STAINED_GLASS: Internal.BlockItem;
    static readonly MELON_SLICE: Internal.Item;
    static readonly HONEYCOMB_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE_STAIRS: Internal.BlockItem;
    static readonly PEARLESCENT_FROGLIGHT: Internal.BlockItem;
    static readonly GOLDEN_CHESTPLATE: Internal.ArmorItem;
    static readonly ANCIENT_DEBRIS: Internal.BlockItem;
    static readonly HOPPER_MINECART: Internal.MinecartItem;
    static readonly MAGMA_CREAM: Internal.Item;
    static readonly ZOMBIE_HEAD: Internal.StandingAndWallBlockItem;
    static readonly POLISHED_GRANITE: Internal.BlockItem;
    static readonly PINK_CONCRETE: Internal.BlockItem;
    static readonly HONEYCOMB: Internal.HoneycombItem;
    static readonly NOTE_BLOCK: Internal.BlockItem;
    static readonly RED_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly FURNACE_MINECART: Internal.MinecartItem;
    static readonly DRAGON_BREATH: Internal.Item;
    static readonly CYAN_CONCRETE: Internal.BlockItem;
    static readonly CRIMSON_PLANKS: Internal.BlockItem;
    static readonly CHORUS_PLANT: Internal.BlockItem;
    static readonly WAXED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly YELLOW_CONCRETE_POWDER: Internal.BlockItem;
    static readonly TURTLE_HELMET: Internal.ArmorItem;
    static readonly DARK_OAK_FENCE_GATE: Internal.BlockItem;
    static readonly COAL_ORE: Internal.BlockItem;
    static readonly COAL: Internal.Item;
    static readonly COAST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly GRAY_CARPET: Internal.BlockItem;
    static readonly OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static readonly LIGHT_BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DANGER_POTTERY_SHERD: Internal.Item;
    static readonly SANDSTONE_SLAB: Internal.BlockItem;
    static readonly GREEN_CONCRETE: Internal.BlockItem;
    static readonly BARREL: Internal.BlockItem;
    static readonly RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly WHITE_DYE: Internal.DyeItem;
    static readonly ORANGE_DYE: Internal.DyeItem;
    static readonly ENCHANTED_BOOK: Internal.EnchantedBookItem;
    static readonly SOUL_SOIL: Internal.BlockItem;
    static readonly IRON_NUGGET: Internal.Item;
    static readonly ENDERMITE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHERITE_BOOTS: Internal.ArmorItem;
    static readonly LEVER: Internal.BlockItem;
    static readonly COOKED_SALMON: Internal.Item;
    static readonly CAULDRON: Internal.BlockItem;
    static readonly ALLIUM: Internal.BlockItem;
    static readonly JUNGLE_CHEST_BOAT: Internal.BoatItem;
    static readonly EXPLORER_POTTERY_SHERD: Internal.Item;
    static readonly POISONOUS_POTATO: Internal.Item;
    static readonly FLOWER_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly SMOOTH_STONE: Internal.BlockItem;
    static readonly WHITE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly SNORT_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_MUSHROOM_BLOCK: Internal.BlockItem;
    static readonly GHAST_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHER_BRICK_STAIRS: Internal.BlockItem;
    static readonly IRON_SHOVEL: Internal.ShovelItem;
    static readonly AXOLOTL_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ORANGE_STAINED_GLASS: Internal.BlockItem;
    static readonly SEA_LANTERN: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_WALL: Internal.BlockItem;
    static readonly STONE_PICKAXE: Internal.PickaxeItem;
    static readonly LIME_TERRACOTTA: Internal.BlockItem;
    static readonly SHIELD: Internal.ShieldItem;
    static readonly DIORITE_WALL: Internal.BlockItem;
    static readonly STONE_SWORD: Internal.SwordItem;
    static readonly GOLDEN_HOE: Internal.HoeItem;
    static readonly BLACK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DIAMOND_ORE: Internal.BlockItem;
    static readonly BLACK_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly LIGHT_GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static readonly LIGHT_BLUE_DYE: Internal.DyeItem;
    static readonly REPEATER: Internal.BlockItem;
    static readonly SPECTRAL_ARROW: Internal.SpectralArrowItem;
    static readonly CHERRY_SLAB: Internal.BlockItem;
    static readonly LEAD: Internal.LeadItem;
    static readonly WHITE_CANDLE: Internal.BlockItem;
    static readonly CHISELED_STONE_BRICKS: Internal.BlockItem;
    static readonly DEAD_TUBE_CORAL: Internal.BlockItem;
    static readonly BROWN_BANNER: Internal.BannerItem;
    static readonly WAXED_OXIDIZED_COPPER: Internal.BlockItem;
    static readonly PINK_WOOL: Internal.BlockItem;
    static readonly BIRCH_BOAT: Internal.BoatItem;
    static readonly BLACK_CARPET: Internal.BlockItem;
    static readonly SPRUCE_FENCE_GATE: Internal.BlockItem;
    static readonly BREWING_STAND: Internal.BlockItem;
    static readonly BIG_DRIPLEAF: Internal.BlockItem;
    static readonly CARVED_PUMPKIN: Internal.BlockItem;
    static readonly OAK_BUTTON: Internal.BlockItem;
    static readonly PINK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DIORITE_SLAB: Internal.BlockItem;
    static readonly ACACIA_BOAT: Internal.BoatItem;
    static readonly POLISHED_BLACKSTONE_BRICK_SLAB: Internal.BlockItem;
    static readonly CHERRY_WOOD: Internal.BlockItem;
    static readonly SMOOTH_QUARTZ_STAIRS: Internal.BlockItem;
    static readonly END_STONE: Internal.BlockItem;
    static readonly BLUE_BED: Internal.BedItem;
    static readonly LIGHT: Internal.BlockItem;
    static readonly BONE_BLOCK: Internal.BlockItem;
    static readonly DRIPSTONE_BLOCK: Internal.BlockItem;
    static readonly WET_SPONGE: Internal.BlockItem;
    static readonly FLINT: Internal.Item;
    static readonly INFESTED_CHISELED_STONE_BRICKS: Internal.BlockItem;
    static readonly GRAY_SHULKER_BOX: Internal.BlockItem;
    static readonly YELLOW_CANDLE: Internal.BlockItem;
    static readonly SPRUCE_LEAVES: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_SLAB: Internal.BlockItem;
    static readonly HUSK_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PINK_STAINED_GLASS: Internal.BlockItem;
    static readonly MAGENTA_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly BLUE_ICE: Internal.BlockItem;
    static readonly JUKEBOX: Internal.BlockItem;
    static readonly FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly FIRE_CHARGE: Internal.FireChargeItem;
    static readonly COOKED_MUTTON: Internal.Item;
    static readonly BASALT: Internal.BlockItem;
    static readonly ACACIA_PLANKS: Internal.BlockItem;
    static readonly PIG_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSHROOM_STEW: Internal.BowlFoodItem;
    static readonly PURPLE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly MANGROVE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly HOWL_POTTERY_SHERD: Internal.Item;
    static readonly SMALL_AMETHYST_BUD: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL_BLOCK: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BRICK_WALL: Internal.BlockItem;
    static readonly WEATHERED_COPPER: Internal.BlockItem;
    static readonly RED_WOOL: Internal.BlockItem;
    static readonly MANGROVE_PROPAGULE: Internal.BlockItem;
    static readonly PURPUR_STAIRS: Internal.BlockItem;
    static readonly PAPER: Internal.Item;
    static readonly IRON_HOE: Internal.HoeItem;
    static readonly MAGENTA_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly STICKY_PISTON: Internal.BlockItem;
    static readonly COMPASS: Internal.CompassItem;
    static readonly RED_SANDSTONE_WALL: Internal.BlockItem;
    static readonly DARK_PRISMARINE: Internal.BlockItem;
    static readonly DARK_OAK_FENCE: Internal.BlockItem;
    static readonly BAMBOO_BUTTON: Internal.BlockItem;
    static readonly CLAY_BALL: Internal.Item;
    static readonly CYAN_WOOL: Internal.BlockItem;
    static readonly STONECUTTER: Internal.BlockItem;
    static readonly MINECART: Internal.MinecartItem;
    static readonly POLISHED_BLACKSTONE_STAIRS: Internal.BlockItem;
    static readonly RED_CANDLE: Internal.BlockItem;
    static readonly GREEN_STAINED_GLASS: Internal.BlockItem;
    static readonly SHELTER_POTTERY_SHERD: Internal.Item;
    static readonly AIR: Internal.AirItem;
    static readonly SEAGRASS: Internal.BlockItem;
    static readonly GLOWSTONE: Internal.BlockItem;
    static readonly YELLOW_BED: Internal.BedItem;
    static readonly ANVIL: Internal.BlockItem;
    static readonly YELLOW_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly RAW_COPPER_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE: Internal.BlockItem;
    static readonly DARK_OAK_SIGN: Internal.SignItem;
    static readonly MAGENTA_STAINED_GLASS: Internal.BlockItem;
    static readonly NETHER_BRICKS: Internal.BlockItem;
    static readonly WITHER_SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static readonly DONKEY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly WARPED_DOOR: Internal.DoubleHighBlockItem;
    static readonly WAXED_COPPER_BLOCK: Internal.BlockItem;
    static readonly ENCHANTED_GOLDEN_APPLE: Internal.EnchantedGoldenAppleItem;
    static readonly MANGROVE_CHEST_BOAT: Internal.BoatItem;
    static readonly MUD: Internal.BlockItem;
    static readonly OAK_FENCE: Internal.BlockItem;
    static readonly GOAT_HORN: Internal.InstrumentItem;
    static readonly HOST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CAVE_SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ_PILLAR: Internal.BlockItem;
    static readonly DEAD_FIRE_CORAL: Internal.BlockItem;
    static readonly SUGAR: Internal.Item;
    static readonly WAXED_EXPOSED_CUT_COPPER: Internal.BlockItem;
    static readonly BROWN_CONCRETE: Internal.BlockItem;
    static readonly SCULK_VEIN: Internal.BlockItem;
    static readonly FLETCHING_TABLE: Internal.BlockItem;
    static readonly INFESTED_MOSSY_STONE_BRICKS: Internal.BlockItem;
    static readonly WARPED_STAIRS: Internal.BlockItem;
    static readonly SPRUCE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly BROWN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PINK_CANDLE: Internal.BlockItem;
    static readonly STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly PLENTY_POTTERY_SHERD: Internal.Item;
    static readonly RED_CARPET: Internal.BlockItem;
    static readonly CLOCK: Internal.Item;
    static readonly GRAY_TERRACOTTA: Internal.BlockItem;
    static readonly EMERALD: Internal.Item;
    static readonly DEEPSLATE_DIAMOND_ORE: Internal.BlockItem;
    static readonly BIRCH_PRESSURE_PLATE: Internal.BlockItem;
    static readonly BIRCH_DOOR: Internal.DoubleHighBlockItem;
    static readonly BROWN_CANDLE: Internal.BlockItem;
    static readonly KELP: Internal.BlockItem;
    static readonly WITHER_ROSE: Internal.BlockItem;
    static readonly ACACIA_CHEST_BOAT: Internal.BoatItem;
    static readonly TADPOLE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OAK_HANGING_SIGN: Internal.HangingSignItem;
    static readonly SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly SPRUCE_FENCE: Internal.BlockItem;
    static readonly ORANGE_CONCRETE: Internal.BlockItem;
    static readonly CRAFTING_TABLE: Internal.BlockItem;
    static readonly BAKED_POTATO: Internal.Item;
    static readonly MANGROVE_SLAB: Internal.BlockItem;
    static readonly CYAN_BED: Internal.BedItem;
    static readonly CHISELED_BOOKSHELF: Internal.BlockItem;
    static readonly NAUTILUS_SHELL: Internal.Item;
    static readonly SHULKER_BOX: Internal.BlockItem;
    static readonly STICK: Internal.Item;
    static readonly HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly COARSE_DIRT: Internal.BlockItem;
    static readonly QUARTZ_SLAB: Internal.BlockItem;
    static readonly SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly COBBLED_DEEPSLATE_SLAB: Internal.BlockItem;
    static readonly LIGHTNING_ROD: Internal.BlockItem;
    static readonly ACACIA_FENCE: Internal.BlockItem;
    static readonly POLAR_BEAR_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ACACIA_LOG: Internal.BlockItem;
    static readonly MOJANG_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly DEEPSLATE_REDSTONE_ORE: Internal.BlockItem;
    static readonly INFESTED_STONE_BRICKS: Internal.BlockItem;
    static readonly ENCHANTING_TABLE: Internal.BlockItem;
    static readonly POLISHED_ANDESITE_SLAB: Internal.BlockItem;
    static readonly PURPLE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PINK_CARPET: Internal.BlockItem;
    static readonly BREWER_POTTERY_SHERD: Internal.Item;
    static readonly DIORITE: Internal.BlockItem;
    static readonly RED_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DARK_OAK_SAPLING: Internal.BlockItem;
    static readonly GRAY_DYE: Internal.DyeItem;
    static readonly LIGHT_GRAY_BED: Internal.BedItem;
    static readonly BAMBOO_SIGN: Internal.SignItem;
    static readonly IRON_ORE: Internal.BlockItem;
    static readonly SCULK_SENSOR: Internal.BlockItem;
    static readonly BUNDLE: Internal.BundleItem;
    static readonly STRING: Internal.ItemNameBlockItem;
    static readonly STRIPPED_JUNGLE_LOG: Internal.BlockItem;
    static readonly END_CRYSTAL: Internal.EndCrystalItem;
    static readonly LEATHER_BOOTS: Internal.DyeableArmorItem;
    static readonly SLIME_BALL: Internal.Item;
    static readonly ORANGE_TERRACOTTA: Internal.BlockItem;
    static readonly DEEPSLATE_IRON_ORE: Internal.BlockItem;
    static readonly BOW: Internal.BowItem;
    static readonly ORANGE_CANDLE: Internal.BlockItem;
    static readonly BLUE_ORCHID: Internal.BlockItem;
    static readonly SPRUCE_BUTTON: Internal.BlockItem;
    static readonly LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CAMPFIRE: Internal.BlockItem;
    static readonly LIGHT_BLUE_STAINED_GLASS: Internal.BlockItem;
    static readonly CHERRY_BUTTON: Internal.BlockItem;
    static readonly MAGENTA_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_STAIRS: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static readonly RED_MUSHROOM: Internal.BlockItem;
    static readonly ACACIA_STAIRS: Internal.BlockItem;
    static readonly BLACK_CONCRETE: Internal.BlockItem;
    static readonly SAND: Internal.BlockItem;
    static readonly NETHERITE_HOE: Internal.HoeItem;
    static readonly RED_MUSHROOM_BLOCK: Internal.BlockItem;
    static readonly MYCELIUM: Internal.BlockItem;
    static readonly PINK_TULIP: Internal.BlockItem;
    static readonly PINK_TERRACOTTA: Internal.BlockItem;
    static readonly GOAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly INFESTED_CRACKED_STONE_BRICKS: Internal.BlockItem;
    static readonly RABBIT: Internal.Item;
    static readonly PRISMARINE_SLAB: Internal.BlockItem;
    static readonly REDSTONE_LAMP: Internal.BlockItem;
    static readonly LIGHT_BLUE_CARPET: Internal.BlockItem;
    static readonly TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly MANGROVE_WOOD: Internal.BlockItem;
    static readonly LIME_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_DOOR: Internal.DoubleHighBlockItem;
    static readonly STRIPPED_ACACIA_WOOD: Internal.BlockItem;
    static readonly LIGHT_BLUE_SHULKER_BOX: Internal.BlockItem;
    static readonly ARMOR_STAND: Internal.ArmorStandItem;
    static readonly CHERRY_SAPLING: Internal.BlockItem;
    static readonly BROWN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly STONE_SLAB: Internal.BlockItem;
    static readonly CHERRY_HANGING_SIGN: Internal.HangingSignItem;
    static readonly MANGROVE_BOAT: Internal.BoatItem;
    static readonly PRISMARINE_WALL: Internal.BlockItem;
    static readonly LIGHT_GRAY_BANNER: Internal.BannerItem;
    static readonly RED_NETHER_BRICK_SLAB: Internal.BlockItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly IRON_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CRIMSON_NYLIUM: Internal.BlockItem;
    static readonly FIRE_CORAL_BLOCK: Internal.BlockItem;
    static readonly EXPERIENCE_BOTTLE: Internal.ExperienceBottleItem;
    static readonly POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_NETHER_BRICKS: Internal.BlockItem;
    static readonly BLACK_CONCRETE_POWDER: Internal.BlockItem;
    static readonly SMITHING_TABLE: Internal.BlockItem;
    static readonly DARK_OAK_TRAPDOOR: Internal.BlockItem;
    static readonly LIGHT_BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly ACACIA_SIGN: Internal.SignItem;
    static readonly YELLOW_STAINED_GLASS: Internal.BlockItem;
    static readonly VEX_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PIGLIN_BRUTE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GRAY_CANDLE: Internal.BlockItem;
    static readonly COBBLESTONE_STAIRS: Internal.BlockItem;
    static readonly BLAZE_POWDER: Internal.Item;
    static readonly MUSIC_DISC_MALL: Internal.RecordItem;
    static readonly LARGE_AMETHYST_BUD: Internal.BlockItem;
    static readonly BRICKS: Internal.BlockItem;
    static readonly BUDDING_AMETHYST: Internal.BlockItem;
    static readonly RABBIT_FOOT: Internal.Item;
    static readonly BAMBOO_MOSAIC: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_STAIRS: Internal.BlockItem;
    static readonly SKULL_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly ACACIA_TRAPDOOR: Internal.BlockItem;
    static readonly BURN_POTTERY_SHERD: Internal.Item;
    static readonly COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly BEACON: Internal.BlockItem;
    static readonly STRIPPED_SPRUCE_WOOD: Internal.BlockItem;
    static readonly OAK_SAPLING: Internal.BlockItem;
    static readonly SMOOTH_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly BIRCH_BUTTON: Internal.BlockItem;
    static readonly STRIPPED_CRIMSON_STEM: Internal.BlockItem;
    static readonly GLOW_INK_SAC: Internal.GlowInkSacItem;
    static readonly CYAN_BANNER: Internal.BannerItem;
    static readonly CAMEL_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly POLISHED_BLACKSTONE: Internal.BlockItem;
    static readonly GRASS: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly BROWN_STAINED_GLASS: Internal.BlockItem;
    static readonly MUSIC_DISC_CHIRP: Internal.RecordItem;
    static readonly MUSIC_DISC_FAR: Internal.RecordItem;
    static readonly RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly JUNGLE_STAIRS: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE_WALL: Internal.BlockItem;
    static readonly BLUE_SHULKER_BOX: Internal.BlockItem;
    static readonly WOODEN_AXE: Internal.AxeItem;
    static readonly SPORE_BLOSSOM: Internal.BlockItem;
    static readonly DEAD_BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DEEPSLATE_TILE_STAIRS: Internal.BlockItem;
    static readonly CROSSBOW: Internal.CrossbowItem;
    static readonly BAMBOO_PRESSURE_PLATE: Internal.BlockItem;
    static readonly HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly ORANGE_TULIP: Internal.BlockItem;
    static readonly DIAMOND_PICKAXE: Internal.PickaxeItem;
    static readonly GREEN_CARPET: Internal.BlockItem;
    static readonly SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly RABBIT_HIDE: Internal.Item;
    static readonly COOKED_COD: Internal.Item;
    static readonly BLACK_BED: Internal.BedItem;
    static readonly PUFFERFISH: Internal.Item;
    static readonly ENDER_EYE: Internal.EnderEyeItem;
    static readonly INFESTED_COBBLESTONE: Internal.BlockItem;
    static readonly GOLD_INGOT: Internal.Item;
    static readonly VEX_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly STRIPPED_MANGROVE_LOG: Internal.BlockItem;
    static readonly ICE: Internal.BlockItem;
    static readonly BAMBOO_MOSAIC_STAIRS: Internal.BlockItem;
    static readonly BLACK_BANNER: Internal.BannerItem;
    static readonly OAK_CHEST_BOAT: Internal.BoatItem;
    static readonly LIME_BANNER: Internal.BannerItem;
    static readonly PINK_SHULKER_BOX: Internal.BlockItem;
    static readonly SMALL_DRIPLEAF: Internal.DoubleHighBlockItem;
    static readonly LILY_PAD: Internal.PlaceOnWaterBlockItem;
    static readonly CREEPER_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly GLOW_BERRIES: Internal.ItemNameBlockItem;
    static readonly HOPPER: Internal.BlockItem;
    static readonly PUFFERFISH_BUCKET: Internal.MobBucketItem;
    static readonly PURPLE_BANNER: Internal.BannerItem;
    static readonly HAY_BLOCK: Internal.BlockItem;
    static readonly HEART_OF_THE_SEA: Internal.Item;
    static readonly WARD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly MOSSY_STONE_BRICK_WALL: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WARPED_WART_BLOCK: Internal.BlockItem;
    static readonly NETHERITE_SWORD: Internal.SwordItem;
    static readonly SHEEP_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ANGLER_POTTERY_SHERD: Internal.Item;
    static readonly PODZOL: Internal.BlockItem;
    static readonly DIAMOND_HOE: Internal.HoeItem;
    static readonly GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly YELLOW_SHULKER_BOX: Internal.BlockItem;
    static readonly STRIPPED_WARPED_STEM: Internal.BlockItem;
    static readonly SPRUCE_SIGN: Internal.SignItem;
    static readonly RABBIT_STEW: Internal.BowlFoodItem;
    static readonly DEAD_TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DECORATED_POT: Internal.BlockItem;
    static readonly OAK_PRESSURE_PLATE: Internal.BlockItem;
    static readonly LIGHT_GRAY_SHULKER_BOX: Internal.BlockItem;
    static readonly CHAINMAIL_HELMET: Internal.ArmorItem;
    static readonly CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static readonly ACACIA_HANGING_SIGN: Internal.HangingSignItem;
    static readonly LIME_BED: Internal.BedItem;
    static readonly TUFF: Internal.BlockItem;
    static readonly GRAVEL: Internal.BlockItem;
    static readonly BARRIER: Internal.BlockItem;
    static readonly DRAGON_HEAD: Internal.StandingAndWallBlockItem;
    static readonly MUSIC_DISC_MELLOHI: Internal.RecordItem;
    static readonly IRON_DOOR: Internal.DoubleHighBlockItem;
    static readonly BAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly VINDICATOR_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SMOOTH_BASALT: Internal.BlockItem;
    static readonly LIGHT_GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DROWNED_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHER_STAR: Internal.SimpleFoiledItem;
    static readonly CRIMSON_PRESSURE_PLATE: Internal.BlockItem;
    static readonly FLINT_AND_STEEL: Internal.FlintAndSteelItem;
    static readonly MAGENTA_BED: Internal.BedItem;
    static readonly BONE: Internal.Item;
    static readonly BROWN_TERRACOTTA: Internal.BlockItem;
    static readonly END_STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly CALIBRATED_SCULK_SENSOR: Internal.BlockItem;
    static readonly COMPARATOR: Internal.BlockItem;
    static readonly LEATHER_HORSE_ARMOR: Internal.DyeableHorseArmorItem;
    static readonly STRIPPED_BAMBOO_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE_SLAB: Internal.BlockItem;
    static readonly MUD_BRICK_WALL: Internal.BlockItem;
    static readonly MOSS_BLOCK: Internal.BlockItem;
    static readonly CRIMSON_STAIRS: Internal.BlockItem;
    static readonly CREEPER_HEAD: Internal.StandingAndWallBlockItem;
    static readonly JUNGLE_DOOR: Internal.DoubleHighBlockItem;
    static readonly BLACK_TERRACOTTA: Internal.BlockItem;
    static readonly COOKIE: Internal.Item;
    static readonly GRANITE: Internal.BlockItem;
    static readonly LEATHER: Internal.Item;
    static readonly SALMON_BUCKET: Internal.MobBucketItem;
    static readonly DANDELION: Internal.BlockItem;
    static readonly WARPED_HANGING_SIGN: Internal.HangingSignItem;
    static readonly PRISMARINE_BRICK_SLAB: Internal.BlockItem;
    static readonly RED_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly IRON_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly IRON_SWORD: Internal.SwordItem;
    static readonly BONE_MEAL: Internal.BoneMealItem;
    static readonly GRAY_STAINED_GLASS: Internal.BlockItem;
    static readonly DEAD_FIRE_CORAL_BLOCK: Internal.BlockItem;
    static readonly POINTED_DRIPSTONE: Internal.BlockItem;
    static readonly PURPUR_SLAB: Internal.BlockItem;
    static readonly BIRCH_LEAVES: Internal.BlockItem;
    static readonly ORANGE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly ALLAY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly COW_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ARMS_UP_POTTERY_SHERD: Internal.Item;
    static readonly BLUE_WOOL: Internal.BlockItem;
    static readonly LIGHT_BLUE_TERRACOTTA: Internal.BlockItem;
    static readonly MUSIC_DISC_WARD: Internal.RecordItem;
    static readonly PINK_CONCRETE_POWDER: Internal.BlockItem;
    static readonly BLUE_STAINED_GLASS: Internal.BlockItem;
    static readonly ANDESITE_STAIRS: Internal.BlockItem;
    static readonly CHORUS_FRUIT: Internal.ChorusFruitItem;
    static readonly VINE: Internal.BlockItem;
    static readonly COAL_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_WALL: Internal.BlockItem;
    static readonly MUSIC_DISC_OTHERSIDE: Internal.RecordItem;
    static readonly MOSSY_STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SNOW_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SCULK: Internal.BlockItem;
    static readonly POLISHED_ANDESITE: Internal.BlockItem;
    static readonly JUNGLE_SIGN: Internal.SignItem;
    static readonly COCOA_BEANS: Internal.ItemNameBlockItem;
    static readonly CYAN_STAINED_GLASS: Internal.BlockItem;
    static readonly BAMBOO_FENCE_GATE: Internal.BlockItem;
    static readonly PURPLE_DYE: Internal.DyeItem;
    static readonly CYAN_TERRACOTTA: Internal.BlockItem;
    static readonly BLACKSTONE_STAIRS: Internal.BlockItem;
    static readonly GLOBE_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly SPRUCE_LOG: Internal.BlockItem;
    static readonly TUBE_CORAL_BLOCK: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER: Internal.BlockItem;
    static readonly GREEN_SHULKER_BOX: Internal.BlockItem;
    static readonly CONDUIT: Internal.BlockItem;
    static readonly GLISTERING_MELON_SLICE: Internal.Item;
    static readonly RAVAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SKELETON_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static readonly BAMBOO: Internal.BlockItem;
    static readonly COOKED_PORKCHOP: Internal.Item;
    static readonly GOLDEN_SHOVEL: Internal.ShovelItem;
    static readonly CUT_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly MOSSY_STONE_BRICKS: Internal.BlockItem;
    static readonly DIAMOND_HELMET: Internal.ArmorItem;
    static readonly BAMBOO_DOOR: Internal.DoubleHighBlockItem;
    static readonly POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SMOOTH_STONE_SLAB: Internal.BlockItem;
    static readonly IRON_LEGGINGS: Internal.ArmorItem;
    static readonly SMOKER: Internal.BlockItem;
    static readonly STRIPPED_BIRCH_WOOD: Internal.BlockItem;
    static readonly SPRUCE_BOAT: Internal.BoatItem;
    static readonly MOSS_CARPET: Internal.BlockItem;
    static readonly FIREWORK_ROCKET: Internal.FireworkRocketItem;
    static readonly OCHRE_FROGLIGHT: Internal.BlockItem;
    static readonly CHISELED_DEEPSLATE: Internal.BlockItem;
    static readonly CHERRY_LEAVES: Internal.BlockItem;
    static readonly NETHER_BRICK_FENCE: Internal.BlockItem;
    static readonly CHISELED_RED_SANDSTONE: Internal.BlockItem;
    static readonly TADPOLE_BUCKET: Internal.MobBucketItem;
    static readonly DRAGON_EGG: Internal.BlockItem;
    static readonly PRIZE_POTTERY_SHERD: Internal.Item;
    static readonly DARK_OAK_PLANKS: Internal.BlockItem;
    static readonly COOKED_RABBIT: Internal.Item;
    static readonly CHERRY_BOAT: Internal.BoatItem;
    static readonly END_STONE_BRICK_WALL: Internal.BlockItem;
    static readonly GREEN_DYE: Internal.DyeItem;
    static readonly MUSIC_DISC_WAIT: Internal.RecordItem;
    static readonly RED_NETHER_BRICK_WALL: Internal.BlockItem;
    static readonly PITCHER_PLANT: Internal.BlockItem;
    static readonly LIME_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PRISMARINE_STAIRS: Internal.BlockItem;
    static readonly MANGROVE_BUTTON: Internal.BlockItem;
    static readonly AMETHYST_CLUSTER: Internal.BlockItem;
    static readonly CHISELED_SANDSTONE: Internal.BlockItem;
    static readonly DEEPSLATE_COAL_ORE: Internal.BlockItem;
    static readonly STRIPPED_MANGROVE_WOOD: Internal.BlockItem;
    static readonly STONE_BUTTON: Internal.BlockItem;
    static readonly RED_DYE: Internal.DyeItem;
    static readonly SPLASH_POTION: Internal.SplashPotionItem;
    static readonly PURPLE_TERRACOTTA: Internal.BlockItem;
    static readonly STRIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OXEYE_DAISY: Internal.BlockItem;
    static readonly SPRUCE_SLAB: Internal.BlockItem;
    static readonly PINK_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly STRIPPED_CHERRY_WOOD: Internal.BlockItem;
    static readonly REPEATING_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly CHERRY_SIGN: Internal.SignItem;
    static readonly CRYING_OBSIDIAN: Internal.BlockItem;
    static readonly RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CREEPER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BAMBOO_BLOCK: Internal.BlockItem;
    static readonly SCULK_SHRIEKER: Internal.BlockItem;
    static readonly GOLDEN_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly POLISHED_DEEPSLATE: Internal.BlockItem;
    static readonly YELLOW_CONCRETE: Internal.BlockItem;
    static readonly LIGHT_GRAY_WOOL: Internal.BlockItem;
    static readonly PINK_PETALS: Internal.BlockItem;
    static readonly YELLOW_DYE: Internal.DyeItem;
    static readonly CRIMSON_DOOR: Internal.DoubleHighBlockItem;
    static readonly PURPLE_CARPET: Internal.BlockItem;
    static readonly WITHER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BEETROOT_SOUP: Internal.BowlFoodItem;
    static readonly CRIMSON_ROOTS: Internal.BlockItem;
    static readonly BLACKSTONE: Internal.BlockItem;
    static readonly FLOWERING_AZALEA_LEAVES: Internal.BlockItem;
    static readonly OAK_BOAT: Internal.BoatItem;
    static readonly POLISHED_ANDESITE_STAIRS: Internal.BlockItem;
    static readonly BROWN_BED: Internal.BedItem;
    static readonly BLUE_CANDLE: Internal.BlockItem;
    static readonly STRIPPED_CRIMSON_HYPHAE: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static readonly SPRUCE_WOOD: Internal.BlockItem;
    static readonly BAMBOO_HANGING_SIGN: Internal.HangingSignItem;
    static readonly TARGET: Internal.BlockItem;
    static readonly SOUL_SAND: Internal.BlockItem;
    static readonly DAYLIGHT_DETECTOR: Internal.BlockItem;
    static readonly MOOSHROOM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PRISMARINE_BRICKS: Internal.BlockItem;
    static readonly DAMAGED_ANVIL: Internal.BlockItem;
    static readonly YELLOW_TERRACOTTA: Internal.BlockItem;
    static readonly RAW_IRON_BLOCK: Internal.BlockItem;
    static readonly TROPICAL_FISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BAMBOO_STAIRS: Internal.BlockItem;
    static readonly INK_SAC: Internal.InkSacItem;
    static readonly LINGERING_POTION: Internal.LingeringPotionItem;
    static readonly BRAIN_CORAL: Internal.BlockItem;
    static readonly SPRUCE_DOOR: Internal.DoubleHighBlockItem;
    static readonly GILDED_BLACKSTONE: Internal.BlockItem;
    static readonly PRISMARINE: Internal.BlockItem;
    static readonly SOUL_CAMPFIRE: Internal.BlockItem;
    static readonly LECTERN: Internal.BlockItem;
    static readonly SHROOMLIGHT: Internal.BlockItem;
    static readonly GOLD_BLOCK: Internal.BlockItem;
    static readonly BRICK_SLAB: Internal.BlockItem;
    static readonly MUD_BRICKS: Internal.BlockItem;
    static readonly JUNGLE_FENCE: Internal.BlockItem;
    static readonly SNIFFER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHERRY_TRAPDOOR: Internal.BlockItem;
    static readonly MANGROVE_LEAVES: Internal.BlockItem;
    static readonly PAINTING: Internal.HangingEntityItem;
    static readonly MANGROVE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly IRON_BLOCK: Internal.BlockItem;
    static readonly ARROW: Internal.ArrowItem;
    static readonly DEAD_BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static readonly STRIPPED_DARK_OAK_LOG: Internal.BlockItem;
    static readonly WHITE_CARPET: Internal.BlockItem;
    static readonly DIAMOND_BLOCK: Internal.BlockItem;
    static readonly CRIMSON_STEM: Internal.BlockItem;
    static readonly SOUL_LANTERN: Internal.BlockItem;
    static readonly BLUE_BANNER: Internal.BannerItem;
    static readonly WRITABLE_BOOK: Internal.WritableBookItem;
    static readonly PURPLE_SHULKER_BOX: Internal.BlockItem;
    static readonly CUT_RED_SANDSTONE: Internal.BlockItem;
    static readonly LIME_CANDLE: Internal.BlockItem;
    static readonly STRAY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STRIPPED_BIRCH_LOG: Internal.BlockItem;
    static readonly DEEPSLATE_TILE_WALL: Internal.BlockItem;
    static readonly SLIME_BLOCK: Internal.BlockItem;
    static readonly NETHER_WART_BLOCK: Internal.BlockItem;
    static readonly DEEPSLATE_TILE_SLAB: Internal.BlockItem;
    static readonly BAMBOO_MOSAIC_SLAB: Internal.BlockItem;
    static readonly END_STONE_BRICKS: Internal.BlockItem;
    static readonly SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CRIMSON_FENCE: Internal.BlockItem;
    static readonly SUSPICIOUS_SAND: Internal.BlockItem;
    static readonly CRACKED_NETHER_BRICKS: Internal.BlockItem;
    static readonly STRUCTURE_BLOCK: Internal.GameMasterBlockItem;
    static readonly CAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly IRON_BOOTS: Internal.ArmorItem;
    static readonly STRIPPED_OAK_WOOD: Internal.BlockItem;
    static readonly PISTON: Internal.BlockItem;
    static readonly NETHERITE_UPGRADE_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly DEEPSLATE_BRICK_WALL: Internal.BlockItem;
    static readonly COD_BUCKET: Internal.MobBucketItem;
    static readonly HONEY_BOTTLE: Internal.HoneyBottleItem;
    static readonly EXPOSED_COPPER: Internal.BlockItem;
    static readonly MUSIC_DISC_STRAD: Internal.RecordItem;
    static readonly GREEN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PINK_BED: Internal.BedItem;
    static readonly LADDER: Internal.BlockItem;
    static readonly SCULK_CATALYST: Internal.BlockItem;
    static readonly BLUE_CONCRETE: Internal.BlockItem;
    static readonly BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly SNOW_BLOCK: Internal.BlockItem;
    static readonly BAMBOO_CHEST_RAFT: Internal.BoatItem;
    static readonly SALMON: Internal.Item;
    static readonly DISPENSER: Internal.BlockItem;
    static readonly DIAMOND_BOOTS: Internal.ArmorItem;
    static readonly OAK_STAIRS: Internal.BlockItem;
    static readonly RED_BANNER: Internal.BannerItem;
    static readonly IRON_AXE: Internal.AxeItem;
    static readonly DEEPSLATE_LAPIS_ORE: Internal.BlockItem;
    static readonly SILVERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ENDERMAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GOLDEN_AXE: Internal.AxeItem;
    static readonly OAK_FENCE_GATE: Internal.BlockItem;
    static readonly GRANITE_STAIRS: Internal.BlockItem;
    static readonly CHARCOAL: Internal.Item;
    static readonly WOODEN_PICKAXE: Internal.PickaxeItem;
    static readonly MELON: Internal.BlockItem;
    static readonly ECHO_SHARD: Internal.Item;
    static readonly BAMBOO_PLANKS: Internal.BlockItem;
    static readonly DIRT_PATH: Internal.BlockItem;
    static readonly DEEPSLATE: Internal.BlockItem;
    static readonly WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly WHITE_BED: Internal.BedItem;
    static readonly DIORITE_STAIRS: Internal.BlockItem;
    static readonly MANGROVE_FENCE_GATE: Internal.BlockItem;
    static readonly RECOVERY_COMPASS: Internal.Item;
    static readonly SNOW: Internal.BlockItem;
    static readonly GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly GHAST_TEAR: Internal.Item;
    static readonly GOLDEN_CARROT: Internal.Item;
    static readonly FERN: Internal.BlockItem;
    static readonly CORNFLOWER: Internal.BlockItem;
    static readonly CHAIN_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly ZOMBIE_VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIME_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly JUNGLE_FENCE_GATE: Internal.BlockItem;
    static readonly GREEN_BANNER: Internal.BannerItem;
    static readonly TRIPWIRE_HOOK: Internal.BlockItem;
    static readonly EVOKER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SALMON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DEEPSLATE_BRICK_SLAB: Internal.BlockItem;
    static readonly RAW_GOLD: Internal.Item;
    static readonly BIRCH_SIGN: Internal.SignItem;
    static readonly FROGSPAWN: Internal.PlaceOnWaterBlockItem;
    static readonly SADDLE: Internal.SaddleItem;
    static readonly YELLOW_WOOL: Internal.BlockItem;
    static readonly TRIDENT: Internal.TridentItem;
    static readonly LIGHT_BLUE_CONCRETE: Internal.BlockItem;
    static readonly WARPED_BUTTON: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BUTTON: Internal.BlockItem;
    static readonly SLIME_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OAK_WOOD: Internal.BlockItem;
    static readonly ENDER_CHEST: Internal.BlockItem;
    static readonly REDSTONE_BLOCK: Internal.BlockItem;
    static readonly ORANGE_BED: Internal.BedItem;
    static readonly CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly WANDERING_TRADER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WAXED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly CRIMSON_FENCE_GATE: Internal.BlockItem;
    static readonly WAXED_WEATHERED_CUT_COPPER: Internal.BlockItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly QUARTZ_BLOCK: Internal.BlockItem;
    static readonly BAMBOO_SLAB: Internal.BlockItem;
    static readonly RAIL: Internal.BlockItem;
    static readonly EMERALD_BLOCK: Internal.BlockItem;
    static readonly CUT_COPPER: Internal.BlockItem;
    static readonly POPPY: Internal.BlockItem;
    static readonly ACACIA_BUTTON: Internal.BlockItem;
    static readonly ANDESITE_WALL: Internal.BlockItem;
    static readonly LEATHER_HELMET: Internal.DyeableArmorItem;
    static readonly ACACIA_SAPLING: Internal.BlockItem;
    static readonly CARTOGRAPHY_TABLE: Internal.BlockItem;
    static readonly RED_TULIP: Internal.BlockItem;
    static readonly TRAPPED_CHEST: Internal.BlockItem;
    static readonly MANGROVE_LOG: Internal.BlockItem;
    static readonly DARK_OAK_PRESSURE_PLATE: Internal.BlockItem;
    static readonly CHERRY_LOG: Internal.BlockItem;
    static readonly CHIPPED_ANVIL: Internal.BlockItem;
    static readonly MAGMA_BLOCK: Internal.BlockItem;
    static readonly GUNPOWDER: Internal.Item;
    static readonly OXIDIZED_COPPER: Internal.BlockItem;
    static readonly BLACK_SHULKER_BOX: Internal.BlockItem;
    static readonly BLUE_DYE: Internal.DyeItem;
    static readonly PACKED_ICE: Internal.BlockItem;
    static readonly PEONY: Internal.DoubleHighBlockItem;
    static readonly CRIMSON_FUNGUS: Internal.BlockItem;
    static readonly JUNGLE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly JUNGLE_WOOD: Internal.BlockItem;
    static readonly ORANGE_SHULKER_BOX: Internal.BlockItem;
    static readonly BEETROOT_SEEDS: Internal.ItemNameBlockItem;
    static readonly IRON_CHESTPLATE: Internal.ArmorItem;
    static readonly GOLDEN_APPLE: Internal.Item;
    static readonly LIGHT_BLUE_BED: Internal.BedItem;
    static readonly WARPED_TRAPDOOR: Internal.BlockItem;
    static readonly CACTUS: Internal.BlockItem;
    static readonly TORCH: Internal.StandingAndWallBlockItem;
    static readonly GLASS_BOTTLE: Internal.BottleItem;
    static readonly MAGENTA_SHULKER_BOX: Internal.BlockItem;
    static readonly STRUCTURE_VOID: Internal.BlockItem;
    static readonly DEAD_TUBE_CORAL_BLOCK: Internal.BlockItem;
    static readonly GREEN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly MUSIC_DISC_BLOCKS: Internal.RecordItem;
    static readonly COOKED_BEEF: Internal.Item;
    static readonly DIAMOND_SHOVEL: Internal.ShovelItem;
    static readonly WOODEN_SWORD: Internal.SwordItem;
    static readonly CRIMSON_SIGN: Internal.SignItem;
    static readonly NETHER_BRICK: Internal.Item;
    static readonly STONE_AXE: Internal.AxeItem;
    static readonly DEAD_BUSH: Internal.BlockItem;
    static readonly CYAN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly SPRUCE_CHEST_BOAT: Internal.BoatItem;
    static readonly DEEPSLATE_BRICK_STAIRS: Internal.BlockItem;
    static readonly WHITE_BANNER: Internal.BannerItem;
    static readonly GRANITE_SLAB: Internal.BlockItem;
    static readonly MOSSY_STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly OAK_SLAB: Internal.BlockItem;
    static readonly DEAD_BUBBLE_CORAL: Internal.BlockItem;
    static readonly WARPED_FENCE_GATE: Internal.BlockItem;
    static readonly MINER_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_MUSHROOM: Internal.BlockItem;
    static readonly SPRUCE_PLANKS: Internal.BlockItem;
    static readonly WOLF_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MAGENTA_BANNER: Internal.BannerItem;
    static readonly CYAN_SHULKER_BOX: Internal.BlockItem;
    static readonly WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly RAW_IRON: Internal.Item;
    static readonly WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly RED_SANDSTONE: Internal.BlockItem;
    static readonly STRIPPED_DARK_OAK_WOOD: Internal.BlockItem;
    static readonly BAMBOO_FENCE: Internal.BlockItem;
    static readonly INFESTED_DEEPSLATE: Internal.BlockItem;
    static readonly IRON_BARS: Internal.BlockItem;
    static readonly SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly BEDROCK: Internal.BlockItem;
    static readonly MOURNER_POTTERY_SHERD: Internal.Item;
    static readonly STRIPPED_CHERRY_LOG: Internal.BlockItem;
    static readonly TNT_MINECART: Internal.MinecartItem;
    static readonly BEE_NEST: Internal.BlockItem;
    static readonly ACTIVATOR_RAIL: Internal.BlockItem;
    static readonly MUSIC_DISC_5: Internal.RecordItem;
    static readonly DEAD_FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly GOLDEN_HELMET: Internal.ArmorItem;
    static readonly STRIPPED_WARPED_HYPHAE: Internal.BlockItem;
    static readonly MAGENTA_CARPET: Internal.BlockItem;
    static readonly TORCHFLOWER_SEEDS: Internal.ItemNameBlockItem;
    static readonly HONEY_BLOCK: Internal.BlockItem;
    static readonly STRIPPED_ACACIA_LOG: Internal.BlockItem;
    static readonly FRIEND_POTTERY_SHERD: Internal.Item;
    static readonly RAW_GOLD_BLOCK: Internal.BlockItem;
    static readonly WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static readonly SMOOTH_SANDSTONE: Internal.BlockItem;
    static readonly SPRUCE_SAPLING: Internal.BlockItem;
    static readonly DOLPHIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHERITE_PICKAXE: Internal.PickaxeItem;
    static readonly GRANITE_WALL: Internal.BlockItem;
    static readonly BRICK_STAIRS: Internal.BlockItem;
    static readonly LIME_WOOL: Internal.BlockItem;
    static readonly CHAINMAIL_CHESTPLATE: Internal.ArmorItem;
    static readonly WOODEN_HOE: Internal.HoeItem;
    static readonly HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WATER_BUCKET: Internal.BucketItem;
    static readonly SMOOTH_QUARTZ_SLAB: Internal.BlockItem;
    static readonly WAXED_CUT_COPPER: Internal.BlockItem;
    static readonly HORN_CORAL: Internal.BlockItem;
    static readonly BLACKSTONE_WALL: Internal.BlockItem;
    static readonly MUSIC_DISC_STAL: Internal.RecordItem;
    static readonly SPONGE: Internal.BlockItem;
    static readonly PIGLIN_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly RAW_COPPER: Internal.Item;
    static readonly DARK_OAK_BOAT: Internal.BoatItem;
    static readonly REDSTONE_ORE: Internal.BlockItem;
    static readonly ANDESITE_SLAB: Internal.BlockItem;
    static readonly BOWL: Internal.Item;
    static readonly BLACK_WOOL: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static readonly BEEF: Internal.Item;
    static readonly COBBLESTONE_SLAB: Internal.BlockItem;
    static readonly CYAN_CANDLE: Internal.BlockItem;
    static readonly ACACIA_DOOR: Internal.DoubleHighBlockItem;
    static readonly SPRUCE_STAIRS: Internal.BlockItem;
    static readonly HEARTBREAK_POTTERY_SHERD: Internal.Item;
    static readonly CRIMSON_HYPHAE: Internal.BlockItem;
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class PonderPalette extends Internal.Enum<PonderPalette> {
    getColor(): number;
    static values(): PonderPalette[];
    static valueOf(name: string): PonderPalette;
    getColorObject(): com.simibubi.create.foundation.utility.Color;
    get color(): number
    get colorObject(): com.simibubi.create.foundation.utility.Color
    static readonly BLACK: PonderPalette;
    static readonly GREEN: PonderPalette;
    static readonly INPUT: PonderPalette;
    static readonly BLUE: PonderPalette;
    static readonly FAST: PonderPalette;
    static readonly OUTPUT: PonderPalette;
    static readonly MEDIUM: PonderPalette;
    static readonly WHITE: PonderPalette;
    static readonly RED: PonderPalette;
    static readonly SLOW: PonderPalette;
}
type PonderPalette_ = "medium" | "slow" | PonderPalette | "white" | "output" | "red" | "input" | "blue" | "fast" | "black" | "green";
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare class SoundType {
    constructor($$0: number, $$1: number, $$2: Internal.SoundEvent_, $$3: Internal.SoundEvent_, $$4: Internal.SoundEvent_, $$5: Internal.SoundEvent_, $$6: Internal.SoundEvent_)
    getVolume(): number;
    getPitch(): number;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    getBreakSound(): Internal.SoundEvent;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    get volume(): number
    get pitch(): number
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get breakSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    static readonly EMPTY: SoundType;
    static readonly SAND: SoundType;
    static readonly DECORATED_POT: SoundType;
    static readonly TUFF: SoundType;
    static readonly GRAVEL: SoundType;
    static readonly SHROOMLIGHT: SoundType;
    static readonly MOSS: SoundType;
    readonly pitch: number;
    static readonly GRASS: SoundType;
    static readonly SOUL_SOIL: SoundType;
    static readonly WEEPING_VINES: SoundType;
    static readonly ANCIENT_DEBRIS: SoundType;
    static readonly SCULK_SENSOR: SoundType;
    static readonly POINTED_DRIPSTONE: SoundType;
    static readonly ROOTED_DIRT: SoundType;
    static readonly FROGSPAWN: SoundType;
    static readonly NETHER_ORE: SoundType;
    static readonly COPPER: SoundType;
    static readonly LANTERN: SoundType;
    static readonly BONE_BLOCK: SoundType;
    static readonly FROGLIGHT: SoundType;
    static readonly SNOW: SoundType;
    static readonly SCULK_VEIN: SoundType;
    static readonly CHERRY_WOOD: SoundType;
    static readonly POLISHED_DEEPSLATE: SoundType;
    static readonly NYLIUM: SoundType;
    static readonly DEEPSLATE: SoundType;
    static readonly SPORE_BLOSSOM: SoundType;
    static readonly BASALT: SoundType;
    static readonly CHERRY_WOOD_HANGING_SIGN: SoundType;
    static readonly SMALL_AMETHYST_BUD: SoundType;
    static readonly CANDLE: SoundType;
    static readonly FLOWERING_AZALEA: SoundType;
    static readonly ANVIL: SoundType;
    static readonly SCAFFOLDING: SoundType;
    static readonly DEEPSLATE_BRICKS: SoundType;
    static readonly CORAL_BLOCK: SoundType;
    static readonly BAMBOO_SAPLING: SoundType;
    static readonly LILY_PAD: SoundType;
    static readonly MOSS_CARPET: SoundType;
    static readonly LADDER: SoundType;
    static readonly LARGE_AMETHYST_BUD: SoundType;
    static readonly GLOW_LICHEN: SoundType;
    static readonly CROP: SoundType;
    static readonly PINK_PETALS: SoundType;
    static readonly AZALEA_LEAVES: SoundType;
    static readonly POWDER_SNOW: SoundType;
    static readonly METAL: SoundType;
    static readonly HONEY_BLOCK: SoundType;
    static readonly NETHER_BRICKS: SoundType;
    static readonly SUSPICIOUS_SAND: SoundType;
    static readonly GILDED_BLACKSTONE: SoundType;
    static readonly HARD_CROP: SoundType;
    static readonly SCULK_CATALYST: SoundType;
    static readonly DEEPSLATE_TILES: SoundType;
    static readonly PACKED_MUD: SoundType;
    static readonly SCULK: SoundType;
    static readonly VINE: SoundType;
    static readonly BAMBOO: SoundType;
    static readonly GLASS: SoundType;
    static readonly DRIPSTONE_BLOCK: SoundType;
    static readonly CHERRY_SAPLING: SoundType;
    static readonly CALCITE: SoundType;
    static readonly MUD_BRICKS: SoundType;
    static readonly STEM: SoundType;
    static readonly BAMBOO_WOOD: SoundType;
    static readonly SOUL_SAND: SoundType;
    static readonly MUD: SoundType;
    static readonly BIG_DRIPLEAF: SoundType;
    static readonly BAMBOO_WOOD_HANGING_SIGN: SoundType;
    static readonly TWISTING_VINES: SoundType;
    static readonly NETHERRACK: SoundType;
    static readonly AMETHYST_CLUSTER: SoundType;
    static readonly SLIME_BLOCK: SoundType;
    static readonly SCULK_SHRIEKER: SoundType;
    static readonly CHAIN: SoundType;
    static readonly WOOD: SoundType;
    static readonly AZALEA: SoundType;
    static readonly MANGROVE_ROOTS: SoundType;
    static readonly CHISELED_BOOKSHELF: SoundType;
    static readonly NETHER_GOLD_ORE: SoundType;
    static readonly CHERRY_LEAVES: SoundType;
    static readonly AMETHYST: SoundType;
    static readonly DECORATED_POT_CRACKED: SoundType;
    static readonly CAVE_VINES: SoundType;
    static readonly SUSPICIOUS_GRAVEL: SoundType;
    static readonly LODESTONE: SoundType;
    readonly volume: number;
    static readonly FUNGUS: SoundType;
    static readonly SMALL_DRIPLEAF: SoundType;
    static readonly HANGING_ROOTS: SoundType;
    static readonly SWEET_BERRY_BUSH: SoundType;
    static readonly NETHER_WOOD: SoundType;
    static readonly NETHER_WART: SoundType;
    static readonly STONE: SoundType;
    static readonly NETHER_WOOD_HANGING_SIGN: SoundType;
    static readonly HANGING_SIGN: SoundType;
    static readonly WET_GRASS: SoundType;
    static readonly NETHERITE_BLOCK: SoundType;
    static readonly MEDIUM_AMETHYST_BUD: SoundType;
    static readonly MUDDY_MANGROVE_ROOTS: SoundType;
    static readonly WOOL: SoundType;
    static readonly ROOTS: SoundType;
    static readonly WART_BLOCK: SoundType;
    static readonly NETHER_SPROUTS: SoundType;
}
type SoundType_ = SoundType;
declare class Stats {
    constructor()
    static makeCustomStat($$0: string, $$1: Internal.StatFormatter_): ResourceLocation;
    static readonly SWIM_ONE_CM: ResourceLocation;
    static readonly FLY_ONE_CM: ResourceLocation;
    static readonly CLEAN_SHULKER_BOX: ResourceLocation;
    static readonly TOTAL_WORLD_TIME: ResourceLocation;
    static readonly TUNE_NOTEBLOCK: ResourceLocation;
    static readonly DAMAGE_RESISTED: ResourceLocation;
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: ResourceLocation;
    static readonly INTERACT_WITH_BREWINGSTAND: ResourceLocation;
    static readonly INTERACT_WITH_CAMPFIRE: ResourceLocation;
    static readonly INSPECT_DISPENSER: ResourceLocation;
    static readonly INTERACT_WITH_FURNACE: ResourceLocation;
    static readonly OPEN_ENDERCHEST: ResourceLocation;
    static readonly ANIMALS_BRED: ResourceLocation;
    static readonly POT_FLOWER: ResourceLocation;
    static readonly INTERACT_WITH_STONECUTTER: ResourceLocation;
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: ResourceLocation;
    static readonly DAMAGE_ABSORBED: ResourceLocation;
    static readonly FISH_CAUGHT: ResourceLocation;
    static readonly INTERACT_WITH_ANVIL: ResourceLocation;
    static readonly BOAT_ONE_CM: ResourceLocation;
    static readonly PLAY_RECORD: ResourceLocation;
    static readonly DAMAGE_DEALT_RESISTED: ResourceLocation;
    static readonly RAID_WIN: ResourceLocation;
    static readonly DAMAGE_DEALT: ResourceLocation;
    static readonly DEATHS: ResourceLocation;
    static readonly INTERACT_WITH_SMOKER: ResourceLocation;
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: ResourceLocation;
    static readonly INTERACT_WITH_SMITHING_TABLE: ResourceLocation;
    static readonly INSPECT_DROPPER: ResourceLocation;
    static readonly DROP: ResourceLocation;
    static readonly INTERACT_WITH_LECTERN: ResourceLocation;
    static readonly PLAY_TIME: ResourceLocation;
    static readonly WALK_ONE_CM: ResourceLocation;
    static readonly CLIMB_ONE_CM: ResourceLocation;
    static readonly TRADED_WITH_VILLAGER: ResourceLocation;
    static readonly RAID_TRIGGER: ResourceLocation;
    static readonly STRIDER_ONE_CM: ResourceLocation;
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: ResourceLocation;
    static readonly INTERACT_WITH_BEACON: ResourceLocation;
    static readonly INSPECT_HOPPER: ResourceLocation;
    static readonly PLAY_NOTEBLOCK: ResourceLocation;
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: ResourceLocation;
    static readonly JUMP: ResourceLocation;
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: ResourceLocation;
    static readonly MOB_KILLS: ResourceLocation;
    static readonly OPEN_CHEST: ResourceLocation;
    static readonly SLEEP_IN_BED: ResourceLocation;
    static readonly CLEAN_ARMOR: ResourceLocation;
    static readonly CROUCH_ONE_CM: ResourceLocation;
    static readonly TALKED_TO_VILLAGER: ResourceLocation;
    static readonly DAMAGE_DEALT_ABSORBED: ResourceLocation;
    static readonly INTERACT_WITH_LOOM: ResourceLocation;
    static readonly LEAVE_GAME: ResourceLocation;
    static readonly HORSE_ONE_CM: ResourceLocation;
    static readonly WALK_ON_WATER_ONE_CM: ResourceLocation;
    static readonly MINECART_ONE_CM: ResourceLocation;
    static readonly ENCHANT_ITEM: ResourceLocation;
    static readonly TIME_SINCE_DEATH: ResourceLocation;
    static readonly DAMAGE_TAKEN: ResourceLocation;
    static readonly INTERACT_WITH_BLAST_FURNACE: ResourceLocation;
    static readonly TRIGGER_TRAPPED_CHEST: ResourceLocation;
    static readonly INTERACT_WITH_GRINDSTONE: ResourceLocation;
    static readonly OPEN_BARREL: ResourceLocation;
    static readonly SPRINT_ONE_CM: ResourceLocation;
    static readonly DAMAGE_BLOCKED_BY_SHIELD: ResourceLocation;
    static readonly EAT_CAKE_SLICE: ResourceLocation;
    static readonly INTERACT_WITH_CRAFTING_TABLE: ResourceLocation;
    static readonly CLEAN_BANNER: ResourceLocation;
    static readonly TARGET_HIT: ResourceLocation;
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: ResourceLocation;
    static readonly PIG_ONE_CM: ResourceLocation;
    static readonly OPEN_SHULKER_BOX: ResourceLocation;
    static readonly USE_CAULDRON: ResourceLocation;
    static readonly AVIATE_ONE_CM: ResourceLocation;
    static readonly FILL_CAULDRON: ResourceLocation;
}
type Stats_ = Stats;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    static parse(arg0: Internal.CharSequence_): Duration;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    minus(arg0: Duration_): this;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    plusNanos(arg0: number): this;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    toDaysPart(): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    minusMillis(arg0: number): this;
    dividedBy(arg0: Duration_): number;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: Duration;
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getNbt(): Internal.CompoundTag;
    getCount(): number;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    getChance(): number;
    isEmpty(): boolean;
    withCount(count: number): this;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    hasChance(): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get nbt(): Internal.CompoundTag
    get count(): number
    get chance(): number
    get empty(): boolean
    static readonly EMPTY: OutputItem;
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    static water(): Internal.FluidStackJS;
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: ResourceLocation;
    static readonly WATER_ID: ResourceLocation;
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    validForMatching(): boolean;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    unwrap(): Internal.List<InputItem>;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    isEmpty(): boolean;
    withCount(count: number): this;
    toJson(): Internal.JsonElement;
    kjs$asIngredient(): Internal.Ingredient;
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: InputItem;
    static readonly PARSE_CACHE: {"deeperdarker:warden_upgrade_smithing_template": InputItem, "lolmct:acacia_crafting_table": InputItem, "minecraft:redstone_torch": InputItem, "minecraft:oak_log": InputItem, "#create:seats": InputItem, "betterend:jellyshroom_log": InputItem, "minecraft:compass": InputItem, "terrestria:rubber_planks": InputItem, "regions_unexplored:kapok_planks": InputItem, "#minecraft:buttons": InputItem, "betterend:lacugrove_log": InputItem, "lolmct:jungle_crafting_table": InputItem, "create:sturdy_sheet": InputItem, "create:electron_tube": InputItem, "minecraft:emerald": InputItem, "create:display_link": InputItem, "betterend:end_lotus_crafting_table": InputItem, "betternether:nether_sakura_log": InputItem, "regions_unexplored:cypress_planks": InputItem, "regions_unexplored:baobab_planks": InputItem, "create:propeller": InputItem, "#c:stripped_logs": InputItem, "betternether:mushroom_fir_log": InputItem, "regions_unexplored:dead_log": InputItem, "create:precision_mechanism": InputItem, "lolmct:birch_crafting_table": InputItem, "create:steam_engine": InputItem, "minecraft:acacia_log": InputItem, "create:content_observer": InputItem, "#c:brass_plates": InputItem, "betternether:wart_crafting_table": InputItem, "terrestria:rainbow_eucalyptus_planks": InputItem, "regions_unexplored:pink_bioshroom_stem": InputItem, "terrestria:redwood_log": InputItem, "minecraft:chain": InputItem, "lolmct:bamboo_crafting_table": InputItem, "betterend:lucernia_crafting_table": InputItem, "create:iron_sheet": InputItem, "minecraft:sculk": InputItem, "betterend:helix_tree_crafting_table": InputItem, "betterend:umbrella_tree_crafting_table": InputItem, "terrestria:cypress_planks": InputItem, "#c:wooden_rods": InputItem, "betterend:helix_tree_log": InputItem, "terrestria:willow_planks": InputItem, "regions_unexplored:redwood_log": InputItem, "regions_unexplored:mauve_planks": InputItem, "create:blaze_burner": InputItem, "immersive_aircraft:sail": InputItem, "betternether:nether_reed_crafting_table": InputItem, "create:brass_casing": InputItem, "regions_unexplored:redwood_planks": InputItem, "betterend:dragon_tree_crafting_table": InputItem, "minecraft:paper": InputItem, "betternether:crimson_crafting_table": InputItem, "regions_unexplored:blackwood_planks": InputItem, "regions_unexplored:socotra_planks": InputItem, "immersive_aircraft:propeller": InputItem, "lolmct:warped_crafting_table": InputItem, "regions_unexplored:willow_log": InputItem, "terrestria:cypress_log": InputItem, "create:fluid_pipe": InputItem, "betterend:pythadendron_log": InputItem, "regions_unexplored:brimwood_planks": InputItem, "terrestria:yucca_palm_planks": InputItem, "regions_unexplored:magnolia_planks": InputItem, "regions_unexplored:eucalyptus_log": InputItem, "#minecraft:trapdoors": InputItem, "create:cogwheel": InputItem, "terrestria:rainbow_eucalyptus_log": InputItem, "minecraft:lava_bucket": InputItem, "regions_unexplored:maple_planks": InputItem, "toms_storage:ts.painted_trim": InputItem, "regions_unexplored:eucalyptus_planks": InputItem, "regions_unexplored:alpha_log": InputItem, "minecraft:dried_kelp": InputItem, "lolmct:crimson_crafting_table": InputItem, "create:fluid_tank": InputItem, "create:white_sail": InputItem, "minecraft:book": InputItem, "deeperdarker:echo_log": InputItem, "lolmct:cherry_crafting_table": InputItem, "betternether:wart_log": InputItem, "regions_unexplored:pine_planks": InputItem, "minecraft:chest": InputItem, "minecraft:spruce_log": InputItem, "minecraft:dark_oak_log": InputItem, "terrestria:sakura_log": InputItem, "immersive_aircraft:boiler": InputItem, "terrestria:hemlock_planks": InputItem, "toms_storage:ts.inventory_cable_connector": InputItem, "betternether:anchor_tree_crafting_table": InputItem, "#minecraft:wooden_slabs": InputItem, "betterend:dragon_tree_log": InputItem, "regions_unexplored:brimwood_log": InputItem, "minecraft:warped_stem": InputItem, "create:redstone_link": InputItem, "#minecraft:planks": InputItem, "minecraft:bamboo_block": InputItem, "minecraft:tnt": InputItem, "betterend:tenanea_log": InputItem, "regions_unexplored:baobab_log": InputItem, "betternether:rubeus_crafting_table": InputItem, "create:andesite_casing": InputItem, "regions_unexplored:pine_log": InputItem, "betterend:mossy_glowshroom_crafting_table": InputItem, "betternether:willow_log": InputItem, "betternether:mushroom_fir_crafting_table": InputItem, "regions_unexplored:cobalt_log": InputItem, "minecraft:copper_ingot": InputItem, "lolmct:spruce_crafting_table": InputItem, "minecraft:birch_log": InputItem, "create:belt_connector": InputItem, "regions_unexplored:palm_log": InputItem, "regions_unexplored:joshua_planks": InputItem, "minecraft:cherry_log": InputItem, "minecraft:iron_ingot": InputItem, "toms_storage:ts.inventory_cable": InputItem, "betternether:nether_mushroom_crafting_table": InputItem, "regions_unexplored:green_bioshroom_stem": InputItem, "regions_unexplored:palm_planks": InputItem, "betterend:umbrella_tree_log": InputItem, "betterarcheology:rotten_log": InputItem, "regions_unexplored:cypress_log": InputItem, "betternether:stalagnate_crafting_table": InputItem, "minecraft:crimson_stem": InputItem, "betterend:lucernia_log": InputItem, "betternether:nether_sakura_crafting_table": InputItem, "immersive_aircraft:hull": InputItem, "minecraft:ender_pearl": InputItem, "lolmct:mangrove_crafting_table": InputItem, "regions_unexplored:yellow_bioshroom_stem": InputItem, "regions_unexplored:socotra_log": InputItem, "lolmct:dark_oak_crafting_table": InputItem, "create:brass_tunnel": InputItem, "regions_unexplored:joshua_log": InputItem, "#c:glass_blocks": InputItem, "regions_unexplored:magnolia_log": InputItem, "regions_unexplored:dead_planks": InputItem, "betterend:tenanea_crafting_table": InputItem, "betternether:rubeus_log": InputItem, "betternether:nether_mushroom_stem": InputItem, "terrestria:yucca_palm_log": InputItem, "minecraft:string": InputItem, "create:brass_sheet": InputItem, "regions_unexplored:maple_log": InputItem, "#minecraft:logs": InputItem, "create:display_board": InputItem, "betternether:warped_crafting_table": InputItem, "terrestria:japanese_maple_log": InputItem, "regions_unexplored:blackwood_log": InputItem, "terrestria:redwood_planks": InputItem, "betterend:jellyshroom_crafting_table": InputItem, "betternether:stalagnate_log": InputItem, "minecraft:amethyst_shard": InputItem, "betterend:mossy_glowshroom_log": InputItem, "minecraft:water_bucket": InputItem, "terrestria:japanese_maple_planks": InputItem, "create:chute": InputItem, "betterend:end_lotus_log": InputItem, "create:smart_chute": InputItem, "regions_unexplored:larch_log": InputItem, "minecraft:mangrove_log": InputItem, "create:copper_sheet": InputItem, "minecraft:obsidian": InputItem, "#c:chests": InputItem, "regions_unexplored:kapok_log": InputItem, "regions_unexplored:mauve_log": InputItem, "deeperdarker:reinforced_echo_shard": InputItem, "betternether:anchor_tree_log": InputItem, "createaddition:diamond_grit": InputItem, "toms_storage:ts.inventory_connector": InputItem, "minecraft:stick": InputItem, "betterend:lacugrove_crafting_table": InputItem, "minecraft:jungle_log": InputItem, "regions_unexplored:willow_planks": InputItem, "minecraft:piston": InputItem, "terrestria:rubber_log": InputItem, "betternether:willow_crafting_table": InputItem, "betterend:pythadendron_crafting_table": InputItem, "terrestria:sakura_planks": InputItem, "terrestria:willow_log": InputItem, "terrestria:hemlock_log": InputItem, "regions_unexplored:blue_bioshroom_stem": InputItem, "regions_unexplored:cobalt_planks": InputItem};
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare class DamageSource {
    constructor($$0: Internal.Holder_<Internal.DamageType>)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Internal.Entity_, $$2: Internal.Entity_)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Internal.Entity_)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Vec3d_)
    getSourcePosition(): Vec3d;
    isIndirect(): boolean;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    getImmediate(): Internal.Entity;
    getFoodExhaustion(): number;
    getLocalizedDeathMessage($$0: Internal.LivingEntity_): Internal.Component;
    sourcePositionRaw(): Vec3d;
    is($$0: Internal.TagKey_<Internal.DamageType>): boolean;
    is($$0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    isCreativePlayer(): boolean;
    type(): Internal.DamageType;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    get sourcePosition(): Vec3d
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
}
type DamageSource_ = DamageSource;
declare class ParrotElement extends Internal.AnimatedSceneElement {
    setPositionOffset(position: Vec3d_, immediate: boolean): void;
    getRotation(): Vec3d;
    getPositionOffset(): Vec3d;
    setRotation(eulers: Vec3d_, immediate: boolean): void;
    setConductor(isConductor: boolean): void;
    static create(location: Vec3d_, pose: Internal.Supplier_<Internal.ParrotElement$ParrotPose>): ParrotElement;
    setPose(pose: Internal.ParrotElement$ParrotPose_): void;
    get rotation(): Vec3d
    get positionOffset(): Vec3d
    set conductor(isConductor: boolean)
    set pose(pose: Internal.ParrotElement$ParrotPose_)
}
type ParrotElement_ = ParrotElement;
declare interface Color {
    of(o: any): Internal.Color;
    rgba(r: number, g: number, b: number, a: number): Internal.Color;
    createMapped(o: any, ...names: string[]): Internal.Color;
    readonly DARK_PURPLE: Internal.ChatFormatting;
    readonly YELLOW: Internal.ChatFormatting;
    readonly CYAN_DYE: Internal.DyeColor;
    readonly GRAY: Internal.ChatFormatting;
    readonly BROWN_DYE: Internal.DyeColor;
    readonly LIGHT_PURPLE: Internal.ChatFormatting;
    readonly PURPLE_DYE: Internal.DyeColor;
    readonly DARK_AQUA: Internal.ChatFormatting;
    readonly GREEN: Internal.ChatFormatting;
    readonly LIGHT_GRAY_DYE: Internal.DyeColor;
    readonly WHITE: Internal.ChatFormatting;
    readonly MAGENTA_DYE: Internal.DyeColor;
    readonly RED: Internal.ChatFormatting;
    readonly BLACK_DYE: Internal.DyeColor;
    readonly TEXT: {"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting};
    readonly RED_DYE: Internal.DyeColor;
    readonly GRAY_DYE: Internal.DyeColor;
    readonly DARK_GRAY: Internal.ChatFormatting;
    readonly NONE: Internal.NoColor;
    readonly ORANGE_DYE: Internal.DyeColor;
    readonly WHITE_DYE: Internal.DyeColor;
    readonly DYE: {"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor};
    readonly BLACK: Internal.ChatFormatting;
    readonly BLUE: Internal.ChatFormatting;
    readonly DARK_GREEN: Internal.ChatFormatting;
    readonly DARK_RED: Internal.ChatFormatting;
    readonly GOLD: Internal.ChatFormatting;
    readonly MAP: {"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting};
    readonly GREEN_DYE: Internal.DyeColor;
    readonly LIGHT_BLUE_DYE: Internal.DyeColor;
    readonly AQUA: Internal.ChatFormatting;
    readonly DARK_BLUE: Internal.ChatFormatting;
    readonly PINK_DYE: Internal.DyeColor;
    readonly BLUE_DYE: Internal.DyeColor;
    readonly YELLOW_DYE: Internal.DyeColor;
    readonly LIME_DYE: Internal.DyeColor;
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    static read(path: Internal.Path_): Internal.Map<any, any>;
    static toPrettyString(json: Internal.JsonElement_): string;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static getJsonHashString(json: Internal.JsonElement_): string;
    static parse(string: string): any;
    static toObject(json: Internal.JsonElement_): any;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static toPrimitive(element: Internal.JsonElement_): any;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static of(o: any): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
}
type JsonIO_ = JsonIO;
declare class Platform {
    constructor()
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getMcVersion(): string;
    static getList(): Internal.Set<string>;
    static isClientEnvironment(): boolean;
    static isForge(): boolean;
    static isFabric(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    static isGeneratingData(): boolean;
    static getMinecraftVersionString(): string;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get mcVersion(): string
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get forge(): boolean
    get fabric(): boolean
    get modVersion(): string
    get generatingData(): boolean
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
    get name(): string
}
type Platform_ = Platform;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: Internal.UUID;
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: Internal.UUID;
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    longValue(): number;
    shortValue(): number;
    doubleValue(): number;
    intValue(): number;
    floatValue(): number;
    byteValue(): number;
}
type number_ = number;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    rotateY(arg0: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    set(arg0: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    set(arg0: Internal.FloatBuffer_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    z(): number;
    round(): this;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    get(arg0: number): number;
    mul(arg0: number, arg1: number, arg2: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    ceil(arg0: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    negate(): this;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    rotateZ(arg0: number): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    floor(): this;
    set(arg0: number[]): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    mul(arg0: Internal.Matrix3x2fc_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    div(arg0: number): this;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    x(): number;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    absolute(): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateY(arg0: number, arg1: Vec3f_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    distance(arg0: number, arg1: number, arg2: number): number;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    dot(arg0: Internal.Vector3fc_): number;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    rotateX(arg0: number): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    distance(arg0: Internal.Vector3fc_): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    max(arg0: Internal.Vector3fc_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    setFromAddress(arg0: number): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    z(): number;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    set(arg0: Internal.Vector4fc_): this;
    negate(arg0: Vec4f_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    length(): number;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    add(arg0: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    set(arg0: number): this;
    mul(arg0: Internal.Matrix4fc_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    write(buf: Internal.FriendlyByteBuf_): void;
    setAtlasIcon(icon: string): void;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    setItemIcon(stack: Internal.ItemStack_): void;
    set atlasIcon(icon: string)
    set icon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: Duration;
    backgroundColor: Internal.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: Internal.SimpleColor;
    static readonly DEFAULT_BORDER_COLOR: Internal.SimpleColor;
    borderColor: Internal.Color;
    text: Internal.Component;
    outlineColor: Internal.Color;
    textShadow: boolean;
    static readonly NO_TEXT: Internal.Component[];
}
type Notification_ = Notification;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
declare interface Facing {
    readonly south: Internal.Direction;
    readonly up: Internal.Direction;
    readonly UP: Internal.Direction;
    readonly NORTH: Internal.Direction;
    readonly east: Internal.Direction;
    readonly DOWN: Internal.Direction;
    readonly EAST: Internal.Direction;
    readonly west: Internal.Direction;
    readonly north: Internal.Direction;
    readonly down: Internal.Direction;
    readonly ALL: {"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction};
    readonly WEST: Internal.Direction;
    readonly SOUTH: Internal.Direction;
}
type Facing_ = Facing;
declare const Facing: Facing;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: Internal.CustomIngredientImpl;
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: Internal.Ingredient;
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnit(arg0: Vec4f_): Vec4f;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normalize(arg0: Quaternionf_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    lengthSquared(): number;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix3f_): Matrix3f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    set(arg0: Internal.AxisAngle4d_): this;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    set fromNormalized(arg0: Internal.Matrix4fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class JavaMath {
    static asin(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static exp(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static random(): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static abs(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static rint(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    static tan(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static toRadians(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static toDegrees(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static tanh(arg0: number): number;
    static nextDown(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static nextDown(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static readonly PI: 3.141592653589793;
    static readonly E: 2.718281828459045;
}
type JavaMath_ = JavaMath;
declare class BlockProperties {
    constructor()
    static readonly LEVEL_FLOWING: Internal.IntegerProperty;
    static readonly PERSISTENT: Internal.BooleanProperty;
    static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: Internal.BooleanProperty;
    static readonly NOTE: Internal.IntegerProperty;
    static readonly AGE_5: Internal.IntegerProperty;
    static readonly EGGS: Internal.IntegerProperty;
    static readonly NORTH: Internal.BooleanProperty;
    static readonly HAS_RECORD: Internal.BooleanProperty;
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: Internal.IntegerProperty;
    static readonly HANGING: Internal.BooleanProperty;
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: Internal.BooleanProperty;
    static readonly HAS_BOTTLE_2: Internal.BooleanProperty;
    static readonly LAYERS: Internal.IntegerProperty;
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: Internal.BooleanProperty;
    static readonly CONDITIONAL: Internal.BooleanProperty;
    static readonly LOCKED: Internal.BooleanProperty;
    static readonly POWER: Internal.IntegerProperty;
    static readonly EYE: Internal.BooleanProperty;
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: 1;
    static readonly ATTACHED: Internal.BooleanProperty;
    static readonly MAX_LEVEL_15: 15;
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: 7;
    static readonly FLOWER_AMOUNT: Internal.IntegerProperty;
    static readonly EXTENDED: Internal.BooleanProperty;
    static readonly INVERTED: Internal.BooleanProperty;
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: Internal.IntegerProperty;
    static readonly LIT: Internal.BooleanProperty;
    static DISTANCE: Internal.IntegerProperty;
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: Internal.IntegerProperty;
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: 8;
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: 0;
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: Internal.BooleanProperty;
    static readonly ENABLED: Internal.BooleanProperty;
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: Internal.BooleanProperty;
    static readonly UNSTABLE: Internal.BooleanProperty;
    static readonly AGE_4: Internal.IntegerProperty;
    static readonly EAST: Internal.BooleanProperty;
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: 4;
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: 7;
    static readonly DOWN: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: Internal.BooleanProperty;
    static readonly AGE_15: Internal.IntegerProperty;
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: Internal.BooleanProperty;
    static readonly BLOOM: Internal.BooleanProperty;
    static readonly SHRIEKING: Internal.BooleanProperty;
    static readonly AGE_1: Internal.IntegerProperty;
    static readonly FACING_HOPPER: Internal.DirectionProperty;
    static readonly VERTICAL_DIRECTION: Internal.DirectionProperty;
    static readonly PICKLES: Internal.IntegerProperty;
    static readonly MAX_AGE_25: 25;
    static readonly LEVEL_HONEY: Internal.IntegerProperty;
    static readonly DUSTED: Internal.IntegerProperty;
    static readonly MAX_AGE_4: 4;
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: Internal.IntegerProperty;
    static readonly SNOWY: Internal.BooleanProperty;
    static readonly TRIGGERED: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: Internal.BooleanProperty;
    static readonly SIGNAL_FIRE: Internal.BooleanProperty;
    static readonly LEVEL_CAULDRON: Internal.IntegerProperty;
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: Internal.IntegerProperty;
    static readonly DRAG: Internal.BooleanProperty;
    static readonly CAN_SUMMON: Internal.BooleanProperty;
    static readonly LEVEL: Internal.IntegerProperty;
    static readonly STAGE: Internal.IntegerProperty;
    static readonly MAX_AGE_5: 5;
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: Internal.BooleanProperty;
    static readonly BITES: Internal.IntegerProperty;
    static readonly IN_WALL: Internal.BooleanProperty;
    static readonly AGE_25: Internal.IntegerProperty;
    static readonly STABILITY_MAX_DISTANCE: 7;
    static readonly HAS_BOTTLE_1: Internal.BooleanProperty;
    static readonly AGE_7: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: Internal.BooleanProperty;
    static readonly SOUTH: Internal.BooleanProperty;
    static readonly MAX_AGE_15: 15;
    static readonly DISARMED: Internal.BooleanProperty;
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: Internal.IntegerProperty;
    static readonly DELAY: Internal.IntegerProperty;
    static readonly MIN_LEVEL: 0;
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: 1;
    static readonly BOTTOM: Internal.BooleanProperty;
    static readonly HAS_BOOK: Internal.BooleanProperty;
    static readonly CANDLES: Internal.IntegerProperty;
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: Internal.BooleanProperty;
    static readonly SHORT: Internal.BooleanProperty;
    static readonly BERRIES: Internal.BooleanProperty;
    static readonly MAX_AGE_2: 2;
    static readonly HAS_BOTTLE_0: Internal.BooleanProperty;
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: Internal.IntegerProperty;
    static readonly MAX_LEVEL_3: 3;
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: Internal.BooleanProperty;
    static readonly MAX_AGE_3: 3;
    static readonly OCCUPIED: Internal.BooleanProperty;
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: Internal.DirectionProperty;
}
type BlockProperties_ = BlockProperties;
declare class PonderIcons implements Internal.ScreenElement {
    constructor(x: number, y: number)
    asStencil(): Internal.DelegatedStencilElement;
    bind(): void;
    render(ms: Internal.PoseStack_, buffer: Internal.MultiBufferSource_, color: number): void;
    render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
    static readonly I_WHITELIST_AND: PonderIcons;
    static readonly I_ARM_ROUND_ROBIN: PonderIcons;
    static readonly I_SEQ_REPEAT: PonderIcons;
    static readonly I_PATTERN_CHECKERED: PonderIcons;
    static readonly VALUE_BOX_HOVER_8PX: PonderIcons;
    static readonly I_MTD_REPLAY: PonderIcons;
    static readonly I_TOOL_MOVE_Y: PonderIcons;
    static readonly I_PRIORITY_HIGH: PonderIcons;
    static readonly I_PATTERN_CHANCE_50: PonderIcons;
    static readonly I_CONFIG_PREV: PonderIcons;
    static readonly I_ATTACHED: PonderIcons;
    static readonly I_SCHEMATIC: PonderIcons;
    static readonly I_CONFIG_OPEN: PonderIcons;
    static readonly I_FX_FIELD_OFF: PonderIcons;
    static readonly I_FX_FIELD_ON: PonderIcons;
    static readonly I_REFRESH: PonderIcons;
    static readonly I_PLACE: PonderIcons;
    static readonly I_OVERLAY: PonderIcons;
    static readonly I_MOVE_PLACE_RETURNED: PonderIcons;
    static readonly I_CONFIG_SAVE: PonderIcons;
    static readonly I_CONFIRM: PonderIcons;
    static readonly I_ROLLER_FILL: PonderIcons;
    static readonly I_MOVE_NEVER_PLACE: PonderIcons;
    static readonly I_TUNNEL_FORCED_ROUND_ROBIN: PonderIcons;
    static readonly I_PATTERN_SOLID: PonderIcons;
    static readonly I_DISABLE: PonderIcons;
    static readonly I_TOOL_MOVE_XZ: PonderIcons;
    static readonly I_PATTERN_CHANCE_75: PonderIcons;
    static readonly ICON_ATLAS_SIZE: 256;
    static readonly I_SCROLL: PonderIcons;
    static readonly I_TUNNEL_FORCED_SPLIT: PonderIcons;
    static readonly I_CONFIG_UNLOCKED: PonderIcons;
    static readonly I_PASSIVE: PonderIcons;
    static readonly I_CONFIG_LOCKED: PonderIcons;
    static readonly I_PRIORITY_VERY_HIGH: PonderIcons;
    static readonly I_MTD_LEFT: PonderIcons;
    static readonly I_TOOLBOX: PonderIcons;
    static readonly I_MTD_SLOW_MODE: PonderIcons;
    static readonly I_OPEN_FOLDER: PonderIcons;
    static readonly I_MINUTE_HAND_FIRST: PonderIcons;
    static readonly I_ROTATE_PLACE: PonderIcons;
    static readonly I_PATTERN_CHECKERED_INVERSED: PonderIcons;
    static readonly I_HOUR_HAND_FIRST_24: PonderIcons;
    static readonly I_ARM_FORCED_ROUND_ROBIN: PonderIcons;
    static readonly I_REPLACE_ANY: PonderIcons;
    static readonly I_CONFIG_BACK: PonderIcons;
    static readonly I_MOVE_PLACE: PonderIcons;
    static readonly I_TARGET: PonderIcons;
    static readonly I_TUNNEL_SYNCHRONIZE: PonderIcons;
    static readonly I_FOLLOW_DIAGONAL: PonderIcons;
    static readonly I_ROLLER_PAVE: PonderIcons;
    static readonly I_REPLACE_EMPTY: PonderIcons;
    static readonly I_ROTATE_CCW: PonderIcons;
    static readonly I_CLEAR: PonderIcons;
    static readonly I_WHITELIST_NOT: PonderIcons;
    static readonly I_FLATTEN: PonderIcons;
    static readonly I_MTD_CLOSE: PonderIcons;
    static readonly I_CENTERED: PonderIcons;
    static readonly I_SKIP_BLOCK_ENTITIES: PonderIcons;
    static readonly I_BLACKLIST: PonderIcons;
    static readonly I_WHITELIST: PonderIcons;
    static readonly I_MTD_RIGHT: PonderIcons;
    static readonly I_CONFIG_DISCARD: PonderIcons;
    static readonly I_FX_BLEND_OFF: PonderIcons;
    static readonly I_WHITELIST_OR: PonderIcons;
    static readonly I_TOOL_DEPLOY: PonderIcons;
    static readonly I_CONFIG_RESET: PonderIcons;
    static readonly I_ADD: PonderIcons;
    static readonly I_CART_ROTATE: PonderIcons;
    static readonly I_REPLACE: PonderIcons;
    static readonly VALUE_BOX_HOVER_4PX: PonderIcons;
    static readonly I_TOOL_MIRROR: PonderIcons;
    static readonly I_CLEAR_CHECKED: PonderIcons;
    static readonly I_ADD_INVERTED_ATTRIBUTE: PonderIcons;
    static readonly ICON_ATLAS: ResourceLocation;
    static readonly I_3x3: PonderIcons;
    static readonly I_RMB: PonderIcons;
    static readonly I_PAUSE: PonderIcons;
    static readonly I_TOOL_ROTATE: PonderIcons;
    static readonly I_FLIP: PonderIcons;
    static readonly I_PRIORITY_LOW: PonderIcons;
    static readonly I_INSERTED: PonderIcons;
    static readonly I_FX_SURFACE_ON: PonderIcons;
    static readonly I_TUNNEL_PREFER_NEAREST: PonderIcons;
    static readonly I_ROLLER_WIDE_FILL: PonderIcons;
    static readonly I_CONFIG_NEXT: PonderIcons;
    static readonly I_DONT_REPLACE: PonderIcons;
    static readonly I_FX_SURFACE_OFF: PonderIcons;
    static readonly I_VIEW_SCHEDULE: PonderIcons;
    static readonly I_DICE: PonderIcons;
    static readonly I_NONE: PonderIcons;
    static readonly I_ACTIVE: PonderIcons;
    static readonly I_ROTATE_PLACE_RETURNED: PonderIcons;
    static readonly I_CART_ROTATE_PAUSED: PonderIcons;
    static readonly I_FX_BLEND: PonderIcons;
    static readonly VALUE_BOX_HOVER_6PX: PonderIcons;
    static readonly I_PLAY: PonderIcons;
    static readonly I_FILL: PonderIcons;
    static readonly I_SKIP_MISSING: PonderIcons;
    static readonly I_HOUR_HAND_FIRST: PonderIcons;
    static readonly I_REPLACE_SOLID: PonderIcons;
    static readonly I_TUNNEL_ROUND_ROBIN: PonderIcons;
    static readonly I_TUNNEL_RANDOMIZE: PonderIcons;
    static readonly I_PLACEMENT_SETTINGS: PonderIcons;
    static readonly I_MTD_USER_MODE: PonderIcons;
    static readonly I_LMB: PonderIcons;
    static readonly I_TUNNEL_SPLIT: PonderIcons;
    static readonly I_ARM_PREFER_FIRST: PonderIcons;
    static readonly I_TRASH: PonderIcons;
    static readonly I_PRIORITY_VERY_LOW: PonderIcons;
    static readonly I_PATTERN_CHANCE_25: PonderIcons;
    static readonly I_CART_ROTATE_LOCKED: PonderIcons;
    static readonly I_STOP: PonderIcons;
    static readonly I_RESPECT_NBT: PonderIcons;
    static readonly I_FOLLOW_MATERIAL: PonderIcons;
    static readonly I_IGNORE_NBT: PonderIcons;
    static readonly I_ROTATE_NEVER_PLACE: PonderIcons;
    static readonly I_MTD_SCAN: PonderIcons;
}
type PonderIcons_ = PonderIcons;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    listTag(): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    longTag(v: number): Internal.Tag;
    intTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor($$0: number, $$1: number, $$2: number)
    north(): this;
    distToCenterSqr($$0: Internal.Position_): number;
    getX(): number;
    static offsetCodec($$0: number): Internal.Codec<Vec3i>;
    getY(): number;
    south($$0: number): this;
    toShortString(): string;
    above($$0: number): this;
    west($$0: number): this;
    compareTo(arg0: any): number;
    east($$0: number): this;
    distToLowCornerSqr($$0: number, $$1: number, $$2: number): number;
    relative($$0: Internal.Direction_): this;
    multiply($$0: number): this;
    getZ(): number;
    closerThan($$0: Vec3i_, $$1: number): boolean;
    below($$0: number): this;
    offset($$0: number, $$1: number, $$2: number): this;
    above(): this;
    north($$0: number): this;
    east(): this;
    below(): this;
    west(): this;
    distManhattan($$0: Vec3i_): number;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    get($$0: Internal.Direction$Axis_): number;
    offset($$0: Vec3i_): this;
    cross($$0: Vec3i_): this;
    south(): this;
    distSqr($$0: Vec3i_): number;
    subtract($$0: Vec3i_): this;
    relative($$0: Internal.Direction_, $$1: number): this;
    compareTo($$0: Vec3i_): number;
    closerToCenterThan($$0: Internal.Position_, $$1: number): boolean;
    distToCenterSqr($$0: number, $$1: number, $$2: number): number;
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: Vec3i;
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare interface FluidAmounts {
    readonly MILLIBUCKET: 81;
    readonly MB: 81;
    readonly INGOT: 9000;
    readonly BOTTLE: 27000;
    readonly B: 81000;
    readonly NUGGET: 1000;
    readonly METAL_BLOCK: 81000;
    readonly BUCKET: 81000;
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    mapnYnXZ(arg0: Matrix3f_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    mapnXZY(arg0: Matrix3f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    m10(): number;
    mapXnZnY(): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    m22(): number;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    negateX(): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    invert(arg0: Matrix3f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapnYXZ(arg0: Matrix3f_): this;
    mapZXY(): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromAddress(arg0: number)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Matrix4fAccess, Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    getRowColumn(arg0: number, arg1: number): number;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    mapnYnXnZ(arg0: Matrix4f_): this;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    m33(arg0: number): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    invertAffine(arg0: Matrix4f_): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalize3x3(arg0: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m32(): number;
    getScale(arg0: Vec3f_): Vec3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    rotationTowardsXY(arg0: number, arg1: number): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    transpose3x3(arg0: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXnY(): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m33(): number;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    transpose(arg0: Matrix4f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    m22(): number;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    m31(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    mapZYX(arg0: Matrix4f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    mapnZnXY(): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m13(arg0: number): this;
    m12(): number;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYnZX(arg0: Matrix4f_): this;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    mapXZnY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateLocalY(arg0: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYXZ(): this;
    setFromAddress(arg0: number): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m02(arg0: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transpose(): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    m22(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    normal(): this;
    m03(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    cofactor3x3(): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    scaling(arg0: Internal.Vector3fc_): this;
    positiveY(arg0: Vec3f_): Vec3f;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    m00(arg0: number): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    mapXZY(arg0: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapZYX(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapZnYnX(arg0: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    mapnYnZX(): this;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    copyFromArray(arg0: number[]): void;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x3(arg0: Matrix3f_): Matrix3f;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    convertToJOML(): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Matrix4x3fc_): this;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    m03(arg0: number): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    invert(): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    mapnXnZY(): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    copyIntoArray(): number[];
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapYnXnZ(): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    invertAffine(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    mapZXnY(arg0: Matrix4f_): this;
    clone(): any;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    invert(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    add4x3(arg0: Internal.Matrix4fc_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnXnZnY(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.Quaternionfc_): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXZ(): this;
    mapXnZnY(arg0: Matrix4f_): this;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    determinant(): number;
    perspectiveFov(): number;
    mapZYnX(arg0: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mapZXY(): this;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    mapnXZnY(arg0: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    m30(): number;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set fromAddress(arg0: number)
    set transposed(arg0: Internal.ByteBuffer_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
declare class Blocks {
    constructor()
    static log($$0: Internal.MapColor_, $$1: Internal.MapColor_, $$2: SoundType_): Internal.RotatedPillarBlock;
    static never($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static never($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
    static always($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
    static rebuildCache(): void;
    static stoneButton(): Internal.ButtonBlock;
    static woodenButton($$0: Internal.BlockSetType_, ...$$1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    static log($$0: Internal.MapColor_, $$1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static register($$0: string, $$1: Internal.Block_): Internal.Block;
    static leaves($$0: SoundType_): Internal.LeavesBlock;
    static netherStem($$0: Internal.MapColor_): Internal.Block;
    static litBlockEmission($$0: number): Internal.ToIntFunction<Internal.BlockState>;
    static always($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static ocelotOrParrot($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static flowerPot($$0: Internal.Block_, ...$$1: Internal.FeatureFlag_[]): Internal.FlowerPotBlock;
    static readonly MANGROVE_PROPAGULE: Internal.MangrovePropaguleBlock;
    static readonly STONE_SLAB: Internal.SlabBlock;
    static readonly POTTED_CRIMSON_FUNGUS: Internal.FlowerPotBlock;
    static readonly DEEPSLATE_BRICK_STAIRS: Internal.StairBlock;
    static readonly CHERRY_SAPLING: Internal.SaplingBlock;
    static readonly POLISHED_ANDESITE: Internal.Block;
    static readonly RED_NETHER_BRICKS: Internal.Block;
    static readonly TORCH: Internal.TorchBlock;
    static readonly COAL_BLOCK: Internal.Block;
    static readonly STRIPPED_CRIMSON_STEM: Internal.RotatedPillarBlock;
    static readonly FIRE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly WEEPING_VINES_PLANT: Internal.WeepingVinesPlantBlock;
    static readonly PEONY: Internal.TallFlowerBlock;
    static readonly CARROTS: Internal.CarrotBlock;
    static readonly YELLOW_CANDLE: Internal.CandleBlock;
    static readonly CYAN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly TUBE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly SMITHING_TABLE: Internal.SmithingTableBlock;
    static readonly ACACIA_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly MAGENTA_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly POTTED_CHERRY_SAPLING: Internal.FlowerPotBlock;
    static readonly PLAYER_WALL_HEAD: Internal.PlayerWallHeadBlock;
    static readonly DEAD_HORN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly MANGROVE_LOG: Internal.RotatedPillarBlock;
    static readonly SPRUCE_BUTTON: Internal.ButtonBlock;
    static readonly IRON_ORE: Internal.DropExperienceBlock;
    static readonly TRIPWIRE: Internal.TripWireBlock;
    static readonly BLACK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly LIGHT_BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly ACACIA_STAIRS: Internal.StairBlock;
    static readonly CRIMSON_FUNGUS: Internal.FungusBlock;
    static readonly BUBBLE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly LIGHT_BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly PRISMARINE_SLAB: Internal.SlabBlock;
    static readonly DEAD_TUBE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly PURPLE_BANNER: Internal.BannerBlock;
    static readonly RED_NETHER_BRICK_SLAB: Internal.SlabBlock;
    static readonly SCULK_SENSOR: Internal.SculkSensorBlock;
    static readonly YELLOW_WOOL: Internal.Block;
    static readonly MAGENTA_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly SAND: Internal.SandBlock;
    static readonly MYCELIUM: Internal.MyceliumBlock;
    static readonly LIGHT_GRAY_BANNER: Internal.BannerBlock;
    static readonly ORANGE_CANDLE: Internal.CandleBlock;
    static readonly CORNFLOWER: Internal.FlowerBlock;
    static readonly DARK_OAK_DOOR: Internal.DoorBlock;
    static readonly GRANITE_SLAB: Internal.SlabBlock;
    static readonly REDSTONE_LAMP: Internal.RedstoneLampBlock;
    static readonly LIGHT: Internal.LightBlock;
    static readonly TUBE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly WARPED_FENCE_GATE: Internal.FenceGateBlock;
    static readonly DANDELION: Internal.FlowerBlock;
    static readonly PINK_TERRACOTTA: Internal.Block;
    static readonly WARPED_BUTTON: Internal.ButtonBlock;
    static readonly RED_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SOUL_SOIL: Internal.Block;
    static readonly ACACIA_FENCE: Internal.FenceBlock;
    static readonly CRIMSON_SIGN: Internal.StandingSignBlock;
    static readonly HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static readonly PRISMARINE_STAIRS: Internal.StairBlock;
    static readonly TWISTING_VINES_PLANT: Internal.TwistingVinesPlantBlock;
    static readonly DEEPSLATE_BRICK_SLAB: Internal.SlabBlock;
    static readonly WARPED_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly RED_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WARPED_WART_BLOCK: Internal.Block;
    static readonly EXPOSED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly COARSE_DIRT: Internal.Block;
    static readonly DEEPSLATE_REDSTONE_ORE: Internal.RedStoneOreBlock;
    static readonly TUFF: Internal.Block;
    static readonly CHISELED_BOOKSHELF: Internal.ChiseledBookShelfBlock;
    static readonly ACACIA_LOG: Internal.RotatedPillarBlock;
    static readonly DEEPSLATE_IRON_ORE: Internal.DropExperienceBlock;
    static readonly PURPLE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly LIGHTNING_ROD: Internal.LightningRodBlock;
    static readonly COBBLED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static readonly RED_CARPET: Internal.WoolCarpetBlock;
    static readonly CHERRY_LOG: Internal.RotatedPillarBlock;
    static readonly LILY_PAD: Internal.WaterlilyBlock;
    static readonly GREEN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly BARRIER: Internal.BarrierBlock;
    static readonly PINK_CARPET: Internal.WoolCarpetBlock;
    static readonly DRAGON_HEAD: Internal.SkullBlock;
    static readonly YELLOW_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly DEAD_BUBBLE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly STRIPPED_BIRCH_WOOD: Internal.RotatedPillarBlock;
    static readonly SEAGRASS: Internal.SeagrassBlock;
    static readonly CHERRY_WALL_SIGN: Internal.WallSignBlock;
    static readonly HORN_CORAL: Internal.CoralPlantBlock;
    static readonly MOSSY_STONE_BRICKS: Internal.Block;
    static readonly SPRUCE_SIGN: Internal.StandingSignBlock;
    static readonly WAXED_COPPER_BLOCK: Internal.Block;
    static readonly STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly GRANITE_WALL: Internal.WallBlock;
    static readonly NETHER_BRICK_FENCE: Internal.FenceBlock;
    static readonly MOSS_CARPET: Internal.CarpetBlock;
    static readonly DARK_OAK_PLANKS: Internal.Block;
    static readonly MAGENTA_WALL_BANNER: Internal.WallBannerBlock;
    static readonly ANDESITE_SLAB: Internal.SlabBlock;
    static readonly RED_NETHER_BRICK_WALL: Internal.WallBlock;
    static readonly BIRCH_DOOR: Internal.DoorBlock;
    static readonly BAMBOO_DOOR: Internal.DoorBlock;
    static readonly BROWN_CONCRETE: Internal.Block;
    static readonly DEEPSLATE_DIAMOND_ORE: Internal.DropExperienceBlock;
    static readonly BEETROOTS: Internal.BeetrootBlock;
    static readonly POTTED_BAMBOO: Internal.FlowerPotBlock;
    static readonly FERN: Internal.TallGrassBlock;
    static readonly CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static readonly WAXED_CUT_COPPER: Internal.Block;
    static readonly ACACIA_DOOR: Internal.DoorBlock;
    static readonly BLACK_WOOL: Internal.Block;
    static readonly POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly BRAIN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly VINE: Internal.VineBlock;
    static readonly CHERRY_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly ANDESITE_STAIRS: Internal.StairBlock;
    static readonly INFESTED_DEEPSLATE: Internal.InfestedRotatedPillarBlock;
    static readonly ACACIA_WALL_SIGN: Internal.WallSignBlock;
    static readonly SPONGE: Internal.SpongeBlock;
    static readonly REDSTONE_ORE: Internal.RedStoneOreBlock;
    static readonly STRIPPED_ACACIA_WOOD: Internal.RotatedPillarBlock;
    static readonly REDSTONE_WALL_TORCH: Internal.RedstoneWallTorchBlock;
    static readonly CYAN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BLACK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly CAMPFIRE: Internal.CampfireBlock;
    static readonly OCHRE_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly COBBLESTONE_STAIRS: Internal.StairBlock;
    static readonly DRAGON_WALL_HEAD: Internal.WallSkullBlock;
    static readonly POTTED_WITHER_ROSE: Internal.FlowerPotBlock;
    static readonly BLACKSTONE_STAIRS: Internal.StairBlock;
    static readonly GRAY_CANDLE: Internal.CandleBlock;
    static readonly CYAN_TERRACOTTA: Internal.Block;
    static readonly BAMBOO_SIGN: Internal.StandingSignBlock;
    static readonly BIRCH_WALL_SIGN: Internal.WallSignBlock;
    static readonly POTTED_CORNFLOWER: Internal.FlowerPotBlock;
    static readonly STICKY_PISTON: Internal.PistonBaseBlock;
    static readonly LIGHT_BLUE_TERRACOTTA: Internal.Block;
    static readonly WEATHERED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly CYAN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly RAW_GOLD_BLOCK: Internal.Block;
    static readonly STRIPPED_BIRCH_LOG: Internal.RotatedPillarBlock;
    static readonly LARGE_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly POLISHED_ANDESITE_SLAB: Internal.SlabBlock;
    static readonly NETHER_PORTAL: Internal.NetherPortalBlock;
    static readonly JUNGLE_PLANKS: Internal.Block;
    static readonly PINK_TULIP: Internal.FlowerBlock;
    static readonly OAK_SLAB: Internal.SlabBlock;
    static readonly STRIPPED_WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static readonly POTTED_OAK_SAPLING: Internal.FlowerPotBlock;
    static readonly MANGROVE_SLAB: Internal.SlabBlock;
    static readonly DARK_OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly EXPOSED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly ORANGE_CONCRETE: Internal.Block;
    static readonly BLUE_ORCHID: Internal.FlowerBlock;
    static readonly STRIPPED_BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static readonly BIRCH_LOG: Internal.RotatedPillarBlock;
    static readonly GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly DEEPSLATE_TILES: Internal.Block;
    static readonly CRIMSON_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly WHITE_BANNER: Internal.BannerBlock;
    static readonly KELP: Internal.KelpBlock;
    static readonly BROWN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly INFESTED_CRACKED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly JUNGLE_FENCE: Internal.FenceBlock;
    static readonly LIGHT_GRAY_CONCRETE: Internal.Block;
    static readonly RED_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static readonly GRAY_TERRACOTTA: Internal.Block;
    static readonly MOSS_BLOCK: Internal.MossBlock;
    static readonly LIME_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly CRIMSON_STAIRS: Internal.StairBlock;
    static readonly CARVED_PUMPKIN: Internal.EquipableCarvedPumpkinBlock;
    static readonly POTATOES: Internal.PotatoBlock;
    static readonly PURPUR_PILLAR: Internal.RotatedPillarBlock;
    static readonly MUD_BRICKS: Internal.Block;
    static readonly DEAD_FIRE_CORAL_BLOCK: Internal.Block;
    static readonly MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static readonly CHERRY_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly NOTE_BLOCK: Internal.NoteBlock;
    static readonly ENDER_CHEST: Internal.EnderChestBlock;
    static readonly CYAN_BED: Internal.BedBlock;
    static readonly DEAD_TUBE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly BIRCH_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly YELLOW_CONCRETE: Internal.Block;
    static readonly DEAD_TUBE_CORAL_BLOCK: Internal.Block;
    static readonly STRIPPED_WARPED_STEM: Internal.RotatedPillarBlock;
    static readonly LEVER: Internal.LeverBlock;
    static readonly POLISHED_BLACKSTONE: Internal.Block;
    static readonly LIGHT_BLUE_CONCRETE: Internal.Block;
    static readonly POTTED_MANGROVE_PROPAGULE: Internal.FlowerPotBlock;
    static readonly DROPPER: Internal.DropperBlock;
    static readonly SPRUCE_FENCE: Internal.FenceBlock;
    static readonly RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly CRAFTING_TABLE: Internal.CraftingTableBlock;
    static readonly SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GRASS: Internal.TallGrassBlock;
    static readonly CHERRY_SLAB: Internal.SlabBlock;
    static readonly MEDIUM_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly CRIMSON_ROOTS: Internal.RootsBlock;
    static readonly WITHER_ROSE: Internal.WitherRoseBlock;
    static readonly OXEYE_DAISY: Internal.FlowerBlock;
    static readonly OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly EMERALD_BLOCK: Internal.Block;
    static readonly BUDDING_AMETHYST: Internal.BuddingAmethystBlock;
    static readonly RAIL: Internal.RailBlock;
    static readonly JUNGLE_WALL_SIGN: Internal.WallSignBlock;
    static readonly BROWN_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static readonly DARK_OAK_SAPLING: Internal.SaplingBlock;
    static readonly DIAMOND_ORE: Internal.DropExperienceBlock;
    static readonly LADDER: Internal.LadderBlock;
    static readonly OAK_SAPLING: Internal.SaplingBlock;
    static readonly MELON: Internal.MelonBlock;
    static readonly CRIMSON_PLANKS: Internal.Block;
    static readonly GLOW_LICHEN: Internal.GlowLichenBlock;
    static readonly REDSTONE_WIRE: Internal.RedStoneWireBlock;
    static readonly HORN_CORAL_FAN: Internal.CoralFanBlock;
    static readonly DARK_PRISMARINE_SLAB: Internal.SlabBlock;
    static readonly CAVE_VINES_PLANT: Internal.CaveVinesPlantBlock;
    static readonly ACACIA_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly YELLOW_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly SMOOTH_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly COBBLED_DEEPSLATE_WALL: Internal.WallBlock;
    static readonly CRIMSON_NYLIUM: Internal.NyliumBlock;
    static readonly POTTED_BLUE_ORCHID: Internal.FlowerPotBlock;
    static readonly CYAN_BANNER: Internal.BannerBlock;
    static readonly SCULK_CATALYST: Internal.SculkCatalystBlock;
    static readonly STRIPPED_MANGROVE_LOG: Internal.RotatedPillarBlock;
    static readonly DISPENSER: Internal.DispenserBlock;
    static readonly PRISMARINE_WALL: Internal.WallBlock;
    static readonly ORANGE_TULIP: Internal.FlowerBlock;
    static readonly COMMAND_BLOCK: Internal.CommandBlock;
    static readonly BLACK_WALL_BANNER: Internal.WallBannerBlock;
    static readonly SPORE_BLOSSOM: Internal.SporeBlossomBlock;
    static readonly OXIDIZED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly DEEPSLATE_TILE_STAIRS: Internal.StairBlock;
    static readonly JUNGLE_STAIRS: Internal.StairBlock;
    static readonly DIRT_PATH: Internal.DirtPathBlock;
    static readonly BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GREEN_CARPET: Internal.WoolCarpetBlock;
    static readonly HONEYCOMB_BLOCK: Internal.Block;
    static readonly ICE: Internal.IceBlock;
    static readonly BAMBOO_MOSAIC_STAIRS: Internal.StairBlock;
    static readonly POTTED_BIRCH_SAPLING: Internal.FlowerPotBlock;
    static readonly WHITE_CARPET: Internal.WoolCarpetBlock;
    static readonly WATER: Internal.LiquidBlock;
    static readonly CRACKED_NETHER_BRICKS: Internal.Block;
    static readonly WATER_CAULDRON: Internal.LayeredCauldronBlock;
    static readonly MUD_BRICK_SLAB: Internal.SlabBlock;
    static readonly WAXED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly POLISHED_DEEPSLATE_WALL: Internal.WallBlock;
    static readonly OAK_FENCE_GATE: Internal.FenceGateBlock;
    static readonly OAK_LEAVES: Internal.LeavesBlock;
    static readonly POTTED_BROWN_MUSHROOM: Internal.FlowerPotBlock;
    static readonly WARPED_DOOR: Internal.DoorBlock;
    static readonly JUKEBOX: Internal.JukeboxBlock;
    static readonly MANGROVE_FENCE: Internal.FenceBlock;
    static readonly NETHER_BRICKS: Internal.Block;
    static readonly PLAYER_HEAD: Internal.PlayerHeadBlock;
    static readonly PURPLE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_TUBE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BIRCH_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POWDER_SNOW_CAULDRON: Internal.PowderSnowCauldronBlock;
    static readonly BROWN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly BREWING_STAND: Internal.BrewingStandBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly REDSTONE_TORCH: Internal.RedstoneTorchBlock;
    static readonly BAMBOO_FENCE_GATE: Internal.FenceGateBlock;
    static readonly BLACK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly POLISHED_GRANITE_STAIRS: Internal.StairBlock;
    static readonly MAGENTA_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_BRAIN_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BLACK_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly NETHER_SPROUTS: Internal.NetherSproutsBlock;
    static readonly GREEN_CANDLE: Internal.CandleBlock;
    static readonly SPRUCE_LOG: Internal.RotatedPillarBlock;
    static readonly PURPLE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly CONDUIT: Internal.ConduitBlock;
    static readonly ORANGE_WOOL: Internal.Block;
    static readonly POTTED_WHITE_TULIP: Internal.FlowerPotBlock;
    static readonly PRISMARINE_BRICKS: Internal.Block;
    static readonly POLISHED_BLACKSTONE_WALL: Internal.WallBlock;
    static readonly SEA_LANTERN: Internal.Block;
    static readonly MAGENTA_BED: Internal.BedBlock;
    static readonly POLISHED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static readonly STONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly SCAFFOLDING: Internal.ScaffoldingBlock;
    static readonly NETHER_BRICK_STAIRS: Internal.StairBlock;
    static readonly DIORITE_SLAB: Internal.SlabBlock;
    static readonly PISTON_HEAD: Internal.PistonHeadBlock;
    static readonly BLACK_TERRACOTTA: Internal.Block;
    static readonly PURPLE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly LIME_CANDLE: Internal.CandleBlock;
    static readonly OAK_WALL_SIGN: Internal.WallSignBlock;
    static readonly CUT_RED_SANDSTONE: Internal.Block;
    static readonly DEAD_FIRE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly LIME_BED: Internal.BedBlock;
    static readonly SPAWNER: Internal.SpawnerBlock;
    static readonly FROSTED_ICE: Internal.FrostedIceBlock;
    static readonly IRON_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly WARPED_ROOTS: Internal.RootsBlock;
    static readonly STONE: Internal.Block;
    static readonly MUD_BRICK_WALL: Internal.WallBlock;
    static readonly SOUL_LANTERN: Internal.LanternBlock;
    static readonly COPPER_BLOCK: Internal.WeatheringCopperFullBlock;
    static readonly WAXED_OXIDIZED_COPPER: Internal.Block;
    static readonly WARPED_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POLISHED_BASALT: Internal.RotatedPillarBlock;
    static readonly DAYLIGHT_DETECTOR: Internal.DaylightDetectorBlock;
    static readonly CRIMSON_SLAB: Internal.SlabBlock;
    static readonly CHERRY_WOOD: Internal.RotatedPillarBlock;
    static readonly GOLD_BLOCK: Internal.Block;
    static readonly POTTED_LILY_OF_THE_VALLEY: Internal.FlowerPotBlock;
    static readonly LIGHT_BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly DRIPSTONE_BLOCK: Internal.Block;
    static readonly COBBLED_DEEPSLATE: Internal.Block;
    static readonly BIG_DRIPLEAF: Internal.BigDripleafBlock;
    static readonly MANGROVE_LEAVES: Internal.MangroveLeavesBlock;
    static readonly GRAY_WOOL: Internal.Block;
    static readonly INFESTED_CHISELED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly CHERRY_SIGN: Internal.StandingSignBlock;
    static readonly REPEATING_COMMAND_BLOCK: Internal.CommandBlock;
    static readonly WARPED_FENCE: Internal.FenceBlock;
    static readonly RED_BED: Internal.BedBlock;
    static readonly CHERRY_DOOR: Internal.DoorBlock;
    static readonly POTTED_DANDELION: Internal.FlowerPotBlock;
    static readonly POTTED_CACTUS: Internal.FlowerPotBlock;
    static readonly DIORITE_WALL: Internal.WallBlock;
    static readonly HOPPER: Internal.HopperBlock;
    static readonly SPRUCE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly BARREL: Internal.BarrelBlock;
    static readonly MELON_STEM: Internal.StemBlock;
    static readonly ROOTED_DIRT: Internal.RootedDirtBlock;
    static readonly LIGHT_BLUE_WOOL: Internal.Block;
    static readonly SOUL_WALL_TORCH: Internal.WallTorchBlock;
    static readonly LAPIS_BLOCK: Internal.Block;
    static readonly ANDESITE: Internal.Block;
    static readonly YELLOW_BED: Internal.BedBlock;
    static readonly END_STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly BLAST_FURNACE: Internal.BlastFurnaceBlock;
    static readonly SMALL_DRIPLEAF: Internal.SmallDripleafBlock;
    static readonly KELP_PLANT: Internal.KelpPlantBlock;
    static readonly RED_SAND: Internal.SandBlock;
    static readonly JUNGLE_LOG: Internal.RotatedPillarBlock;
    static readonly QUARTZ_BRICKS: Internal.Block;
    static readonly CRIMSON_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly ZOMBIE_WALL_HEAD: Internal.WallSkullBlock;
    static readonly LIME_TERRACOTTA: Internal.Block;
    static readonly RAW_COPPER_BLOCK: Internal.Block;
    static readonly CHERRY_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly ORANGE_CARPET: Internal.WoolCarpetBlock;
    static readonly LOOM: Internal.LoomBlock;
    static readonly GREEN_WOOL: Internal.Block;
    static readonly BROWN_WOOL: Internal.Block;
    static readonly LIGHT_GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly PIGLIN_WALL_HEAD: Internal.PiglinWallSkullBlock;
    static readonly BLUE_CANDLE: Internal.CandleBlock;
    static readonly PINK_CANDLE: Internal.CandleBlock;
    static readonly SMOKER: Internal.SmokerBlock;
    static readonly ANVIL: Internal.AnvilBlock;
    static readonly BROWN_CARPET: Internal.WoolCarpetBlock;
    static readonly FLOWER_POT: Internal.FlowerPotBlock;
    static readonly LIGHT_BLUE_BANNER: Internal.BannerBlock;
    static readonly POLISHED_BLACKSTONE_STAIRS: Internal.StairBlock;
    static readonly STONECUTTER: Internal.StonecutterBlock;
    static readonly CUT_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly RED_CONCRETE: Internal.Block;
    static readonly DARK_OAK_FENCE: Internal.FenceBlock;
    static readonly GREEN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BAMBOO: Internal.BambooStalkBlock;
    static readonly DEAD_HORN_CORAL_BLOCK: Internal.Block;
    static readonly DARK_OAK_WALL_SIGN: Internal.WallSignBlock;
    static readonly MAGENTA_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly DARK_OAK_SIGN: Internal.StandingSignBlock;
    static readonly CHISELED_RED_SANDSTONE: Internal.Block;
    static readonly CRIMSON_BUTTON: Internal.ButtonBlock;
    static readonly PITCHER_CROP: Internal.PitcherCropBlock;
    static readonly CHERRY_LEAVES: Internal.CherryLeavesBlock;
    static readonly RED_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly QUARTZ_PILLAR: Internal.RotatedPillarBlock;
    static readonly CHISELED_POLISHED_BLACKSTONE: Internal.Block;
    static readonly DEAD_FIRE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly PURPLE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly RED_CANDLE: Internal.CandleBlock;
    static readonly AMETHYST_CLUSTER: Internal.AmethystClusterBlock;
    static readonly DARK_PRISMARINE: Internal.Block;
    static readonly MANGROVE_WALL_SIGN: Internal.WallSignBlock;
    static readonly SCULK_VEIN: Internal.SculkVeinBlock;
    static readonly JUNGLE_SAPLING: Internal.SaplingBlock;
    static readonly YELLOW_CARPET: Internal.WoolCarpetBlock;
    static readonly OBSERVER: Internal.ObserverBlock;
    static readonly END_STONE_BRICK_WALL: Internal.WallBlock;
    static readonly SPRUCE_LEAVES: Internal.LeavesBlock;
    static readonly MANGROVE_BUTTON: Internal.ButtonBlock;
    static readonly WAXED_EXPOSED_CUT_COPPER: Internal.Block;
    static readonly STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly BAMBOO_BUTTON: Internal.ButtonBlock;
    static readonly STONE_BRICKS: Internal.Block;
    static readonly SPRUCE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly NETHER_WART: Internal.NetherWartBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly RED_WALL_BANNER: Internal.WallBannerBlock;
    static readonly OBSIDIAN: Internal.Block;
    static readonly PURPLE_CONCRETE: Internal.Block;
    static readonly BLACK_CONCRETE: Internal.Block;
    static readonly WARPED_SIGN: Internal.StandingSignBlock;
    static readonly REINFORCED_DEEPSLATE: Internal.Block;
    static readonly DRAGON_EGG: Internal.DragonEggBlock;
    static readonly PACKED_MUD: Internal.Block;
    static readonly ACACIA_PLANKS: Internal.Block;
    static readonly RED_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly DARK_OAK_STAIRS: Internal.StairBlock;
    static readonly MOSSY_STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static readonly FIRE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly QUARTZ_STAIRS: Internal.StairBlock;
    static readonly PURPUR_STAIRS: Internal.StairBlock;
    static readonly STONE_STAIRS: Internal.StairBlock;
    static readonly STRIPPED_JUNGLE_LOG: Internal.RotatedPillarBlock;
    static readonly RED_WOOL: Internal.Block;
    static readonly FARMLAND: Internal.FarmBlock;
    static readonly DARK_OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly ORANGE_TERRACOTTA: Internal.Block;
    static readonly DEEPSLATE_GOLD_ORE: Internal.DropExperienceBlock;
    static readonly LIGHT_BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_WALL: Internal.WallBlock;
    static readonly BRICKS: Internal.Block;
    static readonly WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly MOSSY_COBBLESTONE_STAIRS: Internal.StairBlock;
    static readonly CAKE: Internal.CakeBlock;
    static readonly GREEN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly JUNGLE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly BLUE_BED: Internal.BedBlock;
    static readonly OAK_BUTTON: Internal.ButtonBlock;
    static readonly MANGROVE_DOOR: Internal.DoorBlock;
    static readonly DEEPSLATE_BRICKS: Internal.Block;
    static readonly BASALT: Internal.RotatedPillarBlock;
    static readonly REPEATER: Internal.RepeaterBlock;
    static readonly PURPLE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly AZURE_BLUET: Internal.FlowerBlock;
    static readonly LILY_OF_THE_VALLEY: Internal.FlowerBlock;
    static readonly STONE_BRICK_WALL: Internal.WallBlock;
    static readonly BIRCH_SAPLING: Internal.SaplingBlock;
    static readonly BIRCH_STAIRS: Internal.StairBlock;
    static readonly LIGHT_BLUE_CARPET: Internal.WoolCarpetBlock;
    static readonly BROWN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly FIRE_CORAL: Internal.CoralPlantBlock;
    static readonly SANDSTONE_WALL: Internal.WallBlock;
    static readonly RESPAWN_ANCHOR: Internal.RespawnAnchorBlock;
    static readonly PRISMARINE_BRICK_SLAB: Internal.SlabBlock;
    static readonly NETHER_BRICK_SLAB: Internal.SlabBlock;
    static readonly NETHERRACK: Internal.NetherrackBlock;
    static readonly CAVE_VINES: Internal.CaveVinesBlock;
    static readonly WARPED_NYLIUM: Internal.NyliumBlock;
    static readonly POTTED_POPPY: Internal.FlowerPotBlock;
    static readonly POINTED_DRIPSTONE: Internal.PointedDripstoneBlock;
    static readonly ORANGE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly LIGHT_GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static readonly GLASS: Internal.GlassBlock;
    static readonly WARPED_PLANKS: Internal.Block;
    static readonly WET_SPONGE: Internal.WetSpongeBlock;
    static readonly GRASS_BLOCK: Internal.GrassBlock;
    static readonly COAL_ORE: Internal.DropExperienceBlock;
    static readonly PURPUR_SLAB: Internal.SlabBlock;
    static readonly WARPED_STEM: Internal.RotatedPillarBlock;
    static readonly DEEPSLATE_COPPER_ORE: Internal.DropExperienceBlock;
    static readonly POLISHED_DIORITE_STAIRS: Internal.StairBlock;
    static readonly ANCIENT_DEBRIS: Internal.Block;
    static readonly GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_BRAIN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly WHITE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly END_STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly PODZOL: Internal.SnowyDirtBlock;
    static readonly CHERRY_BUTTON: Internal.ButtonBlock;
    static readonly COMPARATOR: Internal.ComparatorBlock;
    static readonly ACACIA_FENCE_GATE: Internal.FenceGateBlock;
    static readonly CHISELED_STONE_BRICKS: Internal.Block;
    static readonly WAXED_WEATHERED_COPPER: Internal.Block;
    static readonly SUGAR_CANE: Internal.SugarCaneBlock;
    static readonly DEAD_BRAIN_CORAL_BLOCK: Internal.Block;
    static readonly NETHERITE_BLOCK: Internal.Block;
    static readonly OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly WHITE_CONCRETE: Internal.Block;
    static readonly POTTED_AZURE_BLUET: Internal.FlowerPotBlock;
    static readonly SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly ORANGE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly ORANGE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BRAIN_CORAL_FAN: Internal.CoralFanBlock;
    static readonly PINK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly OXIDIZED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly GRAY_BED: Internal.BedBlock;
    static readonly GLASS_PANE: Internal.IronBarsBlock;
    static readonly GRAVEL: Internal.GravelBlock;
    static readonly BAMBOO_MOSAIC: Internal.Block;
    static readonly SUSPICIOUS_GRAVEL: Internal.BrushableBlock;
    static readonly ENCHANTING_TABLE: Internal.EnchantmentTableBlock;
    static readonly LILAC: Internal.TallFlowerBlock;
    static readonly STRIPPED_SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static readonly MANGROVE_SIGN: Internal.StandingSignBlock;
    static readonly RED_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly STRIPPED_JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static readonly ALLIUM: Internal.FlowerBlock;
    static readonly MUD_BRICK_STAIRS: Internal.StairBlock;
    static readonly DEAD_BRAIN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly LIGHT_GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly ZOMBIE_HEAD: Internal.SkullBlock;
    static readonly WHITE_TULIP: Internal.FlowerBlock;
    static readonly PINK_WALL_BANNER: Internal.WallBannerBlock;
    static readonly MOSSY_COBBLESTONE_WALL: Internal.WallBlock;
    static readonly CRACKED_DEEPSLATE_BRICKS: Internal.Block;
    static readonly WHITE_WOOL: Internal.Block;
    static readonly GREEN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly GRAY_CARPET: Internal.WoolCarpetBlock;
    static readonly BLACK_BANNER: Internal.BannerBlock;
    static readonly TUBE_CORAL: Internal.CoralPlantBlock;
    static readonly JUNGLE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly CUT_SANDSTONE: Internal.Block;
    static readonly POLISHED_GRANITE: Internal.Block;
    static readonly DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly SKELETON_WALL_SKULL: Internal.WallSkullBlock;
    static readonly TALL_GRASS: Internal.DoublePlantBlock;
    static readonly POTTED_JUNGLE_SAPLING: Internal.FlowerPotBlock;
    static readonly YELLOW_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly PEARLESCENT_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly DARK_OAK_FENCE_GATE: Internal.FenceGateBlock;
    static readonly MAGENTA_WOOL: Internal.Block;
    static readonly PUMPKIN_STEM: Internal.StemBlock;
    static readonly MUD: Internal.MudBlock;
    static readonly GRINDSTONE: Internal.GrindstoneBlock;
    static readonly LIGHT_BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BAMBOO_FENCE: Internal.FenceBlock;
    static readonly BLUE_ICE: Internal.HalfTransparentBlock;
    static readonly BROWN_BANNER: Internal.BannerBlock;
    static readonly FLOWERING_AZALEA: Internal.AzaleaBlock;
    static readonly CHERRY_PLANKS: Internal.Block;
    static readonly PACKED_ICE: Internal.Block;
    static readonly ACACIA_SLAB: Internal.SlabBlock;
    static readonly GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly DARK_OAK_SLAB: Internal.SlabBlock;
    static readonly BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly ORANGE_BANNER: Internal.BannerBlock;
    static readonly BEEHIVE: Internal.BeehiveBlock;
    static readonly PURPLE_CANDLE: Internal.CandleBlock;
    static readonly BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly BLACK_CARPET: Internal.WoolCarpetBlock;
    static readonly WHITE_CANDLE: Internal.CandleBlock;
    static readonly NETHER_GOLD_ORE: Internal.DropExperienceBlock;
    static readonly LODESTONE: Internal.Block;
    static readonly WEEPING_VINES: Internal.WeepingVinesBlock;
    static readonly MAGENTA_CANDLE: Internal.CandleBlock;
    static readonly OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly END_PORTAL: Internal.EndPortalBlock;
    static readonly TINTED_GLASS: Internal.TintedGlassBlock;
    static readonly LIME_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly SKELETON_SKULL: Internal.SkullBlock;
    static readonly LIME_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly END_STONE: Internal.Block;
    static readonly JUNGLE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly TWISTING_VINES: Internal.TwistingVinesBlock;
    static readonly END_PORTAL_FRAME: Internal.EndPortalFrameBlock;
    static readonly CRIMSON_WALL_SIGN: Internal.WallSignBlock;
    static readonly SPRUCE_PLANKS: Internal.Block;
    static readonly POLISHED_GRANITE_SLAB: Internal.SlabBlock;
    static readonly YELLOW_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SNIFFER_EGG: Internal.SnifferEggBlock;
    static readonly MOSSY_COBBLESTONE_SLAB: Internal.SlabBlock;
    static readonly CHERRY_FENCE_GATE: Internal.FenceGateBlock;
    static readonly ORANGE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly LIGHT_BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly ACACIA_LEAVES: Internal.LeavesBlock;
    static readonly GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly GRAY_BANNER: Internal.BannerBlock;
    static readonly BIRCH_SLAB: Internal.SlabBlock;
    static readonly CRACKED_DEEPSLATE_TILES: Internal.Block;
    static readonly HANGING_ROOTS: Internal.HangingRootsBlock;
    static readonly TURTLE_EGG: Internal.TurtleEggBlock;
    static readonly BLACKSTONE_WALL: Internal.WallBlock;
    static readonly SMOOTH_RED_SANDSTONE: Internal.Block;
    static readonly BAMBOO_SAPLING: Internal.BambooSaplingBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly WHITE_BED: Internal.BedBlock;
    static readonly CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly DETECTOR_RAIL: Internal.DetectorRailBlock;
    static readonly COPPER_ORE: Internal.DropExperienceBlock;
    static readonly CAULDRON: Internal.CauldronBlock;
    static readonly LANTERN: Internal.LanternBlock;
    static readonly GLOWSTONE: Internal.Block;
    static readonly YELLOW_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly VOID_AIR: Internal.AirBlock;
    static readonly PURPUR_BLOCK: Internal.Block;
    static readonly INFESTED_STONE: Internal.InfestedBlock;
    static readonly CHAIN: Internal.ChainBlock;
    static readonly STRIPPED_SPRUCE_LOG: Internal.RotatedPillarBlock;
    static readonly OAK_SIGN: Internal.StandingSignBlock;
    static readonly OAK_DOOR: Internal.DoorBlock;
    static readonly MAGMA_BLOCK: Internal.MagmaBlock;
    static readonly DIORITE_STAIRS: Internal.StairBlock;
    static readonly RED_SANDSTONE_WALL: Internal.WallBlock;
    static readonly LAPIS_ORE: Internal.DropExperienceBlock;
    static readonly SPRUCE_SAPLING: Internal.SaplingBlock;
    static readonly SMOOTH_STONE: Internal.Block;
    static readonly BUBBLE_COLUMN: Internal.BubbleColumnBlock;
    static readonly CANDLE: Internal.CandleBlock;
    static readonly POLISHED_DIORITE: Internal.Block;
    static readonly BIRCH_WOOD: Internal.RotatedPillarBlock;
    static readonly AIR: Internal.AirBlock;
    static readonly AZALEA_LEAVES: Internal.LeavesBlock;
    static readonly WHITE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly CAVE_AIR: Internal.AirBlock;
    static readonly MOSSY_COBBLESTONE: Internal.Block;
    static readonly OAK_FENCE: Internal.FenceBlock;
    static readonly BAMBOO_SLAB: Internal.SlabBlock;
    static readonly EMERALD_ORE: Internal.DropExperienceBlock;
    static readonly CYAN_WOOL: Internal.Block;
    static readonly BIRCH_PLANKS: Internal.Block;
    static readonly POTTED_ORANGE_TULIP: Internal.FlowerPotBlock;
    static readonly POTTED_WARPED_ROOTS: Internal.FlowerPotBlock;
    static readonly SPRUCE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly DARK_PRISMARINE_STAIRS: Internal.StairBlock;
    static readonly SMALL_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly SPRUCE_STAIRS: Internal.StairBlock;
    static readonly WITHER_SKELETON_SKULL: Internal.WitherSkullBlock;
    static readonly BUBBLE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly CREEPER_WALL_HEAD: Internal.WallSkullBlock;
    static readonly STRIPPED_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly ACACIA_WOOD: Internal.RotatedPillarBlock;
    static readonly CHAIN_COMMAND_BLOCK: Internal.CommandBlock;
    static readonly PIGLIN_HEAD: Internal.SkullBlock;
    static readonly MANGROVE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly INFESTED_MOSSY_STONE_BRICKS: Internal.InfestedBlock;
    static readonly BROWN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly ACACIA_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly CYAN_CANDLE: Internal.CandleBlock;
    static readonly FLETCHING_TABLE: Internal.FletchingTableBlock;
    static readonly TORCHFLOWER_CROP: Internal.TorchflowerCropBlock;
    static readonly GRAY_CONCRETE: Internal.Block;
    static readonly WARPED_STAIRS: Internal.StairBlock;
    static readonly HORN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly BROWN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly END_GATEWAY: Internal.EndGatewayBlock;
    static readonly DEEPSLATE_TILE_WALL: Internal.WallBlock;
    static readonly POTTED_ALLIUM: Internal.FlowerPotBlock;
    static readonly COBBLESTONE: Internal.Block;
    static readonly OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CALCITE: Internal.Block;
    static readonly MANGROVE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly POTTED_OXEYE_DAISY: Internal.FlowerPotBlock;
    static readonly FIRE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly OAK_LOG: Internal.RotatedPillarBlock;
    static readonly STRIPPED_CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static readonly BIRCH_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly TERRACOTTA: Internal.Block;
    static readonly JUNGLE_SLAB: Internal.SlabBlock;
    static readonly NETHER_BRICK_WALL: Internal.WallBlock;
    static readonly CYAN_CARPET: Internal.WoolCarpetBlock;
    static readonly BAMBOO_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly END_ROD: Internal.EndRodBlock;
    static readonly LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SMOOTH_QUARTZ: Internal.Block;
    static readonly PRISMARINE: Internal.Block;
    static readonly SMOOTH_QUARTZ_STAIRS: Internal.StairBlock;
    static readonly NETHER_QUARTZ_ORE: Internal.DropExperienceBlock;
    static readonly MUDDY_MANGROVE_ROOTS: Internal.RotatedPillarBlock;
    static readonly LIGHT_GRAY_CANDLE: Internal.CandleBlock;
    static readonly MANGROVE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly DEEPSLATE_TILE_SLAB: Internal.SlabBlock;
    static readonly ATTACHED_PUMPKIN_STEM: Internal.AttachedStemBlock;
    static readonly CYAN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly OXIDIZED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly POLISHED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly POLISHED_DEEPSLATE: Internal.Block;
    static readonly COCOA: Internal.CocoaBlock;
    static readonly JUNGLE_BUTTON: Internal.ButtonBlock;
    static readonly BIRCH_FENCE_GATE: Internal.FenceGateBlock;
    static readonly SPRUCE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POTTED_RED_MUSHROOM: Internal.FlowerPotBlock;
    static readonly MAGENTA_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static readonly WARPED_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CRIMSON_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CHEST: Internal.ChestBlock;
    static readonly SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BLACKSTONE_SLAB: Internal.SlabBlock;
    static readonly LIME_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly GILDED_BLACKSTONE: Internal.Block;
    static readonly SUNFLOWER: Internal.TallFlowerBlock;
    static readonly ORANGE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly VERDANT_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly PETRIFIED_OAK_SLAB: Internal.SlabBlock;
    static readonly RED_NETHER_BRICK_STAIRS: Internal.StairBlock;
    static readonly DRIED_KELP_BLOCK: Internal.Block;
    static readonly BONE_BLOCK: Internal.RotatedPillarBlock;
    static readonly WHITE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly POTTED_SPRUCE_SAPLING: Internal.FlowerPotBlock;
    static readonly DEAD_HORN_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BUBBLE_CORAL: Internal.CoralPlantBlock;
    static readonly GREEN_CONCRETE: Internal.Block;
    static readonly CHORUS_FLOWER: Internal.ChorusFlowerBlock;
    static readonly GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SMOOTH_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly YELLOW_BANNER: Internal.BannerBlock;
    static readonly LIGHT_GRAY_TERRACOTTA: Internal.Block;
    static readonly PINK_WOOL: Internal.Block;
    static readonly PINK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly CYAN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DARK_OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POWERED_RAIL: Internal.PoweredRailBlock;
    static readonly LIGHT_BLUE_CANDLE: Internal.CandleBlock;
    static readonly POWDER_SNOW: Internal.PowderSnowBlock;
    static readonly ORANGE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly PINK_BANNER: Internal.BannerBlock;
    static readonly BLACK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SPRUCE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static readonly WARPED_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly JIGSAW: Internal.JigsawBlock;
    static readonly WHITE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SPRUCE_SLAB: Internal.SlabBlock;
    static readonly LIGHT_GRAY_WOOL: Internal.Block;
    static readonly PISTON: Internal.PistonBaseBlock;
    static readonly SMOOTH_RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly DIRT: Internal.Block;
    static readonly BLUE_CONCRETE: Internal.Block;
    static readonly RED_TERRACOTTA: Internal.Block;
    static readonly DEAD_BUBBLE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly OXIDIZED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly TALL_SEAGRASS: Internal.TallSeagrassBlock;
    static readonly CHORUS_PLANT: Internal.ChorusPlantBlock;
    static readonly PINK_CONCRETE: Internal.Block;
    static readonly WHITE_TERRACOTTA: Internal.Block;
    static readonly MOVING_PISTON: Internal.MovingPistonBlock;
    static readonly CHERRY_FENCE: Internal.FenceBlock;
    static readonly MANGROVE_ROOTS: Internal.MangroveRootsBlock;
    static readonly POTTED_ACACIA_SAPLING: Internal.FlowerPotBlock;
    static readonly MANGROVE_PLANKS: Internal.Block;
    static readonly ACACIA_BUTTON: Internal.ButtonBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER: Internal.Block;
    static readonly BAMBOO_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly RED_BANNER: Internal.BannerBlock;
    static readonly BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly BELL: Internal.BellBlock;
    static readonly MUSHROOM_STEM: Internal.HugeMushroomBlock;
    static readonly EXPOSED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly CYAN_CONCRETE: Internal.Block;
    static readonly POTTED_CRIMSON_ROOTS: Internal.FlowerPotBlock;
    static readonly GREEN_TERRACOTTA: Internal.Block;
    static readonly CHISELED_QUARTZ_BLOCK: Internal.Block;
    static readonly JUNGLE_LEAVES: Internal.LeavesBlock;
    static readonly FROGSPAWN: Internal.FrogspawnBlock;
    static readonly SOUL_TORCH: Internal.TorchBlock;
    static readonly BOOKSHELF: Internal.Block;
    static readonly WAXED_EXPOSED_COPPER: Internal.Block;
    static readonly CRIMSON_FENCE: Internal.FenceBlock;
    static readonly DIAMOND_BLOCK: Internal.Block;
    static readonly RED_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly CRIMSON_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly MAGENTA_CARPET: Internal.WoolCarpetBlock;
    static readonly STRIPPED_DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly DEAD_BUBBLE_CORAL_BLOCK: Internal.Block;
    static readonly SPRUCE_WALL_SIGN: Internal.WallSignBlock;
    static readonly BLUE_BANNER: Internal.BannerBlock;
    static readonly STRIPPED_CHERRY_LOG: Internal.RotatedPillarBlock;
    static readonly POLISHED_BLACKSTONE_SLAB: Internal.SlabBlock;
    static readonly CALIBRATED_SCULK_SENSOR: Internal.CalibratedSculkSensorBlock;
    static readonly AMETHYST_BLOCK: Internal.AmethystBlock;
    static readonly STRUCTURE_BLOCK: Internal.StructureBlock;
    static readonly BAMBOO_WALL_SIGN: Internal.WallSignBlock;
    static readonly BRAIN_CORAL_BLOCK: Internal.CoralBlock;
    static readonly BAMBOO_MOSAIC_SLAB: Internal.SlabBlock;
    static readonly STRIPPED_DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly SMOOTH_SANDSTONE: Internal.Block;
    static readonly WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly BLUE_WOOL: Internal.Block;
    static readonly IRON_BARS: Internal.IronBarsBlock;
    static readonly IRON_BLOCK: Internal.Block;
    static readonly SUSPICIOUS_SAND: Internal.BrushableBlock;
    static readonly HORN_CORAL_BLOCK: Internal.CoralBlock;
    static readonly MAGENTA_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly HONEY_BLOCK: Internal.HoneyBlock;
    static readonly END_STONE_BRICKS: Internal.Block;
    static readonly JACK_O_LANTERN: Internal.CarvedPumpkinBlock;
    static readonly TARGET: Internal.TargetBlock;
    static readonly BRAIN_CORAL: Internal.CoralPlantBlock;
    static readonly DEAD_FIRE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly MOSSY_STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WITHER_SKELETON_WALL_SKULL: Internal.WitherWallSkullBlock;
    static readonly CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly BIRCH_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly ROSE_BUSH: Internal.TallFlowerBlock;
    static readonly YELLOW_TERRACOTTA: Internal.Block;
    static readonly LECTERN: Internal.LecternBlock;
    static readonly CRIMSON_FENCE_GATE: Internal.FenceGateBlock;
    static readonly DAMAGED_ANVIL: Internal.AnvilBlock;
    static readonly POLISHED_BLACKSTONE_BUTTON: Internal.ButtonBlock;
    static readonly POLISHED_DIORITE_SLAB: Internal.SlabBlock;
    static readonly HAY_BLOCK: Internal.HayBlock;
    static readonly WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static readonly CHERRY_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly MANGROVE_STAIRS: Internal.StairBlock;
    static readonly WEATHERED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly LIME_BANNER: Internal.BannerBlock;
    static readonly TRIPWIRE_HOOK: Internal.TripWireHookBlock;
    static readonly CLAY: Internal.Block;
    static readonly SNOW: Internal.SnowLayerBlock;
    static readonly WHEAT: Internal.CropBlock;
    static readonly CYAN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly WEATHERED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly BROWN_MUSHROOM: Internal.MushroomBlock;
    static readonly SHROOMLIGHT: Internal.Block;
    static readonly CRIMSON_DOOR: Internal.DoorBlock;
    static readonly PRISMARINE_BRICK_STAIRS: Internal.StairBlock;
    static readonly POPPY: Internal.FlowerBlock;
    static readonly STRUCTURE_VOID: Internal.StructureVoidBlock;
    static readonly ORANGE_BED: Internal.BedBlock;
    static readonly DEEPSLATE_COAL_ORE: Internal.DropExperienceBlock;
    static readonly PURPLE_TERRACOTTA: Internal.Block;
    static readonly CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly REDSTONE_BLOCK: Internal.PoweredBlock;
    static readonly BLACK_CANDLE: Internal.CandleBlock;
    static readonly WAXED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly GREEN_BANNER: Internal.BannerBlock;
    static readonly POTTED_AZALEA: Internal.FlowerPotBlock;
    static readonly LIME_CONCRETE: Internal.Block;
    static readonly BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static readonly PURPLE_WOOL: Internal.Block;
    static readonly SOUL_FIRE: Internal.SoulFireBlock;
    static readonly CHISELED_NETHER_BRICKS: Internal.Block;
    static readonly CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static readonly PINK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly CARTOGRAPHY_TABLE: Internal.CartographyTableBlock;
    static readonly BLACK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GREEN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly CYAN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly QUARTZ_BLOCK: Internal.Block;
    static readonly BAMBOO_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly WHITE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER: Internal.Block;
    static readonly WARPED_WALL_SIGN: Internal.WallSignBlock;
    static readonly COMPOSTER: Internal.ComposterBlock;
    static readonly DARK_OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly ACACIA_SAPLING: Internal.SaplingBlock;
    static readonly PITCHER_PLANT: Internal.DoublePlantBlock;
    static readonly CHISELED_SANDSTONE: Internal.Block;
    static readonly POTTED_PINK_TULIP: Internal.FlowerPotBlock;
    static readonly LARGE_FERN: Internal.DoublePlantBlock;
    static readonly TNT: Internal.TntBlock;
    static readonly COBBLED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static readonly BRICK_STAIRS: Internal.StairBlock;
    static readonly WARPED_SLAB: Internal.SlabBlock;
    static readonly SMOOTH_QUARTZ_SLAB: Internal.SlabBlock;
    static readonly LAVA_CAULDRON: Internal.LavaCauldronBlock;
    static readonly SCULK_SHRIEKER: Internal.SculkShriekerBlock;
    static readonly BRICK_WALL: Internal.WallBlock;
    static readonly CHISELED_DEEPSLATE: Internal.Block;
    static readonly AZALEA: Internal.AzaleaBlock;
    static readonly SMOOTH_STONE_SLAB: Internal.SlabBlock;
    static readonly JUNGLE_SIGN: Internal.StandingSignBlock;
    static readonly LIME_WOOL: Internal.Block;
    static readonly LIME_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly GREEN_BED: Internal.BedBlock;
    static readonly ACTIVATOR_RAIL: Internal.PoweredRailBlock;
    static readonly SEA_PICKLE: Internal.SeaPickleBlock;
    static readonly PINK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly BLUE_TERRACOTTA: Internal.Block;
    static readonly WEATHERED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly CRACKED_STONE_BRICKS: Internal.Block;
    static readonly FURNACE: Internal.FurnaceBlock;
    static readonly COBBLESTONE_SLAB: Internal.SlabBlock;
    static readonly MANGROVE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly CHERRY_STAIRS: Internal.StairBlock;
    static readonly BAMBOO_STAIRS: Internal.StairBlock;
    static readonly LIGHT_GRAY_CARPET: Internal.WoolCarpetBlock;
    static readonly MANGROVE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly COBBLESTONE_WALL: Internal.WallBlock;
    static readonly BEDROCK: Internal.Block;
    static readonly BIRCH_LEAVES: Internal.LeavesBlock;
    static readonly PURPLE_BED: Internal.BedBlock;
    static readonly LIME_WALL_BANNER: Internal.WallBannerBlock;
    static readonly RED_SANDSTONE: Internal.Block;
    static readonly GOLD_ORE: Internal.DropExperienceBlock;
    static readonly SCULK: Internal.SculkBlock;
    static readonly ACACIA_SIGN: Internal.StandingSignBlock;
    static readonly COBWEB: Internal.WebBlock;
    static readonly CRIMSON_STEM: Internal.RotatedPillarBlock;
    static readonly PINK_BED: Internal.BedBlock;
    static readonly STRIPPED_ACACIA_LOG: Internal.RotatedPillarBlock;
    static readonly BEE_NEST: Internal.BeehiveBlock;
    static readonly LAVA: Internal.LiquidBlock;
    static readonly POTTED_WARPED_FUNGUS: Internal.FlowerPotBlock;
    static readonly NETHER_WART_BLOCK: Internal.Block;
    static readonly TORCHFLOWER: Internal.FlowerBlock;
    static readonly ATTACHED_MELON_STEM: Internal.AttachedStemBlock;
    static readonly DEEPSLATE_EMERALD_ORE: Internal.DropExperienceBlock;
    static readonly BROWN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly POTTED_DARK_OAK_SAPLING: Internal.FlowerPotBlock;
    static readonly POTTED_FERN: Internal.FlowerPotBlock;
    static readonly PUMPKIN: Internal.PumpkinBlock;
    static readonly EXPOSED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly RED_MUSHROOM: Internal.MushroomBlock;
    static readonly BROWN_TERRACOTTA: Internal.Block;
    static readonly PURPLE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly ORANGE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly RAW_IRON_BLOCK: Internal.Block;
    static readonly WALL_TORCH: Internal.WallTorchBlock;
    static readonly CACTUS: Internal.CactusBlock;
    static readonly FIRE: Internal.FireBlock;
    static readonly SLIME_BLOCK: Internal.SlimeBlock;
    static readonly CHIPPED_ANVIL: Internal.AnvilBlock;
    static readonly QUARTZ_SLAB: Internal.SlabBlock;
    static readonly LIGHT_BLUE_BED: Internal.BedBlock;
    static readonly GREEN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly JUNGLE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly SOUL_SAND: Internal.SoulSandBlock;
    static readonly CUT_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly MAGENTA_CONCRETE: Internal.Block;
    static readonly GRANITE: Internal.Block;
    static readonly LIGHT_GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SMOOTH_BASALT: Internal.Block;
    static readonly DEAD_BUSH: Internal.DeadBushBlock;
    static readonly DARK_OAK_LEAVES: Internal.LeavesBlock;
    static readonly SOUL_CAMPFIRE: Internal.CampfireBlock;
    static readonly MAGENTA_BANNER: Internal.BannerBlock;
    static readonly SPRUCE_DOOR: Internal.DoorBlock;
    static readonly CREEPER_HEAD: Internal.SkullBlock;
    static readonly BROWN_CANDLE: Internal.CandleBlock;
    static readonly YELLOW_WALL_BANNER: Internal.WallBannerBlock;
    static readonly DEAD_BUBBLE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BLUE_CARPET: Internal.WoolCarpetBlock;
    static readonly BRICK_SLAB: Internal.SlabBlock;
    static readonly JUNGLE_DOOR: Internal.DoorBlock;
    static readonly LIME_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly ACACIA_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly MOSSY_STONE_BRICK_WALL: Internal.WallBlock;
    static readonly TUBE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly BROWN_BED: Internal.BedBlock;
    static readonly PURPLE_CARPET: Internal.WoolCarpetBlock;
    static readonly LIGHT_GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static readonly BIG_DRIPLEAF_STEM: Internal.BigDripleafStemBlock;
    static readonly LIME_CARPET: Internal.WoolCarpetBlock;
    static readonly WARPED_FUNGUS: Internal.FungusBlock;
    static readonly WHITE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly STRIPPED_MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static readonly CRYING_OBSIDIAN: Internal.CryingObsidianBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly MAGENTA_TERRACOTTA: Internal.Block;
    static readonly POTTED_TORCHFLOWER: Internal.FlowerPotBlock;
    static readonly STONE_BUTTON: Internal.ButtonBlock;
    static readonly IRON_DOOR: Internal.DoorBlock;
    static readonly TRAPPED_CHEST: Internal.TrappedChestBlock;
    static readonly LIGHT_GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly OAK_PLANKS: Internal.Block;
    static readonly FLOWERING_AZALEA_LEAVES: Internal.LeavesBlock;
    static readonly POTTED_FLOWERING_AZALEA: Internal.FlowerPotBlock;
    static readonly POLISHED_ANDESITE_STAIRS: Internal.StairBlock;
    static readonly BUBBLE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly ANDESITE_WALL: Internal.WallBlock;
    static readonly YELLOW_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BIRCH_SIGN: Internal.StandingSignBlock;
    static readonly DEEPSLATE_BRICK_WALL: Internal.WallBlock;
    static readonly SMOOTH_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly BLACKSTONE: Internal.Block;
    static readonly LIGHT_GRAY_BED: Internal.BedBlock;
    static readonly STRIPPED_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_PETALS: Internal.PinkPetalsBlock;
    static readonly DIORITE: Internal.Block;
    static readonly SWEET_BERRY_BUSH: Internal.SweetBerryBushBlock;
    static readonly DECORATED_POT: Internal.DecoratedPotBlock;
    static readonly INFESTED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly POTTED_RED_TULIP: Internal.FlowerPotBlock;
    static readonly RED_TULIP: Internal.FlowerBlock;
    static readonly BAMBOO_PLANKS: Internal.Block;
    static readonly BIRCH_BUTTON: Internal.ButtonBlock;
    static readonly JUNGLE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly GREEN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BEACON: Internal.BeaconBlock;
    static readonly DEEPSLATE_LAPIS_ORE: Internal.DropExperienceBlock;
    static readonly OAK_STAIRS: Internal.StairBlock;
    static readonly BIRCH_FENCE: Internal.FenceBlock;
    static readonly SANDSTONE: Internal.Block;
    static readonly SNOW_BLOCK: Internal.Block;
    static readonly BLACK_BED: Internal.BedBlock;
    static readonly BROWN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly POTTED_DEAD_BUSH: Internal.FlowerPotBlock;
    static readonly STRIPPED_CHERRY_WOOD: Internal.RotatedPillarBlock;
    static readonly GRANITE_STAIRS: Internal.StairBlock;
    static readonly DEEPSLATE: Internal.RotatedPillarBlock;
    static readonly DARK_OAK_BUTTON: Internal.ButtonBlock;
    static readonly WHITE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly DEAD_HORN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly BAMBOO_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly INFESTED_COBBLESTONE: Internal.InfestedBlock;
}
type Blocks_ = Blocks;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): Internal.Component;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: Internal.Component_): boolean;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: Internal.Component_[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<Internal.Component>): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: Internal.DustParticleOptions;
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: Internal.AABB;
    readonly EMPTY: Internal.AABB;
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace dev.lambdaurora.spruceui.util {
    interface Nameable {
        getName(): string;
        get name(): string
    }
    type Nameable_ = Nameable;
}
declare namespace atonkish.reinfcore.mixin {
    interface ItemGroupAccessor {
        setIcon(arg0: Internal.ItemStack_): void;
        set icon(arg0: Internal.ItemStack_)
    }
    type ItemGroupAccessor_ = ItemGroupAccessor;
    interface SlotAccessor {
        setY(arg0: number): void;
        setX(arg0: number): void;
        set y(arg0: number)
        set x(arg0: number)
    }
    type SlotAccessor_ = SlotAccessor;
}
declare namespace Internal {
    class Level$ExplosionInteraction extends Internal.Enum<Internal.Level$ExplosionInteraction> {
        static values(): Internal.Level$ExplosionInteraction[];
        static valueOf($$0: string): Internal.Level$ExplosionInteraction;
        static readonly TNT: Internal.Level$ExplosionInteraction;
        static readonly NONE: Internal.Level$ExplosionInteraction;
        static readonly MOB: Internal.Level$ExplosionInteraction;
        static readonly BLOCK: Internal.Level$ExplosionInteraction;
    }
    type Level$ExplosionInteraction_ = "block" | "mob" | Level$ExplosionInteraction | "none" | "tnt";
    interface BaseMapCodec <K, V> {
        keyCodec(): Internal.Codec<K>;
        elementCodec(): Internal.Codec<V>;
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>): Internal.DataResult<Internal.Map<K, V>>;
    }
    type BaseMapCodec_<K, V> = BaseMapCodec<K, V>;
    class ServerStatus$Players extends Internal.Record {
        constructor($$0: number, $$1: number, $$2: Internal.List_<Internal.GameProfile>)
        online(): number;
        sample(): Internal.List<Internal.GameProfile>;
        max(): number;
        static readonly CODEC: Internal.Codec<Internal.ServerStatus$Players>;
    }
    type ServerStatus$Players_ = ServerStatus$Players;
    class FluidStack {
        constructor(resource: any_<Internal.FluidVariant>)
        constructor(copy: Internal.FluidStack_, amount: number)
        constructor(view: Internal.StorageView_<Internal.FluidVariant>)
        constructor(type: Internal.Fluid_, amount: number)
        constructor(type: Internal.FluidVariant_, amount: number)
        constructor(type: Internal.FluidVariant_, amount: number, tag: Internal.CompoundTag_)
        constructor(type: Internal.Fluid_, amount: number, nbt: Internal.CompoundTag_)
        getDisplayName(): Internal.Component;
        static isFluidEqual(mine: Internal.FluidVariant_, other: Internal.FluidVariant_): boolean;
        static readFromPacket(buffer: Internal.FriendlyByteBuf_): Internal.FluidStack;
        setTag(tag: Internal.CompoundTag_): void;
        setAmount(amount: number): this;
        getType(): Internal.FluidVariant;
        removeChildTag(key: string): void;
        isFluidEqual(other: Internal.FluidVariant_): boolean;
        isEmpty(): boolean;
        copy(): this;
        writeToNBT(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        isFluidEqual(other: Internal.FluidStack_): boolean;
        shrink(amount: number): void;
        getAmount(): number;
        shrink(amount: number): void;
        getOrCreateTag(): Internal.CompoundTag;
        canFill(var_: Internal.FluidVariant_): boolean;
        grow(amount: number): void;
        hasTag(): boolean;
        getTag(): Internal.CompoundTag;
        getFluid(): Internal.Fluid;
        writeToPacket(buffer: Internal.FriendlyByteBuf_): Internal.FriendlyByteBuf;
        static loadFluidStackFromNBT(tag: Internal.CompoundTag_): Internal.FluidStack;
        get displayName(): Internal.Component
        set tag(tag: Internal.CompoundTag_)
        set amount(amount: number)
        get type(): Internal.FluidVariant
        get empty(): boolean
        get amount(): number
        get orCreateTag(): Internal.CompoundTag
        get tag(): Internal.CompoundTag
        get fluid(): Internal.Fluid
        static readonly CODEC: Internal.Codec<Internal.FluidStack>;
        static readonly EMPTY: Internal.FluidStack;
    }
    type FluidStack_ = FluidStack;
    class SurfaceRules$Context implements Internal.SurfaceRulesContextAccessor {
        getSurfaceDepth(): number;
        getChunk(): Internal.ChunkAccess;
        getStoneDepthBelow(): number;
        getLastUpdateY(): number;
        getLastUpdateXZ(): number;
        getBlockZ(): number;
        getBlockY(): number;
        getBlockX(): number;
        getMinSurfaceLevel(): number;
        getRandomState(): Internal.RandomState;
        getBiome(): Internal.Supplier<any>;
        getStoneDepthAbove(): number;
        getNoiseChunk(): Internal.NoiseChunk;
        get surfaceDepth(): number
        get chunk(): Internal.ChunkAccess
        get stoneDepthBelow(): number
        get lastUpdateY(): number
        get lastUpdateXZ(): number
        get blockZ(): number
        get blockY(): number
        get blockX(): number
        get minSurfaceLevel(): number
        get randomState(): Internal.RandomState
        get biome(): Internal.Supplier<any>
        get stoneDepthAbove(): number
        get noiseChunk(): Internal.NoiseChunk
        biome: Internal.Supplier<Internal.Holder<Internal.Biome>>;
        readonly biomeGetter: Internal.Function<BlockPos, Internal.Holder<Internal.Biome>>;
    }
    type SurfaceRules$Context_ = SurfaceRules$Context;
    interface TranslationAccess {
        union(right: Internal.TranslationAccess_): this;
        get(key: string): string;
        getOrNull(arg0: string): string;
        subtract(right: Internal.TranslationAccess_): this;
        contains(arg0: string): boolean;
        readonly EMPTY: Internal.TranslationAccess;
    }
    type TranslationAccess_ = TranslationAccess;
    interface BoundingBoxAccessor {
        setMinZ(arg0: number): void;
        setMaxX(arg0: number): void;
        setMaxY(arg0: number): void;
        setMaxZ(arg0: number): void;
        setMinX(arg0: number): void;
        setMinY(arg0: number): void;
        set minZ(arg0: number)
        set maxX(arg0: number)
        set maxY(arg0: number)
        set maxZ(arg0: number)
        set minX(arg0: number)
        set minY(arg0: number)
    }
    type BoundingBoxAccessor_ = BoundingBoxAccessor;
    abstract class ImmutableCollections$AbstractImmutableMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
    }
    type ImmutableCollections$AbstractImmutableMap_<K, V> = ImmutableCollections$AbstractImmutableMap<K, V>;
    class PalettedContainerRO$PackedData <T> extends Internal.Record {
        constructor($$0: Internal.List_<T>, $$1: Internal.Optional_<Internal.LongStream>)
        storage(): Internal.Optional<Internal.LongStream>;
        paletteEntries(): Internal.List<T>;
    }
    type PalettedContainerRO$PackedData_<T> = PalettedContainerRO$PackedData<T>;
    interface ReferenceAccessor {
        callSetRegistryKey(arg0: Internal.ResourceKey_<any>): void;
    }
    type ReferenceAccessor_ = ReferenceAccessor;
    interface FriendlyByteBuf$Reader <T> extends Internal.Function<Internal.FriendlyByteBuf, T> {
        compose<V>(arg0: Internal.Function_<V, Internal.FriendlyByteBuf>): Internal.Function<V, T>;
        asOptional(): Internal.FriendlyByteBuf$Reader<Internal.Optional<T>>;
        andThen<V>(arg0: Internal.Function_<T, V>): Internal.Function<Internal.FriendlyByteBuf, V>;
        apply(arg0: Internal.FriendlyByteBuf_): T;
        identity<T>(): Internal.Function<T, T>;
        (arg0: Internal.FriendlyByteBuf_): T;
    }
    type FriendlyByteBuf$Reader_<T> = FriendlyByteBuf$Reader<T>;
    class SculkPatchFeature extends Internal.Feature<Internal.SculkPatchConfiguration> {
        constructor($$0: Internal.Codec_<Internal.SculkPatchConfiguration>)
    }
    type SculkPatchFeature_ = SculkPatchFeature;
    class Zombie extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.Zombie>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setCanBreakDoors($$0: boolean): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static getSpawnAsBabyOdds($$0: Internal.RandomSource_): boolean;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        isUnderWaterConverting(): boolean;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        canBreakDoors(): boolean;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        set canBreakDoors($$0: boolean)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get underWaterConverting(): boolean
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ZOMBIE_LEADER_CHANCE: 0.05;
        static readonly REINFORCEMENT_RANGE_MIN: 7;
        static readonly REINFORCEMENT_RANGE_MAX: 40;
        static readonly REINFORCEMENT_ATTEMPTS: 50;
    }
    type Zombie_ = Zombie;
    class RemoveOresProperties {
        constructor()
        worldgenLayer: Internal.GenerationStep$Decoration;
        biomes: Internal.BiomeFilter;
        blocks: BlockStatePredicate;
    }
    type RemoveOresProperties_ = RemoveOresProperties;
    interface BalmEntity {
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getFabricBalmData(): Internal.CompoundTag;
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get fabricBalmData(): Internal.CompoundTag
    }
    type BalmEntity_ = BalmEntity;
    class LadderBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock, Internal.MoreBlockCulling {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        shouldAttemptToCull(state: Internal.BlockState_, side: Internal.Direction_): boolean;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        canCull(): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        setCanCull(canCull: boolean): void;
        /**
         * @deprecated
        */
        shouldAttemptToCull(state: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        cantCullAgainst(state: Internal.BlockState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        set canCull(canCull: boolean)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type LadderBlock_ = LadderBlock;
    interface IMapRenderer {
        immediatelyFast$getMapAtlasTexture(arg0: number): Internal.MapAtlasTexture;
        immediatelyFast$getAtlasMapping(arg0: number): number;
    }
    type IMapRenderer_ = IMapRenderer;
    interface Int2BooleanFunction extends Internal.IntPredicate, it.unimi.dsi.fastutil.Function<number, boolean> {
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2BooleanFunction<T>;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2BooleanFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        or(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        negate(): Internal.IntPredicate;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2BooleanFunction;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2BooleanFunction;
        containsKey(arg0: number): boolean;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Int2IntFunction;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Int2CharFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2BooleanFunction;
        put(arg0: number, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, boolean>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        apply(arg0: number): boolean;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        get(arg0: number): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        defaultReturnValue(): boolean;
        and(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        remove(arg0: number): boolean;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Int2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        test(arg0: number): boolean;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Int2DoubleFunction;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2BooleanFunction;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Int2LongFunction;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2BooleanFunction<T>;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Int2FloatFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<number, T>;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Int2ByteFunction;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: boolean): boolean;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2BooleanFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: number, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: boolean): void;
        (arg0: number): boolean;
    }
    type Int2BooleanFunction_ = Int2BooleanFunction;
    class LootContext$VisitedEntry <T> extends Internal.Record {
        constructor($$0: Internal.LootDataType_<T>, $$1: T)
        type(): Internal.LootDataType<T>;
        value(): T;
    }
    type LootContext$VisitedEntry_<T> = LootContext$VisitedEntry<T>;
    class CrossCollisionBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly NORTH: Internal.BooleanProperty;
        static readonly PROPERTY_BY_DIRECTION: {[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty};
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type CrossCollisionBlock_ = CrossCollisionBlock;
    interface ConstProperties {
        isConst(arg0: string): boolean;
        putConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_, arg3: any): void;
        defineConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_): void;
    }
    type ConstProperties_ = ConstProperties;
    class RenderLayer extends Internal.Enum<Internal.RenderLayer> {
        static getLayer(type: Internal.RenderType_): Internal.RenderLayer;
        static valueOf(name: string): Internal.RenderLayer;
        static values(): Internal.RenderLayer[];
        static getPrimaryLayer(type: Internal.RenderType_): Internal.RenderLayer;
        static readonly TRANSPARENT: Internal.RenderLayer;
        static readonly CUTOUT: Internal.RenderLayer;
        static readonly SOLID: Internal.RenderLayer;
    }
    type RenderLayer_ = "transparent" | RenderLayer | "solid" | "cutout";
    interface CharSequence {
        compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        subSequence(arg0: number, arg1: number): this;
        toString(): string;
        chars(): Internal.IntStream;
        charAt(arg0: number): string;
        isEmpty(): boolean;
        length(): number;
        codePoints(): Internal.IntStream;
        get empty(): boolean
    }
    type CharSequence_ = CharSequence;
    class ChainBlock extends Internal.RotatedPillarBlock implements Internal.SimpleWaterloggedBlock, Internal.BlockBehaviourInterface {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ChainBlock_ = ChainBlock;
    class Enchantment$Rarity extends Internal.Enum<Internal.Enchantment$Rarity> {
        static values(): Internal.Enchantment$Rarity[];
        getWeight(): number;
        static valueOf($$0: string): Internal.Enchantment$Rarity;
        get weight(): number
        static readonly VERY_RARE: Internal.Enchantment$Rarity;
        static readonly RARE: Internal.Enchantment$Rarity;
        static readonly UNCOMMON: Internal.Enchantment$Rarity;
        static readonly COMMON: Internal.Enchantment$Rarity;
    }
    type Enchantment$Rarity_ = "uncommon" | "rare" | "common" | "very_rare" | Enchantment$Rarity;
    interface PolymerIdList <T> {
        polymer$getVanillaBitCount(): number;
        polymer$getPolymerEntries(): Internal.Collection<T>;
        polymer$setReorderLock(arg0: boolean): void;
        polymer$clear(): void;
        polymer$getReorderLock(): boolean;
        polymer$setIgnoreCalls(arg0: boolean): void;
        polymer$setChecker(arg0: Internal.Predicate_<T>, arg1: Internal.Predicate_<T>, arg2: Internal.Function_<T, string>): void;
        polymer$getOffset(): number;
        polymer$getNonPolymerBitCount(): number;
    }
    type PolymerIdList_<T> = PolymerIdList<T>;
    class ShipwreckStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_, $$1: boolean)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        readonly isBeached: boolean;
        static readonly CODEC: Internal.Codec<Internal.ShipwreckStructure>;
    }
    type ShipwreckStructure_ = ShipwreckStructure;
    class VerticalAnchor$BelowTop extends Internal.Record implements Internal.VerticalAnchor {
        constructor($$0: number)
        static aboveBottom($$0: number): Internal.VerticalAnchor;
        static absolute($$0: number): Internal.VerticalAnchor;
        static belowTop($$0: number): Internal.VerticalAnchor;
        static bottom(): Internal.VerticalAnchor;
        static top(): Internal.VerticalAnchor;
        resolveY($$0: Internal.WorldGenerationContext_): number;
        offset(): number;
        static readonly CODEC: Internal.Codec<Internal.VerticalAnchor$BelowTop>;
    }
    type VerticalAnchor$BelowTop_ = VerticalAnchor$BelowTop;
    interface GoalSelectorAccessor {
        getGoals(): Internal.Set<Internal.WrappedGoal>;
        get goals(): Internal.Set<Internal.WrappedGoal>
    }
    type GoalSelectorAccessor_ = GoalSelectorAccessor;
    interface InfoDisplayOnCompile <T> {
        onCompile(arg0: Internal.InfoDisplay_<T>, arg1: Internal.InfoDisplayCompiler_, arg2: Internal.XaeroMinimapSession_, arg3: Internal.MinimapProcessor_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: BlockPos_): void;
        (arg0: Internal.InfoDisplay_<T>, arg1: Internal.InfoDisplayCompiler_, arg2: Internal.XaeroMinimapSession_, arg3: Internal.MinimapProcessor_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: BlockPos_): void;
    }
    type InfoDisplayOnCompile_<T> = InfoDisplayOnCompile<T>;
    abstract class BaseSpawner implements Internal.BaseSpawnerAccessor {
        constructor()
        setEntityId($$0: Internal.EntityType_<any>, $$1: Internal.Level_, $$2: Internal.RandomSource_, $$3: BlockPos_): void;
        broadcastEvent(arg0: Internal.Level_, arg1: BlockPos_, arg2: number): void;
        getoSpin(): number;
        onEventTriggered($$0: Internal.Level_, $$1: number): boolean;
        getOrCreateDisplayEntity($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_): Internal.Entity;
        port_lib$getSpawnPotentials(): Internal.SimpleWeightedRandomList<any>;
        port_lib$getNextSpawnData(): Internal.SpawnData;
        load($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.CompoundTag_): void;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        clientTick($$0: Internal.Level_, $$1: BlockPos_): void;
        getSpin(): number;
        serverTick($$0: Internal.ServerLevel_, $$1: BlockPos_): void;
        get oSpin(): number
        get spin(): number
        spawnDelay: number;
        static readonly SPAWN_DATA_TAG: "SpawnData";
    }
    type BaseSpawner_ = BaseSpawner;
    class Excluder implements Internal.TypeAdapterFactory, Internal.Cloneable {
        constructor()
        withVersion(arg0: number): this;
        excludeClass(arg0: typeof any, arg1: boolean): boolean;
        excludeField(arg0: Internal.Field_, arg1: boolean): boolean;
        withExclusionStrategy(arg0: Internal.ExclusionStrategy_, arg1: boolean, arg2: boolean): this;
        withModifiers(...arg0: number[]): this;
        excludeFieldsWithoutExposeAnnotation(): this;
        disableInnerClassSerialization(): this;
        create<T>(arg0: Internal.Gson_, arg1: com.google.gson.reflect.TypeToken_<T>): Internal.TypeAdapter<T>;
        static readonly DEFAULT: Internal.Excluder;
    }
    type Excluder_ = Excluder;
    interface RegionBasedStorageSectionExtended <R> {
        getInChunkColumn(arg0: number, arg1: number): Internal.Iterable<R>;
        getWithinChunkColumn(arg0: number, arg1: number): Internal.Stream<R>;
    }
    type RegionBasedStorageSectionExtended_<R> = RegionBasedStorageSectionExtended<R>;
    class CarriageSyncData {
        constructor()
        read(buffer: Internal.FriendlyByteBuf_): void;
        write(buffer: Internal.FriendlyByteBuf_): void;
        approach(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_, partialIn: number): void;
        getDistanceTo(graph: Internal.TrackGraph_, current: Internal.TravellingPoint_, target: Internal.TravellingPoint_, maxDistance: number, forward: boolean): number;
        update(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_): void;
        copy(): this;
        isDirty(): boolean;
        setDirty(dirty: boolean): void;
        apply(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_): void;
        get dirty(): boolean
        set dirty(dirty: boolean)
        wheelLocations: Internal.Vector<com.simibubi.create.foundation.utility.Pair<Internal.Couple<number>, number>>;
        leadingCarriage: boolean;
        fallbackLocations: com.simibubi.create.foundation.utility.Pair<Vec3d, Internal.Couple<Vec3d>>;
        distanceToDestination: number;
    }
    type CarriageSyncData_ = CarriageSyncData;
    interface HttpTextureAccessor {
        chatheads$setTextureLocation(arg0: ResourceLocation_): void;
    }
    type HttpTextureAccessor_ = HttpTextureAccessor;
    interface InjectedEntityTypeExtension extends Internal.InjectedRegistryEntryExtension<Internal.EntityType<any>> {
        arch$holder(): Internal.Holder<Internal.EntityType<any>>;
        arch$registryName(): ResourceLocation;
    }
    type InjectedEntityTypeExtension_ = InjectedEntityTypeExtension;
    class FrostedIceBlock extends Internal.IceBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static replaceBlockOnSnow(world: Internal.ServerLevel_, blockPos: BlockPos_, biome: Internal.Biome_): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        onMeltableManuallyPlaced(world: Internal.ServerLevel_, pos: BlockPos_): void;
        onMeltableReplaced(world: Internal.ServerLevel_, pos: BlockPos_): void;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 3;
    }
    type FrostedIceBlock_ = FrostedIceBlock;
    interface StructType <S> {
        getLayout(): Internal.BufferLayout;
        create(): S;
        get layout(): Internal.BufferLayout
    }
    type StructType_<S> = StructType<S>;
    interface ServerDataExtension {
        setPreventsChatReports(arg0: boolean): void;
        preventsChatReports(): boolean;
        set preventsChatReports(arg0: boolean)
    }
    type ServerDataExtension_ = ServerDataExtension;
    interface ShortListIterator extends Internal.ListIterator<number>, Internal.ShortBidirectionalIterator {
        /**
         * @deprecated
        */
        add(arg0: any): void;
        /**
         * @deprecated
        */
        set(arg0: number): void;
        previousShort(): number;
        nextIndex(): number;
        forEachRemaining(arg0: any): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        set(arg0: any): void;
        skip(arg0: number): number;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        nextShort(): number;
        forEachRemaining(arg0: Internal.ShortConsumer_): void;
        add(arg0: number): void;
        remove(): void;
        hasPrevious(): boolean;
        back(arg0: number): number;
        hasNext(): boolean;
        set(arg0: number): void;
        /**
         * @deprecated
        */
        previous(): any;
        /**
         * @deprecated
        */
        add(arg0: number): void;
        previousIndex(): number;
    }
    type ShortListIterator_ = ShortListIterator;
    class Markings extends Internal.Enum<Internal.Markings> {
        static byId($$0: number): Internal.Markings;
        static values(): Internal.Markings[];
        static valueOf($$0: string): Internal.Markings;
        getId(): number;
        get id(): number
        static readonly BLACK_DOTS: Internal.Markings;
        static readonly WHITE_FIELD: Internal.Markings;
        static readonly NONE: Internal.Markings;
        static readonly WHITE: Internal.Markings;
        static readonly WHITE_DOTS: Internal.Markings;
    }
    type Markings_ = "white_field" | "white" | "black_dots" | Markings | "white_dots" | "none";
    class ClientboundPlayerLookAtPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.EntityAnchorArgument$Anchor_, $$1: number, $$2: number, $$3: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.EntityAnchorArgument$Anchor_, $$1: Internal.Entity_, $$2: Internal.EntityAnchorArgument$Anchor_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getPosition($$0: Internal.Level_): Vec3d;
        isSkippable(): boolean;
        getFromAnchor(): Internal.EntityAnchorArgument$Anchor;
        get skippable(): boolean
        get fromAnchor(): Internal.EntityAnchorArgument$Anchor
    }
    type ClientboundPlayerLookAtPacket_ = ClientboundPlayerLookAtPacket;
    interface ResourceLocationAccess {
        setNamespace(arg0: string): void;
        setPath(arg0: string): void;
        set namespace(arg0: string)
        set path(arg0: string)
    }
    type ResourceLocationAccess_ = ResourceLocationAccess;
    interface Shader {
        getFragmentProgram(): Internal.Program;
        markDirty(): void;
        attachToProgram(): void;
        getVertexProgram(): Internal.Program;
        getId(): number;
        get fragmentProgram(): Internal.Program
        get vertexProgram(): Internal.Program
        get id(): number
    }
    type Shader_ = Shader;
    class NormalNoise$NoiseParameters extends Internal.Record {
        constructor($$0: number, $$1: Internal.DoubleList_)
        constructor($$0: number, $$1: number, ...$$2: number[])
        constructor($$0: number, $$1: Internal.List_<number>)
        amplitudes(): Internal.DoubleList;
        firstOctave(): number;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.NormalNoise$NoiseParameters>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.NormalNoise$NoiseParameters>>;
    }
    type NormalNoise$NoiseParameters_ = Special.Noise | NormalNoise$NoiseParameters;
    class KeyframeAnimation$StateCollection$State {
        constructor(state: Internal.KeyframeAnimation$StateCollection$State_)
        getKeyFrames(): Internal.List<Internal.KeyframeAnimation$KeyFrame>;
        findAtTick(tick: number): number;
        replace(keyFrame: Internal.KeyframeAnimation$KeyFrame_, pos: number): void;
        addKeyFrame(tick: number, value: number, ease: Internal.Ease_, rotate: number, degrees: boolean): boolean;
        setEnabled(newValue: boolean): void;
        addKeyFrame(tick: number, value: number, ease: Internal.Ease_): boolean;
        copy(): this;
        lockAndVerify(maxLength: number): void;
        isEnabled(): boolean;
        length(): number;
        replaceEase(pos: number, ease: Internal.Ease_): void;
        get keyFrames(): Internal.List<Internal.KeyframeAnimation$KeyFrame>
        set enabled(newValue: boolean)
        get enabled(): boolean
        readonly name: string;
        readonly defaultValue: number;
        readonly threshold: number;
    }
    type KeyframeAnimation$StateCollection$State_ = KeyframeAnimation$StateCollection$State;
    class GridAlignedBB implements Internal.ImmutableBox {
        constructor()
        constructor(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number)
        sizeY(): number;
        unionAssign(other: Internal.ImmutableBox_): void;
        intersect(other: Internal.ImmutableBox_): this;
        static from(start: BlockPos_, end: BlockPos_): Internal.GridAlignedBB;
        sameAs(other: Internal.ImmutableBox_): boolean;
        intersectAssign(other: Internal.ImmutableBox_): void;
        forEachContained(func: Internal.CoordinateConsumer_): void;
        getMinY(): number;
        setMinY(minY: number): this;
        getMaxY(): number;
        intersects(other: Internal.ImmutableBox_): boolean;
        static from(pos: BlockPos_): Internal.GridAlignedBB;
        setMaxX(maxX: number): this;
        setMaxZ(maxZ: number): this;
        union(other: Internal.ImmutableBox_): Internal.ImmutableBox;
        volume(): number;
        intersects(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): boolean;
        sameAs(other: Internal.ImmutableBox_, margin: number): boolean;
        nextPowerOf2(): void;
        setMax(v: Vec3i_): this;
        static from(aabb: Internal.AABB_): Internal.GridAlignedBB;
        translate(by: Vec3i_): void;
        setMax(x: number, y: number, z: number): this;
        nextPowerOf2Centered(): void;
        translate(x: number, y: number, z: number): void;
        grow(s: number): void;
        empty(): boolean;
        setMin(v: Vec3i_): this;
        setMin(x: number, y: number, z: number): this;
        sizeX(): number;
        grow(x: number, y: number, z: number): void;
        sizeZ(): number;
        fixMinMax(): void;
        sameAs(other: Internal.AABB_): boolean;
        toAABB(): Internal.AABB;
        assign(start: BlockPos_, end: BlockPos_): this;
        getMaxZ(): number;
        mirrorAbout(axis: Internal.Direction$Axis_): void;
        contains(x: number, y: number, z: number): boolean;
        setMinZ(minZ: number): this;
        getMinX(): number;
        setMinX(minX: number): this;
        getMaxX(): number;
        getMinZ(): number;
        unionAssign(other: Internal.AABB_): void;
        static containingAll(positions: Internal.Collection_<BlockPos>): Internal.ImmutableBox;
        setMaxY(maxY: number): this;
        contains(other: Internal.ImmutableBox_): boolean;
        isContainedBy(other: Internal.GridAlignedBB_): boolean;
        static from(pos: Internal.SectionPos_): Internal.GridAlignedBB;
        assign(other: Internal.AABB_): void;
        hasPowerOf2Sides(): boolean;
        static ofRadius(radius: number): Internal.GridAlignedBB;
        static from(sectionX: number, sectionZ: number): Internal.GridAlignedBB;
        assign(other: Internal.ImmutableBox_): void;
        copy(): this;
        get minY(): number
        set minY(minY: number)
        get maxY(): number
        set maxX(maxX: number)
        set maxZ(maxZ: number)
        set max(v: Vec3i_)
        set min(v: Vec3i_)
        get maxZ(): number
        set minZ(minZ: number)
        get minX(): number
        set minX(minX: number)
        get maxX(): number
        get minZ(): number
        set maxY(maxY: number)
    }
    type GridAlignedBB_ = GridAlignedBB;
    class Currency implements Internal.Serializable {
        static getInstance(arg0: string): Internal.Currency;
        getSymbol(arg0: Internal.Locale_): string;
        getNumericCode(): number;
        getDisplayName(): string;
        static getAvailableCurrencies(): Internal.Set<Internal.Currency>;
        getNumericCodeAsString(): string;
        getDisplayName(arg0: Internal.Locale_): string;
        getSymbol(): string;
        getDefaultFractionDigits(): number;
        getCurrencyCode(): string;
        static getInstance(arg0: Internal.Locale_): Internal.Currency;
        get numericCode(): number
        get displayName(): string
        get availableCurrencies(): Internal.Set<Internal.Currency>
        get numericCodeAsString(): string
        get symbol(): string
        get defaultFractionDigits(): number
        get currencyCode(): string
    }
    type Currency_ = Currency;
    interface HolderGetter <T> {
        get(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        get(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder$Reference<T>>;
        getOrThrow($$0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        getOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
    }
    type HolderGetter_<T> = HolderGetter<T>;
    class ClientboundSetActionBarTextPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Component_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getText(): Internal.Component;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get text(): Internal.Component
        get skippable(): boolean
    }
    type ClientboundSetActionBarTextPacket_ = ClientboundSetActionBarTextPacket;
    class LinkedHashMap <K, V> extends Internal.HashMap<K, V> implements Internal.Map<K, V> {
        constructor()
        constructor(arg0: Internal.Map_<K, V>)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number, arg2: boolean)
        constructor(arg0: number, arg1: number)
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type LinkedHashMap_<K, V> = LinkedHashMap<K, V>;
    interface InterruptibleChannel extends Internal.Channel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean
    }
    type InterruptibleChannel_ = InterruptibleChannel;
    interface IXaeroClickableWidget extends xaero.common.gui.ICanTooltip {
        getXaero_tooltip(): Internal.Supplier<Internal.CursorBox>;
        setXaero_tooltip(arg0: Internal.Supplier_<Internal.CursorBox>): void;
        get xaero_tooltip(): Internal.Supplier<Internal.CursorBox>
        set xaero_tooltip(arg0: Internal.Supplier_<Internal.CursorBox>)
    }
    type IXaeroClickableWidget_ = IXaeroClickableWidget;
    class DummySensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type DummySensor_ = DummySensor;
    class ClientboundPlayerInfoRemovePacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.List_<Internal.UUID>)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        profileIds(): Internal.List<Internal.UUID>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundPlayerInfoRemovePacket_ = ClientboundPlayerInfoRemovePacket;
    class ServerData implements Internal.ServerDataExtension {
        constructor($$0: string, $$1: string, $$2: boolean)
        setResourcePackStatus($$0: Internal.ServerData$ServerPackStatus_): void;
        write(): Internal.CompoundTag;
        setIconBytes($$0: number[]): void;
        preventsChatReports(): boolean;
        setEnforcesSecureChat($$0: boolean): void;
        getIconBytes(): number[];
        isLan(): boolean;
        enforcesSecureChat(): boolean;
        setPreventsChatReports(prevents: boolean): void;
        static read($$0: Internal.CompoundTag_): Internal.ServerData;
        copyNameIconFrom($$0: Internal.ServerData_): void;
        getResourcePackStatus(): Internal.ServerData$ServerPackStatus;
        copyFrom($$0: Internal.ServerData_): void;
        set resourcePackStatus($$0: Internal.ServerData$ServerPackStatus_)
        set iconBytes($$0: number[])
        set enforcesSecureChat($$0: boolean)
        get iconBytes(): number[]
        get lan(): boolean
        set preventsChatReports(prevents: boolean)
        get resourcePackStatus(): Internal.ServerData$ServerPackStatus
        name: string;
        playerList: Internal.List<Internal.Component>;
        ip: string;
        players: Internal.ServerStatus$Players;
        ping: number;
        motd: Internal.Component;
        pinged: boolean;
        version: Internal.Component;
        status: Internal.Component;
        protocol: number;
    }
    type ServerData_ = ServerData;
    class FoodProperties {
        getSaturationModifier(): number;
        getEffects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>;
        getNutrition(): number;
        isFastFood(): boolean;
        isMeat(): boolean;
        canAlwaysEat(): boolean;
        get saturationModifier(): number
        get effects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>
        get nutrition(): number
        get fastFood(): boolean
        get meat(): boolean
    }
    type FoodProperties_ = FoodProperties;
    interface StructureTemplateManagerAccessor {
        mvs_getResourceManager(): Internal.ResourceManager;
    }
    type StructureTemplateManagerAccessor_ = StructureTemplateManagerAccessor;
    class CauldronBlock extends Internal.AbstractCauldronBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CauldronBlock_ = CauldronBlock;
    class ChatType$Bound extends Internal.Record {
        constructor($$0: Internal.ChatType_, $$1: Internal.Component_, $$2: Internal.Component_)
        toNetwork($$0: Internal.RegistryAccess_): Internal.ChatType$BoundNetwork;
        decorateNarration($$0: Internal.Component_): Internal.Component;
        decorate($$0: Internal.Component_): Internal.Component;
        name(): Internal.Component;
        targetName(): Internal.Component;
        withTargetName($$0: Internal.Component_): this;
        chatType(): Internal.ChatType;
    }
    type ChatType$Bound_ = ChatType$Bound;
    interface ToIntFunction <T> {
        applyAsInt(arg0: T): number;
        (arg0: T): number;
    }
    type ToIntFunction_<T> = ToIntFunction<T>;
    class Holder$Kind extends Internal.Enum<Internal.Holder$Kind> {
        static values(): Internal.Holder$Kind[];
        static valueOf($$0: string): Internal.Holder$Kind;
        static readonly DIRECT: Internal.Holder$Kind;
        static readonly REFERENCE: Internal.Holder$Kind;
    }
    type Holder$Kind_ = "reference" | Holder$Kind | "direct";
    class Tuple <A, B> {
        constructor($$0: A, $$1: B)
        getA(): A;
        getB(): B;
        setB($$0: B): void;
        setA($$0: A): void;
        get a(): A
        get b(): B
        set b($$0: B)
        set a($$0: A)
    }
    type Tuple_<A, B> = Tuple<A, B>;
    class ParticleRenderingPhase extends Internal.Enum<Internal.ParticleRenderingPhase> {
        static values(): Internal.ParticleRenderingPhase[];
        static valueOf(arg0: string): Internal.ParticleRenderingPhase;
        static readonly EVERYTHING: Internal.ParticleRenderingPhase;
        static readonly TRANSLUCENT: Internal.ParticleRenderingPhase;
        static readonly OPAQUE: Internal.ParticleRenderingPhase;
    }
    type ParticleRenderingPhase_ = ParticleRenderingPhase | "translucent" | "opaque" | "everything";
    class CarpetEventServer$CallbackList {
        constructor(reqArgs: number, isSystem: boolean, isGlobalOnly: boolean)
        call(argumentSupplier: Internal.Supplier_<Internal.List<Internal.Value>>, cmdSourceSupplier: Internal.Supplier_<Internal.CommandSourceStack>): boolean;
        removeEventCall(hostName: string, target: string, funName: string): void;
        createChildEvents(host: Internal.CarpetScriptHost_): void;
        addEventCallInternal(host: Internal.ScriptHost_, function_: Internal.FunctionValue_, args: Internal.List_<Internal.Value>): boolean;
        removeAllCalls(host: Internal.CarpetScriptHost_): void;
        inspectCurrentCalls(): Internal.List<Internal.CarpetEventServer$Callback>;
        clearEverything(): void;
        sortByPriority(scriptServer: Internal.CarpetScriptServer_): void;
        addFromExternal(source: Internal.CommandSourceStack_, hostName: string, funName: string, hostOnEventHandler: Internal.Consumer_<Internal.ScriptHost>, scriptServer: Internal.CarpetScriptServer_): boolean;
        signal(sender: Internal.CommandSourceStack_, recipient: Internal.ServerPlayer_, callArg: Internal.List_<Internal.Value>): number;
        readonly reqArgs: number;
    }
    type CarpetEventServer$CallbackList_ = CarpetEventServer$CallbackList;
    class BlendMode {
        constructor()
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number)
        constructor($$0: number, $$1: number, $$2: number)
        isOpaque(): boolean;
        static stringToBlendFactor($$0: string): number;
        static stringToBlendFunc($$0: string): number;
        apply(): void;
        get opaque(): boolean
    }
    type BlendMode_ = BlendMode;
    interface AbstractMinecartEntityAccessor {
        getCUSTOM_BLOCK_ID(): Internal.EntityDataAccessor<number>;
        get CUSTOM_BLOCK_ID(): Internal.EntityDataAccessor<number>
    }
    type AbstractMinecartEntityAccessor_ = AbstractMinecartEntityAccessor;
    interface RandomBlockTickerLevel {
        leavesbegone$getRandomBlockTicks(): Internal.LevelTicks<Internal.Block>;
    }
    type RandomBlockTickerLevel_ = RandomBlockTickerLevel;
    class LerpingBossEvent extends Internal.BossEvent {
        constructor($$0: Internal.UUID_, $$1: Internal.Component_, $$2: number, $$3: Internal.BossEvent$BossBarColor_, $$4: Internal.BossEvent$BossBarOverlay_, $$5: boolean, $$6: boolean, $$7: boolean)
    }
    type LerpingBossEvent_ = LerpingBossEvent;
    class PNGExportResultType extends Internal.Enum<Internal.PNGExportResultType> {
        isSuccess(): boolean;
        getMessage(): Internal.Component;
        static values(): Internal.PNGExportResultType[];
        static valueOf(name: string): Internal.PNGExportResultType;
        get success(): boolean
        get message(): Internal.Component
        static readonly BAD_FBO: Internal.PNGExportResultType;
        static readonly NOT_PREPARED: Internal.PNGExportResultType;
        static readonly IMAGE_TOO_BIG: Internal.PNGExportResultType;
        static readonly IO_EXCEPTION: Internal.PNGExportResultType;
        static readonly TOO_BIG: Internal.PNGExportResultType;
        static readonly OUT_OF_MEMORY: Internal.PNGExportResultType;
        static readonly EMPTY: Internal.PNGExportResultType;
        static readonly SUCCESS: Internal.PNGExportResultType;
    }
    type PNGExportResultType_ = "out_of_memory" | "image_too_big" | "empty" | "not_prepared" | "success" | "too_big" | "io_exception" | PNGExportResultType | "bad_fbo";
    class MovingPistonBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        static newMovingBlockEntity($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.Direction_, $$4: boolean, $$5: boolean): Internal.BlockEntity;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly TYPE: Internal.EnumProperty<Internal.PistonType>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type MovingPistonBlock_ = MovingPistonBlock;
    class Module implements Internal.AnnotatedElement {
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        addOpens(arg0: string, arg1: Internal.Module_): this;
        isNamed(): boolean;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        isExported(arg0: string, arg1: Internal.Module_): boolean;
        getLayer(): Internal.ModuleLayer;
        isOpen(arg0: string): boolean;
        isOpen(arg0: string, arg1: Internal.Module_): boolean;
        addReads(arg0: Internal.Module_): this;
        isExported(arg0: string): boolean;
        addExports(arg0: string, arg1: Internal.Module_): this;
        getPackages(): Internal.Set<string>;
        getName(): string;
        addUses(arg0: typeof any): this;
        getClassLoader(): Internal.ClassLoader;
        canRead(arg0: Internal.Module_): boolean;
        getAnnotations(): Internal.Annotation[];
        getDescriptor(): Internal.ModuleDescriptor;
        canUse(arg0: typeof any): boolean;
        getResourceAsStream(arg0: string): Internal.InputStream;
        getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        get named(): boolean
        get layer(): Internal.ModuleLayer
        get packages(): Internal.Set<string>
        get name(): string
        get classLoader(): Internal.ClassLoader
        get annotations(): Internal.Annotation[]
        get descriptor(): Internal.ModuleDescriptor
        get declaredAnnotations(): Internal.Annotation[]
    }
    type Module_ = Module;
    interface IClumpedOrb {
        clumps$resolve(): boolean;
        clumps$getClumpedMap(): Internal.Map<number, number>;
        clumps$setClumpedMap(arg0: Internal.Map_<number, number>): void;
    }
    type IClumpedOrb_ = IClumpedOrb;
    class LakeFeature$Configuration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.BlockStateProvider_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        barrier(): Internal.BlockStateProvider;
        fluid(): Internal.BlockStateProvider;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.LakeFeature$Configuration>;
    }
    type LakeFeature$Configuration_ = LakeFeature$Configuration;
    class WallSkullBlock extends Internal.AbstractSkullBlock {
        constructor($$0: Internal.SkullBlock$Type_, $$1: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type WallSkullBlock_ = WallSkullBlock;
    class ConduitBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ConduitBlock_ = ConduitBlock;
    interface ModelCuboidAccessor {
        sodium$copy(): Internal.ModelCuboid;
    }
    type ModelCuboidAccessor_ = ModelCuboidAccessor;
    abstract class AbstractObject2ByteSortedMap <K> extends Internal.AbstractObject2ByteMap<K> implements Internal.Object2ByteSortedMap<K> {
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ByteFunction;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        comparator(): Internal.Comparator<K>;
        /**
         * @deprecated
        */
        computeByteIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        removeByte(arg0: any): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        mergeByte(arg0: K, arg1: number, arg2: Internal.IntBinaryOperator_): number;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        subMap(arg0: any, arg1: any): Internal.SortedMap<any, any>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<any>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        applyAsInt(arg0: K): number;
        /**
         * @deprecated
        */
        computeByteIfAbsentPartial(arg0: K, arg1: Internal.Object2ByteFunction_<K>): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Object2ShortFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        putIfAbsent(arg0: K, arg1: number): number;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        static identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Object2IntFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        put(arg0: K, arg1: number): number;
        static of<K, V>(): Internal.Map<K, V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        replace(arg0: K, arg1: number, arg2: number): boolean;
        remove(arg0: any, arg1: number): boolean;
        mergeByte(arg0: K, arg1: number, arg2: Internal.ByteBinaryOperator_): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ByteFunction;
        computeIfAbsent(arg0: K, arg1: Internal.Object2ByteFunction_<K>): number;
        andThenByte(arg0: Internal.Byte2ByteFunction_): Internal.Object2ByteFunction<K>;
        apply(arg0: K): number;
        object2ByteEntrySet(): Internal.ObjectSortedSet<Internal.Object2ByteMap$Entry<K>>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ByteFunction;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        computeIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Object2FloatFunction<K>;
        tailMap(arg0: any): Internal.SortedMap<any, any>;
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        mergeByte(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        headMap(arg0: any): Internal.SortedMap<any, any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        computeByte(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        computeByteIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        lastKey(): K;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ByteFunction;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ByteFunction<T>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: number): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ByteFunction;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        firstKey(): K;
    }
    type AbstractObject2ByteSortedMap_<K> = AbstractObject2ByteSortedMap<K>;
    abstract class MapBlockMarker <D extends Internal.CustomMapDecoration> {
        setPersistent(persistent: boolean): void;
        getName(): Internal.Component;
        setPos(pos: BlockPos_): void;
        setRotation(rot: number): void;
        getRotation(): number;
        getTypeId(): string;
        shouldRefresh(): boolean;
        getPos(): BlockPos;
        createDecorationFromMarker(data: Internal.MapItemSavedData_): D;
        saveToNBT(compound: Internal.CompoundTag_): Internal.CompoundTag;
        setName(name: Internal.Component_): void;
        loadFromNBT(compound: Internal.CompoundTag_): void;
        getMarkerId(): string;
        getType(): Internal.MapDecorationType<D, any>;
        shouldSave(): boolean;
        set persistent(persistent: boolean)
        get name(): Internal.Component
        set pos(pos: BlockPos_)
        set rotation(rot: number)
        get rotation(): number
        get typeId(): string
        get pos(): BlockPos
        set name(name: Internal.Component_)
        get markerId(): string
        get type(): Internal.MapDecorationType<D, any>
    }
    type MapBlockMarker_<D extends Internal.CustomMapDecoration> = MapBlockMarker<D>;
    class ShapedRecipeSchema$ShapedRecipeJS extends Internal.RecipeJS {
        constructor()
        noShrink(): Internal.RecipeJS;
        getMod(): string;
        noMirror(): Internal.RecipeJS;
        get mod(): string
    }
    type ShapedRecipeSchema$ShapedRecipeJS_ = ShapedRecipeSchema$ShapedRecipeJS;
    interface SPC_WorldSavePath_Invoker {
        create(relativePath: string): Internal.LevelResource;
    }
    type SPC_WorldSavePath_Invoker_ = SPC_WorldSavePath_Invoker;
    class DamageSources {
        constructor($$0: Internal.RegistryAccess_)
        generic(): DamageSource;
        freeze(): DamageSource;
        onFire(): DamageSource;
        genericKill(): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>, $$1: Internal.Entity_, $$2: Internal.Entity_): DamageSource;
        cramming(): DamageSource;
        thrown($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        fireworks($$0: Internal.FireworkRocketEntity_, $$1: Internal.Entity_): DamageSource;
        lightningBolt(): DamageSource;
        magic(): DamageSource;
        starve(): DamageSource;
        fireball($$0: Internal.Fireball_, $$1: Internal.Entity_): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>, $$1: Internal.Entity_): DamageSource;
        fallingBlock($$0: Internal.Entity_): DamageSource;
        lava(): DamageSource;
        sting($$0: Internal.LivingEntity_): DamageSource;
        dragonBreath(): DamageSource;
        playerAttack($$0: Internal.Player_): DamageSource;
        inFire(): DamageSource;
        trident($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        indirectMagic($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        wither(): DamageSource;
        dryOut(): DamageSource;
        noAggroMobAttack($$0: Internal.LivingEntity_): DamageSource;
        sonicBoom($$0: Internal.Entity_): DamageSource;
        thorns($$0: Internal.Entity_): DamageSource;
        fallingStalactite($$0: Internal.Entity_): DamageSource;
        anvil($$0: Internal.Entity_): DamageSource;
        arrow($$0: Internal.AbstractArrow_, $$1: Internal.Entity_): DamageSource;
        explosion($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>): DamageSource;
        hotFloor(): DamageSource;
        outOfBorder(): DamageSource;
        mobProjectile($$0: Internal.Entity_, $$1: Internal.LivingEntity_): DamageSource;
        mobAttack($$0: Internal.LivingEntity_): DamageSource;
        explosion($$0: Internal.Explosion_): DamageSource;
        inWall(): DamageSource;
        flyIntoWall(): DamageSource;
        stalagmite(): DamageSource;
        witherSkull($$0: Internal.WitherSkull_, $$1: Internal.Entity_): DamageSource;
        fall(): DamageSource;
        badRespawnPointExplosion($$0: Vec3d_): DamageSource;
        drown(): DamageSource;
        cactus(): DamageSource;
        fellOutOfWorld(): DamageSource;
        sweetBerryBush(): DamageSource;
        readonly damageTypes: Internal.Registry<Internal.DamageType>;
    }
    type DamageSources_ = DamageSources;
    abstract class RandomizableContainerBlockEntity extends Internal.BaseContainerBlockEntity implements Internal.SpecialLogicInventory {
        stopOpen($$0: Internal.Player_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        fabric_setSuppress(suppress: boolean): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isDynamicLightEnabled(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        fabric_onFinalCommit(slot: number, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        kjs$self(): Internal.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        static setLootTable($$0: Internal.BlockGetter_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: ResourceLocation_): void;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        "redirect$fhg000$fabric-transfer-api-v1$fabric_redirectMarkDirty"(self: Internal.RandomizableContainerBlockEntity_): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        setLootTable($$0: ResourceLocation_, $$1: number): void;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        setDynamicLightEnabled(enabled: boolean): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        countNonEmpty(): number;
        asContainer(): Internal.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        canTakeItem($$0: Internal.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        unpackLootTable($$0: Internal.Player_): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get dynamicLightEnabled(): boolean
        get slots(): number
        get width(): number
        get maxStackSize(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        set dynamicLightEnabled(enabled: boolean)
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        lootTableSeed: number;
        static readonly LOOT_TABLE_SEED_TAG: "LootTableSeed";
        static readonly LOOT_TABLE_TAG: "LootTable";
        lootTable: ResourceLocation;
    }
    type RandomizableContainerBlockEntity_ = RandomizableContainerBlockEntity;
    class BellBlockEntity extends Internal.BlockEntity implements Internal.IBellConnections {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BellBlockEntity_): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        method_11007(compound: Internal.CompoundTag_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isDynamicLightEnabled(): boolean;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getConnected(): Internal.IBellConnections$BellConnection;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        static clientTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BellBlockEntity_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setConnected(con: Internal.IBellConnections$BellConnection_): void;
        onHit($$0: Internal.Direction_): void;
        getRenderBoundingBox(): Internal.AABB;
        get dynamicLightEnabled(): boolean
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get connected(): Internal.IBellConnections$BellConnection
        get updatePacket(): Internal.Packet<any>
        set dynamicLightEnabled(enabled: boolean)
        set connected(con: Internal.IBellConnections$BellConnection_)
        get renderBoundingBox(): Internal.AABB
        shaking: boolean;
        clickDirection: Internal.Direction;
        ticks: number;
        connection: Internal.IBellConnections$BellConnection;
    }
    type BellBlockEntity_ = BellBlockEntity;
    interface IMsgCtx {
        getConnection(): Internal.ActiveConnection;
        isServerSide(): boolean;
        isClientSide(): boolean;
        getNetSide(): Internal.EnumNetSide;
        getNetId(): Internal.NetIdBase;
        get connection(): Internal.ActiveConnection
        get serverSide(): boolean
        get clientSide(): boolean
        get netSide(): Internal.EnumNetSide
        get netId(): Internal.NetIdBase
    }
    type IMsgCtx_ = IMsgCtx;
    interface ByteBufAllocator {
        compositeDirectBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        buffer(): Internal.ByteBuf;
        compositeHeapBuffer(arg0: number): Internal.CompositeByteBuf;
        compositeDirectBuffer(): Internal.CompositeByteBuf;
        compositeBuffer(): Internal.CompositeByteBuf;
        heapBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        ioBuffer(): Internal.ByteBuf;
        heapBuffer(): Internal.ByteBuf;
        heapBuffer(arg0: number): Internal.ByteBuf;
        ioBuffer(arg0: number): Internal.ByteBuf;
        compositeBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(): Internal.ByteBuf;
        isDirectBufferPooled(): boolean;
        directBuffer(arg0: number): Internal.ByteBuf;
        calculateNewCapacity(arg0: number, arg1: number): number;
        buffer(arg0: number, arg1: number): Internal.ByteBuf;
        ioBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        compositeHeapBuffer(): Internal.CompositeByteBuf;
        buffer(arg0: number): Internal.ByteBuf;
        get directBufferPooled(): boolean
        readonly DEFAULT: Internal.PooledByteBufAllocator;
    }
    type ByteBufAllocator_ = ByteBufAllocator;
    class Item$Properties implements Internal.InjectedItemPropertiesExtension, Internal.ItemPropertiesExtensionImpl {
        constructor()
        rarity($$0: Internal.Rarity_): this;
        arch$getTab(): Internal.CreativeModeTab;
        durability($$0: number): this;
        arch$tab(tab: Internal.CreativeModeTab_): this;
        arch$tab(tab: Internal.ResourceKey_<any>): this;
        arch$tab(tab: Internal.DeferredSupplier_<any>): this;
        requiredFeatures(...$$0: Internal.FeatureFlag_[]): this;
        arch$getTabSupplier(): Internal.DeferredSupplier<any>;
        fireResistant(): this;
        craftRemainder($$0: Internal.Item_): this;
        food($$0: Internal.FoodProperties_): this;
        defaultDurability($$0: number): this;
        stacksTo($$0: number): this;
    }
    type Item$Properties_ = Item$Properties;
    class InputType extends Internal.Enum<Internal.InputType> {
        isMouse(): boolean;
        isKeyboard(): boolean;
        static valueOf($$0: string): Internal.InputType;
        static values(): Internal.InputType[];
        get mouse(): boolean
        get keyboard(): boolean
        static readonly NONE: Internal.InputType;
        static readonly KEYBOARD_TAB: Internal.InputType;
        static readonly MOUSE: Internal.InputType;
        static readonly KEYBOARD_ARROW: Internal.InputType;
    }
    type InputType_ = InputType | "mouse" | "keyboard_arrow" | "keyboard_tab" | "none";
    interface CapturedDropsEntity {
        puzzleslib$acceptCapturedDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
    }
    type CapturedDropsEntity_ = CapturedDropsEntity;
    class MapRunner implements Internal.Runnable {
        constructor()
        doTasks(mapProcessor: Internal.MapProcessor_): void;
        stop(): void;
        run(): void;
        addTask(task: Internal.MapRunnerTask_): void;
    }
    type MapRunner_ = MapRunner;
    interface ConnectionAccessor {
        getChannel(): io.netty.channel.Channel;
        get channel(): io.netty.channel.Channel
    }
    type ConnectionAccessor_ = ConnectionAccessor;
    interface AsynchronousChannel extends Internal.Channel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean
    }
    type AsynchronousChannel_ = AsynchronousChannel;
    class Villager extends Internal.AbstractVillager implements Internal.VillagerEntityInteraction, Internal.AVillager, Internal.VillagerDataHolder, Internal.ReputationEventHandler, Internal.VillagerEntityAccessor, Internal.VillagerEntityInterface, Internal.VillagerUtil, Internal.VillagerAccessor, fuzs.tradingpost.mixin.accessor.VillagerAccessor {
        constructor($$0: Internal.EntityType_<Internal.Villager>, $$1: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.Villager>, $$1: Internal.Level_, $$2: Internal.VillagerType_)
        getDistance(pos: BlockPos_): number;
        restock(): void;
        getVillagerData(): Internal.VillagerData;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        getGossips(): Internal.GossipContainer;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        getPlayerReputation($$0: Internal.Player_): number;
        static getSPRINTING_FLAG_INDEX(): number;
        handler$lae000$smarterfarmers$handleEntityEvent(pId: number, ci: Internal.CallbackInfo_): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        wantsMoreFood(): boolean;
        static "fabric_getGatherableItems$fabric-content-registries-v0_$md$896f98$4"(): Internal.Set<any>;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        static fabric_setGatherableItems(items: Internal.Set_<Internal.Item>): void;
        getBrain(): Internal.Brain<Internal.Villager>;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        getVariant(): Internal.VillagerType;
        callNeedsToRestock(): boolean;
        increaseLevelOnTick(): boolean;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        setVariant($$0: Internal.VillagerType_): void;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        static isParent(stack: Internal.ItemStack_): boolean;
        attack(hp: number): void;
        shouldRestock(): boolean;
        getVariant(): any;
        static fabric_getGatherableItems(): Internal.Set<Internal.Item>;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        wantsToSpawnGolem($$0: number): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        isChasing(): boolean;
        callStopTrading(): void;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        callUpdateSpecialPrices(arg0: Internal.Player_): void;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        static pickUpItem($$0: Internal.Mob_, $$1: Internal.InventoryCarrier_, $$2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        playWorkSound(): void;
        spawnGolemIfNeeded($$0: Internal.ServerLevel_, $$1: number, $$2: number): void;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static fabric_setItemFoodValues(items: Internal.Map_<Internal.Item, number>): void;
        static getFALL_FLYING_FLAG_INDEX(): number;
        assignProfessionWhenSpawned(): boolean;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        setIncreaseLevelOnTick(arg0: boolean): void;
        releasePoi($$0: Internal.MemoryModuleType_<Internal.GlobalPos>): void;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        gossip($$0: Internal.ServerLevel_, $$1: Internal.Villager_, $$2: number): void;
        readInventoryFromTag($$0: Internal.CompoundTag_): void;
        self(): Internal.LivingEntity;
        writeInventoryToTag($$0: Internal.CompoundTag_): void;
        getDefaultMovementSpeed(): number;
        forceDefaultTradingScreen(force: boolean): void;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        static "fabric_setItemFoodValues$fabric-content-registries-v0_$md$896f98$2"(arg0: Internal.Map_<any, any>): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setGossips($$0: Internal.Tag_): void;
        hasExcessFood(): boolean;
        refreshBrain($$0: Internal.ServerLevel_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isDynamicLightEnabled(): boolean;
        hasFarmSeeds(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        static "fabric_setGatherableItems$fabric-content-registries-v0_$md$896f98$3"(arg0: Internal.Set_<any>): void;
        setChestArmorItem(item: Internal.ItemStack_): void;
        onInteractionWith(interaction: Internal.ReputationEventType_, uuid: Internal.UUID_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setChasing($$0: boolean): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        openTradingScreen($$0: Internal.Player_, $$1: Internal.Component_, $$2: number): void;
        lithiumOnEquipmentChanged(): void;
        setIsSnitch(player: Internal.Player_, isSnitch: boolean): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setOffers($$0: Internal.MerchantOffers_): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        eatAndDigestFood(): void;
        setVillagerData($$0: Internal.VillagerData_): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setVillagerXp($$0: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        onReputationEventFrom($$0: Internal.ReputationEventType_, $$1: Internal.Entity_): void;
        setMovementSpeedAddition(speed: number): void;
        isSnitch(player: Internal.Player_): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        static onUseEntity(player: Internal.Player_, level: Internal.Level_, hand: Internal.InteractionHand_, entity: Internal.Entity_, hitResult: Internal.EntityHitResult_): Internal.InteractionResult;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        callIncreaseMerchantCareer(): void;
        callUpdateTrades(): void;
        getChestArmorItem(): Internal.ItemStack;
        static saveVillager(villager: Internal.Villager_, stack: Internal.ItemStack_, removeJobSite: boolean): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        callReleaseAllPois(): void;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        invokeUpdateSpecialPrices(arg0: Internal.Player_): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        callStartTrading(arg0: Internal.Player_): void;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        get villagerData(): Internal.VillagerData
        get SILENT(): Internal.EntityDataAccessor<boolean>
        get gossips(): Internal.GossipContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get brain(): Internal.Brain<Internal.Villager>
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get variant(): Internal.VillagerType
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        set variant($$0: Internal.VillagerType_)
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get chasing(): boolean
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        set increaseLevelOnTick(arg0: boolean)
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set gossips($$0: Internal.Tag_)
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set chasing($$0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        set offers($$0: Internal.MerchantOffers_)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set villagerData($$0: Internal.VillagerData_)
        set motionX(x: number)
        set villagerXp($$0: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
        static FOOD_POINTS: {[key: Internal.Item]: 4, [key: Internal.Item]: 3, [key: any]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: any]: 9, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: any]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: any]: 4, [key: Internal.Item]: 5, [key: any]: 9, [key: any]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: any]: 9, [key: any]: 3, [key: any]: 8, [key: any]: 8, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 5, [key: any]: 2, [key: any]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 2, [key: any]: 2, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 4, [key: Internal.Item]: 3, [key: any]: 5, [key: Internal.Item]: 2, [key: Internal.Item]: 6, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 4, [key: any]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: any]: 1, [key: any]: 2, [key: any]: 2, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: any]: 9, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 6, [key: any]: 4, [key: Internal.Item]: 3, [key: Internal.Item]: 4, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 3, [key: Internal.Item]: 5, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: any]: 1, [key: any]: 9, [key: any]: 4, [key: any]: 1, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: any]: 5, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 1, [key: any]: 4, [key: Internal.Item]: 1, [key: Internal.BlockItem]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 4, [key: Internal.Item]: 5, [key: any]: 9, [key: any]: 4, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 9, [key: Internal.Item]: 5, [key: any]: 9, [key: any]: 4, [key: Internal.Item]: 1, [key: any]: 4, [key: Internal.Item]: 3, [key: any]: 8, [key: Internal.ItemNameBlockItem]: 2, [key: Internal.Item]: 6, [key: Internal.Item]: 5, [key: Internal.Item]: 2, [key: any]: 4, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 5, [key: Internal.ItemNameBlockItem]: 1, [key: any]: 1, [key: any]: 2, [key: Internal.Item]: 3, [key: any]: 9, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 4, [key: Internal.Item]: 2, [key: any]: 4, [key: any]: 8, [key: Internal.Item]: 4, [key: any]: 3, [key: any]: 9, [key: Internal.ItemNameBlockItem]: 1, [key: any]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.BlockItem]: 2, [key: any]: 5, [key: Internal.Item]: 4, [key: Internal.Item]: 5, [key: Internal.Item]: 2, [key: any]: 2, [key: Internal.ChorusFruitItem]: 2, [key: any]: 8, [key: any]: 8, [key: Internal.Item]: 4, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 6, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: any]: 4, [key: Internal.Item]: 5, [key: any]: 9, [key: Internal.Item]: 3, [key: Internal.Item]: 6, [key: Internal.Item]: 1, [key: any]: 4, [key: any]: 8, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 4, [key: any]: 3, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: any]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 5, [key: Internal.Item]: 1, [key: any]: 5, [key: Internal.Item]: 1, [key: Internal.Item]: 6, [key: Internal.Item]: 7, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 4, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: any]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 7, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 3, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: any]: 1, [key: any]: 9, [key: Internal.Item]: 1, [key: any]: 1, [key: any]: 9, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: any]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: Internal.Item]: 1, [key: any]: 9, [key: Internal.SuspiciousStewItem]: 4, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: any]: 4, [key: any]: 1, [key: Internal.Item]: 2, [key: Internal.BlockItem]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 5, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: any]: 8, [key: Internal.Item]: 1, [key: any]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: any]: 8, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: any]: 1, [key: Internal.Item]: 1, [key: any]: 9, [key: Internal.Item]: 4, [key: Internal.Item]: 4, [key: any]: 2, [key: Internal.Item]: 5, [key: any]: 1, [key: any]: 8, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 1, [key: any]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 4, [key: any]: 8, [key: Internal.Item]: 3, [key: Internal.Item]: 4, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 1, [key: Internal.Item]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 5, [key: Internal.Item]: 2, [key: Internal.Item]: 4, [key: Internal.Item]: 2, [key: Internal.Item]: 2, [key: Internal.Item]: 4, [key: Internal.Item]: 1, [key: Internal.Item]: 3, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 9, [key: any]: 2, [key: Internal.Item]: 2, [key: any]: 4, [key: Internal.Item]: 2, [key: Internal.Item]: 1, [key: any]: 8, [key: Internal.Item]: 1, [key: any]: 1, [key: any]: 4, [key: any]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 1, [key: Internal.Item]: 1, [key: any]: 6, [key: Internal.Item]: 1, [key: any]: 1, [key: any]: 6, [key: Internal.Item]: 1};
        static readonly SPEED_MODIFIER: 0.5;
        static readonly BREEDING_FOOD_THRESHOLD: 12;
        static MEMORY_TYPES: [Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>];
        static readonly POI_MEMORIES: {[key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any};
    }
    type Villager_ = Villager;
    interface Float2IntFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Float2ShortFunction;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2IntFunction;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Float2ByteFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2IntFunction;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Float2LongFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Float2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Float2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Float2DoubleFunction;
        apply(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2IntFunction<T>;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2IntFunction<T>;
        size(): number;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2IntFunction;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2IntFunction;
        clear(): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        get(arg0: number): number;
        remove(arg0: number): number;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Float2IntFunction_ = Float2IntFunction;
    interface BlockEntityTypeAccessor {
        getBlocks(): Internal.Set<Internal.Block>;
        get blocks(): Internal.Set<Internal.Block>
    }
    type BlockEntityTypeAccessor_ = BlockEntityTypeAccessor;
    class TemptingSensor extends Internal.Sensor<Internal.PathfinderMob> {
        constructor($$0: Internal.Ingredient_)
        static readonly TEMPTATION_RANGE: 10;
    }
    type TemptingSensor_ = TemptingSensor;
    interface Animatable <T extends Internal.Animatable<T>> {
        interpolate(arg0: T, arg1: number): T;
    }
    type Animatable_<T extends Internal.Animatable<T>> = Animatable<T>;
    abstract class AbstractSimiWidget extends Internal.AbstractWidget implements Internal.TickableGuiEventListener {
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        withCallback<T extends Internal.AbstractSimiWidget>(cb: Internal.BiConsumer_<number, number>): T;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        runCallback(mouseX: number, mouseY: number): void;
        moveTo(x: number, y: number): void;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        method_48579(graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, partialTicks: number): void;
        getToolTip(): Internal.List<Internal.Component>;
        mouseMoved($$0: number, $$1: number): void;
        tooltip(tooltip: Internal.Collection_<Internal.Component>): io.wispforest.owo.ui.core.Component;
        atZLevel<T extends Internal.AbstractSimiWidget>(z: number): T;
        setPosition($$0: number, $$1: number): void;
        method_47399(pNarrationElementOutput: Internal.NarrationElementOutput_): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        tick(): void;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        withCallback<T extends Internal.AbstractSimiWidget>(cb: Internal.Runnable_): T;
        root(): Internal.ParentComponent;
        tooltip(tooltip: Internal.Component_): io.wispforest.owo.ui.core.Component;
        get toolTip(): Internal.List<Internal.Component>
        get currentFocusPath(): Internal.ComponentPath
        lockedTooltipY: number;
        lockedTooltipX: number;
        static readonly HINT_RGB: 9877472;
        static readonly HEADER_RGB: 5476833;
    }
    type AbstractSimiWidget_ = AbstractSimiWidget;
    interface ThreadFactory {
        newThread(arg0: Internal.Runnable_): Internal.Thread;
    }
    type ThreadFactory_ = ThreadFactory;
    interface SinglePoolElementAccessor {
        callGetTemplate(arg0: Internal.StructureTemplateManager_): Internal.StructureTemplate;
        repurposedstructures_getTemplate(): Internal.Either<ResourceLocation, Internal.StructureTemplate>;
        repurposedstructures_getProcessors(): Internal.Holder<Internal.StructureProcessorList>;
    }
    type SinglePoolElementAccessor_ = SinglePoolElementAccessor;
    interface DSL$TypeReference {
        "in"(arg0: Internal.Schema_): Internal.TypeTemplate;
        typeName(): string;
    }
    type DSL$TypeReference_ = DSL$TypeReference;
    class CandleCakeBlock extends Internal.AbstractCandleBlock {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static byCandle($$0: Internal.Block_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight($$0: Internal.BlockState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIT: Internal.BooleanProperty;
    }
    type CandleCakeBlock_ = CandleCakeBlock;
    interface CoordinateConsumer {
        consume(arg0: number, arg1: number, arg2: number): void;
        (arg0: number, arg1: number, arg2: number): void;
    }
    type CoordinateConsumer_ = CoordinateConsumer;
    interface SleepingBlockEntity {
        startSleeping(): boolean;
        getSleepingTicker(): Internal.TickingBlockEntity;
        wakeUpNow(): void;
        isSleeping(): boolean;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        setTickWrapper(arg0: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        setSleepingTicker(arg0: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        sleepOnlyCurrentTick(): void;
        get sleepingTicker(): Internal.TickingBlockEntity
        get sleeping(): boolean
        set ticker(delegate: Internal.TickingBlockEntity_)
        set tickWrapper(arg0: Internal.WrappedBlockEntityTickInvokerAccessor_)
        set sleepingTicker(arg0: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        readonly SLEEPING_BLOCK_ENTITY_TICKER: Internal.TickingBlockEntity;
    }
    type SleepingBlockEntity_ = SleepingBlockEntity;
    interface DescriptionContext {
        typeName(type: typeof any): string;
        javaType(type: typeof any): Internal.TypeDescJS;
        readonly DEFAULT: Internal.DescriptionContext;
        readonly DISPLAY: Internal.DescriptionContext;
    }
    type DescriptionContext_ = DescriptionContext;
    class PlayerSocialManager {
        constructor($$0: Internal.Minecraft_, $$1: Internal.UserApiService_)
        isBlocked($$0: Internal.UUID_): boolean;
        isHidden($$0: Internal.UUID_): boolean;
        shouldHideMessageFrom($$0: Internal.UUID_): boolean;
        getDiscoveredUUID($$0: string): Internal.UUID;
        handler$lka000$supplementaries$addPlayer(info: Internal.PlayerInfo_, ci: Internal.CallbackInfo_): void;
        hidePlayer($$0: Internal.UUID_): void;
        getHiddenPlayers(): Internal.Set<Internal.UUID>;
        addPlayer($$0: Internal.PlayerInfo_): void;
        startOnlineMode(): void;
        removePlayer($$0: Internal.UUID_): void;
        handler$lka000$supplementaries$removePlayer(id: Internal.UUID_, ci: Internal.CallbackInfo_): void;
        stopOnlineMode(): void;
        showPlayer($$0: Internal.UUID_): void;
        get hiddenPlayers(): Internal.Set<Internal.UUID>
    }
    type PlayerSocialManager_ = PlayerSocialManager;
    /**
     * Invoked when a network packet is received.
     * 
     * Note that the behaviour of this event is depending on the **script type**.
     * 
     * In `server_scripts`, this event is invoked on the server side when a packet is received from a client.
     * 
     * In `client_scripts`, this event is invoked on the client side when a packet is received from the server.
    */
    class NetworkEventJS extends Internal.PlayerEventJS {
        constructor(p: Internal.Player_, c: string, d: Internal.CompoundTag_)
        /**
         * The channel of the packet.
        */
        getChannel(): string;
        /**
         * The data of the packet.
        */
        getData(): Internal.CompoundTag;
        /**
         * The channel of the packet.
        */
        get channel(): string
        /**
         * The data of the packet.
        */
        get data(): Internal.CompoundTag
    }
    type NetworkEventJS_ = NetworkEventJS;
    interface IDropDownContainer {
        onDropdownOpen(arg0: Internal.DropDownWidget_): void;
        onDropdownClosed(arg0: Internal.DropDownWidget_): void;
    }
    type IDropDownContainer_ = IDropDownContainer;
    interface BeeEntityAccessor {
        setTicksUntilCanPollinate(arg0: number): void;
        invokeSetHasNectar(arg0: boolean): void;
        getTicksUntilCanPollinate(): number;
        set ticksUntilCanPollinate(arg0: number)
        get ticksUntilCanPollinate(): number
    }
    type BeeEntityAccessor_ = BeeEntityAccessor;
    class CommandBuildContext$MissingTagAccessPolicy extends Internal.Enum<Internal.CommandBuildContext$MissingTagAccessPolicy> {
        static valueOf($$0: string): Internal.CommandBuildContext$MissingTagAccessPolicy;
        static values(): Internal.CommandBuildContext$MissingTagAccessPolicy[];
        static readonly CREATE_NEW: Internal.CommandBuildContext$MissingTagAccessPolicy;
        static readonly FAIL: Internal.CommandBuildContext$MissingTagAccessPolicy;
    }
    type CommandBuildContext$MissingTagAccessPolicy_ = CommandBuildContext$MissingTagAccessPolicy | "create_new" | "fail";
    class MapCodec$MapCodecCodec <A> implements Internal.Codec<A> {
        constructor(arg0: Internal.MapCodec_<A>)
        optionalFieldOf(arg0: string, arg1: A): Internal.MapCodec<A>;
        static empty<A>(): Internal.MapEncoder<A>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<A>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.Encoder<B>;
        simple(): Internal.Decoder$Simple<A>;
        stable(): Internal.Codec<A>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        fieldOf(arg0: string): Internal.MapEncoder<any>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        dispatch<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<A>>, arg2: Internal.Function_<A, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Encoder<any>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.Encoder<B>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<A>): Internal.Codec<A>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: A): Internal.Codec<A>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<A>>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        dispatchStable<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: A, arg3: Internal.Lifecycle_): Internal.MapCodec<A>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<A>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        orElseGet(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        map<B>(arg0: Internal.Function_<A, B>): Internal.Decoder<B>;
        orElse(arg0: A): Internal.Codec<A>;
        deprecated(arg0: number): Internal.Codec<A>;
        codec(): Internal.MapCodec<A>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        dispatchMap<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        flatMap<B>(arg0: Internal.Function_<A, Internal.DataResult<B>>): Internal.Decoder<B>;
        boxed(): Internal.Decoder$Boxed<A>;
        promotePartial(arg0: Internal.Consumer_<any>): Internal.Decoder<any>;
        xmap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        comapFlatMap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<A>): Internal.Codec<A>;
        optionalFieldOf(arg0: string, arg1: A, arg2: Internal.Lifecycle_): Internal.MapCodec<A>;
        terminal(): Internal.Decoder$Terminal<A>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        orElse(arg0: Internal.Consumer_<string>, arg1: A): Internal.Codec<A>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        listOf(): Internal.Codec<Internal.List<A>>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: A): Internal.DataResult<T>;
        flatXmap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        flatComapMap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        mapResult(arg0: Internal.Codec$ResultFunction_<A>): Internal.Codec<A>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
        encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
    }
    type MapCodec$MapCodecCodec_<A> = Special.BiomeSource | Special.ChunkGenerator | Special.Sdf | Special.BiomeCodec | Special.MaterialCondition | Special.MaterialRule | MapCodec$MapCodecCodec<A> | Special.DensityFunctionType;
    class SnowballItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        getLightColor(arg0: Internal.Player_, arg1: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SnowballItem_ = SnowballItem;
    class ServerScoreboard$Method extends Internal.Enum<Internal.ServerScoreboard$Method> {
        static valueOf($$0: string): Internal.ServerScoreboard$Method;
        static values(): Internal.ServerScoreboard$Method[];
        static readonly REMOVE: Internal.ServerScoreboard$Method;
        static readonly CHANGE: Internal.ServerScoreboard$Method;
    }
    type ServerScoreboard$Method_ = "remove" | "change" | ServerScoreboard$Method;
    interface CriterionTriggerInstance {
        serializeToJson(arg0: Internal.SerializationContext_): Internal.JsonObject;
        getCriterion(): ResourceLocation;
        get criterion(): ResourceLocation
    }
    type CriterionTriggerInstance_ = CriterionTriggerInstance;
    class Fox$Type extends Internal.Enum<Internal.Fox$Type> implements Internal.StringRepresentable {
        static byId($$0: number): Internal.Fox$Type;
        static byName($$0: string): Internal.Fox$Type;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static byBiome($$0: Internal.Holder_<Internal.Biome>): Internal.Fox$Type;
        static values(): Internal.Fox$Type[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Fox$Type;
        getId(): number;
        get serializedName(): string
        get id(): number
        static readonly RED: Internal.Fox$Type;
        static readonly SNOW: Internal.Fox$Type;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Fox$Type>;
    }
    type Fox$Type_ = "snow" | Fox$Type | "red";
    interface FloatPredicate extends Internal.DoublePredicate, Internal.Predicate<number> {
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        /**
         * @deprecated
        */
        or(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        and(arg0: Internal.DoublePredicate_): Internal.DoublePredicate;
        /**
         * @deprecated
        */
        and(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        and(arg0: Internal.FloatPredicate_): this;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        /**
         * @deprecated
        */
        test(arg0: any): boolean;
        or(arg0: Internal.DoublePredicate_): this;
        test(arg0: number): boolean;
        or(arg0: Internal.FloatPredicate_): this;
        negate(): Internal.DoublePredicate;
        (arg0: number): boolean;
    }
    type FloatPredicate_ = FloatPredicate;
    interface BlockExtensions {
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
    }
    type BlockExtensions_ = BlockExtensions;
    interface ItemCaller {
        cardinal_createComponents(arg0: Internal.ItemStack_): Internal.ComponentContainer;
    }
    type ItemCaller_ = ItemCaller;
    interface RecipeManager$CachedCheck <C extends Internal.Container, T extends Internal.Recipe<C>> {
        getRecipeFor(arg0: C, arg1: Internal.Level_): Internal.Optional<T>;
    }
    type RecipeManager$CachedCheck_<C extends Internal.Container, T extends Internal.Recipe<C>> = RecipeManager$CachedCheck<C, T>;
    class DownloadedPackSource implements Internal.RepositorySource {
        constructor($$0: Internal.File_)
        loadPacks($$0: Internal.Consumer_<Internal.Pack>): void;
        handler$djm000$chat_heads$chatheads$checkForDisableResource(file: Internal.File_, packSource: Internal.PackSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        loadBundledResourcePack($$0: Internal.LevelStorageSource$LevelStorageAccess_): Internal.CompletableFuture<void>;
        clearServerPack(): Internal.CompletableFuture<void>;
        downloadAndSelectResourcePack($$0: Internal.URL_, $$1: string, $$2: boolean): Internal.CompletableFuture<any>;
        setServerPack($$0: Internal.File_, $$1: Internal.PackSource_): Internal.CompletableFuture<void>;
    }
    type DownloadedPackSource_ = DownloadedPackSource;
    class CompostableRecipesEventJS extends Internal.EventJS {
        constructor()
        removeAll(): void;
        add(ingredient: Internal.Ingredient_, f: number): void;
        remove(ingredient: Internal.Ingredient_): void;
        static originalMap: Internal.Object2FloatMap<Internal.ItemLike>;
    }
    type CompostableRecipesEventJS_ = CompostableRecipesEventJS;
    class ModuleDescriptor$Exports implements Internal.Comparable<Internal.ModuleDescriptor$Exports> {
        isQualified(): boolean;
        targets(): Internal.Set<string>;
        source(): string;
        compareTo(arg0: Internal.ModuleDescriptor$Exports_): number;
        modifiers(): Internal.Set<Internal.ModuleDescriptor$Exports$Modifier>;
        compareTo(arg0: any): number;
        get qualified(): boolean
    }
    type ModuleDescriptor$Exports_ = ModuleDescriptor$Exports;
    class BowItem extends Internal.ProjectileWeaponItem implements Internal.Vanishable {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        static getPowerForTime($$0: number): number;
        getLightColor(arg0: Internal.Player_, arg1: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        handler$dlg002$collective$use(level: Internal.Level_, player: Internal.Player_, interactionHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        localvar$jlj000$puzzleslib$releaseUsing(charge: number): number;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        localvar$zzo000$porting_lib_base$customArrowTest(oldArrow: Internal.AbstractArrow_): Internal.AbstractArrow;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        handler$jlj000$puzzleslib$releaseUsing(stack: Internal.ItemStack_, level: Internal.Level_, livingEntity: Internal.LivingEntity_, timeCharged: number, callback: Internal.CallbackInfo_, player: Internal.Player_, hasInfiniteAmmo: boolean, projectileStack: Internal.ItemStack_): void;
        handler$lgl000$supplementaries$getAllSupportedProjectiles(cir: Internal.CallbackInfoReturnable_<any>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly MAX_DRAW_DURATION: 20;
        static readonly DEFAULT_RANGE: 15;
    }
    type BowItem_ = BowItem;
    interface EquipmentEntity {
        lithiumOnEquipmentChanged(): void;
    }
    type EquipmentEntity_ = EquipmentEntity;
    interface EntityMovementTrackerSection {
        addListener(arg0: Internal.SectionedEntityMovementTracker_<any, any>): void;
        removeListenToMovementOnce<S, E extends Internal.EntityAccess>(arg0: Internal.SectionedEntityMovementTracker_<E, S>, arg1: number): void;
        removeListener(arg0: Internal.EntitySectionStorage_<any>, arg1: Internal.SectionedEntityMovementTracker_<any, any>): void;
        trackEntityMovement(arg0: number, arg1: number): void;
        listenToMovementOnce<S, E extends Internal.EntityAccess>(arg0: Internal.SectionedEntityMovementTracker_<E, S>, arg1: number): void;
        getChangeTime(arg0: number): number;
    }
    type EntityMovementTrackerSection_ = EntityMovementTrackerSection;
    class UnitContext {
        constructor()
        pushDebug(): void;
        debugInfo(s: string, values: Internal.Collection_<any>): void;
        sub(): this;
        addConstant(s: string, u: Internal.Unit_): void;
        popDebug(): void;
        parse(input: string): Internal.Unit;
        getFunctionFactory(name: string): Internal.FunctionFactory;
        createStream(input: string): Internal.UnitTokenStream;
        debugInfo(s: string): void;
        addFunction(factory: Internal.FunctionFactory_): void;
        isDebug(): boolean;
        get debug(): boolean
        static readonly DEFAULT: Internal.UnitContext;
        readonly constants: Internal.Map<string, Internal.Unit>;
    }
    type UnitContext_ = UnitContext;
    class SceneBuilder implements Internal.SceneBuilderAccessor {
        constructor(ponderScene: Internal.PonderScene_)
        configureBasePlate(xOffset: number, zOffset: number, basePlateSize: number): void;
        addInstruction(callback: Internal.Consumer_<Internal.PonderScene>): void;
        setSceneOffsetY(yOffset: number): void;
        idleSeconds(seconds: number): void;
        title(sceneId: string, title: string): void;
        ponderjs$setSpecialInstructions(arg0: Internal.SceneBuilder$SpecialInstructions_): void;
        ponderjs$setWorldInstructions(arg0: Internal.SceneBuilder$WorldInstructions_): void;
        removeShadow(): void;
        addInstruction(instruction: Internal.PonderInstruction_): void;
        scaleSceneView(factor: number): void;
        markAsFinished(): void;
        idle(ticks: number): void;
        rotateCameraY(degrees: number): void;
        showBasePlate(): void;
        addKeyframe(): void;
        addLazyKeyframe(): void;
        ponderjs$getPonderScene(): Internal.PonderScene;
        set sceneOffsetY(yOffset: number)
        readonly overlay: Internal.SceneBuilder$OverlayInstructions;
        world: Internal.SceneBuilder$WorldInstructions;
        readonly debug: Internal.SceneBuilder$DebugInstructions;
        readonly effects: Internal.SceneBuilder$EffectInstructions;
        special: Internal.SceneBuilder$SpecialInstructions;
    }
    type SceneBuilder_ = SceneBuilder;
    class Llama extends Internal.AbstractChestedHorse implements Internal.RangedAttackMob, Internal.VariantHolder<Internal.Llama$Variant> {
        constructor($$0: Internal.EntityType_<Internal.Llama>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        isTraderLlama(): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        setVariant($$0: Internal.Llama$Variant_): void;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getJumpCooldown(): number;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        getCaravanHead(): this;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        getStrength(): number;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        leaveCaravan(): void;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        inCaravan(): boolean;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getVariant(): Internal.Llama$Variant;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        getSwag(): Internal.DyeColor;
        performRangedAttack($$0: Internal.LivingEntity_, $$1: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        joinCaravan($$0: Internal.Llama_): void;
        hasCaravanTail(): boolean;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get traderLlama(): boolean
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        set variant($$0: Internal.Llama$Variant_)
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get jumpCooldown(): number
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        get caravanHead(): Internal.Llama
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get strength(): number
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        get variant(): Internal.Llama$Variant
        set motionX(x: number)
        get swag(): Internal.DyeColor
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
    }
    type Llama_ = Llama;
    class JigsawBlock extends Internal.Block implements Internal.GameMasterBlock, Internal.EntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        newBlockEntity($$0: BlockPos_, $$1: Internal.BlockState_): Internal.BlockEntity;
        static canAttach($$0: Internal.StructureTemplate$StructureBlockInfo_, $$1: Internal.StructureTemplate$StructureBlockInfo_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static getTopFacing($$0: Internal.BlockState_): Internal.Direction;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        static getFrontFacing($$0: Internal.BlockState_): Internal.Direction;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    }
    type JigsawBlock_ = JigsawBlock;
    interface SPC_ShapedRecipe_Invoker {
        invokeGetPattern(json: Internal.JsonArray_): string[];
        invokeReadSymbols(json: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        invokeRemovePadding(...pattern: string[]): string[];
        invokeCreatePatternMatrix(pattern: string[], symbols: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
    }
    type SPC_ShapedRecipe_Invoker_ = SPC_ShapedRecipe_Invoker;
    interface TransformStack extends Internal.TStack<Internal.TransformStack>, Internal.Transform<Internal.TransformStack> {
        translateBack(vec: Vec3i_): this;
        cast(stack: Internal.PoseStack_): this;
        translate(vec: Vec3i_): this;
        multiply(axis: Vec3f_, angle: number): this;
        multiplyRadians(axis: Internal.Axis_, angle: number): this;
        rotateCentered(q: Quaternionf_): this;
        rotateZRadians(angle: number): this;
        translateAll(v: number): this;
        mulPose(arg0: Matrix4f_): this;
        popPose(): this;
        translateBack(vec: Vec3d_): this;
        nudge(seed: number): this;
        translate(arg0: number, arg1: number, arg2: number): this;
        scale(factor: number): this;
        transform(stack: Internal.PoseStack_): this;
        multiply(axis: Internal.Axis_, angle: number): this;
        rotate(axis: Internal.Direction_, radians: number): this;
        scale(arg0: number, arg1: number, arg2: number): this;
        pushPose(): this;
        transform(pose: Matrix4f_, normal: Matrix3f_): this;
        unCentre(): this;
        rotateYRadians(angle: number): this;
        mulNormal(arg0: Matrix3f_): this;
        rotateX(angle: number): this;
        multiplyRadians(axis: Vec3f_, angle: number): this;
        rotateY(angle: number): this;
        translateX(x: number): this;
        multiply(arg0: Quaternionf_): this;
        translateZ(z: number): this;
        translateY(y: number): this;
        rotateCentered(axis: Internal.Direction_, radians: number): this;
        translate(vec: Vec3f_): this;
        rotateZ(angle: number): this;
        centre(): this;
        rotateToFace(facing: Internal.Direction_): this;
        rotate(angle: number, axis: Internal.Direction$Axis_): this;
        rotateXRadians(angle: number): this;
        translate(vec: Vec3d_): this;
        translateBack(x: number, y: number, z: number): this;
    }
    type TransformStack_ = TransformStack;
    class AtomicBoolean implements Internal.Serializable {
        constructor()
        constructor(arg0: boolean)
        weakCompareAndSetPlain(arg0: boolean, arg1: boolean): boolean;
        set(arg0: boolean): void;
        setPlain(arg0: boolean): void;
        getAcquire(): boolean;
        weakCompareAndSetAcquire(arg0: boolean, arg1: boolean): boolean;
        weakCompareAndSetRelease(arg0: boolean, arg1: boolean): boolean;
        get(): boolean;
        getAndSet(arg0: boolean): boolean;
        weakCompareAndSetVolatile(arg0: boolean, arg1: boolean): boolean;
        getPlain(): boolean;
        setRelease(arg0: boolean): void;
        compareAndExchange(arg0: boolean, arg1: boolean): boolean;
        lazySet(arg0: boolean): void;
        /**
         * @deprecated
        */
        weakCompareAndSet(arg0: boolean, arg1: boolean): boolean;
        compareAndSet(arg0: boolean, arg1: boolean): boolean;
        compareAndExchangeAcquire(arg0: boolean, arg1: boolean): boolean;
        compareAndExchangeRelease(arg0: boolean, arg1: boolean): boolean;
        getOpaque(): boolean;
        setOpaque(arg0: boolean): void;
        set plain(arg0: boolean)
        get acquire(): boolean
        get plain(): boolean
        set release(arg0: boolean)
        get opaque(): boolean
        set opaque(arg0: boolean)
    }
    type AtomicBoolean_ = AtomicBoolean;
    class ScreenRectangle extends Internal.Record {
        constructor($$0: Internal.ScreenPosition_, $$1: number, $$2: number)
        constructor($$0: number, $$1: number, $$2: number, $$3: number)
        getCenterInAxis($$0: Internal.ScreenAxis_): number;
        bottom(): number;
        position(): Internal.ScreenPosition;
        height(): number;
        static empty(): Internal.ScreenRectangle;
        step($$0: Internal.ScreenDirection_): this;
        static of($$0: Internal.ScreenAxis_, $$1: number, $$2: number, $$3: number, $$4: number): Internal.ScreenRectangle;
        overlapsInAxis($$0: Internal.ScreenRectangle_, $$1: Internal.ScreenAxis_): boolean;
        getBoundInDirection($$0: Internal.ScreenDirection_): number;
        intersection($$0: Internal.ScreenRectangle_): this;
        getBorder($$0: Internal.ScreenDirection_): this;
        width(): number;
        top(): number;
        right(): number;
        overlaps($$0: Internal.ScreenRectangle_): boolean;
        getLength($$0: Internal.ScreenAxis_): number;
        left(): number;
    }
    type ScreenRectangle_ = ScreenRectangle;
    interface TickingBlockEntity {
        getPos(): BlockPos;
        isRemoved(): boolean;
        getType(): string;
        tick(): void;
        get pos(): BlockPos
        get removed(): boolean
        get type(): string
    }
    type TickingBlockEntity_ = TickingBlockEntity;
    class DirectoryValidator {
        constructor($$0: any_)
        validateSymlink($$0: Internal.Path_, $$1: Internal.List_<Internal.ForbiddenSymlinkInfo>): void;
        validateSave($$0: Internal.Path_, $$1: boolean): Internal.List<Internal.ForbiddenSymlinkInfo>;
    }
    type DirectoryValidator_ = DirectoryValidator;
    interface BlockEntityInterface {
        setCMPos(arg0: BlockPos_): void;
        set CMPos(arg0: BlockPos_)
    }
    type BlockEntityInterface_ = BlockEntityInterface;
    class MaterialData extends Internal.Record {
        constructor(color: number, emissive: boolean, ambientOcclusion: boolean, blendMode: ResourceLocation_)
        emissive(): boolean;
        ambientOcclusion(): boolean;
        color(): number;
        blendMode(): ResourceLocation;
        static readonly DEFAULT: Internal.MaterialData;
        static readonly COLOR: Internal.Codec<number>;
        static readonly CODEC: Internal.Codec<Internal.MaterialData>;
    }
    type MaterialData_ = MaterialData;
    abstract class GuiSettings extends Internal.ScreenBase {
        constructor(title: Internal.Component_, backScreen: Internal.Screen_, escScreen: Internal.Screen_)
        isFocused(): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        setFocused($$0: boolean): void;
        getTabOrderGroup(): number;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        restoreFocus(index: number): void;
        getEntriesCopy(): any[];
        getIndex(child: Internal.GuiEventListener_): number;
        getCurrentFocusPath(): Internal.ComponentPath;
        method_25426(): void;
        redirect$mik000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        static getExtensions(screen: Internal.Screen_): Internal.ScreenExtensions;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        mouseMoved($$0: number, $$1: number): void;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        get focused(): boolean
        set focused($$0: boolean)
        get tabOrderGroup(): number
        get entriesCopy(): any[]
        get currentFocusPath(): Internal.ComponentPath
    }
    type GuiSettings_ = GuiSettings;
    class DisplayInfo {
        constructor($$0: Internal.ItemStack_, $$1: Internal.Component_, $$2: Internal.Component_, $$3: ResourceLocation_, $$4: Internal.FrameType_, $$5: boolean, $$6: boolean, $$7: boolean)
        setLocation($$0: number, $$1: number): void;
        serializeToJson(): Internal.JsonElement;
        getX(): number;
        getY(): number;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.DisplayInfo;
        isHidden(): boolean;
        getIcon(): Internal.ItemStack;
        shouldShowToast(): boolean;
        handler$zhb000$advancementinfo$isHiddenOverride(cir: Internal.CallbackInfoReturnable_<any>): void;
        getBackground(): ResourceLocation;
        getFrame(): Internal.FrameType;
        getTitle(): Internal.Component;
        static fromJson($$0: Internal.JsonObject_): Internal.DisplayInfo;
        shouldAnnounceChat(): boolean;
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        getDescription(): Internal.Component;
        get x(): number
        get y(): number
        get hidden(): boolean
        get icon(): Internal.ItemStack
        get background(): ResourceLocation
        get frame(): Internal.FrameType
        get title(): Internal.Component
        get description(): Internal.Component
    }
    type DisplayInfo_ = DisplayInfo;
    interface Pointer {
        address(): number;
        readonly CLONG_SIZE: 4;
        readonly POINTER_SHIFT: 3;
        readonly CLONG_SHIFT: 2;
        readonly BITS64: true;
        readonly BITS32: false;
        readonly POINTER_SIZE: 8;
    }
    type Pointer_ = Pointer;
    interface MobEffectRenderer {
        isVisibleInGui(instance: Internal.MobEffectInstance_): boolean;
        renderInventoryIcon(instance: Internal.MobEffectInstance_, screen: Internal.EffectRenderingInventoryScreen_<any>, guiGraphics: Internal.GuiGraphics_, x: number, y: number, blitOffset: number): boolean;
        renderGuiIcon(instance: Internal.MobEffectInstance_, gui: Internal.Gui_, guiGraphics: Internal.GuiGraphics_, x: number, y: number, z: number, alpha: number): boolean;
        renderInventoryText(instance: Internal.MobEffectInstance_, screen: Internal.EffectRenderingInventoryScreen_<any>, guiGraphics: Internal.GuiGraphics_, x: number, y: number, blitOffset: number): boolean;
        isVisibleInInventory(instance: Internal.MobEffectInstance_): boolean;
        readonly DEFAULT: Internal.MobEffectRenderer;
    }
    type MobEffectRenderer_ = MobEffectRenderer;
    class OctahedralGroup extends Internal.Enum<Internal.OctahedralGroup> implements Internal.StringRepresentable {
        transformation(): Matrix3f;
        static valueOf($$0: string): Internal.OctahedralGroup;
        inverse(): this;
        rotate($$0: Internal.Direction_): Internal.Direction;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        inverts($$0: Internal.Direction$Axis_): boolean;
        getSerializedName(): string;
        static values(): Internal.OctahedralGroup[];
        rotate($$0: Internal.FrontAndTop_): Internal.FrontAndTop;
        compose($$0: Internal.OctahedralGroup_): this;
        get serializedName(): string
        static readonly ROT_180_EDGE_XY_NEG: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_YZ_POS: Internal.OctahedralGroup;
        static readonly SWAP_XZ: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Y_NEG: Internal.OctahedralGroup;
        static readonly INVERT_Z: Internal.OctahedralGroup;
        static readonly SWAP_YZ: Internal.OctahedralGroup;
        static readonly INVERT_X: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XY_POS: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_YZ_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Z_POS: Internal.OctahedralGroup;
        static readonly SWAP_NEG_YZ: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_XY: Internal.OctahedralGroup;
        static readonly SWAP_NEG_XZ: Internal.OctahedralGroup;
        static readonly ROT_90_Z_NEG: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PNN: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PPP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PNP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NNP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NNN: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NPP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PPN: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Y_POS: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NPN: Internal.OctahedralGroup;
        static readonly ROT_90_X_NEG: Internal.OctahedralGroup;
        static readonly ROT_120_PNP: Internal.OctahedralGroup;
        static readonly INVERT_Y: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XZ_POS: Internal.OctahedralGroup;
        static readonly SWAP_XY: Internal.OctahedralGroup;
        static readonly ROT_120_NPN: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Z_POS: Internal.OctahedralGroup;
        static readonly ROT_120_NNP: Internal.OctahedralGroup;
        static readonly ROT_90_REF_X_POS: Internal.OctahedralGroup;
        static readonly ROT_120_PPN: Internal.OctahedralGroup;
        static readonly ROT_120_NNN: Internal.OctahedralGroup;
        static readonly ROT_120_NPP: Internal.OctahedralGroup;
        static readonly ROT_90_X_POS: Internal.OctahedralGroup;
        static readonly ROT_120_PNN: Internal.OctahedralGroup;
        static readonly ROT_120_PPP: Internal.OctahedralGroup;
        static readonly ROT_90_REF_X_NEG: Internal.OctahedralGroup;
        static readonly IDENTITY: Internal.OctahedralGroup;
        static readonly SWAP_NEG_XY: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_YZ: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_XZ: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XZ_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Z_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Y_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Y_POS: Internal.OctahedralGroup;
        static readonly INVERSION: Internal.OctahedralGroup;
    }
    type OctahedralGroup_ = "inversion" | "rot_180_face_xz" | "invert_z" | "rot_180_edge_xy_pos" | "rot_120_pnp" | "rot_120_ppp" | "rot_120_nnn" | "rot_120_npn" | "rot_90_ref_z_neg" | "rot_180_edge_xz_pos" | "swap_xy" | "rot_90_x_neg" | "swap_neg_yz" | "identity" | "rot_90_z_neg" | "rot_90_ref_z_pos" | "rot_60_ref_ppn" | "rot_60_ref_npp" | "rot_60_ref_pnn" | "rot_60_ref_nnp" | "rot_180_edge_yz_pos" | "swap_yz" | "rot_90_y_pos" | "rot_90_ref_y_neg" | "rot_90_ref_y_pos" | "rot_90_x_pos" | "rot_180_face_yz" | "rot_180_edge_xy_neg" | "rot_120_nnp" | "rot_120_pnn" | "rot_120_npp" | "rot_120_ppn" | "swap_neg_xz" | "rot_90_ref_x_pos" | "invert_x" | OctahedralGroup | "rot_180_edge_xz_neg" | "rot_90_ref_x_neg" | "rot_180_face_xy" | "rot_90_z_pos" | "rot_60_ref_nnn" | "rot_60_ref_ppp" | "rot_90_y_neg" | "rot_180_edge_yz_neg" | "swap_xz" | "rot_60_ref_npn" | "invert_y" | "rot_60_ref_pnp" | "swap_neg_xy";
    class FloatTag extends Internal.NumericTag {
        getAsString(): string;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        copy(): this;
        getType(): Internal.TagType<Internal.FloatTag>;
        static valueOf($$0: number): Internal.FloatTag;
        get asString(): string
        get type(): Internal.TagType<Internal.FloatTag>
        static readonly TYPE: Internal.TagType<Internal.FloatTag>;
        static readonly ZERO: Internal.FloatTag;
    }
    type FloatTag_ = FloatTag;
    class Program {
        attachToShader($$0: Internal.Shader_): void;
        static compileShader($$0: Internal.Program$Type_, $$1: string, $$2: Internal.InputStream_, $$3: string, $$4: Internal.GlslPreprocessor_): Internal.Program;
        close(): void;
        getName(): string;
        get name(): string
    }
    type Program_ = Program;
    abstract class AbstractStringBuilder implements Internal.CharSequence, Internal.Appendable {
        reverse(): this;
        append(arg0: string): this;
        codePointAt(arg0: number): number;
        insert(arg0: number, arg1: string): this;
        append(arg0: number): this;
        append(arg0: boolean): this;
        append(arg0: number): this;
        lastIndexOf(arg0: string): number;
        insert(arg0: number, arg1: number): this;
        getChars(arg0: number, arg1: number, arg2: string[], arg3: number): void;
        indexOf(arg0: string): number;
        append(arg0: number): this;
        lastIndexOf(arg0: string, arg1: number): number;
        insert(arg0: number, arg1: boolean): this;
        charAt(arg0: number): string;
        length(): number;
        replace(arg0: number, arg1: number, arg2: string): this;
        trimToSize(): void;
        insert(arg0: number, arg1: number): this;
        append(arg0: string): this;
        "delete"(arg0: number, arg1: number): this;
        static compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        indexOf(arg0: string, arg1: number): number;
        chars(): Internal.IntStream;
        ensureCapacity(arg0: number): void;
        insert(arg0: number, arg1: Internal.CharSequence_): this;
        insert(arg0: number, arg1: string): this;
        insert(arg0: number, arg1: any): this;
        append(arg0: number): this;
        capacity(): number;
        append(arg0: string[]): this;
        codePointCount(arg0: number, arg1: number): number;
        substring(arg0: number): string;
        setCharAt(arg0: number, arg1: string): void;
        setLength(arg0: number): void;
        isEmpty(): boolean;
        codePointBefore(arg0: number): number;
        append(arg0: string[], arg1: number, arg2: number): this;
        deleteCharAt(arg0: number): this;
        append(arg0: Internal.StringBuffer_): this;
        subSequence(arg0: number, arg1: number): Internal.CharSequence;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        appendCodePoint(arg0: number): this;
        substring(arg0: number, arg1: number): string;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: Internal.CharSequence_, arg2: number, arg3: number): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        offsetByCodePoints(arg0: number, arg1: number): number;
        append(arg0: any): this;
        insert(arg0: number, arg1: string[]): this;
        append(arg0: Internal.CharSequence_): this;
        codePoints(): Internal.IntStream;
        set length(arg0: number)
        get empty(): boolean
    }
    type AbstractStringBuilder_ = AbstractStringBuilder;
    class StageChangeEvent {
        getPlayerStages(): Internal.Stages;
        getPlayer(): Internal.Player;
        getStage(): string;
        get playerStages(): Internal.Stages
        get player(): Internal.Player
        get stage(): string
    }
    type StageChangeEvent_ = StageChangeEvent;
    class WeakReference <T> extends Internal.Reference<T> {
        constructor(arg0: T)
        constructor(arg0: T, arg1: any_<T>)
    }
    type WeakReference_<T> = WeakReference<T>;
    class BlockTintProvider implements Internal.BlockAndTintGetter {
        constructor(biomeRegistry: Internal.Registry_<Internal.Biome>, calculator: Internal.BiomeColorCalculator_, mapProcessor: Internal.MapProcessor_, brokenBlockTintCache: any_)
        getBlockTint(blockPos: BlockPos_, colorResolver: Internal.ColorResolver_): number;
        getMinSection(): number;
        getBlockState(blockPos: BlockPos_): Internal.BlockState;
        getShade(direction: Internal.Direction_, bl: boolean): number;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        getHeight(): number;
        getBlockEntity(blockPos: BlockPos_): Internal.BlockEntity;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getFluidState(blockPos: BlockPos_): Internal.FluidState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        getBiomeColor(blockPos: BlockPos_, state: Internal.BlockState_, overlay: boolean, tile: Internal.MapTile_, caveLayer: number, tint: number): number;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
    }
    type BlockTintProvider_ = BlockTintProvider;
    interface ArgumentTypeInfo$Template <A extends Internal.ArgumentType<any>> {
        type(): Internal.ArgumentTypeInfo<A, any>;
        instantiate(arg0: Internal.CommandBuildContext_): A;
    }
    type ArgumentTypeInfo$Template_<A extends Internal.ArgumentType<any>> = ArgumentTypeInfo$Template<A>;
    interface SPC_ExtraRenderData {
        getRenderData(): any;
        setRenderData(arg0: any): void;
        get renderData(): any
        set renderData(arg0: any)
    }
    type SPC_ExtraRenderData_ = SPC_ExtraRenderData;
    class SwordItem extends Internal.TieredItem implements Internal.Vanishable, Internal.ModifiableItemKJS {
        constructor($$0: Internal.Tier_, $$1: number, $$2: number, $$3: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        setDigSpeed(speed: number): void;
        getLightColor(arg0: Internal.Player_, arg1: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDamage(): number;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get damage(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        defaultModifiers: Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    }
    type SwordItem_ = SwordItem;
    class UpgradeData {
        constructor($$0: Internal.CompoundTag_, $$1: Internal.LevelHeightAccessor_)
        upgrade($$0: Internal.LevelChunk_): void;
        write(): Internal.CompoundTag;
        isEmpty(): boolean;
        get empty(): boolean
        static readonly EMPTY: Internal.UpgradeData;
    }
    type UpgradeData_ = UpgradeData;
    interface BasicFileAttributes {
        isRegularFile(): boolean;
        creationTime(): Internal.FileTime;
        isSymbolicLink(): boolean;
        isOther(): boolean;
        fileKey(): any;
        isDirectory(): boolean;
        size(): number;
        lastModifiedTime(): Internal.FileTime;
        lastAccessTime(): Internal.FileTime;
        get regularFile(): boolean
        get symbolicLink(): boolean
        get other(): boolean
        get directory(): boolean
    }
    type BasicFileAttributes_ = BasicFileAttributes;
    class StructureMode extends Internal.Enum<Internal.StructureMode> implements Internal.StringRepresentable {
        static values(): Internal.StructureMode[];
        getDisplayName(): Internal.Component;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.StructureMode;
        get displayName(): Internal.Component
        get serializedName(): string
        static readonly SAVE: Internal.StructureMode;
        static readonly CORNER: Internal.StructureMode;
        static readonly LOAD: Internal.StructureMode;
        static readonly DATA: Internal.StructureMode;
    }
    type StructureMode_ = "load" | StructureMode | "save" | "data" | "corner";
    interface Channel$Unsafe {
        deregister(arg0: Internal.ChannelPromise_): void;
        localAddress(): Internal.SocketAddress;
        recvBufAllocHandle(): Internal.RecvByteBufAllocator$Handle;
        closeForcibly(): void;
        close(arg0: Internal.ChannelPromise_): void;
        beginRead(): void;
        outboundBuffer(): Internal.ChannelOutboundBuffer;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): void;
        flush(): void;
        bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): void;
        register(arg0: Internal.EventLoop_, arg1: Internal.ChannelPromise_): void;
        disconnect(arg0: Internal.ChannelPromise_): void;
        write(arg0: any, arg1: Internal.ChannelPromise_): void;
        remoteAddress(): Internal.SocketAddress;
        voidPromise(): Internal.ChannelPromise;
    }
    type Channel$Unsafe_ = Channel$Unsafe;
    class RemoveWorldgenEventJS extends Internal.StartupEventJS {
        constructor()
        printFiltered(): void;
        removeSpawns(p: Internal.Consumer_<Internal.RemoveSpawnsProperties>): void;
        removeAllFeatures(filter: Internal.BiomeFilter_): void;
        printSpawns(category: Internal.MobCategory_): void;
        removeAllFeatures(): void;
        printFeatures(type: Internal.GenerationStep$Decoration_): void;
        removeOres(p: Internal.Consumer_<Internal.RemoveOresProperties>): void;
        removeAllSpawns(): void;
        printSpawns(): void;
        removeFeatureById(filter: Internal.BiomeFilter_, decoration: Internal.GenerationStep$Decoration_, ids: ResourceLocation_[]): void;
        printFeatures(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_): void;
        printFeaturesForType(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_, afterRemoval: boolean): void;
        printFiltered(type: Internal.GenerationStep$Decoration_): void;
        removeAllFeatures(filter: Internal.BiomeFilter_, type: Internal.GenerationStep$Decoration_): void;
        removeFeatureById(type: Internal.GenerationStep$Decoration_, ids: ResourceLocation_[]): void;
        printFiltered(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_): void;
        printFeatures(): void;
    }
    type RemoveWorldgenEventJS_ = RemoveWorldgenEventJS;
    class HashBiMap <K, V> extends Internal.Maps$IteratorBasedAbstractMap<K, V> implements Internal.BiMap<K, V>, Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static create<K, V>(arg0: number): Internal.HashBiMap<K, V>;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        inverse(): Internal.BiMap<V, K>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        entrySet(): Internal.Set<any>;
        static create<K, V>(arg0: Internal.Map_<K, V>): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static create<K, V>(): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        values(): Internal.Set<V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        forcePut(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type HashBiMap_<K, V> = HashBiMap<K, V>;
    interface LootItemFunction extends Internal.LootContextUser, Internal.BiFunction<Internal.ItemStack, Internal.LootContext, Internal.ItemStack> {
        decorate($$0: Internal.BiFunction_<Internal.ItemStack, Internal.LootContext, Internal.ItemStack>, $$1: Internal.Consumer_<Internal.ItemStack>, $$2: Internal.LootContext_): Internal.Consumer<Internal.ItemStack>;
        andThen<V>(arg0: Internal.Function_<Internal.ItemStack, V>): Internal.BiFunction<Internal.ItemStack, Internal.LootContext, V>;
        apply(arg0: Internal.ItemStack_, arg1: Internal.LootContext_): Internal.ItemStack;
        getReferencedContextParams(): Internal.Set<Internal.LootContextParam<any>>;
        validate($$0: Internal.ValidationContext_): void;
        getType(): Internal.LootItemFunctionType;
        get referencedContextParams(): Internal.Set<Internal.LootContextParam<any>>
        get type(): Internal.LootItemFunctionType
    }
    type LootItemFunction_ = LootItemFunction;
    interface AccessorFontManager {
        bookshelf$getFonts(): Internal.Map<ResourceLocation, Internal.FontSet>;
    }
    type AccessorFontManager_ = AccessorFontManager;
    interface SignedMessageValidator {
        updateAndValidate(arg0: Internal.PlayerChatMessage_): boolean;
        (arg0: Internal.PlayerChatMessage_): boolean;
        readonly ACCEPT_UNSIGNED: Internal.SignedMessageValidator;
        readonly REJECT_ALL: Internal.SignedMessageValidator;
    }
    type SignedMessageValidator_ = SignedMessageValidator;
    interface RenderContext$QuadTransform {
        transform(arg0: Internal.MutableQuadView_): boolean;
        (arg0: Internal.MutableQuadView_): boolean;
    }
    type RenderContext$QuadTransform_ = RenderContext$QuadTransform;
    class CommandBlock extends Internal.BaseEntityBlock implements Internal.GameMasterBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: boolean)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly CONDITIONAL: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CommandBlock_ = CommandBlock;
    interface LivingEntityAccessor {
        callGetEquipmentChanges(): Internal.Map<Internal.EquipmentSlot, Internal.ItemStack>;
        callSetSyncedArmorStack(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): void;
        callSetSyncedHandStack(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): void;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
    class ClientboundContainerSetDataPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number, $$2: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getValue(): number;
        getContainerId(): number;
        isSkippable(): boolean;
        getId(): number;
        get value(): number
        get containerId(): number
        get skippable(): boolean
        get id(): number
    }
    type ClientboundContainerSetDataPacket_ = ClientboundContainerSetDataPacket;
    class Block extends Internal.BlockBehaviour implements Internal.FabricBlock, Internal.ItemLike, Internal.BlockAccessor, Internal.BlockExtensions, Internal.MoreBlockCulling, Internal.InjectedBlockExtension, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BlockAccessor, io.github.fabricators_of_create.porting_lib.tool.extensions.BlockExtensions {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockEntity_, $$4: Internal.Entity_, $$5: Internal.ItemStack_): void;
        getSoundType($$0: Internal.BlockState_): SoundType;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static isFaceFull($$0: Internal.VoxelShape_, $$1: Internal.Direction_): boolean;
        static updateOrDestroy($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_, $$4: number, $$5: number): void;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.BlockEntity_): void;
        static byItem($$0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_): Internal.BlockState;
        static canSupportRigidBlock($$0: Internal.BlockGetter_, $$1: BlockPos_): boolean;
        destroy($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        static popResource($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.ItemStack_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getDescriptionId(): string;
        stepOn($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Entity_): void;
        fallOn($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: Internal.Entity_, $$4: number): void;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        handler$jlh000$puzzleslib$playerDestroy$1(level: Internal.Level_, player: Internal.Player_, pos: BlockPos_, state: Internal.BlockState_, blockEntity: Internal.BlockEntity_, itemInHand: Internal.ItemStack_, callback: Internal.CallbackInfo_): void;
        setDestroySpeed(v: number): void;
        defaultBlockState(): Internal.BlockState;
        getExplosionResistance(): number;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        getStateForPlacement($$0: Internal.BlockPlaceContext_): Internal.BlockState;
        cantCullAgainst(state: Internal.BlockState_, side: Internal.Direction_): boolean;
        canCull(): boolean;
        getJumpFactor(): number;
        getSpeedFactor(): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        static canSupportCenter($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.Direction_): boolean;
        shouldAttemptToCull(state: Internal.BlockState_): boolean;
        isPossibleToRespawnInThis($$0: Internal.BlockState_): boolean;
        playerDestroy($$0: Internal.Level_, $$1: Internal.Player_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.BlockEntity_, $$5: Internal.ItemStack_): void;
        getCloneItemStack($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        playerWillDestroy($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Player_): void;
        dropFromExplosion($$0: Internal.Explosion_): boolean;
        isRandomlyTicking($$0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf($$0: Internal.BlockState_): Internal.BlockState;
        static isExceptionForConnection($$0: Internal.BlockState_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        appendHoverText($$0: Internal.ItemStack_, $$1: Internal.BlockGetter_, $$2: Internal.List_<Internal.Component>, $$3: Internal.TooltipFlag_): void;
        static box($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.VoxelShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getName(): Internal.MutableComponent;
        wasExploded($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Explosion_): void;
        setRequiresTool(v: boolean): void;
        updateEntityAfterFallOn($$0: Internal.BlockGetter_, $$1: Internal.Entity_): void;
        animateTick($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        handler$dle000$collective$Block_playerDestroy(level: Internal.Level_, player: Internal.Player_, blockPos: BlockPos_, blockState: Internal.BlockState_, blockEntity: Internal.BlockEntity_, itemStack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        handler$jlh000$puzzleslib$playerDestroy$0(level: Internal.Level_, player: Internal.Player_, pos: BlockPos_, state: Internal.BlockState_, blockEntity: Internal.BlockEntity_, itemInHand: Internal.ItemStack_, callback: Internal.CallbackInfo_): void;
        port_lib$popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static updateOrDestroy($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_, $$4: number): void;
        shouldAttemptToCull(state: Internal.BlockState_, side: Internal.Direction_): boolean;
        handler$dle000$collective$Block_setPlacedBy(level: Internal.Level_, blockPos: BlockPos_, blockState: Internal.BlockState_, livingEntity: Internal.LivingEntity_, itemStack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        static stateById($$0: number): Internal.BlockState;
        static getDrops($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.BlockEntity_, $$4: Internal.Entity_, $$5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        setPlacedBy($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.LivingEntity_, $$4: Internal.ItemStack_): void;
        propagatesSkylightDown($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
        setCanCull(canCull: boolean): void;
        static getId($$0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        getFriction(): number;
        static pushEntitiesUp($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_): Internal.BlockState;
        static popResourceFromFace($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_, $$3: Internal.ItemStack_): void;
        handlePrecipitation($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Biome$Precipitation_): void;
        static getDrops($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        cantCullAgainst(state: Internal.BlockState_): boolean;
        static shouldRenderFace($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: BlockPos_): boolean;
        set lightEmission(v: number)
        get descriptionId(): string
        set destroySpeed(v: number)
        get explosionResistance(): number
        get jumpFactor(): number
        get speedFactor(): number
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        get blockStates(): Internal.List<Internal.BlockState>
        get name(): Internal.MutableComponent
        set requiresTool(v: boolean)
        get mod(): string
        set canCull(canCull: boolean)
        get friction(): number
        static readonly UPDATE_ALL_IMMEDIATE: 11;
        static readonly INDESTRUCTIBLE: -1.0;
        static readonly UPDATE_KNOWN_SHAPE: 16;
        static readonly UPDATE_IMMEDIATE: 8;
        static readonly UPDATE_SUPPRESS_DROPS: 32;
        static readonly UPDATE_ALL: 3;
        static readonly UPDATE_CLIENTS: 2;
        static readonly UPDATE_INVISIBLE: 4;
        static readonly UPDATE_LIMIT: 512;
        static readonly UPDATE_NONE: 4;
        static readonly INSTANT: 0.0;
        static readonly OCCLUSION_CACHE: Internal.ThreadLocal<Internal.Object2ByteLinkedOpenHashMap<Internal.Block$BlockStatePairKey>>;
        static readonly BLOCK_STATE_REGISTRY: Internal.IdMapper<Internal.BlockState>;
        static readonly UPDATE_NEIGHBORS: 1;
        static readonly UPDATE_MOVE_BY_PISTON: 64;
    }
    type Block_ = Special.Block | Block;
    class BitSet implements Internal.Cloneable, Internal.Serializable {
        constructor()
        constructor(arg0: number)
        clone(): any;
        set(arg0: number): void;
        cardinality(): number;
        xor(arg0: Internal.BitSet_): void;
        isEmpty(): boolean;
        set(arg0: number, arg1: number, arg2: boolean): void;
        intersects(arg0: Internal.BitSet_): boolean;
        get(arg0: number, arg1: number): this;
        set(arg0: number, arg1: boolean): void;
        static valueOf(arg0: number[]): Internal.BitSet;
        previousSetBit(arg0: number): number;
        or(arg0: Internal.BitSet_): void;
        get(arg0: number): boolean;
        set(arg0: number, arg1: number): void;
        andNot(arg0: Internal.BitSet_): void;
        and(arg0: Internal.BitSet_): void;
        stream(): Internal.IntStream;
        length(): number;
        static valueOf(arg0: Internal.LongBuffer_): Internal.BitSet;
        clear(arg0: number, arg1: number): void;
        clear(arg0: number): void;
        flip(arg0: number): void;
        flip(arg0: number, arg1: number): void;
        nextClearBit(arg0: number): number;
        static valueOf(arg0: number[]): Internal.BitSet;
        static valueOf(arg0: Internal.ByteBuffer_): Internal.BitSet;
        previousClearBit(arg0: number): number;
        toByteArray(): number[];
        nextSetBit(arg0: number): number;
        size(): number;
        toLongArray(): number[];
        clear(): void;
        get empty(): boolean
    }
    type BitSet_ = BitSet;
    class CommandToken implements Internal.Comparable<Internal.CommandToken> {
        compareTo(o: Internal.CommandToken_): number;
        getCommandNode(host: Internal.CarpetScriptHost_): Internal.ArgumentBuilder<Internal.CommandSourceStack, any>;
        static getToken(source: string, host: Internal.CarpetScriptHost_): Internal.CommandToken;
        compareTo(arg0: any): number;
        static parseSpec(spec: string, host: Internal.CarpetScriptHost_): Internal.List<Internal.CommandToken>;
        static specFromSignature(function_: Internal.FunctionValue_): string;
        readonly type: Internal.CommandArgument;
        readonly isArgument: boolean;
        readonly surface: string;
    }
    type CommandToken_ = CommandToken;
    interface RuleTestType <P extends Internal.RuleTest> {
        codec(): Internal.Codec<P>;
        register<P extends Internal.RuleTest>($$0: string, $$1: Internal.Codec_<P>): this;
        readonly TAG_TEST: Internal.RuleTestType<Internal.TagMatchTest>;
        readonly RANDOM_BLOCKSTATE_TEST: Internal.RuleTestType<Internal.RandomBlockStateMatchTest>;
        readonly BLOCKSTATE_TEST: Internal.RuleTestType<Internal.BlockStateMatchTest>;
        readonly ALWAYS_TRUE_TEST: Internal.RuleTestType<Internal.AlwaysTrueTest>;
        readonly RANDOM_BLOCK_TEST: Internal.RuleTestType<Internal.RandomBlockMatchTest>;
        readonly BLOCK_TEST: Internal.RuleTestType<Internal.BlockMatchTest>;
    }
    type RuleTestType_<P extends Internal.RuleTest> = RuleTestType<P> | Special.RuleTest;
    class ChunkRenderDispatcher implements Internal.ChunkBuilderAccess {
        constructor($$0: Internal.ClientLevel_, $$1: Internal.LevelRenderer_, $$2: Internal.Executor_, $$3: boolean, $$4: Internal.ChunkBufferBuilderPack_)
        getFreeBufferCount(): number;
        setCamera($$0: Vec3d_): void;
        getQueuedTaskCount(): number;
        rebuildChunkSync($$0: Internal.ChunkRenderDispatcher$RenderChunk_, $$1: Internal.RenderRegionCache_): void;
        getCameraPosition(): Vec3d;
        schedule($$0: Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask_): void;
        uploadAllPendingUploads(): void;
        getToBatchCount(): number;
        getToUpload(): number;
        getBufferCount(): number;
        dispose(): void;
        blockUntilClear(): void;
        isQueueEmpty(): boolean;
        getStats(): string;
        setLevel($$0: Internal.ClientLevel_): void;
        uploadChunkLayer($$0: Internal.BufferBuilder$RenderedBuffer_, $$1: Internal.VertexBuffer_): Internal.CompletableFuture<void>;
        getUploadQueue(): Internal.Queue<any>;
        get freeBufferCount(): number
        set camera($$0: Vec3d_)
        get queuedTaskCount(): number
        get cameraPosition(): Vec3d
        get toBatchCount(): number
        get toUpload(): number
        get bufferCount(): number
        get queueEmpty(): boolean
        get stats(): string
        set level($$0: Internal.ClientLevel_)
        get uploadQueue(): Internal.Queue<any>
    }
    type ChunkRenderDispatcher_ = ChunkRenderDispatcher;
    class SlotGroup {
        getSlots(): Internal.Map<string, Internal.SlotType>;
        getName(): string;
        static read(data: Internal.CompoundTag_): Internal.SlotGroup;
        getOrder(): number;
        getSlotId(): number;
        write(data: Internal.CompoundTag_): void;
        get slots(): Internal.Map<string, Internal.SlotType>
        get name(): string
        get order(): number
        get slotId(): number
    }
    type SlotGroup_ = SlotGroup;
    interface FocusGained {
        newStream(): Internal.EventStream<Internal.FocusGained>;
        onFocusGained(arg0: Internal.Component$FocusSource_): void;
    }
    type FocusGained_ = FocusGained;
    interface Blaze3dRenderTargetExt {
        iris$getColorBufferVersion(): number;
        iris$getDepthBufferVersion(): number;
    }
    type Blaze3dRenderTargetExt_ = Blaze3dRenderTargetExt;
    interface BufferBuilderAccessor {
        setIsFlyWheelBufferBuilder(arg0: boolean): void;
        set isFlyWheelBufferBuilder(arg0: boolean)
    }
    type BufferBuilderAccessor_ = BufferBuilderAccessor;
    abstract class ThrowableItemProjectile extends Internal.ThrowableProjectile implements Internal.ItemSupplier {
        constructor($$0: Internal.EntityType_<Internal.ThrowableItemProjectile>, $$1: Internal.LivingEntity_, $$2: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.ThrowableItemProjectile>, $$1: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.ThrowableItemProjectile>, $$1: number, $$2: number, $$3: number, $$4: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getSPRINTING_FLAG_INDEX(): number;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem($$0: Internal.ItemStack_): void;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): Internal.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        method_5652($$0: Internal.CompoundTag_): void;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        static getSWIMMING_FLAG_INDEX(): number;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): Internal.Component;
        setMotionX(x: number): void;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        getScriptType(): Internal.ScriptType;
        canRiderInteract(): boolean;
        method_5749($$0: Internal.CompoundTag_): void;
        serializeNBT(): Internal.Tag;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        getMotionZ(): number;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get SILENT(): Internal.EntityDataAccessor<boolean>
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get SPRINTING_FLAG_INDEX(): number
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        set item($$0: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get GLOWING_FLAG_INDEX(): number
        get SWIMMING_FLAG_INDEX(): number
        get server(): Internal.MinecraftServer
        get displayName(): Internal.Component
        set motionX(x: number)
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get scriptType(): Internal.ScriptType
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set dynamicLightEnabled(enabled: boolean)
        get CURRENT_ID(): Internal.AtomicInteger
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get motionZ(): number
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ThrowableItemProjectile_ = ThrowableItemProjectile;
    interface ScreenElement {
        render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number): void;
    }
    type ScreenElement_ = ScreenElement;
    class SeagrassBlock extends Internal.BushBlock implements Internal.IShearable, Internal.LiquidBlockContainer, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SeagrassBlock_ = SeagrassBlock;
    interface IPartialSafeNBT {
        writeSafe(arg0: Internal.CompoundTag_): void;
    }
    type IPartialSafeNBT_ = IPartialSafeNBT;
    class FileTime implements Internal.Comparable<Internal.FileTime> {
        static from(arg0: number, arg1: Internal.TimeUnit_): Internal.FileTime;
        toMillis(): number;
        compareTo(arg0: Internal.FileTime_): number;
        toInstant(): Internal.Instant;
        to(arg0: Internal.TimeUnit_): number;
        static fromMillis(arg0: number): Internal.FileTime;
        compareTo(arg0: any): number;
        static from(arg0: Internal.Instant_): Internal.FileTime;
    }
    type FileTime_ = FileTime;
    class ClientboundSetChunkCacheRadiusPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getRadius(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get radius(): number
        get skippable(): boolean
    }
    type ClientboundSetChunkCacheRadiusPacket_ = ClientboundSetChunkCacheRadiusPacket;
    class PacketFlow extends Internal.Enum<Internal.PacketFlow> {
        getOpposite(): this;
        static values(): Internal.PacketFlow[];
        static valueOf($$0: string): Internal.PacketFlow;
        get opposite(): Internal.PacketFlow
        static readonly CLIENTBOUND: Internal.PacketFlow;
        static readonly SERVERBOUND: Internal.PacketFlow;
    }
    type PacketFlow_ = "serverbound" | "clientbound" | PacketFlow;
    class ClientInitEventJS extends Internal.ClientEventJS {
        constructor()
        registerEntityRenderer(type: Internal.EntityType_<any>, renderer: Internal.EntityRendererProvider_<any>): void;
        registerMenuScreen(type: Internal.MenuType_<any>, screenFactory: Internal.MenuRegistry$ScreenFactory_<any, any>): void;
        getEntity(): Internal.Entity;
        registerBlockEntityRenderer(type: Internal.BlockEntityType_<any>, renderer: Internal.BlockEntityRendererProvider_<any>): void;
        get entity(): Internal.Entity
    }
    type ClientInitEventJS_ = ClientInitEventJS;
    interface BlockEntityCallback {
        accept(arg0: Internal.BlockEntityJS_): void;
    }
    type BlockEntityCallback_ = BlockEntityCallback;
    class ServerboundResourcePackPacket$Action extends Internal.Enum<Internal.ServerboundResourcePackPacket$Action> {
        static valueOf($$0: string): Internal.ServerboundResourcePackPacket$Action;
        static values(): Internal.ServerboundResourcePackPacket$Action[];
        static readonly SUCCESSFULLY_LOADED: Internal.ServerboundResourcePackPacket$Action;
        static readonly FAILED_DOWNLOAD: Internal.ServerboundResourcePackPacket$Action;
        static readonly ACCEPTED: Internal.ServerboundResourcePackPacket$Action;
        static readonly DECLINED: Internal.ServerboundResourcePackPacket$Action;
    }
    type ServerboundResourcePackPacket$Action_ = "declined" | "failed_download" | "successfully_loaded" | ServerboundResourcePackPacket$Action | "accepted";
    class RelativeMovement extends Internal.Enum<Internal.RelativeMovement> {
        static valueOf($$0: string): Internal.RelativeMovement;
        static pack($$0: Internal.Set_<Internal.RelativeMovement>): number;
        static values(): Internal.RelativeMovement[];
        static unpack($$0: number): Internal.Set<Internal.RelativeMovement>;
        static readonly Y_ROT: Internal.RelativeMovement;
        static readonly ALL: Internal.Set<Internal.RelativeMovement>;
        static readonly X: Internal.RelativeMovement;
        static readonly Y: Internal.RelativeMovement;
        static readonly Z: Internal.RelativeMovement;
        static readonly X_ROT: Internal.RelativeMovement;
        static readonly ROTATION: Internal.Set<Internal.RelativeMovement>;
    }
    type RelativeMovement_ = RelativeMovement | "z" | "y" | "x" | "y_rot" | "x_rot";
    class SearchRegistry$Key <T> {
        constructor()
    }
    type SearchRegistry$Key_<T> = SearchRegistry$Key<T>;
    class ModelCuboid {
        constructor(u: number, v: number, x1: number, y1: number, z1: number, sizeX: number, sizeY: number, sizeZ: number, extraX: number, extraY: number, extraZ: number, mirror: boolean, textureWidth: number, textureHeight: number, renderDirections: Internal.Set_<Internal.Direction>)
        updateVertices(mat: Matrix4f_): void;
        readonly quads: any[];
    }
    type ModelCuboid_ = ModelCuboid;
    class ClientboundRecipePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.ClientboundRecipePacket$State_, $$1: Internal.Collection_<ResourceLocation>, $$2: Internal.Collection_<ResourceLocation>, $$3: Internal.RecipeBookSettings_)
        constructor($$0: Internal.FriendlyByteBuf_)
        getRecipes(): Internal.List<ResourceLocation>;
        handle(arg0: Internal.PacketListener_): void;
        getHighlights(): Internal.List<ResourceLocation>;
        write($$0: Internal.FriendlyByteBuf_): void;
        getState(): Internal.ClientboundRecipePacket$State;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getBookSettings(): Internal.RecipeBookSettings;
        isSkippable(): boolean;
        get recipes(): Internal.List<ResourceLocation>
        get highlights(): Internal.List<ResourceLocation>
        get state(): Internal.ClientboundRecipePacket$State
        get bookSettings(): Internal.RecipeBookSettings
        get skippable(): boolean
    }
    type ClientboundRecipePacket_ = ClientboundRecipePacket;
    abstract class PathNavigation implements Internal.IMixinEntityNavigation {
        constructor($$0: Internal.Mob_, $$1: Internal.Level_)
        createPath($$0: Internal.Stream_<BlockPos>, $$1: number): net.minecraft.world.level.pathfinder.Path;
        moveTo($$0: Internal.Entity_, $$1: number): boolean;
        canFloat(): boolean;
        createPath($$0: Internal.Entity_, $$1: number): net.minecraft.world.level.pathfinder.Path;
        recomputePath(): void;
        createPath($$0: number, $$1: number, $$2: number, $$3: number): net.minecraft.world.level.pathfinder.Path;
        setCanFloat($$0: boolean): void;
        createPath($$0: BlockPos_, $$1: number, $$2: number): net.minecraft.world.level.pathfinder.Path;
        isInProgress(): boolean;
        getTargetPos(): BlockPos;
        isStuck(): boolean;
        getPath(): net.minecraft.world.level.pathfinder.Path;
        resetMaxVisitedNodesMultiplier(): void;
        moveTo($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getNodeEvaluator(): Internal.NodeEvaluator;
        moveTo($$0: net.minecraft.world.level.pathfinder.Path_, $$1: number): boolean;
        setSpeedModifier($$0: number): void;
        shouldRecomputePath($$0: BlockPos_): boolean;
        isDone(): boolean;
        tick(): void;
        getMaxDistanceToWaypoint(): number;
        setMaxVisitedNodesMultiplier($$0: number): void;
        createPath($$0: BlockPos_, $$1: number): net.minecraft.world.level.pathfinder.Path;
        stop(): void;
        canCutCorner($$0: Internal.BlockPathTypes_): boolean;
        createPath($$0: Internal.Set_<BlockPos>, $$1: number): net.minecraft.world.level.pathfinder.Path;
        isStableDestination($$0: BlockPos_): boolean;
        set canFloat($$0: boolean)
        get inProgress(): boolean
        get targetPos(): BlockPos
        get stuck(): boolean
        get path(): net.minecraft.world.level.pathfinder.Path
        get nodeEvaluator(): Internal.NodeEvaluator
        set speedModifier($$0: number)
        get done(): boolean
        get maxDistanceToWaypoint(): number
        set maxVisitedNodesMultiplier($$0: number)
    }
    type PathNavigation_ = PathNavigation;
    class Agent {
        constructor(arg0: string, arg1: number)
        getName(): string;
        getVersion(): number;
        get name(): string
        get version(): number
        static readonly SCROLLS: Internal.Agent;
        static readonly MINECRAFT: Internal.Agent;
    }
    type Agent_ = Agent;
    class LightLayer extends Internal.Enum<Internal.LightLayer> {
        static valueOf($$0: string): Internal.LightLayer;
        static values(): Internal.LightLayer[];
        static readonly BLOCK: Internal.LightLayer;
        static readonly SKY: Internal.LightLayer;
    }
    type LightLayer_ = "block" | LightLayer | "sky";
    class SpectralArrowItem extends Internal.ArrowItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        getLightColor(arg0: Internal.Player_, arg1: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SpectralArrowItem_ = SpectralArrowItem;
    interface ServerGamePacketListener extends Internal.ServerPacketListener {
        handleChatCommand(arg0: Internal.ServerboundChatCommandPacket_): void;
        handlePlayerAbilities(arg0: Internal.ServerboundPlayerAbilitiesPacket_): void;
        handlePlayerInput(arg0: Internal.ServerboundPlayerInputPacket_): void;
        handleClientCommand(arg0: Internal.ServerboundClientCommandPacket_): void;
        handleResourcePackResponse(arg0: Internal.ServerboundResourcePackPacket_): void;
        handleSetCarriedItem(arg0: Internal.ServerboundSetCarriedItemPacket_): void;
        handlePickItem(arg0: Internal.ServerboundPickItemPacket_): void;
        handleSetCreativeModeSlot(arg0: Internal.ServerboundSetCreativeModeSlotPacket_): void;
        handleSeenAdvancements(arg0: Internal.ServerboundSeenAdvancementsPacket_): void;
        handleKeepAlive(arg0: Internal.ServerboundKeepAlivePacket_): void;
        handleUseItem(arg0: Internal.ServerboundUseItemPacket_): void;
        handlePaddleBoat(arg0: Internal.ServerboundPaddleBoatPacket_): void;
        handleSetStructureBlock(arg0: Internal.ServerboundSetStructureBlockPacket_): void;
        handleCustomPayload(arg0: Internal.ServerboundCustomPayloadPacket_): void;
        handleSelectTrade(arg0: Internal.ServerboundSelectTradePacket_): void;
        handleJigsawGenerate(arg0: Internal.ServerboundJigsawGeneratePacket_): void;
        onDisconnect(arg0: Internal.Component_): void;
        handleSetJigsawBlock(arg0: Internal.ServerboundSetJigsawBlockPacket_): void;
        handleSetCommandMinecart(arg0: Internal.ServerboundSetCommandMinecartPacket_): void;
        handleSetCommandBlock(arg0: Internal.ServerboundSetCommandBlockPacket_): void;
        handleRecipeBookSeenRecipePacket(arg0: Internal.ServerboundRecipeBookSeenRecipePacket_): void;
        handleBlockEntityTagQuery(arg0: Internal.ServerboundBlockEntityTagQuery_): void;
        handleChatSessionUpdate(arg0: Internal.ServerboundChatSessionUpdatePacket_): void;
        handleContainerButtonClick(arg0: Internal.ServerboundContainerButtonClickPacket_): void;
        handlePong(arg0: Internal.ServerboundPongPacket_): void;
        handlePlaceRecipe(arg0: Internal.ServerboundPlaceRecipePacket_): void;
        handlePlayerCommand(arg0: Internal.ServerboundPlayerCommandPacket_): void;
        handleEditBook(arg0: Internal.ServerboundEditBookPacket_): void;
        getPlayer(listener: Internal.PacketListener_): Internal.ServerPlayer;
        handleTeleportToEntityPacket(arg0: Internal.ServerboundTeleportToEntityPacket_): void;
        handleInteract(arg0: Internal.ServerboundInteractPacket_): void;
        getPlayerForPacketTweaker(): Internal.ServerPlayer;
        handleContainerClose(arg0: Internal.ServerboundContainerClosePacket_): void;
        handleChangeDifficulty(arg0: Internal.ServerboundChangeDifficultyPacket_): void;
        handleClientInformation(arg0: Internal.ServerboundClientInformationPacket_): void;
        handleRecipeBookChangeSettingsPacket(arg0: Internal.ServerboundRecipeBookChangeSettingsPacket_): void;
        isAcceptingMessages(): boolean;
        handleContainerClick(arg0: Internal.ServerboundContainerClickPacket_): void;
        handleCustomCommandSuggestions(arg0: Internal.ServerboundCommandSuggestionPacket_): void;
        handleAcceptTeleportPacket(arg0: Internal.ServerboundAcceptTeleportationPacket_): void;
        handleMovePlayer(arg0: Internal.ServerboundMovePlayerPacket_): void;
        handleChatAck(arg0: Internal.ServerboundChatAckPacket_): void;
        handlePlayerAction(arg0: Internal.ServerboundPlayerActionPacket_): void;
        handleLockDifficulty(arg0: Internal.ServerboundLockDifficultyPacket_): void;
        handleAnimate(arg0: Internal.ServerboundSwingPacket_): void;
        handleRenameItem(arg0: Internal.ServerboundRenameItemPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        handleEntityTagQuery(arg0: Internal.ServerboundEntityTagQuery_): void;
        handleSignUpdate(arg0: Internal.ServerboundSignUpdatePacket_): void;
        handleChat(arg0: Internal.ServerboundChatPacket_): void;
        handleSetBeaconPacket(arg0: Internal.ServerboundSetBeaconPacket_): void;
        handleUseItemOn(arg0: Internal.ServerboundUseItemOnPacket_): void;
        handleMoveVehicle(arg0: Internal.ServerboundMoveVehiclePacket_): void;
        get playerForPacketTweaker(): Internal.ServerPlayer
        get acceptingMessages(): boolean
    }
    type ServerGamePacketListener_ = ServerGamePacketListener;
    class FireworkRocketRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        "handler$fab000$fabric-item-api-v1$captureStack"(inventory: Internal.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        handler$zpp000$bclib$bcl_getRemainingItems(container: Internal.Container_, cir: Internal.CallbackInfoReturnable_<any>): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type FireworkRocketRecipe_ = FireworkRocketRecipe;
    class TickTask implements Internal.Runnable {
        constructor($$0: number, $$1: Internal.Runnable_)
        run(): void;
        getTick(): number;
        get tick(): number
    }
    type TickTask_ = TickTask;
    class RandomSpreadStructurePlacement extends Internal.StructurePlacement {
        constructor($$0: number, $$1: number, $$2: Internal.RandomSpreadType_, $$3: number)
        constructor($$0: Vec3i_, $$1: any_, $$2: number, $$3: number, $$4: Internal.Optional_<any>, $$5: number, $$6: number, $$7: Internal.RandomSpreadType_)
        spacing(): number;
        getPotentialStructureChunk($$0: number, $$1: number, $$2: number): Internal.ChunkPos;
        separation(): number;
        spreadType(): Internal.RandomSpreadType;
        static readonly CODEC: Internal.Codec<Internal.RandomSpreadStructurePlacement>;
    }
    type RandomSpreadStructurePlacement_ = RandomSpreadStructurePlacement;
    class FeaturePlaceContext <FC extends Internal.FeatureConfiguration> {
        constructor($$0: Internal.Optional_<Internal.ConfiguredFeature<any, any>>, $$1: Internal.WorldGenLevel_, $$2: Internal.ChunkGenerator_, $$3: Internal.RandomSource_, $$4: BlockPos_, $$5: FC)
        config(): FC;
        topFeature(): Internal.Optional<Internal.ConfiguredFeature<any, any>>;
        origin(): BlockPos;
        random(): Internal.RandomSource;
        level(): Internal.WorldGenLevel;
        chunkGenerator(): Internal.ChunkGenerator;
    }
    type FeaturePlaceContext_<FC extends Internal.FeatureConfiguration> = FeaturePlaceContext<FC>;
    interface Stitcher$Entry {
        width(): number;
        height(): number;
        name(): ResourceLocation;
    }
    type Stitcher$Entry_ = Stitcher$Entry;
    class IpBanList extends Internal.StoredUserList<string, Internal.IpBanListEntry> {
        constructor($$0: Internal.File_)
        isBanned($$0: string): boolean;
        isBanned($$0: Internal.SocketAddress_): boolean;
        get($$0: Internal.SocketAddress_): Internal.IpBanListEntry;
    }
    type IpBanList_ = IpBanList;
    class Horse extends Internal.AbstractHorse implements Internal.VariantHolder<Internal.Variant> {
        constructor($$0: Internal.EntityType_<Internal.Horse>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        getVariant(): Internal.Variant;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getArmor(): Internal.ItemStack;
        getJumpCooldown(): number;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setVariant($$0: Internal.Variant_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getMarkings(): Internal.Markings;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get variant(): Internal.Variant
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get armor(): Internal.ItemStack
        get jumpCooldown(): number
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set variant($$0: Internal.Variant_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get markings(): Internal.Markings
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
    }
    type Horse_ = Horse;
    interface SPC_Screen_Accessor {
        getDrawables(): Internal.List<Internal.Renderable>;
        get drawables(): Internal.List<Internal.Renderable>
    }
    type SPC_Screen_Accessor_ = SPC_Screen_Accessor;
    class SpriteContents implements Internal.Stitcher$Entry, traben.entity_texture_features.mixin.accessor.SpriteContentsAccessor, Internal.SpriteContentsExtension, Internal.SpriteContentsAccessor, net.coderbot.iris.mixin.texture.SpriteContentsAccessor, Internal.SpriteContentsExtensions, Internal.SpriteContentsExtended, Internal.AutoCloseable, Internal.SpriteContentsInvoker, ca.fxco.moreculling.mixin.accessors.SpriteContentsAccessor, Internal.IPotentiallyInvisibleSpriteContents, net.coderbot.iris.texture.SpriteContentsExtension {
        constructor($$0: ResourceLocation_, $$1: any_, $$2: Internal.NativeImage_, $$3: any_)
        callGetFrameCount(): number;
        getImage(): Internal.NativeImage;
        getPixelRGBA(frameIndex: number, x: number, y: number): number;
        getImages(): Internal.NativeImage[];
        getFrameCount(): number;
        sodium$hasAnimation(): boolean;
        getUniqueFrames(): Internal.IntStream;
        name(): ResourceLocation;
        setWidth(arg0: number): void;
        getHeight(): number;
        getAnimatedTexture(): Internal.SpriteContents$AnimatedTexture;
        isTransparent($$0: number, $$1: number, $$2: number): boolean;
        snr$shouldDoInvisibility(): boolean;
        snr$isVisible(): boolean;
        getPBRHolder(): Internal.PBRSpriteHolder;
        getWidth(): number;
        getCreatedTicker(): Internal.SpriteContents$Ticker;
        uploadFirstFrame($$0: number, $$1: number): void;
        height(): number;
        sodium$isActive(): boolean;
        increaseMipLevel($$0: number): void;
        snr$uploadFrame(visible: boolean): void;
        invokeUpload(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.NativeImage_[]): void;
        close(): void;
        width(): number;
        sodium$setActive(value: boolean): void;
        setHeight(arg0: number): void;
        getOrCreatePBRHolder(): Internal.PBRSpriteHolder;
        createTicker(): Internal.SpriteTicker;
        get image(): Internal.NativeImage
        get images(): Internal.NativeImage[]
        get frameCount(): number
        get uniqueFrames(): Internal.IntStream
        set width(arg0: number)
        get height(): number
        get animatedTexture(): Internal.SpriteContents$AnimatedTexture
        get PBRHolder(): Internal.PBRSpriteHolder
        get width(): number
        get createdTicker(): Internal.SpriteContents$Ticker
        set height(arg0: number)
        get orCreatePBRHolder(): Internal.PBRSpriteHolder
        originalImage: Internal.NativeImage;
        byMipLevel: Internal.NativeImage[];
        readonly animatedTexture: Internal.SpriteContents$AnimatedTexture;
    }
    type SpriteContents_ = SpriteContents;
    interface BiomeSourceAccessor {
        bclRebuildFeatures(): void;
    }
    type BiomeSourceAccessor_ = BiomeSourceAccessor;
    interface IWaypointableNavigation {
        isWaypointMode(): boolean;
        get waypointMode(): boolean
    }
    type IWaypointableNavigation_ = IWaypointableNavigation;
    interface SimpleWaterloggedBlock extends Internal.BucketPickup, Internal.LiquidBlockContainer {
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
    }
    type SimpleWaterloggedBlock_ = SimpleWaterloggedBlock;
    interface CustomJavaToJsWrapper {
        convertJavaToJs(arg0: Internal.Context_, arg1: Internal.Scriptable_, arg2: typeof any): Internal.Scriptable;
        (arg0: Internal.Context_, arg1: Internal.Scriptable_, arg2: typeof any): Internal.Scriptable_;
    }
    type CustomJavaToJsWrapper_ = CustomJavaToJsWrapper;
    class LegacyRandomSource implements Internal.BitRandomSource {
        constructor($$0: number)
        static create($$0: number): Internal.RandomSource;
        next($$0: number): number;
        fork(): Internal.RandomSource;
        static create(): Internal.RandomSource;
        nextBoolean(): boolean;
        nextLong(): number;
        setSeed($$0: number): void;
        nextDouble(): number;
        nextInt($$0: number, $$1: number): number;
        nextGaussian(): number;
        static createNewThreadLocalInstance(): Internal.RandomSource;
        forkPositional(): Internal.PositionalRandomFactory;
        consumeCount($$0: number): void;
        triangle($$0: number, $$1: number): number;
        nextInt($$0: number): number;
        nextFloat(): number;
        /**
         * @deprecated
        */
        static createThreadSafe(): Internal.RandomSource;
        nextInt(): number;
        nextIntBetweenInclusive($$0: number, $$1: number): number;
        set seed($$0: number)
    }
    type LegacyRandomSource_ = LegacyRandomSource;
    interface ChannelPipeline extends Internal.Iterable<Internal.Map$Entry<string, Internal.ChannelHandler>>, Internal.ChannelOutboundInvoker, Internal.ChannelInboundInvoker {
        fireExceptionCaught(arg0: Internal.Throwable_): this;
        addBefore(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        firstContext(): Internal.ChannelHandlerContext;
        addFirst(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        addAfter(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        remove<T extends Internal.ChannelHandler>(arg0: T): T;
        removeFirst(): Internal.ChannelHandler;
        write(arg0: any): Internal.ChannelFuture;
        replace<T extends Internal.ChannelHandler>(arg0: T, arg1: string, arg2: Internal.ChannelHandler_): T;
        fireChannelWritabilityChanged(): this;
        close(): Internal.ChannelFuture;
        write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        toMap(): Internal.Map<string, Internal.ChannelHandler>;
        addFirst(arg0: string, arg1: Internal.ChannelHandler_): this;
        spliterator(): Internal.Spliterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        replace(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): Internal.ChannelHandler;
        first(): Internal.ChannelHandler;
        addBefore(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        remove(arg0: Internal.ChannelHandler_): this;
        forEach(arg0: Internal.Consumer_<Internal.Map$Entry<string, Internal.ChannelHandler>>): void;
        get(arg0: string): Internal.ChannelHandler;
        addLast(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        lastContext(): Internal.ChannelHandlerContext;
        read(): Internal.ChannelOutboundInvoker;
        fireChannelUnregistered(): this;
        voidPromise(): Internal.ChannelPromise;
        context(arg0: Internal.ChannelHandler_): Internal.ChannelHandlerContext;
        addLast(...arg0: Internal.ChannelHandler_[]): this;
        fireChannelInactive(): this;
        addFirst(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        fireChannelRegistered(): this;
        replace(arg0: Internal.ChannelHandler_, arg1: string, arg2: Internal.ChannelHandler_): this;
        writeAndFlush(arg0: any): Internal.ChannelFuture;
        disconnect(): Internal.ChannelFuture;
        context(arg0: string): Internal.ChannelHandlerContext;
        fireChannelRead(arg0: any): this;
        fireUserEventTriggered(arg0: any): this;
        addAfter(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        names(): Internal.List<string>;
        deregister(): Internal.ChannelFuture;
        disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        addLast(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        fireChannelReadComplete(): this;
        close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        newSucceededFuture(): Internal.ChannelFuture;
        newProgressivePromise(): Internal.ChannelProgressivePromise;
        iterator(): Internal.Iterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        fireChannelActive(): this;
        last(): Internal.ChannelHandler;
        get<T extends Internal.ChannelHandler>(arg0: T): T;
        channel(): io.netty.channel.Channel;
        remove(arg0: string): Internal.ChannelHandler;
        writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        context(arg0: typeof Internal.ChannelHandler): Internal.ChannelHandlerContext;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        addFirst(...arg0: Internal.ChannelHandler_[]): this;
        flush(): this;
        removeLast(): Internal.ChannelHandler;
        addLast(arg0: string, arg1: Internal.ChannelHandler_): this;
        newPromise(): Internal.ChannelPromise;
    }
    type ChannelPipeline_ = ChannelPipeline;
    interface ExtendingBufferBuilder {
        iris$beginWithoutExtending(arg0: Internal.VertexFormat$Mode_, arg1: Internal.VertexFormat_): void;
    }
    type ExtendingBufferBuilder_ = ExtendingBufferBuilder;
    interface ObjectCollection <K> extends Internal.Collection<K>, Internal.ObjectIterable<K> {
        addAll(arg0: Internal.Collection_<K>): boolean;
        iterator(): Internal.Iterator<any>;
        toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
        remove(arg0: any): boolean;
        isEmpty(): boolean;
        toArray(): any[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        parallelStream(): Internal.Stream<K>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        hashCode(): number;
        size(): number;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        removeAll(arg0: Internal.Collection_<any>): boolean;
        clear(): void;
        equals(arg0: any): boolean;
        add(arg0: K): boolean;
        stream(): Internal.Stream<K>;
        contains(arg0: any): boolean;
        get empty(): boolean
    }
    type ObjectCollection_<K> = ObjectCollection<K>;
    interface IExtendedBiomeSource {
        appendDeferredBiomesList(arg0: Internal.List_<Internal.Holder<Internal.Biome>>): void;
    }
    type IExtendedBiomeSource_ = IExtendedBiomeSource;
    class NbtAccounter implements Internal.NbtAccounterAccessor {
        constructor($$0: number)
        create$getUsage(): number;
        accountBytes($$0: number): void;
        getUsage(): number;
        get usage(): number
        static readonly UNLIMITED: Internal.NbtAccounter;
    }
    type NbtAccounter_ = NbtAccounter;
    class KelpPlantBlock extends Internal.GrowingPlantBodyBlock implements Internal.LiquidBlockContainer {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type KelpPlantBlock_ = KelpPlantBlock;
    interface GraphView {
        getGraphForNode(arg0: Internal.NodePos_): Internal.BlockGraph;
        getLoadedGraphsInChunk(arg0: Internal.ChunkPos_): Internal.Stream<Internal.BlockGraph>;
        getLinkAt(arg0: Internal.LinkPos_): Internal.LinkHolder<Internal.LinkKey>;
        getUniverse(): Internal.GraphUniverse;
        getWorld(): Internal.Level;
        getLoadedGraphsInChunkSection(arg0: Internal.SectionPos_): Internal.Stream<Internal.BlockGraph>;
        linkExistsAt(arg0: Internal.LinkPos_): boolean;
        getAllGraphsInChunk(pos: Internal.ChunkPos_): Internal.Stream<Internal.BlockGraph>;
        getAllGraphIdsAt(arg0: BlockPos_): Internal.LongStream;
        getNodesAt(arg0: Internal.SidedPos_): Internal.Stream<Internal.NodeHolder<Internal.SidedBlockNode>>;
        getAllGraphIdsInChunkSection(arg0: Internal.SectionPos_): Internal.LongStream;
        getLoadedGraphsAt(arg0: BlockPos_): Internal.Stream<Internal.BlockGraph>;
        nodeExistsAt(arg0: Internal.NodePos_): boolean;
        getNodeAt(arg0: Internal.NodePos_): Internal.NodeHolder<Internal.BlockNode>;
        getAllGraphs(): Internal.Stream<Internal.BlockGraph>;
        getAllGraphsInChunkSection(pos: Internal.SectionPos_): Internal.Stream<Internal.BlockGraph>;
        getAllGraphIds(): Internal.LongStream;
        getNodeEntity(arg0: Internal.NodePos_): Internal.NodeEntity;
        getLoadedGraphs(): Internal.Stream<Internal.BlockGraph>;
        getGraph(arg0: number): Internal.BlockGraph;
        getAllGraphIdsInChunk(arg0: Internal.ChunkPos_): Internal.LongStream;
        getAllGraphsAt(pos: BlockPos_): Internal.Stream<Internal.BlockGraph>;
        getLinkEntity(arg0: Internal.LinkPos_): Internal.LinkEntity;
        getNodesAt(arg0: BlockPos_): Internal.Stream<Internal.NodeHolder<Internal.BlockNode>>;
        get universe(): Internal.GraphUniverse
        get world(): Internal.Level
        get allGraphs(): Internal.Stream<Internal.BlockGraph>
        get allGraphIds(): Internal.LongStream
        get loadedGraphs(): Internal.Stream<Internal.BlockGraph>
    }
    type GraphView_ = GraphView;
    abstract class Display extends Internal.Entity implements Internal.DisplayEntityAccessor {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        static "getBRIGHTNESS$polymer-virtual-entity_$md$896f98$5"(): Internal.EntityDataAccessor<any>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static getSCALE(): Internal.EntityDataAccessor<Vec3f>;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        static getSPRINTING_FLAG_INDEX(): number;
        isOnScoreboardTeam(teamId: string): boolean;
        static "getWIDTH$polymer-virtual-entity_$md$896f98$9"(): Internal.EntityDataAccessor<any>;
        static getSHADOW_STRENGTH(): Internal.EntityDataAccessor<number>;
        static "getLEFT_ROTATION$polymer-virtual-entity_$md$896f98$2"(): Internal.EntityDataAccessor<any>;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        calculateInterpolationProgress($$0: number): number;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static "getINTERPOLATION_DURATION$polymer-virtual-entity_$md$896f98$4"(): Internal.EntityDataAccessor<any>;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        static "getSHADOW_STRENGTH$polymer-virtual-entity_$md$896f98$8"(): Internal.EntityDataAccessor<any>;
        static "getRIGHT_ROTATION$polymer-virtual-entity_$md$896f98$3"(): Internal.EntityDataAccessor<any>;
        static getTRANSLATION(): Internal.EntityDataAccessor<Vec3f>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        static "getTRANSLATION$polymer-virtual-entity_$md$896f98$0"(): Internal.EntityDataAccessor<any>;
        getMotionX(): number;
        static getSHADOW_RADIUS(): Internal.EntityDataAccessor<number>;
        isWaterCreature(): boolean;
        static getHEIGHT(): Internal.EntityDataAccessor<number>;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        static getBRIGHTNESS(): Internal.EntityDataAccessor<number>;
        isFrame(): boolean;
        playSound(id: Internal.SoundEvent_): void;
        static getSTART_INTERPOLATION(): Internal.EntityDataAccessor<number>;
        static getLEFT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        renderState(): Internal.Display$RenderState;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        static "getSTART_INTERPOLATION$polymer-virtual-entity_$md$896f98$d"(): Internal.EntityDataAccessor<any>;
        static getVIEW_RANGE(): Internal.EntityDataAccessor<number>;
        static "getVIEW_RANGE$polymer-virtual-entity_$md$896f98$6"(): Internal.EntityDataAccessor<any>;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        static getBILLBOARD(): Internal.EntityDataAccessor<number>;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        static getWIDTH(): Internal.EntityDataAccessor<number>;
        self(): Internal.Entity;
        static "getHEIGHT$polymer-virtual-entity_$md$896f98$a"(): Internal.EntityDataAccessor<any>;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): Internal.Component;
        static "getBILLBOARD$polymer-virtual-entity_$md$896f98$c"(): Internal.EntityDataAccessor<any>;
        getPassengers(): Internal.EntityArrayList;
        static "getSHADOW_RADIUS$polymer-virtual-entity_$md$896f98$7"(): Internal.EntityDataAccessor<any>;
        static getGLOW_COLOR_OVERRIDE(): Internal.EntityDataAccessor<number>;
        static getSWIMMING_FLAG_INDEX(): number;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        static "getSCALE$polymer-virtual-entity_$md$896f98$1"(): Internal.EntityDataAccessor<any>;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        orientation(): Quaternionf;
        setZ(z: number): void;
        static "getGLOW_COLOR_OVERRIDE$polymer-virtual-entity_$md$896f98$b"(): Internal.EntityDataAccessor<any>;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        static getINTERPOLATION_DURATION(): Internal.EntityDataAccessor<number>;
        runCommand(command: string): number;
        static getRIGHT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>;
        get "BRIGHTNESS$polymer-virtual-entity_$md$896f98$5"(): Internal.EntityDataAccessor<any>
        get SCALE(): Internal.EntityDataAccessor<Vec3f>
        get SILENT(): Internal.EntityDataAccessor<boolean>
        get SPRINTING_FLAG_INDEX(): number
        get "WIDTH$polymer-virtual-entity_$md$896f98$9"(): Internal.EntityDataAccessor<any>
        get SHADOW_STRENGTH(): Internal.EntityDataAccessor<number>
        get "LEFT_ROTATION$polymer-virtual-entity_$md$896f98$2"(): Internal.EntityDataAccessor<any>
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get "INTERPOLATION_DURATION$polymer-virtual-entity_$md$896f98$4"(): Internal.EntityDataAccessor<any>
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        get "SHADOW_STRENGTH$polymer-virtual-entity_$md$896f98$8"(): Internal.EntityDataAccessor<any>
        get "RIGHT_ROTATION$polymer-virtual-entity_$md$896f98$3"(): Internal.EntityDataAccessor<any>
        get TRANSLATION(): Internal.EntityDataAccessor<Vec3f>
        get "TRANSLATION$polymer-virtual-entity_$md$896f98$0"(): Internal.EntityDataAccessor<any>
        get motionX(): number
        get SHADOW_RADIUS(): Internal.EntityDataAccessor<number>
        get waterCreature(): boolean
        get HEIGHT(): Internal.EntityDataAccessor<number>
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get BRIGHTNESS(): Internal.EntityDataAccessor<number>
        get frame(): boolean
        get START_INTERPOLATION(): Internal.EntityDataAccessor<number>
        get LEFT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>
        set motionY(y: number)
        get peacefulCreature(): boolean
        get "START_INTERPOLATION$polymer-virtual-entity_$md$896f98$d"(): Internal.EntityDataAccessor<any>
        get VIEW_RANGE(): Internal.EntityDataAccessor<number>
        get "VIEW_RANGE$polymer-virtual-entity_$md$896f98$6"(): Internal.EntityDataAccessor<any>
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get BILLBOARD(): Internal.EntityDataAccessor<number>
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        get WIDTH(): Internal.EntityDataAccessor<number>
        get "HEIGHT$polymer-virtual-entity_$md$896f98$a"(): Internal.EntityDataAccessor<any>
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get "BILLBOARD$polymer-virtual-entity_$md$896f98$c"(): Internal.EntityDataAccessor<any>
        get passengers(): Internal.EntityArrayList
        get "SHADOW_RADIUS$polymer-virtual-entity_$md$896f98$7"(): Internal.EntityDataAccessor<any>
        get GLOW_COLOR_OVERRIDE(): Internal.EntityDataAccessor<number>
        get SWIMMING_FLAG_INDEX(): number
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get "SCALE$polymer-virtual-entity_$md$896f98$1"(): Internal.EntityDataAccessor<any>
        set dynamicLightEnabled(enabled: boolean)
        get CURRENT_ID(): Internal.AtomicInteger
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        get "GLOW_COLOR_OVERRIDE$polymer-virtual-entity_$md$896f98$b"(): Internal.EntityDataAccessor<any>
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        get INTERPOLATION_DURATION(): Internal.EntityDataAccessor<number>
        get RIGHT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>
        static readonly TAG_WIDTH: "width";
        static readonly TAG_BILLBOARD: "billboard";
        static readonly TAG_TRANSFORMATION: "transformation";
        static readonly NO_BRIGHTNESS_OVERRIDE: -1;
        static readonly TAG_START_INTERPOLATION: "start_interpolation";
        static readonly TAG_HEIGHT: "height";
        static readonly TAG_GLOW_COLOR_OVERRIDE: "glow_color_override";
        static readonly TAG_BRIGHTNESS: "brightness";
        static readonly TAG_SHADOW_RADIUS: "shadow_radius";
        static readonly TAG_SHADOW_STRENGTH: "shadow_strength";
        static readonly TAG_INTERPOLATION_DURATION: "interpolation_duration";
        static readonly TAG_VIEW_RANGE: "view_range";
    }
    type Display_ = Display;
    class Couple <T> extends com.simibubi.create.foundation.utility.Pair<T, T> implements Internal.Iterable<T> {
        forEachWithContext(consumer: Internal.BiConsumer_<T, boolean>): void;
        static createWithContext<T>(factory: Internal.Function_<boolean, T>): Internal.Couple<T>;
        replaceWithContext(function_: Internal.BiFunction_<T, boolean, T>): void;
        stream(): Internal.Stream<T>;
        static create<T>(factory: Internal.Supplier_<T>): Internal.Couple<T>;
        set(first: boolean, value: T): void;
        mapWithParams<S, R>(function_: Internal.BiFunction_<T, R, S>, values: Internal.Couple_<R>): Internal.Couple<S>;
        spliterator(): Internal.Spliterator<T>;
        replace(function_: Internal.Function_<T, T>): void;
        forEachWithParams<S>(function_: Internal.BiConsumer_<T, S>, values: Internal.Couple_<S>): void;
        get(first: boolean): T;
        both(test: Internal.Predicate_<T>): boolean;
        mapNotNullWithParam<S, R>(function_: Internal.BiFunction_<T, R, S>, value: R): Internal.Couple<S>;
        iterator(): Internal.Iterator<T>;
        forEach(consumer: Internal.Consumer_<T>): void;
        static create<T>(first: T, second: T): Internal.Couple<T>;
        static deserializeEach<S>(list: Internal.ListTag_, deserializer: Internal.Function_<Internal.CompoundTag, S>): Internal.Couple<S>;
        swap(): this;
        map<S>(function_: Internal.Function_<T, S>): Internal.Couple<S>;
        serializeEach(serializer: Internal.Function_<T, Internal.CompoundTag>): Internal.ListTag;
        either(test: Internal.Predicate_<T>): boolean;
        mapWithContext<S>(function_: Internal.BiFunction_<T, boolean, S>): Internal.Couple<S>;
        copy(): com.simibubi.create.foundation.utility.Pair<any, any>;
        replaceWithParams<S>(function_: Internal.BiFunction_<T, S, T>, values: Internal.Couple_<S>): void;
    }
    type Couple_<T> = Couple<T>;
    interface SignalGetter extends Internal.BlockGetter {
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getMinSection(): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getBlockState(arg0: BlockPos_): Internal.BlockState;
        getBestNeighborSignal($$0: BlockPos_): number;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        getMaxSection(): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getHeight(): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getFluidState(arg0: BlockPos_): Internal.FluidState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get height(): number
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
        readonly DIRECTIONS: Internal.Direction[];
    }
    type SignalGetter_ = SignalGetter;
    class FoodBuilder {
        constructor()
        constructor(properties: Internal.FoodProperties_)
        /**
         * Sets whether the food is fast to eat (having half of the eating time).
        */
        fastToEat(flag: boolean): this;
        /**
         * Sets the hunger restored.
        */
        hunger(h: number): this;
        /**
         * Sets whether the food is always edible.
        */
        alwaysEdible(flag: boolean): this;
        /**
         * Sets the saturation modifier. Note that the saturation restored is hunger * saturation.
        */
        saturation(s: number): this;
        build(): Internal.FoodProperties;
        /**
         * Sets the food is always edible.
        */
        alwaysEdible(): this;
        effect(mobEffectId: Special.MobEffect, duration: number, amplifier: number, probability: number): this;
        /**
         * Sets whether the food is meat.
        */
        meat(flag: boolean): this;
        /**
         * Sets the food is meat.
        */
        meat(): this;
        /**
         * Sets a callback that is called when the food is eaten.
         * 
         * Note: This is currently not having effect in `ItemEvents.modification`,
         * as firing this callback requires an `ItemBuilder` instance in the `Item`.
        */
        eaten(e: Internal.Consumer_<Internal.FoodEatenEventJS>): this;
        /**
         * Removes an effect from the food.
        */
        removeEffect(mobEffect: Internal.MobEffect_): this;
        /**
         * Sets the food is fast to eat (having half of the eating time).
        */
        fastToEat(): this;
        eaten: Internal.Consumer<Internal.FoodEatenEventJS>;
    }
    type FoodBuilder_ = FoodBuilder;
    class VariantBlockStateGenerator$Model {
        constructor()
        uvlock(): this;
        x(_x: number): this;
        y(_y: number): this;
        model(s: string): this;
        toJson(): Internal.JsonObject;
    }
    type VariantBlockStateGenerator$Model_ = VariantBlockStateGenerator$Model;
    class BlockPlaceContext extends Internal.UseOnContext {
        constructor($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: Internal.ItemStack_, $$3: Internal.BlockHitResult_)
        constructor($$0: Internal.Level_, $$1: Internal.Player_, $$2: Internal.InteractionHand_, $$3: Internal.ItemStack_, $$4: Internal.BlockHitResult_)
        constructor($$0: Internal.UseOnContext_)
        getNearestLookingDirection(): Internal.Direction;
        static createUseOnContext(level: Internal.Level_, player: Internal.Player_, interactionHand: Internal.InteractionHand_, itemStack: Internal.ItemStack_, blockHitResult: Internal.BlockHitResult_): Internal.UseOnContext;
        getNearestLookingVerticalDirection(): Internal.Direction;
        getNearestLookingDirections(): Internal.Direction[];
        replacingClickedOnBlock(): boolean;
        canPlace(): boolean;
        static at($$0: Internal.BlockPlaceContext_, $$1: BlockPos_, $$2: Internal.Direction_): Internal.BlockPlaceContext;
        handler$ido000$moonlight$fixNotAccountingForNullPlayer3(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$ido000$moonlight$fixNotAccountingForNullPlayer2(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$ido000$moonlight$fixNotAccountingForNullPlayer1(cir: Internal.CallbackInfoReturnable_<any>): void;
        get nearestLookingDirection(): Internal.Direction
        get nearestLookingVerticalDirection(): Internal.Direction
        get nearestLookingDirections(): Internal.Direction[]
    }
    type BlockPlaceContext_ = BlockPlaceContext;
    interface LootTableBuilderAccessor {
        getPools(): Internal.List<Internal.LootPool>;
        getFunctions(): Internal.List<Internal.LootItemFunction>;
        get pools(): Internal.List<Internal.LootPool>
        get functions(): Internal.List<Internal.LootItemFunction>
    }
    type LootTableBuilderAccessor_ = LootTableBuilderAccessor;
    interface Object2ShortFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToIntFunction<K> {
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Object2FloatFunction<K>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ShortFunction<T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ShortFunction;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ShortFunction;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Object2IntFunction<K>;
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Object2LongFunction<K>;
        defaultReturnValue(): number;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ShortFunction;
        getOrDefault(arg0: any, arg1: number): number;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        apply(arg0: K): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        getShort(arg0: any): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        removeShort(arg0: any): number;
        put(arg0: K, arg1: number): number;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ShortFunction<T>;
        applyAsInt(arg0: K): number;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Object2ByteFunction<K>;
        size(): number;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ShortFunction;
        defaultReturnValue(arg0: number): void;
        clear(): void;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Object2ShortFunction_<K> = Object2ShortFunction<K>;
    interface FabricLootTableBuilder {
        pools(pools: Internal.Collection_<Internal.LootPool>): Internal.LootTable$Builder;
        apply(function_: Internal.LootItemFunction_): Internal.LootTable$Builder;
        modifyPools(modifier: Internal.Consumer_<Internal.LootPool$Builder>): Internal.LootTable$Builder;
        pool(pool: Internal.LootPool_): Internal.LootTable$Builder;
        apply(functions: Internal.Collection_<Internal.LootItemFunction>): Internal.LootTable$Builder;
        copyOf(table: Internal.LootTable_): Internal.LootTable$Builder;
    }
    type FabricLootTableBuilder_ = FabricLootTableBuilder;
    class Climate$ParameterList <T> implements Internal.InterfaceEntries<any>, Internal.IExtendedParameterList<any> {
        constructor($$0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.Climate$ParameterPoint, T>>)
        findValuePositional(target: Internal.Climate$TargetPoint_, x: number, y: number, z: number): any;
        getUniqueness(x: number, y: number, z: number): number;
        biolith$getuniqueTree(x: number, y: number, z: number): Internal.Climate$RTree<any>;
        biolith$getInitialized(): boolean;
        values(): Internal.List<com.mojang.datafixers.util.Pair<Internal.Climate$ParameterPoint, T>>;
        findValueIndex($$0: Internal.Climate$TargetPoint_): T;
        findValueIndex($$0: Internal.Climate$TargetPoint_, $$1: Internal.Climate$DistanceMetric_<T>): T;
        biolith$getUniqueTrees(): Internal.Climate$RTree<any>[];
        findValueBruteForce($$0: Internal.Climate$TargetPoint_): T;
        biolith$getUniqueness(): any;
        getTreeCount(): number;
        biolith$getTreesPopulated(): boolean;
        isInitialized(): boolean;
        static codec<T>($$0: Internal.MapCodec_<T>): Internal.Codec<Internal.Climate$ParameterList<T>>;
        initializeForTerraBlender(registryAccess: Internal.RegistryAccess_, regionType: Internal.RegionType_, seed: number): void;
        getTree(uniqueness: number): Internal.Climate$RTree<any>;
        findValue($$0: Internal.Climate$TargetPoint_): T;
        get treeCount(): number
        get initialized(): boolean
        readonly index: Internal.Climate$RTree<T>;
    }
    type Climate$ParameterList_<T> = Climate$ParameterList<T>;
    class Rarity extends Internal.Enum<Internal.Rarity> {
        static valueOf($$0: string): Internal.Rarity;
        static values(): Internal.Rarity[];
        static readonly COMMON: Internal.Rarity;
        readonly color: Internal.ChatFormatting;
        static readonly UNCOMMON: Internal.Rarity;
        static readonly EPIC: Internal.Rarity;
        static readonly RARE: Internal.Rarity;
    }
    type Rarity_ = Rarity | "uncommon" | "epic" | "rare" | "common";
    interface ChatEvent$ChatComponent {
        get(): Internal.Component;
        set(arg0: Internal.Component_): void;
    }
    type ChatEvent$ChatComponent_ = ChatEvent$ChatComponent;
    interface ProfileResults {
        saveResults(arg0: Internal.Path_): boolean;
        getTimes(arg0: string): Internal.List<Internal.ResultField>;
        getNanoDuration(): number;
        getStartTimeTicks(): number;
        getTickDuration(): number;
        getEndTimeNano(): number;
        getStartTimeNano(): number;
        getEndTimeTicks(): number;
        demanglePath($$0: string): string;
        getProfilerResults(): string;
        get nanoDuration(): number
        get startTimeTicks(): number
        get tickDuration(): number
        get endTimeNano(): number
        get startTimeNano(): number
        get endTimeTicks(): number
        get profilerResults(): string
        readonly PATH_SEPARATOR: "\u001e";
    }
    type ProfileResults_ = ProfileResults;
    class ServerboundPlaceRecipePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.Recipe_<any>, $$2: boolean)
        getRecipe(): ResourceLocation;
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        isShiftDown(): boolean;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getContainerId(): number;
        isSkippable(): boolean;
        get recipe(): ResourceLocation
        get shiftDown(): boolean
        get containerId(): number
        get skippable(): boolean
    }
    type ServerboundPlaceRecipePacket_ = ServerboundPlaceRecipePacket;
    abstract class SignatureSpi {
        constructor()
        clone(): any;
    }
    type SignatureSpi_ = SignatureSpi;
    class CarvingContext extends Internal.WorldGenerationContext {
        constructor($$0: any_, $$1: Internal.RegistryAccess_, $$2: Internal.LevelHeightAccessor_, $$3: Internal.NoiseChunk_, $$4: Internal.RandomState_, $$5: Internal.SurfaceRules$RuleSource_)
        /**
         * @deprecated
        */
        topMaterial($$0: Internal.Function_<BlockPos, Internal.Holder<Internal.Biome>>, $$1: Internal.ChunkAccess_, $$2: BlockPos_, $$3: boolean): Internal.Optional<Internal.BlockState>;
        /**
         * @deprecated
        */
        registryAccess(): Internal.RegistryAccess;
        randomState(): Internal.RandomState;
    }
    type CarvingContext_ = CarvingContext;
    class CandleBlock extends Internal.AbstractCandleBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight($$0: Internal.BlockState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MAX_CANDLES: 4;
        static readonly CANDLES: Internal.IntegerProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly MIN_CANDLES: 1;
        static readonly LIT: Internal.BooleanProperty;
        static readonly LIGHT_EMISSION: Internal.ToIntFunction<Internal.BlockState>;
    }
    type CandleBlock_ = CandleBlock;
    interface ListBuilder <T> {
        build(arg0: Internal.DataResult_<T>): Internal.DataResult<T>;
        add(arg0: T): this;
        withErrorsFrom(arg0: Internal.DataResult_<any>): this;
        ops(): Internal.DynamicOps<T>;
        add<E>(arg0: E, arg1: Internal.Encoder_<E>): this;
        add(arg0: Internal.DataResult_<T>): this;
        addAll<E>(arg0: Internal.Iterable_<E>, arg1: Internal.Encoder_<E>): this;
        build(arg0: T): Internal.DataResult<T>;
        mapError(arg0: Internal.UnaryOperator_<string>): this;
    }
    type ListBuilder_<T> = ListBuilder<T>;
    class PiglinWallSkullBlock extends Internal.WallSkullBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
    }
    type PiglinWallSkullBlock_ = PiglinWallSkullBlock;
    class FormatStyle extends Internal.Enum<Internal.FormatStyle> {
        static values(): Internal.FormatStyle[];
        static valueOf(arg0: string): Internal.FormatStyle;
        static readonly SHORT: Internal.FormatStyle;
        static readonly FULL: Internal.FormatStyle;
        static readonly LONG: Internal.FormatStyle;
        static readonly MEDIUM: Internal.FormatStyle;
    }
    type FormatStyle_ = "medium" | "short" | "full" | FormatStyle | "long";
    class EntityRadarCategory extends Internal.FilterObjectCategory<Internal.Entity, Internal.Player, any, Internal.EntityRadarCategory> {
    }
    type EntityRadarCategory_ = EntityRadarCategory;
    class ReflectionAccessFilter$FilterResult extends Internal.Enum<Internal.ReflectionAccessFilter$FilterResult> {
        static values(): Internal.ReflectionAccessFilter$FilterResult[];
        static valueOf(arg0: string): Internal.ReflectionAccessFilter$FilterResult;
        static readonly ALLOW: Internal.ReflectionAccessFilter$FilterResult;
        static readonly BLOCK_INACCESSIBLE: Internal.ReflectionAccessFilter$FilterResult;
        static readonly INDECISIVE: Internal.ReflectionAccessFilter$FilterResult;
        static readonly BLOCK_ALL: Internal.ReflectionAccessFilter$FilterResult;
    }
    type ReflectionAccessFilter$FilterResult_ = ReflectionAccessFilter$FilterResult | "block_all" | "allow" | "block_inaccessible" | "indecisive";
    class TrackMaterial$TrackType {
        constructor(id: ResourceLocation_, factory: any_)
        static readonly STANDARD: Internal.TrackMaterial$TrackType;
        readonly id: ResourceLocation;
    }
    type TrackMaterial$TrackType_ = TrackMaterial$TrackType;
    class ObjectCategoryExcludeList <E, P, S> extends Internal.ObjectCategoryListRule<E, P, S> {
        spliterator(): Internal.Spliterator<string>;
        getExcludeMode(): Internal.ExcludeListMode;
        forEach(arg0: Internal.Consumer_<string>): void;
        get excludeMode(): Internal.ExcludeListMode
    }
    type ObjectCategoryExcludeList_<E, P, S> = ObjectCategoryExcludeList<E, P, S>;
    class LightBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static setLightOnStack($$0: Internal.ItemStack_, $$1: number): Internal.ItemStack;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MAX_LEVEL: 15;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly LIGHT_EMISSION: Internal.ToIntFunction<Internal.BlockState>;
        static readonly LEVEL: Internal.IntegerProperty;
    }
    type LightBlock_ = LightBlock;
    interface Float2ByteFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Float2IntFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Float2CharFunction;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Float2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2ByteFunction;
        put(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Float2FloatFunction;
        apply(arg0: number): number;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        getOrDefault(arg0: number, arg1: number): number;
        defaultReturnValue(): number;
        containsKey(arg0: number): boolean;
        remove(arg0: number): number;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2ByteFunction<T>;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2ByteFunction;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2ByteFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        clear(): void;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2ByteFunction;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Float2LongFunction;
        get(arg0: number): number;
        identity<T>(): Internal.Function<T, T>;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Float2DoubleFunction;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Float2ByteFunction_ = Float2ByteFunction;
    interface TextureStateShardAccessor {
        port_lib$mipmap(arg0: boolean): void;
        port_lib$blur(arg0: boolean): void;
    }
    type TextureStateShardAccessor_ = TextureStateShardAccessor;
    abstract class SupportType extends Internal.Enum<Internal.SupportType> {
        static values(): Internal.SupportType[];
        static valueOf($$0: string): Internal.SupportType;
        isSupporting(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        static readonly CENTER: Internal.SupportType;
        static readonly RIGID: Internal.SupportType;
        static readonly FULL: Internal.SupportType;
    }
    type SupportType_ = "center" | SupportType | "full" | "rigid";
    class GameNarrator {
        constructor($$0: Internal.Minecraft_)
        sayChat($$0: Internal.Component_): void;
        say($$0: Internal.Component_): void;
        sayNow($$0: string): void;
        updateNarratorStatus($$0: Internal.NarratorStatus_): void;
        checkStatus($$0: boolean): void;
        clear(): void;
        destroy(): void;
        sayNow($$0: Internal.Component_): void;
        isActive(): boolean;
        get active(): boolean
        static readonly NO_TITLE: Internal.MutableComponent;
        readonly narrator: Internal.Narrator;
    }
    type GameNarrator_ = GameNarrator;
    class ArgumentCommandNode <S, T> extends Internal.CommandNode<S> {
        constructor(arg0: string, arg1: Internal.ArgumentType_<T>, arg2: Internal.Command_<S>, arg3: Internal.Predicate_<S>, arg4: Internal.CommandNode_<S>, arg5: Internal.RedirectModifier_<S>, arg6: boolean, arg7: Internal.SuggestionProvider_<S>)
        getType(): Internal.ArgumentType<T>;
        isValidInput(arg0: string): boolean;
        createBuilder(): Internal.ArgumentBuilder<any, any>;
        getCustomSuggestions(): Internal.SuggestionProvider<S>;
        get type(): Internal.ArgumentType<T>
        get customSuggestions(): Internal.SuggestionProvider<S>
    }
    type ArgumentCommandNode_<S, T> = ArgumentCommandNode<S, T>;
    interface AbstractMinecartExtensions {
        create$getController(): Internal.MinecartController;
        readonly CAP_KEY: "Controller";
    }
    type AbstractMinecartExtensions_ = AbstractMinecartExtensions;
    class ImmutableSetMultimap$Builder <K, V> extends Internal.ImmutableMultimap$Builder<K, V> {
        constructor()
        put(arg0: Internal.Map$Entry_<K, V>): this;
        put(arg0: any, arg1: any): Internal.ImmutableMultimap$Builder<any, any>;
        build(): Internal.ImmutableMultimap<any, any>;
        orderValuesBy(arg0: Internal.Comparator_<V>): this;
        putAll(arg0: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: any, arg1: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: Internal.Multimap_<any, any>): Internal.ImmutableMultimap$Builder<any, any>;
        orderKeysBy(arg0: Internal.Comparator_<K>): this;
        putAll(arg0: any, arg1: any[]): Internal.ImmutableMultimap$Builder<any, any>;
    }
    type ImmutableSetMultimap$Builder_<K, V> = ImmutableSetMultimap$Builder<K, V>;
    class TreeSet <E> extends Internal.AbstractSet<E> implements Internal.Cloneable, Internal.NavigableSet<E>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Collection_<E>)
        constructor(arg0: Internal.Comparator_<E>)
        constructor(arg0: Internal.SortedSet_<E>)
        clone(): any;
        subSet(arg0: E, arg1: E): Internal.SortedSet<E>;
        tailSet(arg0: E, arg1: boolean): Internal.NavigableSet<E>;
        headSet(arg0: E, arg1: boolean): Internal.NavigableSet<E>;
        descendingSet(): Internal.NavigableSet<E>;
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        comparator(): Internal.Comparator<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        ceiling(arg0: E): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        descendingIterator(): Internal.Iterator<E>;
        last(): E;
        tailSet(arg0: E): Internal.SortedSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        lower(arg0: E): E;
        higher(arg0: E): E;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        headSet(arg0: E): Internal.SortedSet<E>;
        subSet(arg0: E, arg1: boolean, arg2: E, arg3: boolean): Internal.NavigableSet<E>;
        iterator(): Internal.Iterator<E>;
        pollFirst(): E;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        first(): E;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        floor(arg0: E): E;
        pollLast(): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
    }
    type TreeSet_<E> = TreeSet<E>;
    interface DispenserBlockAccessor {
        getDispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>;
        get dispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>
    }
    type DispenserBlockAccessor_ = DispenserBlockAccessor;
    interface Object2LongFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToLongFunction<K> {
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Object2FloatFunction<K>;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Object2ByteFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        removeLong(arg0: any): number;
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        containsKey(arg0: any): boolean;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2LongFunction;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        getLong(arg0: any): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2LongFunction;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2LongFunction<T>;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2LongFunction;
        applyAsLong(arg0: K): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2LongFunction;
        defaultReturnValue(): number;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Object2IntFunction<K>;
        apply(arg0: K): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2LongFunction;
        getOrDefault(arg0: any, arg1: number): number;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2LongFunction<T>;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Object2ShortFunction<K>;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2LongFunction;
        (arg0: any): number;
    }
    type Object2LongFunction_<K> = Object2LongFunction<K>;
    interface DoubleStream$Builder extends Internal.DoubleConsumer {
        add(arg0: number): this;
        accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        build(): Internal.DoubleStream;
    }
    type DoubleStream$Builder_ = DoubleStream$Builder;
    class Stray extends Internal.AbstractSkeleton implements Internal.IQuiverEntity {
        constructor($$0: Internal.EntityType_<Internal.Stray>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        supplementaries$getQuiver(): Internal.ItemStack;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        supplementaries$hasQuiver(): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        static checkStraySpawnRules($$0: Internal.EntityType_<Internal.Stray>, $$1: Internal.ServerLevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        supplementaries$setQuiver(quiver: Internal.ItemStack_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Stray_ = Stray;
    class FossilFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.List_<ResourceLocation>, $$1: Internal.List_<ResourceLocation>, $$2: Internal.Holder_<Internal.StructureProcessorList>, $$3: Internal.Holder_<Internal.StructureProcessorList>, $$4: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly overlayStructures: Internal.List<ResourceLocation>;
        readonly fossilStructures: Internal.List<ResourceLocation>;
        readonly maxEmptyCornersAllowed: number;
        readonly fossilProcessors: Internal.Holder<Internal.StructureProcessorList>;
        readonly overlayProcessors: Internal.Holder<Internal.StructureProcessorList>;
        static readonly CODEC: Internal.Codec<Internal.FossilFeatureConfiguration>;
    }
    type FossilFeatureConfiguration_ = FossilFeatureConfiguration;
    abstract class ImmutableMultiset <E> extends Internal.ImmutableMultisetGwtSerializationDependencies<E> implements Internal.Multiset<E> {
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: number): number;
        static copyOf<E>(arg0: E[]): Internal.ImmutableMultiset<E>;
        elementSet(): Internal.ImmutableSet<E>;
        /**
         * @deprecated
        */
        setCount(arg0: E, arg1: number): number;
        static toImmutableMultiset<T, E>(arg0: Internal.Function_<T, E>, arg1: Internal.ToIntFunction_<T>): Internal.Collector<T, any, Internal.ImmutableMultiset<E>>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableMultiset<E>;
        forEachEntry(arg0: Internal.ObjIntConsumer_<E>): void;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableMultiset<E>;
        parallelStream(): Internal.Stream<E>;
        static builder<E>(): Internal.ImmutableMultiset$Builder<E>;
        static of<E>(): Internal.ImmutableMultiset<E>;
        static of<E>(arg0: E): Internal.ImmutableMultiset<E>;
        count(arg0: any): number;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        /**
         * @deprecated
        */
        add(arg0: E, arg1: number): number;
        /**
         * @deprecated
        */
        setCount(arg0: E, arg1: number, arg2: number): boolean;
        entrySet(): Internal.ImmutableSet<Internal.Multiset$Entry<E>>;
        iterator(): Internal.Iterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, ...arg6: E[]): Internal.ImmutableMultiset<E>;
        static toImmutableMultiset<E>(): Internal.Collector<E, any, Internal.ImmutableMultiset<E>>;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableMultiset<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableMultiset<E>;
        toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableMultiset<E>;
        asList(): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableMultiset<E>;
        stream(): Internal.Stream<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
    }
    type ImmutableMultiset_<E> = ImmutableMultiset<E>;
    interface PackRepositoryAccessor {
        getSources(): Internal.Set<Internal.RepositorySource>;
        setSources(arg0: Internal.Set_<Internal.RepositorySource>): void;
        get sources(): Internal.Set<Internal.RepositorySource>
        set sources(arg0: Internal.Set_<Internal.RepositorySource>)
    }
    type PackRepositoryAccessor_ = PackRepositoryAccessor;
    class AtlasSpriteRegistryEventJS extends Internal.EventJS {
        constructor(registry: Internal.Consumer_<ResourceLocation>)
        register(id: ResourceLocation_): void;
    }
    type AtlasSpriteRegistryEventJS_ = AtlasSpriteRegistryEventJS;
    abstract class AmbientCreature extends Internal.Mob {
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AmbientCreature_ = AmbientCreature;
    class ServicesKeyType extends Internal.Enum<Internal.ServicesKeyType> {
        static valueOf(arg0: string): Internal.ServicesKeyType;
        static values(): Internal.ServicesKeyType[];
        static readonly PROFILE_KEY: Internal.ServicesKeyType;
        static readonly PROFILE_PROPERTY: Internal.ServicesKeyType;
    }
    type ServicesKeyType_ = ServicesKeyType | "profile_property" | "profile_key";
    class IngredientActionFilter {
        constructor()
        static filterOf(o: any): Internal.IngredientActionFilter;
        copyFrom(filter: Internal.IngredientActionFilter_): void;
        checkFilter(index: number, stack: Internal.ItemStack_): boolean;
        filterIngredient: Internal.Ingredient;
        filterIndex: number;
    }
    type IngredientActionFilter_ = number | Internal.Ingredient_ | IngredientActionFilter | {item: Internal.Ingredient_, index?: number};
    class EndIslandFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type EndIslandFeature_ = EndIslandFeature;
    interface ObjectList <K> extends Internal.ObjectCollection<K>, Internal.List<K>, Internal.Comparable<Internal.List<K>> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        addAll(arg0: Internal.Collection_<K>): boolean;
        setElements(arg0: number, arg1: K[]): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        set(arg0: number, arg1: K): K;
        parallelStream(): Internal.Stream<K>;
        addAll(arg0: number, arg1: Internal.Collection_<K>): boolean;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(): this;
        addElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        setElements(arg0: K[]): void;
        of<K>(...arg0: K[]): this;
        listIterator(): Internal.ListIterator<any>;
        size(arg0: number): void;
        remove(arg0: number): K;
        of<K>(arg0: K, arg1: K, arg2: K): this;
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        spliterator(): Internal.Spliterator<any>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        add(arg0: K): boolean;
        lastIndexOf(arg0: any): number;
        setElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        removeElements(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        isEmpty(): boolean;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        addElements(arg0: number, arg1: K[]): void;
        listIterator(arg0: number): Internal.ObjectListIterator<K>;
        subList(arg0: number, arg1: number): this;
        of<K>(arg0: K): this;
        get(arg0: number): K;
        contains(arg0: any): boolean;
        addAll(arg0: number, arg1: Internal.ObjectList_<K>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        iterator(): Internal.Iterator<any>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        add(arg0: number, arg1: K): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        replaceAll(arg0: Internal.UnaryOperator_<K>): void;
        of<K>(arg0: K, arg1: K): this;
        addAll(arg0: Internal.ObjectList_<K>): boolean;
        unstableSort(arg0: Internal.Comparator_<K>): void;
        hashCode(): number;
        size(): number;
        compareTo(arg0: Internal.List_<K>): number;
        sort(arg0: Internal.Comparator_<K>): void;
        clear(): void;
        equals(arg0: any): boolean;
        stream(): Internal.Stream<K>;
        getElements(arg0: number, arg1: any[], arg2: number, arg3: number): void;
        set elements(arg0: K[])
        get empty(): boolean
    }
    type ObjectList_<K> = ObjectList<K>;
    interface LongStream extends Internal.BaseStream<number, Internal.LongStream> {
        parallel(): this;
        allMatch(arg0: Internal.LongPredicate_): boolean;
        isParallel(): boolean;
        sum(): number;
        toArray(): number[];
        forEach(arg0: Internal.LongConsumer_): void;
        max(): Internal.OptionalLong;
        count(): number;
        iterate(arg0: number, arg1: Internal.LongUnaryOperator_): this;
        of(arg0: number): this;
        empty(): this;
        distinct(): this;
        flatMap(arg0: Internal.LongFunction_<Internal.LongStream>): this;
        min(): Internal.OptionalLong;
        mapToDouble(arg0: Internal.LongToDoubleFunction_): Internal.DoubleStream;
        findFirst(): Internal.OptionalLong;
        reduce(arg0: Internal.LongBinaryOperator_): Internal.OptionalLong;
        boxed(): Internal.Stream<number>;
        reduce(arg0: number, arg1: Internal.LongBinaryOperator_): number;
        generate(arg0: Internal.LongSupplier_): this;
        builder(): Internal.LongStream$Builder;
        limit(arg0: number): this;
        mapMulti(arg0: Internal.LongStream$LongMapMultiConsumer_): this;
        mapToObj<U>(arg0: Internal.LongFunction_<U>): Internal.Stream<U>;
        range(arg0: number, arg1: number): this;
        rangeClosed(arg0: number, arg1: number): this;
        onClose(arg0: Internal.Runnable_): this;
        sequential(): Internal.BaseStream<any, any>;
        peek(arg0: Internal.LongConsumer_): this;
        sorted(): this;
        summaryStatistics(): Internal.LongSummaryStatistics;
        of(...arg0: number[]): this;
        anyMatch(arg0: Internal.LongPredicate_): boolean;
        iterator(): Internal.Iterator<any>;
        findAny(): Internal.OptionalLong;
        skip(arg0: number): this;
        map(arg0: Internal.LongUnaryOperator_): this;
        spliterator(): Internal.Spliterator$OfLong;
        takeWhile(arg0: Internal.LongPredicate_): this;
        asDoubleStream(): Internal.DoubleStream;
        iterate(arg0: number, arg1: Internal.LongPredicate_, arg2: Internal.LongUnaryOperator_): this;
        filter(arg0: Internal.LongPredicate_): this;
        unordered(): this;
        forEachOrdered(arg0: Internal.LongConsumer_): void;
        close(): void;
        dropWhile(arg0: Internal.LongPredicate_): this;
        mapToInt(arg0: Internal.LongToIntFunction_): Internal.IntStream;
        noneMatch(arg0: Internal.LongPredicate_): boolean;
        concat(arg0: Internal.LongStream_, arg1: Internal.LongStream_): this;
        average(): Internal.OptionalDouble;
        collect<R>(arg0: Internal.Supplier_<R>, arg1: Internal.ObjLongConsumer_<R>, arg2: Internal.BiConsumer_<R, R>): R;
        get parallel(): boolean
    }
    type LongStream_ = LongStream;
    class Properties extends Internal.Hashtable<any, any> {
        constructor()
        constructor(arg0: number)
        constructor(arg0: Internal.Properties_)
        store(arg0: Internal.OutputStream_, arg1: string): void;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: Internal.Charset_): void;
        /**
         * @deprecated
        */
        save(arg0: Internal.OutputStream_, arg1: string): void;
        stringPropertyNames(): Internal.Set<string>;
        storeToXML(arg0: Internal.OutputStream_, arg1: string): void;
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(): Internal.Map<K, V>;
        list(arg0: Internal.PrintWriter_): void;
        getProperty(arg0: string, arg1: string): string;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        keys(): Internal.Enumeration<any>;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        setProperty(arg0: string, arg1: string): any;
        store(arg0: Internal.Writer_, arg1: string): void;
        put(arg0: any, arg1: any): any;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        load(arg0: Internal.Reader_): void;
        load(arg0: Internal.InputStream_): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        loadFromXML(arg0: Internal.InputStream_): void;
        computeIfAbsent(arg0: any, arg1: Internal.Function_<any, any>): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        propertyNames(): Internal.Enumeration<any>;
        list(arg0: Internal.PrintStream_): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        elements(): Internal.Enumeration<any>;
        entrySet(): Internal.Set<Internal.Map$Entry<any, any>>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        getProperty(arg0: string): string;
        replace(arg0: any, arg1: any): any;
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        remove(arg0: any): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        get(arg0: any): any;
        compute(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: string): void;
        computeIfPresent(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        putIfAbsent(arg0: any, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type Properties_ = Properties;
    interface PackRepositoryFabricAccessor {
        puzzleslib$getSources(): Internal.Set<Internal.RepositorySource>;
        puzzleslib$setSources(arg0: Internal.Set_<Internal.RepositorySource>): void;
    }
    type PackRepositoryFabricAccessor_ = PackRepositoryFabricAccessor;
    abstract class AbstractObject2ByteFunction <K> implements Internal.Object2ByteFunction<K>, Internal.Serializable {
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Object2IntFunction<K>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ByteFunction;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ByteFunction;
        removeByte(arg0: any): number;
        andThenByte(arg0: Internal.Byte2ByteFunction_): Internal.Object2ByteFunction<K>;
        apply(arg0: K): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ByteFunction;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Object2FloatFunction<K>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        applyAsInt(arg0: K): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        getByte(arg0: any): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Object2ShortFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ByteFunction;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ByteFunction<T>;
        clear(): void;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ByteFunction;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        static identity<T>(): Internal.Function<T, T>;
    }
    type AbstractObject2ByteFunction_<K> = AbstractObject2ByteFunction<K>;
    interface Executor {
        execute(arg0: Internal.Runnable_): void;
    }
    type Executor_ = Executor;
    interface ThreadedAnvilChunkStorageAccessor {
        getEntityTrackers(): Internal.Int2ObjectMap<Internal.EntityTrackerAccessor>;
        get entityTrackers(): Internal.Int2ObjectMap<Internal.EntityTrackerAccessor>
    }
    type ThreadedAnvilChunkStorageAccessor_ = ThreadedAnvilChunkStorageAccessor;
    abstract class AbstractDragonSittingPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
    }
    type AbstractDragonSittingPhase_ = AbstractDragonSittingPhase;
    interface ByteProcessor {
        process(arg0: number): boolean;
        readonly FIND_NUL: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_LINEAR_WHITESPACE: Internal.ByteProcessor;
        readonly FIND_CRLF: Internal.ByteProcessor;
        readonly FIND_SEMI_COLON: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_CR: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_LF: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_CR: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_LF: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_NON_NUL: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_ASCII_SPACE: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_LINEAR_WHITESPACE: Internal.ByteProcessor;
        readonly FIND_NON_CRLF: Internal.ByteProcessor;
        readonly FIND_COMMA: Internal.ByteProcessor$IndexOfProcessor;
    }
    type ByteProcessor_ = ByteProcessor;
    class SculkCatalystBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly PULSE: Internal.BooleanProperty;
    }
    type SculkCatalystBlock_ = SculkCatalystBlock;
    class MapRegion extends Internal.LeveledRegion<Internal.LeafRegionTexture> implements Internal.MapRegionInfo {
        constructor(worldId: string, dimId: string, mwId: string, dim: Internal.MapDimension_, x: number, z: number, caveLayer: number, initialVersion: number, normalMapData: boolean, biomeRegistry: Internal.Registry_<Internal.Biome>)
        setOutdatedWithOtherLayers(outdatedWithOtherLayers: boolean): void;
        cancelRefresh(mapProcessor: Internal.MapProcessor_): void;
        getDimId(): string;
        isResaving(): boolean;
        isResting(): boolean;
        destroyBufferUpdateObjects(): void;
        caveStartOutdated(currentCaveStart: number, currentCaveDepth: number): boolean;
        requestRefresh(mapProcessor: Internal.MapProcessor_, prepareHighlights: boolean): void;
        shouldConvertCacheToOutdatedOnFinishDim(): boolean;
        getTargetHighlightsHash(): number;
        getInitialVersion(): number;
        setVersion(version: number): void;
        getMwId(): string;
        setHighlightsHash(highlightsHash: number): void;
        getLoadState(): number;
        setBeingWritten(beingWritten: boolean): void;
        setChunk(x: number, z: number, chunk: Internal.MapTileChunk_): void;
        getHighlightsHash(): number;
        updateTargetHighlightsHash(): void;
        getLastVisited(): number;
        convertCacheToOutdated(mapSaveLoad: Internal.MapSaveLoad_, reason: string): void;
        isBeingWritten(): boolean;
        isWritingPaused(): boolean;
        getLastSaveTime(): number;
        createTexture(x: number, y: number): Internal.LeafRegionTexture;
        popWriterPause(): void;
        setLastSaveTime(lastSaveTime: number): void;
        hasHadTerrain(): boolean;
        isOutdatedWithOtherLayers(): boolean;
        getVersion(): number;
        pushWriterPause(): void;
        setResaving(resaving: boolean): void;
        getSaveExists(): boolean;
        getReloadVersion(): number;
        countChunks(): number;
        getCaveStart(): number;
        setSaveExists(saveExists: boolean): void;
        getWorldId(): string;
        requestRefresh(mapProcessor: Internal.MapProcessor_): void;
        getChunk(x: number, z: number): Internal.MapTileChunk;
        registerVisit(): void;
        isNormalMapData(): boolean;
        setReloadVersion(reloadVersion: number): void;
        getMutableGlobalPos(): Internal.BlockPos$MutableBlockPos;
        setRefreshing(isRefreshing: boolean): void;
        getUpToDateCaveStart(): number;
        setLookedForCache(lookedForCache: boolean): void;
        getRegionFile(): Internal.File;
        hasVersion(): boolean;
        restoreMetaData(cachedTextureVersions: number[][], cacheHashCode: number, reloadVersion: number, highlightsHash: number, caveStart: number, outdatedWithOtherLayers: boolean, mapProcessor: Internal.MapProcessor_): void;
        getPixelResultBuffer(): number[];
        clean(mapProcessor: Internal.MapProcessor_): void;
        setParent(parent: Internal.BranchLeveledRegion_): void;
        clearRegion(mapProcessor: Internal.MapProcessor_): void;
        getCaveDepth(): number;
        getCacheHashCode(): number;
        canRequestReload_unsynced(): boolean;
        putTexture(x: number, y: number, texture: Internal.LeafRegionTexture_): void;
        hasLookedForCache(): boolean;
        updateCaveMode(): void;
        getBiomeRegistry(): Internal.Registry<Internal.Biome>;
        getTexture(x: number, y: number): Internal.LeafRegionTexture;
        restoreBufferUpdateObjects(): void;
        setCaveStart(caveStart: number): void;
        setRegionFile(loadedFromFile: Internal.File_): void;
        setInitialVersion(initialVersion: number): void;
        setLoadState(loadState: number): void;
        setCacheHashCode(cacheHashCode: number): void;
        setHasHadTerrain(): void;
        unsetHasHadTerrain(): void;
        getTimeSinceVisit(): number;
        set outdatedWithOtherLayers(outdatedWithOtherLayers: boolean)
        get dimId(): string
        get resaving(): boolean
        get resting(): boolean
        get targetHighlightsHash(): number
        get initialVersion(): number
        set version(version: number)
        get mwId(): string
        set highlightsHash(highlightsHash: number)
        get loadState(): number
        set beingWritten(beingWritten: boolean)
        get highlightsHash(): number
        get lastVisited(): number
        get beingWritten(): boolean
        get writingPaused(): boolean
        get lastSaveTime(): number
        set lastSaveTime(lastSaveTime: number)
        get outdatedWithOtherLayers(): boolean
        get version(): number
        set resaving(resaving: boolean)
        get saveExists(): boolean
        get reloadVersion(): number
        get caveStart(): number
        set saveExists(saveExists: boolean)
        get worldId(): string
        get normalMapData(): boolean
        set reloadVersion(reloadVersion: number)
        get mutableGlobalPos(): Internal.BlockPos$MutableBlockPos
        set refreshing(isRefreshing: boolean)
        get upToDateCaveStart(): number
        set lookedForCache(lookedForCache: boolean)
        get regionFile(): Internal.File
        get pixelResultBuffer(): number[]
        set parent(parent: Internal.BranchLeveledRegion_)
        get caveDepth(): number
        get cacheHashCode(): number
        get biomeRegistry(): Internal.Registry<Internal.Biome>
        set caveStart(caveStart: number)
        set regionFile(loadedFromFile: Internal.File_)
        set initialVersion(initialVersion: number)
        set loadState(loadState: number)
        set cacheHashCode(cacheHashCode: number)
        get timeSinceVisit(): number
        readonly writerThreadPauseSync: any;
        static readonly SIDE_LENGTH: 8;
        loadingPrioritized: boolean;
        loadingNeededForBranchLevel: number;
    }
    type MapRegion_ = MapRegion;
    interface ISoundLists {
        readonly muffledSounds: {};
        readonly anchorList: [Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor, Internal.Anchor];
        readonly soundsList: Internal.SortedSet<ResourceLocation>;
        readonly forbiddenSounds: Internal.Set<string>;
        readonly recentSoundsList: Internal.SortedSet<ResourceLocation>;
    }
    type ISoundLists_ = ISoundLists;
    class SynchedEntityData implements Internal.DataTrackerAccessor, eu.pb4.polymer.common.mixin.DataTrackerAccessor {
        constructor($$0: Internal.Entity_)
        assignValues($$0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        set<T>($$0: Internal.EntityDataAccessor_<T>, $$1: T): void;
        get<T>($$0: Internal.EntityDataAccessor_<T>): T;
        getEntries(): Internal.Int2ObjectMap<any>;
        packDirty(): Internal.List<Internal.SynchedEntityData$DataValue<any>>;
        static defineId<T>($$0: typeof Internal.Entity, $$1: Internal.EntityDataSerializer_<T>): Internal.EntityDataAccessor<T>;
        getNonDefaultValues(): Internal.List<Internal.SynchedEntityData$DataValue<any>>;
        set<T>($$0: Internal.EntityDataAccessor_<T>, $$1: T, $$2: boolean): void;
        hasItem<T>($$0: Internal.EntityDataAccessor_<T>): boolean;
        isEmpty(): boolean;
        isDirty(): boolean;
        define<T>($$0: Internal.EntityDataAccessor_<T>, $$1: T): void;
        get entries(): Internal.Int2ObjectMap<any>
        get nonDefaultValues(): Internal.List<Internal.SynchedEntityData$DataValue<any>>
        get empty(): boolean
        get dirty(): boolean
        lock: Internal.ReadWriteLock;
        static readonly ENTITY_ID_POOL: {[key: typeof any]: 20, [key: typeof any]: 14, [key: typeof any]: 10, [key: typeof any]: 16, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 18, [key: typeof any]: 17, [key: typeof any]: 8, [key: typeof any]: 16, [key: typeof any]: 21, [key: typeof any]: 15, [key: typeof any]: 14, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 18, [key: typeof any]: 19, [key: typeof any]: 20, [key: typeof any]: 18, [key: typeof any]: 16, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 18, [key: typeof any]: 18, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 8, [key: typeof any]: 18, [key: typeof any]: 11, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 9, [key: typeof any]: 18, [key: typeof any]: 11, [key: typeof any]: 18, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 8, [key: typeof any]: 17, [key: typeof any]: 18, [key: typeof any]: 18, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 9, [key: typeof any]: 17, [key: typeof any]: 16, [key: typeof any]: 16, [key: typeof any]: 16, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 26, [key: typeof any]: 15, [key: typeof any]: 19, [key: typeof any]: 19, [key: typeof any]: 18, [key: typeof any]: 22, [key: typeof any]: 19, [key: typeof any]: 16, [key: typeof any]: 18, [key: typeof any]: 8, [key: typeof any]: 19, [key: typeof any]: 16, [key: typeof any]: 16, [key: typeof any]: 7, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 18, [key: typeof any]: 14, [key: typeof any]: 20, [key: typeof any]: 19, [key: typeof any]: 18, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 19, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 17, [key: typeof any]: 16, [key: typeof any]: 10, [key: typeof any]: 21, [key: typeof any]: 16, [key: typeof any]: 18, [key: typeof any]: 19, [key: typeof any]: 17, [key: typeof any]: 18, [key: typeof any]: 18, [key: typeof any]: 21, [key: typeof any]: 17, [key: typeof any]: 16, [key: typeof any]: 16, [key: typeof any]: 8, [key: typeof any]: 21, [key: typeof any]: 28, [key: typeof any]: 10, [key: typeof any]: 19, [key: typeof any]: 11, [key: typeof any]: 23, [key: typeof any]: 13, [key: typeof any]: 20, [key: typeof any]: 16, [key: typeof any]: 19, [key: typeof any]: 17, [key: typeof any]: 17, [key: typeof any]: 31, [key: typeof any]: 8, [key: typeof any]: 21, [key: typeof any]: 16, [key: typeof any]: 18, [key: typeof any]: 9, [key: typeof any]: 20, [key: typeof any]: 9, [key: typeof any]: 8, [key: typeof any]: 19, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 19, [key: typeof any]: 16, [key: typeof any]: 21, [key: typeof any]: 23, [key: typeof any]: 16, [key: typeof any]: 13, [key: typeof any]: 17, [key: typeof any]: 9, [key: typeof any]: 21, [key: typeof any]: 18, [key: typeof any]: 19, [key: typeof any]: 17, [key: typeof any]: 16, [key: typeof any]: 8, [key: typeof any]: 19, [key: typeof any]: 21};
        itemsById: Internal.Int2ObjectMap<Internal.SynchedEntityData$DataItem<any>>;
    }
    type SynchedEntityData_ = SynchedEntityData;
    class MultifaceSpreader {
        constructor($$0: Internal.MultifaceBlock_)
        constructor($$0: any_)
        canSpreadInAnyDirection($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_): boolean;
        spreadAll($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: boolean): number;
        spreadFromFaceTowardDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.Direction_, $$5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromRandomFaceTowardRandomDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.RandomSource_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        getSpreadFromFaceTowardDirection($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.Direction_, $$5: Internal.MultifaceSpreader$SpreadPredicate_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromFaceTowardRandomDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.RandomSource_, $$5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadToFace($$0: Internal.LevelAccessor_, $$1: Internal.MultifaceSpreader$SpreadPos_, $$2: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        static readonly DEFAULT_SPREAD_ORDER: any[];
    }
    type MultifaceSpreader_ = MultifaceSpreader;
    interface ScreenKeyboardEvents$AfterKeyRelease {
        afterKeyRelease(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenKeyboardEvents$AfterKeyRelease_ = ScreenKeyboardEvents$AfterKeyRelease;
    class ChronoUnit extends Internal.Enum<Internal.ChronoUnit> implements Internal.TemporalUnit {
        between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): number;
        isTimeBased(): boolean;
        static valueOf(arg0: string): Internal.ChronoUnit;
        addTo<R extends Internal.Temporal>(arg0: R, arg1: number): R;
        getDuration(): Duration;
        isDateBased(): boolean;
        isSupportedBy(arg0: Internal.Temporal_): boolean;
        isDurationEstimated(): boolean;
        static values(): Internal.ChronoUnit[];
        get timeBased(): boolean
        get duration(): Duration
        get dateBased(): boolean
        get durationEstimated(): boolean
        static readonly NANOS: Internal.ChronoUnit;
        static readonly ERAS: Internal.ChronoUnit;
        static readonly MINUTES: Internal.ChronoUnit;
        static readonly HOURS: Internal.ChronoUnit;
        static readonly MONTHS: Internal.ChronoUnit;
        static readonly HALF_DAYS: Internal.ChronoUnit;
        static readonly MILLIS: Internal.ChronoUnit;
        static readonly DAYS: Internal.ChronoUnit;
        static readonly SECONDS: Internal.ChronoUnit;
        static readonly WEEKS: Internal.ChronoUnit;
        static readonly MILLENNIA: Internal.ChronoUnit;
        static readonly DECADES: Internal.ChronoUnit;
        static readonly MICROS: Internal.ChronoUnit;
        static readonly FOREVER: Internal.ChronoUnit;
        static readonly CENTURIES: Internal.ChronoUnit;
        static readonly YEARS: Internal.ChronoUnit;
    }
    type ChronoUnit_ = "minutes" | "years" | "weeks" | "decades" | "eras" | "half_days" | "centuries" | "hours" | "forever" | "months" | "millennia" | "micros" | "nanos" | "seconds" | "days" | "millis" | ChronoUnit;
    interface ChunkScanAccess {
        scanChunk(arg0: Internal.ChunkPos_, arg1: Internal.StreamTagVisitor_): Internal.CompletableFuture<void>;
    }
    type ChunkScanAccess_ = ChunkScanAccess;
    class EventJS {
        constructor()
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
    }
    type EventJS_ = EventJS;
    abstract class LongBuffer extends Internal.Buffer implements Internal.Comparable<Internal.LongBuffer> {
        limit(arg0: number): this;
        compareTo(arg0: any): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        duplicate(): this;
        order(): Internal.ByteOrder;
        mismatch(arg0: Internal.LongBuffer_): number;
        compareTo(arg0: Internal.LongBuffer_): number;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        put(arg0: number, arg1: number): this;
        static allocate(arg0: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[]): this;
        get(arg0: number, arg1: number[]): this;
        get(): number;
        get(arg0: number[]): this;
        position(arg0: number): this;
        put(arg0: number[]): this;
        put(arg0: number): this;
        asReadOnlyBuffer(): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        static wrap(arg0: number[]): Internal.LongBuffer;
        put(arg0: Internal.LongBuffer_): this;
        put(arg0: number, arg1: Internal.LongBuffer_, arg2: number, arg3: number): this;
        get(arg0: number): number;
        array(): number[];
        get(arg0: number[], arg1: number, arg2: number): this;
        compact(): this;
    }
    type LongBuffer_ = LongBuffer;
    class GameConfig$UserData {
        constructor($$0: Internal.User_, $$1: Internal.PropertyMap_, $$2: Internal.PropertyMap_, $$3: Internal.Proxy_)
        readonly user: Internal.User;
        readonly userProperties: Internal.PropertyMap;
        readonly proxy: Internal.Proxy;
        readonly profileProperties: Internal.PropertyMap;
    }
    type GameConfig$UserData_ = GameConfig$UserData;
    interface IColor {
        getName(): string;
        method_27716(): number;
        isAnimated(): boolean;
        get name(): string
        get animated(): boolean
    }
    type IColor_ = IColor;
    class ElderGuardian extends Internal.Guardian {
        constructor($$0: Internal.EntityType_<Internal.ElderGuardian>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ELDER_SIZE_SCALE: 2.35;
    }
    type ElderGuardian_ = ElderGuardian;
    interface SpecialEquality {
        checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        specialEquals(o: any, shallow: boolean): boolean;
    }
    type SpecialEquality_ = SpecialEquality;
    class Direction extends Internal.Enum<Internal.Direction> implements Internal.StringRepresentable {
        static fromYRot($$0: number): Internal.Direction;
        static valueOf($$0: string): Internal.Direction;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getX(): number;
        getY(): number;
        getHorizontalIndex(): number;
        getNormal(): Vec3i;
        getSerializedName(): string;
        getIndex(): number;
        getClockWise(): this;
        getAxis(): Internal.Direction$Axis;
        static getNearest($$0: number, $$1: number, $$2: number): Internal.Direction;
        static getRandom(rand: Internal.RandomSource_): Internal.Direction;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static orderedByNearest($$0: Internal.Entity_): Internal.Direction[];
        getClockWise($$0: Internal.Direction$Axis_): this;
        static getFacingAxis($$0: Internal.Entity_, $$1: Internal.Direction$Axis_): Internal.Direction;
        getPitch(): number;
        static values(): Internal.Direction[];
        static fromDelta($$0: number, $$1: number, $$2: number): Internal.Direction;
        getName(): string;
        getZ(): number;
        static fromAxisAndDirection($$0: Internal.Direction$Axis_, $$1: Internal.Direction$AxisDirection_): Internal.Direction;
        getOpposite(): this;
        static from2DDataValue($$0: number): Internal.Direction;
        step(): Vec3f;
        static stream(): Internal.Stream<Internal.Direction>;
        getAxisDirection(): Internal.Direction$AxisDirection;
        getCounterClockWise($$0: Internal.Direction$Axis_): this;
        static from3DDataValue($$0: number): Internal.Direction;
        static rotate($$0: Matrix4f_, $$1: Internal.Direction_): Internal.Direction;
        isFacingAngle($$0: number): boolean;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static byName($$0: string): Internal.Direction;
        static getNearest(x: number, y: number, z: number): Internal.Direction;
        getYaw(): number;
        static allShuffled($$0: Internal.RandomSource_): Internal.Collection<Internal.Direction>;
        getRotation(): Quaternionf;
        static get($$0: Internal.Direction$AxisDirection_, $$1: Internal.Direction$Axis_): Internal.Direction;
        getCounterClockWise(): this;
        get x(): number
        get y(): number
        get horizontalIndex(): number
        get normal(): Vec3i
        get serializedName(): string
        get index(): number
        get clockWise(): Internal.Direction
        get axis(): Internal.Direction$Axis
        get pitch(): number
        get name(): string
        get z(): number
        get opposite(): Internal.Direction
        get axisDirection(): Internal.Direction$AxisDirection
        get yaw(): number
        get rotation(): Quaternionf
        get counterClockWise(): Internal.Direction
        static readonly UP: Internal.Direction;
        static readonly NORTH: Internal.Direction;
        static readonly DOWN: Internal.Direction;
        static readonly EAST: Internal.Direction;
        static readonly WEST: Internal.Direction;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Direction>;
        static readonly SOUTH: Internal.Direction;
        static readonly VERTICAL_CODEC: Internal.Codec<Internal.Direction>;
    }
    type Direction_ = "west" | "east" | "south" | "up" | "down" | "north" | Direction;
    class SpawnData extends Internal.Record {
        constructor()
        constructor($$0: Internal.CompoundTag_, $$1: Internal.Optional_<Internal.SpawnData$CustomSpawnRules>)
        customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        getEntityToSpawn(): Internal.CompoundTag;
        entityToSpawn(): Internal.CompoundTag;
        getCustomSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        get entityToSpawn(): Internal.CompoundTag
        get customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>
        static readonly LIST_CODEC: Internal.Codec<Internal.SimpleWeightedRandomList<Internal.SpawnData>>;
        static readonly CODEC: Internal.Codec<Internal.SpawnData>;
        static readonly ENTITY_TAG: "entity";
    }
    type SpawnData_ = SpawnData;
    interface ClientBlockApiCache {
        init(): void;
        invalidate(): void;
    }
    type ClientBlockApiCache_ = ClientBlockApiCache;
    interface DynamicLightSource {
        dynamicLightTick(): void;
        shouldUpdateDynamicLight(): boolean;
        lambdynlights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        resetDynamicLight(): void;
        getDynamicLightX(): number;
        getDynamicLightY(): number;
        setDynamicLightEnabled(enabled: boolean): void;
        isDynamicLightEnabled(): boolean;
        lambdynlights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        getDynamicLightZ(): number;
        getDynamicLightWorld(): Internal.Level;
        getLuminance(): number;
        get dynamicLightX(): number
        get dynamicLightY(): number
        set dynamicLightEnabled(enabled: boolean)
        get dynamicLightEnabled(): boolean
        get dynamicLightZ(): number
        get dynamicLightWorld(): Internal.Level
        get luminance(): number
    }
    type DynamicLightSource_ = DynamicLightSource;
    interface ItemBuilder$ReleaseUsingCallback {
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        (arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
    }
    type ItemBuilder$ReleaseUsingCallback_ = ItemBuilder$ReleaseUsingCallback;
    interface WatchKey {
        isValid(): boolean;
        pollEvents(): Internal.List<Internal.WatchEvent<any>>;
        watchable(): Internal.Watchable;
        reset(): boolean;
        cancel(): void;
        get valid(): boolean
    }
    type WatchKey_ = WatchKey;
    interface ServerPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getSpawnLocation(): Internal.BlockContainerJS;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setSpawnLocation(c: Internal.BlockContainerJS_): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        openGUI(gui: Internal.Consumer_<Internal.KubeJSGUI>): void;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isOp(): boolean;
        kick(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(renderer: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        openChestGUI(title: Internal.Component_, rows: number, gui: Internal.Consumer_<Internal.ChestMenuData>): void;
        notify(title: Internal.Component_, text: Internal.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        setXpLevel(l: number): void;
        getCraftingGrid(): Internal.InventoryKJS;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        setXp(xp: number): void;
        setCreativeMode(mode: boolean): void;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(builder: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): Internal.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        ban(banner: string, reason: string, expiresInMillis: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        revokeAdvancement(id: ResourceLocation_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        kick(reason: Internal.Component_): void;
        isAdvancementDone(id: ResourceLocation_): boolean;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        unlockAdvancement(id: ResourceLocation_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getData(): Internal.AttachedData<Internal.Player>;
        openInventoryGUI(inventory: Internal.InventoryKJS_, title: Internal.Component_): void;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get spawnLocation(): Internal.BlockContainerJS
        get offHandItem(): Internal.ItemStack
        set spawnLocation(c: Internal.BlockContainerJS_)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get op(): boolean
        get totalMovementSpeed(): number
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set xpLevel(l: number)
        get craftingGrid(): Internal.InventoryKJS
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        set creativeMode(mode: boolean)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
    }
    type ServerPlayerKJS_ = ServerPlayerKJS;
    class Rotation extends Internal.Enum<Internal.Rotation> implements Internal.StringRepresentable {
        rotate($$0: Internal.Direction_): Internal.Direction;
        static getRandom($$0: Internal.RandomSource_): Internal.Rotation;
        static valueOf($$0: string): Internal.Rotation;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        rotation(): Internal.OctahedralGroup;
        static values(): Internal.Rotation[];
        rotate($$0: number, $$1: number): number;
        getRotated($$0: Internal.Rotation_): this;
        static getShuffled($$0: Internal.RandomSource_): Internal.List<Internal.Rotation>;
        get serializedName(): string
        static readonly CODEC: Internal.Codec<Internal.Rotation>;
        static readonly NONE: Internal.Rotation;
        static readonly CLOCKWISE_90: Internal.Rotation;
        static readonly CLOCKWISE_180: Internal.Rotation;
        static readonly COUNTERCLOCKWISE_90: Internal.Rotation;
    }
    type Rotation_ = "clockwise_90" | "clockwise_180" | "counterclockwise_90" | Rotation | "none";
    class TrackTargetingBehaviour$RenderedTrackOverlayType extends Internal.Enum<Internal.TrackTargetingBehaviour$RenderedTrackOverlayType> {
        static valueOf(name: string): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static values(): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType[];
        static readonly STATION: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly DUAL_SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly OBSERVER: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
    }
    type TrackTargetingBehaviour$RenderedTrackOverlayType_ = "dual_signal" | TrackTargetingBehaviour$RenderedTrackOverlayType | "signal" | "station" | "observer";
    interface NonNullSupplier <T> extends Internal.Supplier<T> {
        of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): this;
        lazy(): this;
        of<T>(sup: Internal.Supplier_<T>): this;
        get(): T;
        lazy<T>(sup: Internal.Supplier_<T>): this;
        (): T;
    }
    type NonNullSupplier_<T> = NonNullSupplier<T>;
    interface IBossHealthPushBox {
        setLastBossHealthHeight(arg0: number): void;
        setActive(arg0: boolean): void;
        set lastBossHealthHeight(arg0: number)
        set active(arg0: boolean)
    }
    type IBossHealthPushBox_ = IBossHealthPushBox;
    class ServerStatus extends Internal.Record implements Internal.ServerDataExtension {
        constructor($$0: Internal.Component_, $$1: Internal.Optional_<Internal.ServerStatus$Players>, $$2: Internal.Optional_<Internal.ServerStatus$Version>, $$3: Internal.Optional_<Internal.ServerStatus$Favicon>, $$4: boolean)
        description(): Internal.Component;
        enforcesSecureChat(): boolean;
        setPreventsChatReports(prevents: boolean): void;
        preventsChatReports(): boolean;
        handler$iia000$nochatreports$onSecureChatCheck(info: Internal.CallbackInfoReturnable_<any>): void;
        favicon(): Internal.Optional<Internal.ServerStatus$Favicon>;
        version(): Internal.Optional<Internal.ServerStatus$Version>;
        players(): Internal.Optional<Internal.ServerStatus$Players>;
        set preventsChatReports(prevents: boolean)
        static readonly CODEC: Internal.Codec<Internal.ServerStatus>;
    }
    type ServerStatus_ = ServerStatus;
    class EnumGetMethod extends Internal.Enum<Internal.EnumGetMethod> {
        isCaseSensitive(): boolean;
        static values(): Internal.EnumGetMethod[];
        isOrdinalOk(): boolean;
        validate<T extends Internal.Enum<T>>(value: any, enumType: T): boolean;
        get<T extends Internal.Enum<T>>(value: any, enumType: T): T;
        static valueOf(name: string): Internal.EnumGetMethod;
        get caseSensitive(): boolean
        get ordinalOk(): boolean
        static readonly ORDINAL_OR_NAME: Internal.EnumGetMethod;
        static readonly ORDINAL_OR_NAME_IGNORECASE: Internal.EnumGetMethod;
        static readonly NAME: Internal.EnumGetMethod;
        static readonly NAME_IGNORECASE: Internal.EnumGetMethod;
    }
    type EnumGetMethod_ = "name" | "ordinal_or_name" | EnumGetMethod | "ordinal_or_name_ignorecase" | "name_ignorecase";
    class FeaturePoolElement extends Internal.StructurePoolElement implements Internal.FeaturePoolElementAccessor {
        getFeature(): Internal.Holder<any>;
        get feature(): Internal.Holder<any>
        static readonly CODEC: Internal.Codec<Internal.FeaturePoolElement>;
    }
    type FeaturePoolElement_ = FeaturePoolElement;
    interface Color extends Internal.SpecialEquality {
        getSerializeJS(): string;
        checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        createTextColorJS(): Internal.TextColor;
        getArgbJS(): number;
        specialEquals(o: any, shallow: boolean): boolean;
        getHexJS(): string;
        getRgbJS(): number;
        getFireworkColorJS(): number;
        get serializeJS(): string
        get argbJS(): number
        get hexJS(): string
        get rgbJS(): number
        get fireworkColorJS(): number
    }
    type Color_ = Color;
    class ClientboundSetHealthPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number, $$2: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getHealth(): number;
        getSaturation(): number;
        getFood(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get health(): number
        get saturation(): number
        get food(): number
        get skippable(): boolean
    }
    type ClientboundSetHealthPacket_ = ClientboundSetHealthPacket;
    class AttributeMap {
        constructor($$0: Internal.AttributeSupplier_)
        load($$0: Internal.ListTag_): void;
        getDirtyAttributes(): Internal.Set<Internal.AttributeInstance>;
        removeAttributeModifiers($$0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): void;
        getInstance($$0: Internal.Holder_<Internal.Attribute>): Internal.AttributeInstance;
        hasModifier($$0: Internal.Attribute_, $$1: Internal.UUID_): boolean;
        assignValues($$0: Internal.AttributeMap_): void;
        getInstance($$0: Internal.Attribute_): Internal.AttributeInstance;
        hasModifier($$0: Internal.Holder_<Internal.Attribute>, $$1: Internal.UUID_): boolean;
        hasAttribute($$0: Internal.Attribute_): boolean;
        getBaseValue($$0: Internal.Attribute_): number;
        getSyncableAttributes(): Internal.Collection<Internal.AttributeInstance>;
        save(): Internal.ListTag;
        getValue($$0: Internal.Attribute_): number;
        addTransientAttributeModifiers($$0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): void;
        hasAttribute($$0: Internal.Holder_<Internal.Attribute>): boolean;
        getModifierValue($$0: Internal.Holder_<Internal.Attribute>, $$1: Internal.UUID_): number;
        getModifierValue($$0: Internal.Attribute_, $$1: Internal.UUID_): number;
        get dirtyAttributes(): Internal.Set<Internal.AttributeInstance>
        get syncableAttributes(): Internal.Collection<Internal.AttributeInstance>
    }
    type AttributeMap_ = AttributeMap;
    interface RandomBlockTickerChunk {
        leavesbegone$getRandomBlockTicks(): Internal.LevelChunkTicks<Internal.Block>;
        leavesbegone$setRandomBlockTicks(arg0: Internal.LevelChunkTicks_<Internal.Block>): void;
    }
    type RandomBlockTickerChunk_ = RandomBlockTickerChunk;
    class Bee$BeePollinateGoal extends Internal.Bee$BaseBeeGoal {
        isPollinating(): boolean;
        get pollinating(): boolean
    }
    type Bee$BeePollinateGoal_ = Bee$BeePollinateGoal;
    interface Predicate <T> {
        negate(): this;
        not<T>(arg0: Internal.Predicate_<T>): this;
        or(arg0: Internal.Predicate_<T>): this;
        test(arg0: T): boolean;
        and(arg0: Internal.Predicate_<T>): this;
        isEqual<T>(arg0: any): this;
        (arg0: T): boolean;
    }
    type Predicate_<T> = Predicate<T>;
    interface FileAttributeView extends Internal.AttributeView {
        name(): string;
    }
    type FileAttributeView_ = FileAttributeView;
    class ContraptionWorld extends Internal.WrappedWorld {
        constructor(world: Internal.Level_, contraption: Internal.Contraption_)
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        getBiome(pos: BlockPos_): Internal.Holder<any>;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        runCommandSilent(command: string): number;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        asComponentProvider(): Internal.ComponentProvider;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getDisplayName(): Internal.Component;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        getDirectSignalTo($$0: BlockPos_): number;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getDimension(): ResourceLocation;
        getDifficulty(): Internal.Difficulty;
        getName(): Internal.Component;
        canSeeSky($$0: BlockPos_): boolean;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        noCollision($$0: Internal.Entity_): boolean;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        self(): Internal.Level;
        getBestNeighborSignal($$0: BlockPos_): number;
        hasChunk($$0: number, $$1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getSide(): Internal.ScriptType;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        getEntities(): Internal.EntityArrayList;
        spawnParticles(options: Internal.ParticleOptions_, overrideLimiter: boolean, x: number, y: number, z: number, vx: number, vy: number, vz: number, count: number, speed: number): void;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        tell(message: Internal.Component_): void;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getPlayers(): Internal.EntityArrayList;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        isOverworld(): boolean;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        runCommand(command: string): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get displayName(): Internal.Component
        get dimension(): ResourceLocation
        get difficulty(): Internal.Difficulty
        get name(): Internal.Component
        get moonPhase(): number
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get moonBrightness(): number
        get side(): Internal.ScriptType
        get entities(): Internal.EntityArrayList
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>
        set statusMessage(message: Internal.Component_)
        get players(): Internal.EntityArrayList
        get maxLightLevel(): number
        get overworld(): boolean
    }
    type ContraptionWorld_ = ContraptionWorld;
    interface NbtAccounterAccessor {
        create$getUsage(): number;
    }
    type NbtAccounterAccessor_ = NbtAccounterAccessor;
    interface DensityFunction$FunctionContext {
        blockX(): number;
        getBlender(): Internal.Blender;
        blockZ(): number;
        blockY(): number;
        get blender(): Internal.Blender
    }
    type DensityFunction$FunctionContext_ = DensityFunction$FunctionContext;
    abstract class BaseComponent implements io.wispforest.owo.ui.core.Component {
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        horizontalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        x(): number;
        charTyped(): Internal.EventSource<Internal.CharTyped>;
        horizontalSizing(horizontalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        updateX(x: number): void;
        mouseLeave(): Internal.EventSource<Internal.MouseLeave>;
        update(delta: number, mouseX: number, mouseY: number): void;
        verticalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        remove(): void;
        hasParent(): boolean;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        onFocusGained(source: Internal.Component$FocusSource_): void;
        draw(arg0: Internal.OwoUIDrawContext_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        height(): number;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        positioning(arg0: Internal.Positioning_): io.wispforest.owo.ui.core.Component;
        onCharTyped(chr: string, modifiers: number): boolean;
        focusLost(): Internal.EventSource<Internal.FocusLost>;
        focusHandler(): Internal.FocusHandler;
        id(): string;
        margins(): Internal.AnimatableProperty<Internal.Insets>;
        onMouseUp(mouseX: number, mouseY: number, button: number): boolean;
        configure<C extends io.wispforest.owo.ui.core.Component>(closure: Internal.Consumer_<C>): C;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        tooltip(tooltip: Internal.List_<Internal.ClientTooltipComponent>): io.wispforest.owo.ui.core.Component;
        onMouseScroll(mouseX: number, mouseY: number, amount: number): boolean;
        inflate(space: Internal.Size_): void;
        width(): number;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        mouseUp(): Internal.EventSource<Internal.MouseUp>;
        root(): Internal.ParentComponent;
        onKeyPress(keyCode: number, scanCode: number, modifiers: number): boolean;
        parent(): Internal.ParentComponent;
        cursorStyle(): Internal.CursorStyle;
        tooltip(tooltip: Internal.Component_): io.wispforest.owo.ui.core.Component;
        shouldDrawTooltip(mouseX: number, mouseY: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        keyPress(): Internal.EventSource<Internal.KeyPress>;
        y(): number;
        id(id: string): io.wispforest.owo.ui.core.Component;
        mouseEnter(): Internal.EventSource<Internal.MouseEnter>;
        updateY(y: number): void;
        moveTo(x: number, y: number): void;
        isInBoundingBox(x: number, y: number): boolean;
        fullSize(): Internal.Size;
        mouseDown(): Internal.EventSource<Internal.MouseDown>;
        onMouseDrag(mouseX: number, mouseY: number, deltaX: number, deltaY: number, button: number): boolean;
        zIndex(): number;
        onMouseDown(mouseX: number, mouseY: number, button: number): boolean;
        zIndex(zIndex: number): io.wispforest.owo.ui.core.Component;
        parseProperties(model: Internal.UIModel_, element: Internal.Element_, children: Internal.Map_<string, Internal.Element>): void;
        mouseScroll(): Internal.EventSource<Internal.MouseScroll>;
        focusGained(): Internal.EventSource<Internal.FocusGained>;
        tooltip(tooltip: Internal.Collection_<Internal.Component>): io.wispforest.owo.ui.core.Component;
        onFocusLost(): void;
        mount(parent: Internal.ParentComponent_, x: number, y: number): void;
        mouseDrag(): Internal.EventSource<Internal.MouseDrag>;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        tooltip(): Internal.List<Internal.ClientTooltipComponent>;
        verticalSizing(verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        cursorStyle(arg0: Internal.CursorStyle_): io.wispforest.owo.ui.core.Component;
        canFocus(source: Internal.Component$FocusSource_): boolean;
        positioning(): Internal.AnimatableProperty<Internal.Positioning>;
        margins(arg0: Internal.Insets_): io.wispforest.owo.ui.core.Component;
        dismount(reason: Internal.Component$DismountReason_): void;
    }
    type BaseComponent_ = BaseComponent;
    class NopProcessor extends Internal.StructureProcessor {
        static readonly CODEC: Internal.Codec<Internal.NopProcessor>;
        static readonly INSTANCE: Internal.NopProcessor;
    }
    type NopProcessor_ = NopProcessor;
    class RandomTickCallbackJS {
        constructor(containerJS: Internal.BlockContainerJS_, random: Internal.RandomSource_)
        getLevel(): Internal.Level;
        getServer(): Internal.MinecraftServer;
        get level(): Internal.Level
        get server(): Internal.MinecraftServer
        block: Internal.BlockContainerJS;
        random: Internal.RandomSource;
    }
    type RandomTickCallbackJS_ = RandomTickCallbackJS;
    /**
     * Invoked after all items are registered to modify them.
    */
    class ItemModificationEventJS extends Internal.EventJS {
        constructor()
        /**
         * Modifies items matching the given ingredient.
         * 
         * **NOTE**: tag ingredients are not supported at this time.
        */
        modify(in_: Internal.Ingredient_, c: Internal.Consumer_<Internal.Item>): void;
    }
    type ItemModificationEventJS_ = ItemModificationEventJS;
    abstract class Certificate implements Internal.Serializable {
        verify(arg0: Internal.PublicKey_, arg1: string): void;
        getPublicKey(): Internal.PublicKey;
        getType(): string;
        verify(arg0: Internal.PublicKey_, arg1: Internal.Provider_): void;
        getEncoded(): number[];
        verify(arg0: Internal.PublicKey_): void;
        get publicKey(): Internal.PublicKey
        get type(): string
        get encoded(): number[]
    }
    type Certificate_ = Certificate;
    class TrackEdge {
        constructor(node1: Internal.TrackNode_, node2: Internal.TrackNode_, turn: Internal.BezierConnection_, trackMaterial: Internal.TrackMaterial_)
        incrementT(currentT: number, distance: number): number;
        getPositionSmoothed(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        getIntersection(node1: Internal.TrackNode_, node2: Internal.TrackNode_, other: Internal.TrackEdge_, other1: Internal.TrackNode_, other2: Internal.TrackNode_): Internal.Collection<number[]>;
        getDirectionAt(t: number): Vec3d;
        getPosition(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        canTravelTo(other: Internal.TrackEdge_): boolean;
        getTurn(): Internal.BezierConnection;
        isTurn(): boolean;
        getNormalSmoothed(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        getDirection(fromFirst: boolean): Vec3d;
        getNormal(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        isInterDimensional(): boolean;
        getLength(): number;
        getTrackMaterial(): Internal.TrackMaterial;
        getEdgeData(): Internal.EdgeData;
        static read(node1: Internal.TrackNode_, node2: Internal.TrackNode_, tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.TrackEdge;
        get turn(): Internal.BezierConnection
        get turn(): boolean
        get interDimensional(): boolean
        get length(): number
        get trackMaterial(): Internal.TrackMaterial
        get edgeData(): Internal.EdgeData
        node1: Internal.TrackNode;
        node2: Internal.TrackNode;
    }
    type TrackEdge_ = TrackEdge;
    class MinimapInterface extends Internal.Interface {
        constructor(modMain: Internal.AXaeroMinimap_, id: number, interfaces: Internal.InterfaceManager_)
        setCrashedWith(crashedWith: Internal.Throwable_): void;
        getOverMapRendererHandler(): Internal.MinimapElementOverMapRendererHandler;
        usingFBO(): boolean;
        getMinimapSafeModeRenderer(): Internal.MinimapSafeModeRenderer;
        getWaypointsGuiRenderer(): Internal.WaypointsGuiRenderer;
        getCompassRenderer(): Internal.CompassRenderer;
        getInfoDisplayManager(): Internal.InfoDisplayManager;
        getInfoDisplayRenderer(): Internal.InfoDisplayRenderer;
        getMinimapFBORenderer(): Internal.MinimapFBORenderer;
        getInfoDisplayIO(): Internal.InfoDisplayIO;
        checkCrashes(): void;
        getWaypointsIngameRenderer(): Internal.WaypointsIngameRenderer;
        getCrashedWith(): Internal.Throwable;
        set crashedWith(crashedWith: Internal.Throwable_)
        get overMapRendererHandler(): Internal.MinimapElementOverMapRendererHandler
        get minimapSafeModeRenderer(): Internal.MinimapSafeModeRenderer
        get waypointsGuiRenderer(): Internal.WaypointsGuiRenderer
        get compassRenderer(): Internal.CompassRenderer
        get infoDisplayManager(): Internal.InfoDisplayManager
        get infoDisplayRenderer(): Internal.InfoDisplayRenderer
        get minimapFBORenderer(): Internal.MinimapFBORenderer
        get infoDisplayIO(): Internal.InfoDisplayIO
        get waypointsIngameRenderer(): Internal.WaypointsIngameRenderer
        get crashedWith(): Internal.Throwable
    }
    type MinimapInterface_ = MinimapInterface;
    class Animation <A extends Internal.Animatable<A>> {
        constructor(duration: number, setter: Internal.Consumer_<A>, easing: Internal.Easing_, from: A, to: A)
        static compose(...elements: Internal.Animation_<any>[]): Internal.Animation$Composed;
        reverse(): this;
        backwards(): this;
        update(delta: number): void;
        forwards(): this;
        direction(): Internal.Animation$Direction;
        looping(): boolean;
        loop(loop: boolean): this;
        finished(): Internal.EventSource<Internal.Animation$Finished>;
    }
    type Animation_<A extends Internal.Animatable<A>> = Animation<A>;
    interface MinecraftServerInterface {
        getResourceManager(): Internal.MinecraftServer$ReloadableResources;
        getScriptServer(): Internal.CarpetScriptServer;
        getTickRateManager(): Internal.ServerTickRateManager;
        getCMWorlds(): Internal.Map<Internal.ResourceKey<Internal.Level>, Internal.ServerLevel>;
        getCMSession(): Internal.LevelStorageSource$LevelStorageAccess;
        addScriptServer(arg0: Internal.CarpetScriptServer_): void;
        forceTick(arg0: Internal.BooleanSupplier_): void;
        reloadAfterReload(arg0: Internal.RegistryAccess_): void;
        get resourceManager(): Internal.MinecraftServer$ReloadableResources
        get scriptServer(): Internal.CarpetScriptServer
        get tickRateManager(): Internal.ServerTickRateManager
        get CMWorlds(): Internal.Map<Internal.ResourceKey<Internal.Level>, Internal.ServerLevel>
        get CMSession(): Internal.LevelStorageSource$LevelStorageAccess
    }
    type MinecraftServerInterface_ = MinecraftServerInterface;
    interface IMixinMinecraft {
        getPausePartialTickFancyMenu(): number;
        openChatScreenFancyMenu(arg0: string): void;
        get pausePartialTickFancyMenu(): number
    }
    type IMixinMinecraft_ = IMixinMinecraft;
    interface IDISHolder {
        getDawnSettings(): Internal.DawnItemSettings;
        get dawnSettings(): Internal.DawnItemSettings
    }
    type IDISHolder_ = IDISHolder;
    interface SortedMap <K, V> extends Internal.Map<K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        containsValue(arg0: any): boolean;
        of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        tailMap(arg0: K): this;
        isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        containsKey(arg0: any): boolean;
        comparator(): Internal.Comparator<K>;
        put(arg0: K, arg1: V): V;
        headMap(arg0: K): this;
        get(arg0: any): V;
        remove(arg0: any): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        subMap(arg0: K, arg1: K): this;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        lastKey(): K;
        hashCode(): number;
        size(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        equals(arg0: any): boolean;
        firstKey(): K;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        get empty(): boolean
    }
    type SortedMap_<K, V> = SortedMap<K, V>;
    class StainedGlassPaneBlock extends Internal.IronBarsBlock implements Internal.BeaconBeamBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        getColor(): Internal.DyeColor;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type StainedGlassPaneBlock_ = StainedGlassPaneBlock;
    class TransformType extends Internal.Enum<Internal.TransformType> {
        static valueOf(name: string): Internal.TransformType;
        static values(): Internal.TransformType[];
        static readonly POSITION: Internal.TransformType;
        static readonly ROTATION: Internal.TransformType;
        static readonly BEND: Internal.TransformType;
    }
    type TransformType_ = "position" | "rotation" | TransformType | "bend";
    class ServerChunkCache extends Internal.ChunkSource implements Internal.IServerChunkCache {
        constructor($$0: Internal.ServerLevel_, $$1: Internal.LevelStorageSource$LevelStorageAccess_, $$2: Internal.DataFixer_, $$3: Internal.StructureTemplateManager_, $$4: Internal.Executor_, $$5: Internal.ChunkGenerator_, $$6: number, $$7: number, $$8: boolean, $$9: Internal.ChunkProgressListener_, $$10: any_, $$11: Internal.Supplier_<Internal.DimensionDataStorage>)
        broadcast($$0: Internal.Entity_, $$1: Internal.Packet_<any>): void;
        pollTask(): boolean;
        getDataStorage(): Internal.DimensionDataStorage;
        setSimulationDistance($$0: number): void;
        removeEntity($$0: Internal.Entity_): void;
        getLevel(): Internal.Level;
        getLastSpawnState(): Internal.NaturalSpawner$SpawnState;
        removeRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        requiresBroadcast(holder: Internal.ChunkHolder_): void;
        getChunkDebugData($$0: Internal.ChunkPos_): string;
        chunkScanner(): Internal.ChunkScanAccess;
        addRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        setViewDistance($$0: number): void;
        getTickingGenerated(): number;
        getPendingTasksCount(): number;
        getVisibleChunkIfPresent($$0: number): Internal.ChunkHolder;
        randomState(): Internal.RandomState;
        getPoiManager(): Internal.PoiManager;
        broadcastAndSend($$0: Internal.Entity_, $$1: Internal.Packet_<any>): void;
        getGeneratorState(): Internal.ChunkGeneratorStructureState;
        move($$0: Internal.ServerPlayer_): void;
        addEntity($$0: Internal.Entity_): void;
        getLightEngine(): Internal.ThreadedLevelLightEngine;
        isPositionTicking($$0: number): boolean;
        blockChanged($$0: BlockPos_): void;
        getChunkFuture($$0: number, $$1: number, $$2: Internal.ChunkStatus_, $$3: boolean): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getGenerator(): Internal.ChunkGenerator;
        removeTicketsOnClosing(): void;
        save($$0: boolean): void;
        get dataStorage(): Internal.DimensionDataStorage
        set simulationDistance($$0: number)
        get level(): Internal.Level
        get lastSpawnState(): Internal.NaturalSpawner$SpawnState
        set viewDistance($$0: number)
        get tickingGenerated(): number
        get pendingTasksCount(): number
        get poiManager(): Internal.PoiManager
        get generatorState(): Internal.ChunkGeneratorStructureState
        get lightEngine(): Internal.ThreadedLevelLightEngine
        get generator(): Internal.ChunkGenerator
        readonly chunkMap: Internal.ChunkMap;
    }
    type ServerChunkCache_ = ServerChunkCache;
    class CocoaBlock extends Internal.HorizontalDirectionalBlock implements Internal.SeasonalFertilizable, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        handler$dne000$collective$CocoaBlock_randomTick(blockState: Internal.BlockState_, serverLevel: Internal.ServerLevel_, blockPos: BlockPos_, randomSource: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        handler$kjg000$seasons$growInject(world: Internal.ServerLevel_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_, ci: Internal.CallbackInfo_): void;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        handler$kjg000$seasons$randomTickInject(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 2;
    }
    type CocoaBlock_ = CocoaBlock;
    interface GraphEntity <G extends Internal.GraphEntity<G>> {
        onDestroy(): void;
        merge(arg0: G): void;
        getContext(): Internal.GraphEntityContext;
        onUnlink(a: Internal.NodeHolder_<Internal.BlockNode>, b: Internal.NodeHolder_<Internal.BlockNode>, entity: Internal.LinkEntity_): void;
        onNodeDestroyed(node: Internal.NodeHolder_<Internal.BlockNode>, nodeEntity: Internal.NodeEntity_, linkEntities: Internal.Map_<Internal.LinkPos, Internal.LinkEntity>): void;
        onDiscard(): void;
        onUnload(): void;
        onNodeCreated(node: Internal.NodeHolder_<Internal.BlockNode>, nodeEntity: Internal.NodeEntity_): void;
        onInit(arg0: Internal.GraphEntityContext_): void;
        toTag(): Internal.Tag;
        toPacket(buf: Internal.NetByteBuf_, ctx: Internal.IMsgWriteCtx_): void;
        onTick(): void;
        onLink(a: Internal.NodeHolder_<Internal.BlockNode>, b: Internal.NodeHolder_<Internal.BlockNode>, entity: Internal.LinkEntity_): void;
        onUpdate(): void;
        getType(): Internal.GraphEntityType<any>;
        get context(): Internal.GraphEntityContext
        get type(): Internal.GraphEntityType<any>
        readonly NET_PARENT: Internal.ParentNetIdSingle<Internal.GraphEntity<any>>;
    }
    type GraphEntity_<G extends Internal.GraphEntity<G>> = GraphEntity<G>;
    interface LongList extends Internal.LongCollection, Internal.Comparable<Internal.List<number>>, Internal.List<number> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        removeLong(arg0: number): number;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        addAll(arg0: Internal.LongList_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        /**
         * @deprecated
        */
        get(arg0: number): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        removeIf(arg0: Internal.LongPredicate_): boolean;
        of(...arg0: number[]): this;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        addAll(arg0: number, arg1: Internal.LongList_): boolean;
        of<E>(arg0: E): Internal.List<E>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        retainAll(arg0: Internal.LongCollection_): boolean;
        replaceAll(arg0: Internal.LongUnaryOperator_): void;
        listIterator(): Internal.ListIterator<any>;
        forEach(arg0: Internal.LongConsumer_): void;
        size(arg0: number): void;
        addAll(arg0: Internal.LongCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        add(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        replaceAll(arg0: it.unimi.dsi.fastutil.longs.LongUnaryOperator_): void;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        addAll(arg0: number, arg1: Internal.LongCollection_): boolean;
        compareTo(arg0: Internal.List_<number>): number;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        forEach(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        removeAll(arg0: Internal.LongCollection_): boolean;
        containsAll(arg0: Internal.LongCollection_): boolean;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        spliterator(): Internal.Spliterator<any>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        getLong(arg0: number): number;
        sort(arg0: Internal.LongComparator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        of(arg0: number, arg1: number): this;
        longSpliterator(): Internal.LongSpliterator;
        unstableSort(arg0: Internal.LongComparator_): void;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        addElements(arg0: number, arg1: number[]): void;
        indexOf(arg0: number): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        setElements(arg0: number[]): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        iterator(): Internal.LongIterator;
        longIterator(): Internal.LongIterator;
        add(arg0: number): boolean;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        isEmpty(): boolean;
        of(arg0: number): this;
        setElements(arg0: number, arg1: number[]): void;
        addAll(arg0: Internal.Collection_<number>): boolean;
        /**
         * @deprecated
        */
        toLongArray(arg0: number[]): number[];
        of<E>(...arg0: E[]): Internal.List<E>;
        toArray(arg0: number[]): number[];
        listIterator(arg0: number): Internal.ListIterator<any>;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        lastIndexOf(arg0: number): number;
        of(arg0: number, arg1: number, arg2: number): this;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        contains(arg0: number): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        rem(arg0: number): boolean;
        subList(arg0: number, arg1: number): Internal.List<any>;
        hashCode(): number;
        size(): number;
        toLongArray(): number[];
        longParallelStream(): Internal.LongStream;
        set(arg0: number, arg1: number): number;
        longStream(): Internal.LongStream;
        clear(): void;
        equals(arg0: any): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.longs.LongPredicate_): boolean;
        of(): this;
        addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        set elements(arg0: number[])
        get empty(): boolean
    }
    type LongList_ = LongList;
    class PitcherCropBlock extends Internal.DoublePlantBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 4;
    }
    type PitcherCropBlock_ = PitcherCropBlock;
    class WidgetLoadingHandler {
        constructor(destination: Internal.WidgetScreenHandler_)
        loadWidget(serialized: string): void;
    }
    type WidgetLoadingHandler_ = WidgetLoadingHandler;
    class WidgetScreenHandler {
        constructor()
        handleClick(screen: Internal.Screen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): void;
        initialize(screen: Internal.WidgetScreen_, width: number, height: number): void;
        renderTooltips(guiGraphics: Internal.GuiGraphics_, screen: Internal.Screen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): boolean;
        render(guiGraphics: Internal.GuiGraphics_, screen: Internal.WidgetScreen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): void;
    }
    type WidgetScreenHandler_ = WidgetScreenHandler;
    interface Double2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.DoubleFunction<V> {
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Double2ObjectFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Double2LongFunction;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Double2DoubleFunction;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        remove(arg0: number): V;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Double2CharFunction;
        put(arg0: number, arg1: V): V;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Double2ByteFunction;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Double2ShortFunction;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ObjectFunction<V>;
        apply(arg0: number): V;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ObjectFunction<V>;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        get(arg0: number): V;
        containsKey(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: V): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Double2FloatFunction;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ObjectFunction<V>;
        size(): number;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Double2ReferenceFunction<T>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Double2IntFunction;
        clear(): void;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        defaultReturnValue(): V;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ObjectFunction<V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Double2ObjectFunction_<V> = Double2ObjectFunction<V>;
    interface VillagerUtil {
        isParent(stack: Internal.ItemStack_): boolean;
        saveVillager(villager: Internal.Villager_, stack: Internal.ItemStack_, removeJobSite: boolean): void;
        onUseEntity(player: Internal.Player_, level: Internal.Level_, hand: Internal.InteractionHand_, entity: Internal.Entity_, hitResult: Internal.EntityHitResult_): Internal.InteractionResult;
        forceDefaultTradingScreen(arg0: boolean): void;
    }
    type VillagerUtil_ = VillagerUtil;
    interface HandledScreenDrawTooltip {
        shulkerboxtooltip$drawMouseoverTooltip(arg0: Internal.GuiGraphics_, arg1: Internal.Font_, arg2: Internal.List_<Internal.Component>, arg3: Internal.Optional_<Internal.TooltipComponent>, arg4: Internal.ItemStack_, arg5: number, arg6: number): void;
    }
    type HandledScreenDrawTooltip_ = HandledScreenDrawTooltip;
    class AtomicReference <V> implements Internal.Serializable {
        constructor()
        constructor(arg0: V)
        weakCompareAndSetPlain(arg0: V, arg1: V): boolean;
        updateAndGet(arg0: Internal.UnaryOperator_<V>): V;
        getAndSet(arg0: V): V;
        weakCompareAndSetRelease(arg0: V, arg1: V): boolean;
        setPlain(arg0: V): void;
        weakCompareAndSetAcquire(arg0: V, arg1: V): boolean;
        getAndUpdate(arg0: Internal.UnaryOperator_<V>): V;
        getOpaque(): V;
        getAcquire(): V;
        compareAndExchangeAcquire(arg0: V, arg1: V): V;
        weakCompareAndSetVolatile(arg0: V, arg1: V): boolean;
        lazySet(arg0: V): void;
        get(): V;
        setRelease(arg0: V): void;
        compareAndSet(arg0: V, arg1: V): boolean;
        compareAndExchangeRelease(arg0: V, arg1: V): V;
        /**
         * @deprecated
        */
        weakCompareAndSet(arg0: V, arg1: V): boolean;
        setOpaque(arg0: V): void;
        compareAndExchange(arg0: V, arg1: V): V;
        accumulateAndGet(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        getPlain(): V;
        set(arg0: V): void;
        getAndAccumulate(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        set plain(arg0: V)
        get opaque(): V
        get acquire(): V
        set release(arg0: V)
        set opaque(arg0: V)
        get plain(): V
    }
    type AtomicReference_<V> = AtomicReference<V>;
    interface ITrackedPlayerReader <P> {
        getX(arg0: P): number;
        getY(arg0: P): number;
        getDimension(arg0: P): ResourceLocation;
        getZ(arg0: P): number;
        getId(arg0: P): Internal.UUID;
    }
    type ITrackedPlayerReader_<P> = ITrackedPlayerReader<P>;
    class SerializerType <T> {
        constructor($$0: Internal.Serializer_<T>)
        getSerializer(): Internal.Serializer<T>;
        get serializer(): Internal.Serializer<T>
    }
    type SerializerType_<T> = SerializerType<T>;
    class BlockRenderDispatcher implements Internal.ResourceManagerReloadListener, Internal.BlockRenderDispatcherAccessor, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.BlockModelShaper_, $$1: Internal.BlockEntityWithoutLevelRenderer_, $$2: Internal.BlockColors_)
        renderSingleBlock($$0: Internal.BlockState_, $$1: Internal.PoseStack_, $$2: Internal.MultiBufferSource_, $$3: number, $$4: number): void;
        onResourceManagerReload($$0: Internal.ResourceManager_): void;
        getBlockModelShaper(): Internal.BlockModelShaper;
        getFabricDependencies(): Internal.Collection<any>;
        getBlockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer;
        getModelRenderer(): Internal.ModelBlockRenderer;
        getBlockModel($$0: Internal.BlockState_): Internal.BakedModel;
        getName(): string;
        renderBreakingTexture($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_): void;
        renderBatched($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_, $$5: boolean, $$6: Internal.RandomSource_): void;
        getFabricId(): ResourceLocation;
        renderLiquid($$0: BlockPos_, $$1: Internal.BlockAndTintGetter_, $$2: Internal.VertexConsumer_, $$3: Internal.BlockState_, $$4: Internal.FluidState_): void;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get blockModelShaper(): Internal.BlockModelShaper
        get fabricDependencies(): Internal.Collection<any>
        get blockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer
        get modelRenderer(): Internal.ModelBlockRenderer
        get name(): string
        get fabricId(): ResourceLocation
    }
    type BlockRenderDispatcher_ = BlockRenderDispatcher;
    class PickaxeItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.Item;
    }
    type PickaxeItemBuilder_ = PickaxeItemBuilder;
    class BlueIceFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BlueIceFeature_ = BlueIceFeature;
    abstract class ByteBuf implements Internal.ByteBufConvertible, Internal.Comparable<Internal.ByteBuf>, Internal.ReferenceCounted {
        constructor()
        indexOf(arg0: number, arg1: number, arg2: number): number;
        getBytes(arg0: number, arg1: Internal.OutputStream_, arg2: number): this;
        readShortLE(): number;
        readableBytes(): number;
        writeInt(arg0: number): this;
        readDouble(): number;
        maxFastWritableBytes(): number;
        skipBytes(arg0: number): this;
        forEachByteDesc(arg0: Internal.ByteProcessor_): number;
        markReaderIndex(): this;
        nioBufferCount(): number;
        markWriterIndex(): this;
        nioBuffers(): Internal.ByteBuffer[];
        writeBytes(arg0: number[], arg1: number, arg2: number): this;
        getShortLE(arg0: number): number;
        getFloat(arg0: number): number;
        writeFloat(arg0: number): this;
        setBytes(arg0: number, arg1: Internal.FileChannel_, arg2: number, arg3: number): number;
        setFloat(arg0: number, arg1: number): this;
        memoryAddress(): number;
        ensureWritable(arg0: number): this;
        forEachByte(arg0: number, arg1: number, arg2: Internal.ByteProcessor_): number;
        isReadable(arg0: number): boolean;
        resetWriterIndex(): this;
        getMediumLE(arg0: number): number;
        maxWritableBytes(): number;
        getBytes(arg0: number, arg1: Internal.GatheringByteChannel_, arg2: number): number;
        readUnsignedMedium(): number;
        isReadable(): boolean;
        readIntLE(): number;
        getByte(arg0: number): number;
        writeShort(arg0: number): this;
        getMedium(arg0: number): number;
        bytesBefore(arg0: number, arg1: number): number;
        writeBytes(arg0: Internal.InputStream_, arg1: number): number;
        compareTo(arg0: Internal.ByteBuf_): number;
        retain(arg0: number): Internal.ReferenceCounted;
        touch(arg0: any): Internal.ReferenceCounted;
        readUnsignedMediumLE(): number;
        readBoolean(): boolean;
        writeIntLE(arg0: number): this;
        setMediumLE(arg0: number, arg1: number): this;
        slice(): this;
        writeMedium(arg0: number): this;
        copy(arg0: number, arg1: number): this;
        setCharSequence(arg0: number, arg1: Internal.CharSequence_, arg2: Internal.Charset_): number;
        isReadOnly(): boolean;
        resetReaderIndex(): this;
        setDoubleLE(arg0: number, arg1: number): this;
        writeLongLE(arg0: number): this;
        writeCharSequence(arg0: Internal.CharSequence_, arg1: Internal.Charset_): number;
        release(): boolean;
        getBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        readBytes(arg0: number[]): this;
        readByte(): number;
        readUnsignedShort(): number;
        writerIndex(arg0: number): this;
        forEachByteDesc(arg0: number, arg1: number, arg2: Internal.ByteProcessor_): number;
        writeMediumLE(arg0: number): this;
        release(arg0: number): boolean;
        writeBytes(arg0: Internal.FileChannel_, arg1: number, arg2: number): number;
        setBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        forEachByte(arg0: Internal.ByteProcessor_): number;
        isContiguous(): boolean;
        setLongLE(arg0: number, arg1: number): this;
        arrayOffset(): number;
        readBytes(arg0: Internal.ByteBuffer_): this;
        retainedSlice(arg0: number, arg1: number): this;
        writeBytes(arg0: Internal.ByteBuf_, arg1: number, arg2: number): this;
        getUnsignedByte(arg0: number): number;
        readBytes(arg0: Internal.ByteBuf_, arg1: number): this;
        readBytes(arg0: number[], arg1: number, arg2: number): this;
        nioBuffer(arg0: number, arg1: number): Internal.ByteBuffer;
        retainedSlice(): this;
        setShort(arg0: number, arg1: number): this;
        getUnsignedInt(arg0: number): number;
        getUnsignedMedium(arg0: number): number;
        getUnsignedMediumLE(arg0: number): number;
        readDoubleLE(): number;
        getBoolean(arg0: number): boolean;
        writeZero(arg0: number): this;
        maxCapacity(): number;
        clear(): this;
        getCharSequence(arg0: number, arg1: number, arg2: Internal.Charset_): Internal.CharSequence;
        nioBuffer(): Internal.ByteBuffer;
        readBytes(arg0: Internal.FileChannel_, arg1: number, arg2: number): number;
        readMedium(): number;
        unwrap(): this;
        retain(): Internal.ReferenceCounted;
        readUnsignedShortLE(): number;
        writeBytes(arg0: number[]): this;
        internalNioBuffer(arg0: number, arg1: number): Internal.ByteBuffer;
        discardReadBytes(): this;
        writeChar(arg0: number): this;
        setBytes(arg0: number, arg1: Internal.InputStream_, arg2: number): number;
        duplicate(): this;
        getFloatLE(arg0: number): number;
        isWritable(): boolean;
        readerIndex(): number;
        getDouble(arg0: number): number;
        setByte(arg0: number, arg1: number): this;
        readBytes(arg0: Internal.GatheringByteChannel_, arg1: number): number;
        capacity(arg0: number): this;
        isDirect(): boolean;
        readUnsignedInt(): number;
        writeDouble(arg0: number): this;
        writerIndex(): number;
        retainedDuplicate(): this;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
        touch(): this;
        compareTo(arg0: any): number;
        setFloatLE(arg0: number, arg1: number): this;
        setShortLE(arg0: number, arg1: number): this;
        setLong(arg0: number, arg1: number): this;
        readMediumLE(): number;
        /**
         * @deprecated
        */
        order(): Internal.ByteOrder;
        writableBytes(): number;
        writeFloatLE(arg0: number): this;
        getUnsignedIntLE(arg0: number): number;
        getChar(arg0: number): string;
        writeBytes(arg0: Internal.ByteBuf_, arg1: number): this;
        readChar(): string;
        setInt(arg0: number, arg1: number): this;
        discardSomeReadBytes(): this;
        bytesBefore(arg0: number, arg1: number, arg2: number): number;
        asByteBuf(): this;
        isWritable(arg0: number): boolean;
        alloc(): Internal.ByteBufAllocator;
        bytesBefore(arg0: number): number;
        readInt(): number;
        nioBuffers(arg0: number, arg1: number): Internal.ByteBuffer[];
        readRetainedSlice(arg0: number): this;
        setChar(arg0: number, arg1: number): this;
        setBytes(arg0: number, arg1: number[]): this;
        writeBytes(arg0: Internal.ByteBuffer_): this;
        readFloatLE(): number;
        array(): number[];
        writeShortLE(arg0: number): this;
        getLong(arg0: number): number;
        readShort(): number;
        getIntLE(arg0: number): number;
        readBytes(arg0: Internal.OutputStream_, arg1: number): this;
        slice(arg0: number, arg1: number): this;
        capacity(): number;
        readerIndex(arg0: number): this;
        setBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        readCharSequence(arg0: number, arg1: Internal.Charset_): Internal.CharSequence;
        writeDoubleLE(arg0: number): this;
        getBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        asReadOnly(): this;
        hasMemoryAddress(): boolean;
        setZero(arg0: number, arg1: number): this;
        getLongLE(arg0: number): number;
        readSlice(arg0: number): this;
        readLongLE(): number;
        getShort(arg0: number): number;
        writeLong(arg0: number): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        readFloat(): number;
        readBytes(arg0: Internal.ByteBuf_): this;
        getDoubleLE(arg0: number): number;
        readUnsignedIntLE(): number;
        getBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        getInt(arg0: number): number;
        getBytes(arg0: number, arg1: number[]): this;
        writeBytes(arg0: Internal.ScatteringByteChannel_, arg1: number): number;
        writeBoolean(arg0: boolean): this;
        setIndex(arg0: number, arg1: number): this;
        setMedium(arg0: number, arg1: number): this;
        hasArray(): boolean;
        setBoolean(arg0: number, arg1: boolean): this;
        writeBytes(arg0: Internal.ByteBuf_): this;
        setBytes(arg0: number, arg1: Internal.ScatteringByteChannel_, arg2: number): number;
        readLong(): number;
        writeByte(arg0: number): this;
        copy(): this;
        readBytes(arg0: Internal.ByteBuf_, arg1: number, arg2: number): this;
        ensureWritable(arg0: number, arg1: boolean): number;
        getBytes(arg0: number, arg1: Internal.FileChannel_, arg2: number, arg3: number): number;
        setDouble(arg0: number, arg1: number): this;
        readBytes(arg0: number): this;
        getUnsignedShort(arg0: number): number;
        readUnsignedByte(): number;
        refCnt(): number;
        getUnsignedShortLE(arg0: number): number;
        setIntLE(arg0: number, arg1: number): this;
        toString(arg0: Internal.Charset_): string;
        /**
         * @deprecated
        */
        order(arg0: Internal.ByteOrder_): this;
        setBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        toString(arg0: number, arg1: number, arg2: Internal.Charset_): string;
        get readable(): boolean
        get readOnly(): boolean
        get contiguous(): boolean
        get writable(): boolean
        get direct(): boolean
    }
    type ByteBuf_ = ByteBuf;
    class ClipContext {
        constructor($$0: Vec3d_, $$1: Vec3d_, $$2: any_, $$3: Internal.ClipContext$Fluid_, $$4: Internal.Entity_)
        getFluidShape($$0: Internal.FluidState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        getFrom(): Vec3d;
        getTo(): Vec3d;
        getBlockShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        get from(): Vec3d
        get to(): Vec3d
    }
    type ClipContext_ = ClipContext;
    interface WorldGenLevel extends Internal.ServerLevelAccessor {
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        getSeed(): number;
        dayTime(): number;
        getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getMaxSection(): number;
        getLevelData(): Internal.LevelData;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getBiome(pos: BlockPos_): Internal.Holder<any>;
        getSectionYFromSectionIndex($$0: number): number;
        players(): Internal.List<Internal.Player>;
        getBiomeManager(): Internal.BiomeManager;
        getRandom(): Internal.RandomSource;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        isClientSide(): boolean;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        dimensionType(): Internal.DimensionType;
        getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        /**
         * @deprecated
        */
        getSeaLevel(): number;
        getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        ensureCanWrite($$0: BlockPos_): boolean;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        getChunk($$0: number, $$1: number): Internal.ChunkAccess;
        addFreshEntity($$0: Internal.Entity_): boolean;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        getWorldBorder(): Internal.WorldBorder;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        gameEvent(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        neighborShapeChanged($$0: Internal.Direction_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: BlockPos_, $$4: number, $$5: number): void;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky($$0: BlockPos_): boolean;
        enabledFeatures(): Internal.FeatureFlagSet;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        addFreshEntityWithPassengers($$0: Internal.Entity_): void;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY($$0: number): number;
        getServer(): Internal.MinecraftServer;
        levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision($$0: Internal.Entity_): boolean;
        getLevel(): Internal.ServerLevel;
        getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getBestNeighborSignal($$0: BlockPos_): number;
        hasChunk($$0: number, $$1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        setCurrentlyGenerating($$0: Internal.Supplier_<string>): void;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        isOutsideBuildHeight($$0: number): boolean;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        getFluidState(arg0: BlockPos_): Internal.FluidState;
        getChunkSource(): Internal.ChunkSource;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        registryAccess(): Internal.RegistryAccess;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        nextSubTickCount(): number;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get seed(): number
        get maxSection(): number
        get levelData(): Internal.LevelData
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get server(): Internal.MinecraftServer
        get level(): Internal.ServerLevel
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        set currentlyGenerating($$0: Internal.Supplier_<string>)
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
    }
    type WorldGenLevel_ = WorldGenLevel;
    class CarverDebugSettings {
        static of($$0: boolean, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.BlockState_): Internal.CarverDebugSettings;
        getAirState(): Internal.BlockState;
        getBarrierState(): Internal.BlockState;
        getWaterState(): Internal.BlockState;
        static of($$0: boolean, $$1: Internal.BlockState_): Internal.CarverDebugSettings;
        getLavaState(): Internal.BlockState;
        static of($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.BlockState_): Internal.CarverDebugSettings;
        isDebugMode(): boolean;
        get airState(): Internal.BlockState
        get barrierState(): Internal.BlockState
        get waterState(): Internal.BlockState
        get lavaState(): Internal.BlockState
        get debugMode(): boolean
        static readonly DEFAULT: Internal.CarverDebugSettings;
        static readonly CODEC: Internal.Codec<Internal.CarverDebugSettings>;
    }
    type CarverDebugSettings_ = CarverDebugSettings;
    class WorldBorder {
        constructor()
        getDamagePerBlock(): number;
        getLerpRemainingTime(): number;
        getMaxZ(): number;
        removeListener($$0: Internal.BorderChangeListener_): void;
        clampToBounds($$0: number, $$1: number, $$2: number): BlockPos;
        getMaxX(): number;
        getAbsoluteMaxSize(): number;
        getLerpSpeed(): number;
        getCenterZ(): number;
        isWithinBounds($$0: number, $$1: number, $$2: number): boolean;
        getCenterX(): number;
        setWarningTime($$0: number): void;
        setCenter($$0: number, $$1: number): void;
        getStatus(): Internal.BorderStatus;
        getCollisionShape(): Internal.VoxelShape;
        setDamageSafeZone($$0: number): void;
        getWarningTime(): number;
        setSize($$0: number): void;
        applySettings($$0: Internal.WorldBorder$Settings_): void;
        getMinX(): number;
        getWarningBlocks(): number;
        createSettings(): Internal.WorldBorder$Settings;
        addListener($$0: Internal.BorderChangeListener_): void;
        getMinZ(): number;
        isWithinBounds($$0: Internal.AABB_): boolean;
        getDistanceToBorder($$0: Internal.Entity_): number;
        getSize(): number;
        getDamageSafeZone(): number;
        lerpSizeBetween($$0: number, $$1: number, $$2: number): void;
        getListeners(): Internal.List<Internal.BorderChangeListener>;
        redirect$hlj000$lithium$getUpdatedArea(instance: Internal.WorldBorder$BorderExtent_): Internal.WorldBorder$BorderExtent;
        tick(): void;
        setDamagePerBlock($$0: number): void;
        getLerpTarget(): number;
        getDistanceToBorder($$0: number, $$1: number): number;
        setAbsoluteMaxSize($$0: number): void;
        isWithinBounds($$0: BlockPos_): boolean;
        isInsideCloseToBorder($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        isWithinBounds($$0: number, $$1: number): boolean;
        isWithinBounds($$0: Internal.ChunkPos_): boolean;
        setWarningBlocks($$0: number): void;
        get damagePerBlock(): number
        get lerpRemainingTime(): number
        get maxZ(): number
        get maxX(): number
        get absoluteMaxSize(): number
        get lerpSpeed(): number
        get centerZ(): number
        get centerX(): number
        set warningTime($$0: number)
        get status(): Internal.BorderStatus
        get collisionShape(): Internal.VoxelShape
        set damageSafeZone($$0: number)
        get warningTime(): number
        set size($$0: number)
        get minX(): number
        get warningBlocks(): number
        get minZ(): number
        get size(): number
        get damageSafeZone(): number
        get listeners(): Internal.List<Internal.BorderChangeListener>
        set damagePerBlock($$0: number)
        get lerpTarget(): number
        set absoluteMaxSize($$0: number)
        set warningBlocks($$0: number)
        static readonly MAX_CENTER_COORDINATE: 2.9999984E7;
        static readonly MAX_SIZE: 5.9999968E7;
        static readonly DEFAULT_SETTINGS: Internal.WorldBorder$Settings;
    }
    type WorldBorder_ = WorldBorder;
    class PaintingVariant {
        constructor($$0: number, $$1: number)
        getWidth(): number;
        getHeight(): number;
        get width(): number
        get height(): number
    }
    type PaintingVariant_ = PaintingVariant | Special.PaintingVariant;
    class TrapezoidHeight extends Internal.HeightProvider {
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.TrapezoidHeight;
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_, $$2: number): Internal.TrapezoidHeight;
        static readonly CODEC: Internal.Codec<Internal.TrapezoidHeight>;
    }
    type TrapezoidHeight_ = TrapezoidHeight;
    abstract class PatrollingMonster extends Internal.Monster {
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        canBeLeader(): boolean;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        setPatrolTarget($$0: BlockPos_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        getPatrolTarget(): BlockPos;
        static checkPatrollingMonsterSpawnRules($$0: Internal.EntityType_<Internal.PatrollingMonster>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        canRiderInteract(): boolean;
        canJoinPatrol(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        hasPatrolTarget(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        setPatrolLeader($$0: boolean): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        isPatrolLeader(): boolean;
        findPatrolTarget(): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        set patrolTarget($$0: BlockPos_)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get patrolTarget(): BlockPos
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        set patrolLeader($$0: boolean)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get patrolLeader(): boolean
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type PatrollingMonster_ = PatrollingMonster;
    interface AnimatedTextureDuck {
        snr$uploadWithVisibility(): void;
    }
    type AnimatedTextureDuck_ = AnimatedTextureDuck;
    class RecipeCollection {
        constructor($$0: Internal.RegistryAccess_, $$1: Internal.List_<Internal.Recipe<any>>)
        hasSingleResultItem(): boolean;
        hasKnownRecipes(): boolean;
        hasFitting(): boolean;
        canCraft($$0: Internal.StackedContents_, $$1: number, $$2: number, $$3: Internal.RecipeBook_): void;
        hasCraftable(): boolean;
        registryAccess(): Internal.RegistryAccess;
        getRecipes($$0: boolean): Internal.List<Internal.Recipe<any>>;
        getDisplayRecipes($$0: boolean): Internal.List<Internal.Recipe<any>>;
        isCraftable($$0: Internal.Recipe_<any>): boolean;
        updateKnownRecipes($$0: Internal.RecipeBook_): void;
        getRecipes(): Internal.List<Internal.Recipe<any>>;
        get recipes(): Internal.List<Internal.Recipe<any>>
    }
    type RecipeCollection_ = RecipeCollection;
    class ChestType extends Internal.Enum<Internal.ChestType> implements Internal.StringRepresentable {
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static valueOf($$0: string): Internal.ChestType;
        getSerializedName(): string;
        getOpposite(): this;
        static values(): Internal.ChestType[];
        get serializedName(): string
        get opposite(): Internal.ChestType
        static readonly SINGLE: Internal.ChestType;
        static readonly LEFT: Internal.ChestType;
        static readonly RIGHT: Internal.ChestType;
    }
    type ChestType_ = "single" | ChestType | "right" | "left";
    abstract class OutputStream implements Internal.Closeable, Internal.Flushable {
        constructor()
        flush(): void;
        write(arg0: number): void;
        static nullOutputStream(): Internal.OutputStream;
        close(): void;
        write(arg0: number[], arg1: number, arg2: number): void;
        write(arg0: number[]): void;
    }
    type OutputStream_ = OutputStream;
    class Wolf extends Internal.TamableAnimal implements Internal.NeutralMob {
        constructor($$0: Internal.EntityType_<Internal.Wolf>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        isWet(): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        readPersistentAngerSaveData($$0: Internal.Level_, $$1: Internal.CompoundTag_): void;
        stopBeingAngry(): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        handler$fja000$faster_entity_animations$getShakeAnimationProgress(f: number, g: number, info: Internal.CallbackInfoReturnable_<any>): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        setCollarColor($$0: Internal.DyeColor_): void;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        handler$fja000$faster_entity_animations$getBegAnimationProgress(f: number, info: Internal.CallbackInfoReturnable_<any>): void;
        forgetCurrentTargetAndRefreshUniversalAnger(): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        getTailAngle(): number;
        canRiderInteract(): boolean;
        addPersistentAngerSaveData($$0: Internal.CompoundTag_): void;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        handler$jnh004$puzzleslib$mobInteract(player: Internal.Player_, interactionHand: Internal.InteractionHand_, callback: Internal.CallbackInfoReturnable_<any>): void;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        getPersistentAngerTarget(): Internal.UUID;
        static checkWolfSpawnRules($$0: Internal.EntityType_<Internal.Wolf>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        "handler$blo000$blanket-client-tweaks$getTailAngle"(cir: Internal.CallbackInfoReturnable_<any>): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        isAngryAtAllPlayers($$0: Internal.Level_): boolean;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getCollarColor(): Internal.DyeColor;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        playerDied($$0: Internal.Player_): void;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isAngry(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        startPersistentAngerTimer(): void;
        isMonster(): boolean;
        getBodyRollAngle($$0: number, $$1: number): number;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        setRemainingPersistentAngerTime($$0: number): void;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        lithiumOnEquipmentChanged(): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        setPersistentAngerTarget($$0: Internal.UUID_): void;
        static getSWIMMING_FLAG_INDEX(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setIsInterested($$0: boolean): void;
        getWetShade($$0: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        isInterested(): boolean;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        isAngryAt($$0: Internal.LivingEntity_): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getRemainingPersistentAngerTime(): number;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getHeadRollAngle($$0: number): number;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        updatePersistentAnger($$0: Internal.ServerLevel_, $$1: boolean): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get SILENT(): Internal.EntityDataAccessor<boolean>
        set defaultMovementSpeedMultiplier(speed: number)
        get SPRINTING_FLAG_INDEX(): number
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get wet(): boolean
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get totalMovementSpeed(): number
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        set collarColor($$0: Internal.DyeColor_)
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set maxHealth(hp: number)
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get tailAngle(): number
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get persistentAngerTarget(): Internal.UUID
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get collarColor(): Internal.DyeColor
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get angry(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        set remainingPersistentAngerTime($$0: number)
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set persistentAngerTarget($$0: Internal.UUID_)
        get SWIMMING_FLAG_INDEX(): number
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set isInterested($$0: boolean)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get interested(): boolean
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get remainingPersistentAngerTime(): number
        get CURRENT_ID(): Internal.AtomicInteger
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        isWet: boolean;
        static readonly PREY_SELECTOR: Internal.Predicate<Internal.LivingEntity>;
    }
    type Wolf_ = Wolf;
    class AttachedData <T> extends Internal.HashMap<string, any> {
        constructor(p: T)
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        static of<K, V>(): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        add(key: string, data: any): void;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        getParent(): T;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        get parent(): T
    }
    type AttachedData_<T> = AttachedData<T>;
    interface PositionedRectangle extends Internal.Animatable<Internal.PositionedRectangle> {
        of(x: number, y: number, width: number, height: number): this;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        isInBoundingBox(x: number, y: number): boolean;
        intersects(other: Internal.PositionedRectangle_): boolean;
        intersection(other: Internal.PositionedRectangle_): this;
        y(): number;
        x(): number;
        height(): number;
        width(): number;
        interpolate(next: Internal.PositionedRectangle_, delta: number): this;
        of(x: number, y: number, size: Internal.Size_): this;
    }
    type PositionedRectangle_ = PositionedRectangle;
    class EndCrystal extends Internal.Entity {
        constructor($$0: Internal.EntityType_<Internal.EndCrystal>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getSPRINTING_FLAG_INDEX(): number;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        isOnScoreboardTeam(teamId: string): boolean;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): Internal.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        static getSWIMMING_FLAG_INDEX(): number;
        spawn(): void;
        showsBottom(): boolean;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): Internal.Component;
        setMotionX(x: number): void;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        getScriptType(): Internal.ScriptType;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        setBeamTarget($$0: BlockPos_): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        getMotionZ(): number;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getBeamTarget(): BlockPos;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        setShowBottom($$0: boolean): void;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get SILENT(): Internal.EntityDataAccessor<boolean>
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get SPRINTING_FLAG_INDEX(): number
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get living(): boolean
        get GLOWING_FLAG_INDEX(): number
        get SWIMMING_FLAG_INDEX(): number
        get server(): Internal.MinecraftServer
        get displayName(): Internal.Component
        set motionX(x: number)
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get scriptType(): Internal.ScriptType
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        set dynamicLightEnabled(enabled: boolean)
        set beamTarget($$0: BlockPos_)
        get CURRENT_ID(): Internal.AtomicInteger
        get motionX(): number
        get waterCreature(): boolean
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get motionZ(): number
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get beamTarget(): BlockPos
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        set showBottom($$0: boolean)
        time: number;
    }
    type EndCrystal_ = EndCrystal;
    interface ExternalArrayData {
        getArrayElement(arg0: number): any;
        getArrayLength(): number;
        setArrayElement(arg0: number, arg1: any): void;
        get arrayLength(): number
    }
    type ExternalArrayData_ = ExternalArrayData;
    class ParticleStatus extends Internal.Enum<Internal.ParticleStatus> implements Internal.OptionEnum {
        static values(): Internal.ParticleStatus[];
        getKey(): string;
        static byId($$0: number): Internal.ParticleStatus;
        getCaption(): Internal.Component;
        static valueOf($$0: string): Internal.ParticleStatus;
        getId(): number;
        get key(): string
        get caption(): Internal.Component
        get id(): number
        static readonly ALL: Internal.ParticleStatus;
        static readonly DECREASED: Internal.ParticleStatus;
        static readonly MINIMAL: Internal.ParticleStatus;
    }
    type ParticleStatus_ = ParticleStatus | "minimal" | "decreased" | "all";
    interface VirtualElement {
        getOffset(): Vec3d;
        notifyMove(arg0: Vec3d_, arg1: Vec3d_, arg2: Vec3d_): void;
        stopWatching(arg0: Internal.ServerPlayer_, arg1: Internal.Consumer_<Internal.Packet<Internal.ClientGamePacketListener>>): void;
        getInteractionHandler(arg0: Internal.ServerPlayer_): Internal.VirtualElement$InteractionHandler;
        setHolder(arg0: Internal.ElementHolder_): void;
        startWatching(arg0: Internal.ServerPlayer_, arg1: Internal.Consumer_<Internal.Packet<Internal.ClientGamePacketListener>>): void;
        setOffset(arg0: Vec3d_): void;
        setInitialPosition(newPos: Vec3d_): void;
        tick(): void;
        getHolder(): Internal.ElementHolder;
        getEntityIds(): Internal.IntList;
        get offset(): Vec3d
        set holder(arg0: Internal.ElementHolder_)
        set offset(arg0: Vec3d_)
        set initialPosition(newPos: Vec3d_)
        get holder(): Internal.ElementHolder
        get entityIds(): Internal.IntList
    }
    type VirtualElement_ = VirtualElement;
    class ClientboundSetBorderWarningDistancePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getWarningBlocks(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get warningBlocks(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderWarningDistancePacket_ = ClientboundSetBorderWarningDistancePacket;
    interface ParticleAccessor {
        port_lib$stoppedByCollision(arg0: boolean): void;
    }
    type ParticleAccessor_ = ParticleAccessor;
    interface EntityInstancingController <T extends Internal.Entity> {
        createInstance(arg0: Internal.MaterialManager_, arg1: T): Internal.EntityInstance<T>;
        shouldSkipRender(arg0: T): boolean;
    }
    type EntityInstancingController_<T extends Internal.Entity> = EntityInstancingController<T>;
    class RailShape extends Internal.Enum<Internal.RailShape> implements Internal.StringRepresentable {
        static values(): Internal.RailShape[];
        isAscending(): boolean;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        getName(): string;
        static valueOf($$0: string): Internal.RailShape;
        get ascending(): boolean
        get serializedName(): string
        get name(): string
        static readonly NORTH_EAST: Internal.RailShape;
        static readonly NORTH_WEST: Internal.RailShape;
        static readonly SOUTH_EAST: Internal.RailShape;
        static readonly ASCENDING_WEST: Internal.RailShape;
        static readonly ASCENDING_EAST: Internal.RailShape;
        static readonly ASCENDING_NORTH: Internal.RailShape;
        static readonly ASCENDING_SOUTH: Internal.RailShape;
        static readonly NORTH_SOUTH: Internal.RailShape;
        static readonly EAST_WEST: Internal.RailShape;
        static readonly SOUTH_WEST: Internal.RailShape;
    }
    type RailShape_ = "north_west" | "north_east" | "ascending_west" | "south_west" | "ascending_east" | RailShape | "north_south" | "east_west" | "ascending_south" | "ascending_north" | "south_east";
    class Passthrough implements Internal.RuleBlockEntityModifier {
        constructor()
        getType(): Internal.RuleBlockEntityModifierType<any>;
        apply($$0: Internal.RandomSource_, $$1: Internal.CompoundTag_): Internal.CompoundTag;
        get type(): Internal.RuleBlockEntityModifierType<any>
        static readonly INSTANCE: Internal.Passthrough;
        static readonly CODEC: Internal.Codec<Internal.Passthrough>;
    }
    type Passthrough_ = Passthrough;
    class Display$ItemDisplay extends Internal.Display implements Internal.ItemDisplayEntityAccessor {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static getSCALE(): Internal.EntityDataAccessor<Vec3f>;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        static getSPRINTING_FLAG_INDEX(): number;
        isOnScoreboardTeam(teamId: string): boolean;
        static getSHADOW_STRENGTH(): Internal.EntityDataAccessor<number>;
        itemRenderState(): Internal.Display$ItemDisplay$ItemRenderState;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        static "getITEM$polymer-virtual-entity_$md$896f98$0"(): Internal.EntityDataAccessor<any>;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        static getITEM_DISPLAY(): Internal.EntityDataAccessor<number>;
        static getGLOWING_FLAG_INDEX(): number;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        static getTRANSLATION(): Internal.EntityDataAccessor<Vec3f>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        static getSHADOW_RADIUS(): Internal.EntityDataAccessor<number>;
        isWaterCreature(): boolean;
        static getHEIGHT(): Internal.EntityDataAccessor<number>;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        static getBRIGHTNESS(): Internal.EntityDataAccessor<number>;
        isFrame(): boolean;
        playSound(id: Internal.SoundEvent_): void;
        static getSTART_INTERPOLATION(): Internal.EntityDataAccessor<number>;
        static getLEFT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>;
        static getITEM(): Internal.EntityDataAccessor<Internal.ItemStack>;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        static getVIEW_RANGE(): Internal.EntityDataAccessor<number>;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        static getBILLBOARD(): Internal.EntityDataAccessor<number>;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>;
        betterTrims$getTrimmables(): Internal.Iterable<any>;
        getType(): string;
        static getWIDTH(): Internal.EntityDataAccessor<number>;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        static getGLOW_COLOR_OVERRIDE(): Internal.EntityDataAccessor<number>;
        static getSWIMMING_FLAG_INDEX(): number;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        polymerVE$getPosHolder(pos: BlockPos_): Internal.BlockBoundAttachment;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        static getCURRENT_ID(): Internal.AtomicInteger;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        polymerVE$removePosHolder(pos: BlockPos_): void;
        static getSNEAKING_FLAG_INDEX(): number;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        static getINTERPOLATION_DURATION(): Internal.EntityDataAccessor<number>;
        runCommand(command: string): number;
        static "getITEM_DISPLAY$polymer-virtual-entity_$md$896f98$1"(): Internal.EntityDataAccessor<any>;
        static getRIGHT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>;
        get SCALE(): Internal.EntityDataAccessor<Vec3f>
        get SILENT(): Internal.EntityDataAccessor<boolean>
        get SPRINTING_FLAG_INDEX(): number
        get SHADOW_STRENGTH(): Internal.EntityDataAccessor<number>
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get AIR(): Internal.EntityDataAccessor<number>
        get "ITEM$polymer-virtual-entity_$md$896f98$0"(): Internal.EntityDataAccessor<any>
        get living(): boolean
        get ITEM_DISPLAY(): Internal.EntityDataAccessor<number>
        get GLOWING_FLAG_INDEX(): number
        get displayName(): Internal.Component
        get ON_FIRE_FLAG_INDEX(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get NO_GRAVITY(): Internal.EntityDataAccessor<boolean>
        get teamId(): string
        get INVISIBLE_FLAG_INDEX(): number
        get facing(): Internal.Direction
        get FROZEN_TICKS(): Internal.EntityDataAccessor<number>
        get FLAGS(): Internal.EntityDataAccessor<number>
        get TRANSLATION(): Internal.EntityDataAccessor<Vec3f>
        get motionX(): number
        get SHADOW_RADIUS(): Internal.EntityDataAccessor<number>
        get waterCreature(): boolean
        get HEIGHT(): Internal.EntityDataAccessor<number>
        get POSE(): Internal.EntityDataAccessor<Internal.Pose>
        get NAME_VISIBLE(): Internal.EntityDataAccessor<boolean>
        get item(): Internal.ItemStack
        set x(x: number)
        get FALL_FLYING_FLAG_INDEX(): number
        get BRIGHTNESS(): Internal.EntityDataAccessor<number>
        get frame(): boolean
        get START_INTERPOLATION(): Internal.EntityDataAccessor<number>
        get LEFT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>
        get ITEM(): Internal.EntityDataAccessor<Internal.ItemStack>
        set motionY(y: number)
        get peacefulCreature(): boolean
        get VIEW_RANGE(): Internal.EntityDataAccessor<number>
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get BILLBOARD(): Internal.EntityDataAccessor<number>
        get monster(): boolean
        get CUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Component>>
        get type(): string
        get WIDTH(): Internal.EntityDataAccessor<number>
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        get GLOW_COLOR_OVERRIDE(): Internal.EntityDataAccessor<number>
        get SWIMMING_FLAG_INDEX(): number
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get CURRENT_ID(): Internal.AtomicInteger
        get motionZ(): number
        get SNEAKING_FLAG_INDEX(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        get INTERPOLATION_DURATION(): Internal.EntityDataAccessor<number>
        get "ITEM_DISPLAY$polymer-virtual-entity_$md$896f98$1"(): Internal.EntityDataAccessor<any>
        get RIGHT_ROTATION(): Internal.EntityDataAccessor<Quaternionf>
    }
    type Display$ItemDisplay_ = Display$ItemDisplay;
    interface MaterialView {
        emissive(): boolean;
        ambientOcclusion(): net.fabricmc.fabric.api.util.TriState;
        disableDiffuse(): boolean;
        glint(): net.fabricmc.fabric.api.util.TriState;
        blendMode(): net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        disableColorIndex(): boolean;
    }
    type MaterialView_ = MaterialView;
    interface AbstractFurnaceBlockEntityAccessor {
        getCookTimeTotal(): number;
        get cookTimeTotal(): number
    }
    type AbstractFurnaceBlockEntityAccessor_ = AbstractFurnaceBlockEntityAccessor;
    abstract class LeveledRegion <T extends Internal.RegionTexture<T>> implements Internal.Comparable<Internal.LeveledRegion<T>> {
        constructor(worldId: string, dimId: string, mwId: string, dim: Internal.MapDimension_, level: number, leveledX: number, leveledZ: number, caveLayer: number, parent: Internal.BranchLeveledRegion_)
        preCache(): void;
        ensureBiomePalette(): void;
        isMetaLoaded(): boolean;
        setShouldCache(shouldCache: boolean, by: string): void;
        calculateSortingChunkDistance(): void;
        recacheHasBeenRequested(): boolean;
        shouldAllowAnotherRegionToLoad(): boolean;
        compareTo(arg0: any): number;
        hasTextures(): boolean;
        loadCacheTextures(mapProcessor: Internal.MapProcessor_, biomeRegistry: Internal.Registry_<Internal.Biome>, justMetaData: boolean, textureLoaded: boolean[][], targetHighlightsHash: number, leafShouldAffectBranchesDest: boolean[], metaLoadedDest: boolean[], extraAttempts: number, oldFormatSupport: Internal.OldFormatSupport_): boolean;
        cleanAndCacheRequestsBlocked(): boolean;
        getBiomePaletteSize(): number;
        setReloadHasBeenRequested(reloadHasBeenRequested: boolean, by: string): void;
        getBiomePalette(): Internal.FastPalette<Internal.ResourceKey<Internal.Biome>>;
        setAllCachePrepared(allCachePrepared: boolean): void;
        getLevel(): number;
        uncountTextureBiomes(texture: Internal.RegionTexture_<any>): void;
        getCaveLayer(): number;
        shouldEndProcessingAfterUpload(): boolean;
        onBiomeAddedToTexture(biome: Internal.ResourceKey_<Internal.Biome>): number;
        findCacheFile(arg0: Internal.MapSaveLoad_): Internal.File;
        isRefreshing(): boolean;
        deleteBuffers(): void;
        getExtraInfo(): string;
        confirmMetaLoaded(): void;
        onLimiterRemoval(arg0: Internal.MapProcessor_): void;
        isLoaded(): boolean;
        shouldCache(): boolean;
        getBiomeKey(paletteIndex: number): Internal.ResourceKey<Internal.Biome>;
        isAllCachePrepared(): boolean;
        deleteGLBuffers(): void;
        calculateSortingDistance(): void;
        shouldBeProcessed(): boolean;
        shouldAffectLoadingRequestFrequency(): boolean;
        putTexture(arg0: number, arg1: number, arg2: T): void;
        getTexture(arg0: number, arg1: number): T;
        updateLeafTextureVersion(localTextureX: number, localTextureZ: number, newVersion: number): void;
        setRecacheHasBeenRequested(recacheHasBeenRequested: boolean, by: string): void;
        checkForUpdates(mapProcessor: Internal.MapProcessor_, prevWaitingForBranchCache: boolean, waitingForBranchCache: boolean[], branchRegionBuffer: Internal.ArrayList_<Internal.BranchLeveledRegion>, viewedLevel: number, minViewedLeafX: number, minViewedLeafZ: number, maxViewedLeafX: number, maxViewedLeafZ: number): void;
        getRootRegion(): Internal.LeveledRegion<any>;
        reloadHasBeenRequested(): boolean;
        setCacheFile(cacheFile: Internal.File_): void;
        resetBiomePalette(): void;
        getCacheFile(): Internal.File;
        deleteTexturesAndBuffers(): void;
        processWhenLoadedChunksExist(globalRegionCacheHashCode: number): void;
        getBiomePaletteIndex(biome: Internal.ResourceKey_<Internal.Biome>): number;
        getRegionZ(): number;
        getParent(): Internal.BranchLeveledRegion;
        onDimensionClear(mapProcessor: Internal.MapProcessor_): void;
        getDim(): Internal.MapDimension;
        getRegionX(): number;
        createTexture(arg0: number, arg1: number): T;
        saveCacheTextures(tempFile: Internal.File_, extraAttempts: number): boolean;
        getAndResetCachedTextureVersion(x: number, y: number): number;
        saveBiomePalette(output: Internal.DataOutputStream_): void;
        compareTo(arg0: Internal.LeveledRegion_<T>): number;
        loadingAnimation(): boolean;
        afterLimiterRemoval(arg0: Internal.MapProcessor_): void;
        addDebugLines(debugLines: Internal.List_<string>, mapProcessor: Internal.MapProcessor_, textureX: number, textureY: number): void;
        postCache(arg0: Internal.File_, arg1: Internal.MapSaveLoad_, arg2: boolean): void;
        skipCaching(arg0: Internal.MapProcessor_): boolean;
        hasRemovableSourceData(): boolean;
        static setComparison(x: number, z: number, level: number, leafX: number, leafZ: number): void;
        onCurrentDimFinish(arg0: Internal.MapSaveLoad_, arg1: Internal.MapProcessor_): void;
        onBiomeRemovedFromTexture(paletteIndex: number): void;
        onProcessingEnd(): void;
        get metaLoaded(): boolean
        get biomePaletteSize(): number
        get biomePalette(): Internal.FastPalette<Internal.ResourceKey<Internal.Biome>>
        set allCachePrepared(allCachePrepared: boolean)
        get level(): number
        get caveLayer(): number
        get refreshing(): boolean
        get extraInfo(): string
        get loaded(): boolean
        get allCachePrepared(): boolean
        get rootRegion(): Internal.LeveledRegion<any>
        set cacheFile(cacheFile: Internal.File_)
        get cacheFile(): Internal.File
        get regionZ(): number
        get parent(): Internal.BranchLeveledRegion
        get dim(): Internal.MapDimension
        get regionX(): number
        static readonly SIDE_LENGTH: 8;
        leafTextureVersionSum: number[][];
        activeBranchUpdateReferences: number;
    }
    type LeveledRegion_<T extends Internal.RegionTexture<T>> = LeveledRegion<T>;
    class TrackNode {
        constructor(location: Internal.TrackNodeLocation_, netId: number, normal: Vec3d_)
        getNetId(): number;
        getNormal(): Vec3d;
        getLocation(): Internal.TrackNodeLocation;
        get netId(): number
        get normal(): Vec3d
        get location(): Internal.TrackNodeLocation
    }
    type TrackNode_ = TrackNode;
    interface PackSource {
        create($$0: Internal.UnaryOperator_<Internal.Component>, $$1: boolean): this;
        shouldAddAutomatically(): boolean;
        decorate(arg0: Internal.Component_): Internal.Component;
        readonly NO_DECORATION: Internal.UnaryOperator<Internal.Component>;
        readonly FEATURE: Internal.PackSource;
        readonly DEFAULT: Internal.PackSource;
        readonly SERVER: Internal.PackSource;
        readonly BUILT_IN: Internal.PackSource;
        readonly WORLD: Internal.PackSource;
    }
    type PackSource_ = PackSource;
    abstract class ObjectCategoryRule <E, P> {
        isFollowedBy(arg0: E, arg1: P): boolean;
        getName(): string;
        get name(): string
    }
    type ObjectCategoryRule_<E, P> = ObjectCategoryRule<E, P>;
    abstract class EntityInstance <E extends Internal.Entity> extends Internal.AbstractInstance implements Internal.TickingLightListener, Internal.LightListener {
        constructor(materialManager: Internal.MaterialManager_, entity: E)
        getInstancePosition(): Vec3f;
        onLightPacket(chunkX: number, chunkZ: number): void;
        getInstancePosition(partialTicks: number): Vec3f;
        getVolume(): Internal.GridAlignedBB;
        tickLightListener(): boolean;
        get instancePosition(): Vec3f
        get volume(): Internal.GridAlignedBB
    }
    type EntityInstance_<E extends Internal.Entity> = EntityInstance<E>;
    class Display$TextDisplay$Align extends Internal.Enum<Internal.Display$TextDisplay$Align> implements Internal.StringRepresentable {
        static values(): Internal.Display$TextDisplay$Align[];
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Display$TextDisplay$Align;
        get serializedName(): string
        static readonly LEFT: Internal.Display$TextDisplay$Align;
        static readonly CODEC: Internal.Codec<Internal.Display$TextDisplay$Align>;
        static readonly CENTER: Internal.Display$TextDisplay$Align;
        static readonly RIGHT: Internal.Display$TextDisplay$Align;
    }
    type Display$TextDisplay$Align_ = "center" | "right" | Display$TextDisplay$Align | "left";
    class Monitor {
        constructor($$0: number)
        getModeCount(): number;
        getX(): number;
        getY(): number;
        getPreferredVidMode($$0: Internal.Optional_<Internal.VideoMode>): Internal.VideoMode;
        getMonitor(): number;
        getMode($$0: number): Internal.VideoMode;
        getCurrentMode(): Internal.VideoMode;
        refreshVideoModes(): void;
        getVideoModeIndex($$0: Internal.VideoMode_): number;
        get modeCount(): number
        get x(): number
        get y(): number
        get monitor(): number
        get currentMode(): Internal.VideoMode
    }
    type Monitor_ = Monitor;
    interface FireworkRocketEntityKJS {
        setLifetimeKJS(arg0: number): void;
        set lifetimeKJS(arg0: number)
    }
    type FireworkRocketEntityKJS_ = FireworkRocketEntityKJS;
    interface StackedContentsCompatible {
        fillStackedContents(arg0: Internal.StackedContents_): void;
    }
    type StackedContentsCompatible_ = StackedContentsCompatible;
    class ServerStatsCounter extends Internal.StatsCounter {
        constructor($$0: Internal.MinecraftServer_, $$1: Internal.File_)
        parseLocal($$0: Internal.DataFixer_, $$1: string): void;
        handler$lki000$tcdcommons$onSendStats(player: Internal.ServerPlayer_, callback: Internal.CallbackInfo_): void;
        sendStats($$0: Internal.ServerPlayer_): void;
        handler$bjc000$betterstats$onSetStat(player: Internal.Player_, stat: Internal.Stat_<any>, value: number, ci: Internal.CallbackInfo_): void;
        markAllDirty(): void;
        save(): void;
    }
    type ServerStatsCounter_ = ServerStatsCounter;
    interface IMixinWorld {
        minihud_getBlockEntityTickers(): Internal.List<Internal.TickingBlockEntity>;
    }
    type IMixinWorld_ = IMixinWorld;
    class NetherPortalBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        handler$leo000$spelunkery$bringToTears(state: Internal.BlockState_, direction: Internal.Direction_, neighborState: Internal.BlockState_, level: Internal.LevelAccessor_, currentPos: BlockPos_, neighborPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type NetherPortalBlock_ = NetherPortalBlock;
    class Outliner {
        constructor()
        showLine(slot: any, start: Vec3d_, end: Vec3d_): Internal.Outline$OutlineParams;
        edit(slot: any): Internal.Optional<Internal.Outline$OutlineParams>;
        remove(slot: any): void;
        showAABB(slot: any, bb: Internal.AABB_, ttl: number): Internal.Outline$OutlineParams;
        showValueBox(slot: any, box: Internal.ValueBox_): Internal.Outline$OutlineParams;
        renderOutlines(ms: Internal.PoseStack_, buffer: Internal.SuperRenderTypeBuffer_, camera: Vec3d_, pt: number): void;
        showAABB(slot: any, bb: Internal.AABB_): Internal.Outline$OutlineParams;
        showCluster(slot: any, selection: Internal.Iterable_<BlockPos>): Internal.Outline$OutlineParams;
        keep(slot: any): void;
        endChasingLine(slot: any, start: Vec3d_, end: Vec3d_, chasingProgress: number, lockStart: boolean): Internal.Outline$OutlineParams;
        showItem(slot: any, pos: Vec3d_, stack: Internal.ItemStack_): Internal.Outline$OutlineParams;
        getOutlines(): Internal.Map<any, Internal.Outliner$OutlineEntry>;
        chaseAABB(slot: any, bb: Internal.AABB_): Internal.Outline$OutlineParams;
        tickOutlines(): void;
        get outlines(): Internal.Map<any, Internal.Outliner$OutlineEntry>
    }
    type Outliner_ = Outliner;
    class GameProfileCache$GameProfileInfo {
        getLastAccess(): number;
        getProfile(): Internal.GameProfile;
        setLastAccess($$0: number): void;
        getExpirationDate(): Internal.Date;
        get lastAccess(): number
        get profile(): Internal.GameProfile
        set lastAccess($$0: number)
        get expirationDate(): Internal.Date
    }
    type GameProfileCache$GameProfileInfo_ = GameProfileCache$GameProfileInfo;
    class AcaciaFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.AcaciaFoliagePlacer>;
    }
    type AcaciaFoliagePlacer_ = AcaciaFoliagePlacer;
    class ModifierPrefixTextProvider {
        constructor(modifier: Internal.KeyModifier_)
        constructor(translationKey: string)
        getText(variation: Internal.ModifierPrefixTextProvider$Variation_): Internal.MutableComponent;
    }
    type ModifierPrefixTextProvider_ = ModifierPrefixTextProvider;
    interface PresetEditor {
        createEditScreen(arg0: Internal.CreateWorldScreen_, arg1: Internal.WorldCreationContext_): Internal.Screen;
        readonly EDITORS: {[key: Internal.Optional<any>]: any, [key: Internal.Optional<any>]: any};
    }
    type PresetEditor_ = PresetEditor;
    interface ShulkerEntityInvoker {
        repurposedstructures_callSetAttachFace(arg0: Internal.Direction_): void;
    }
    type ShulkerEntityInvoker_ = ShulkerEntityInvoker;
    class PlaceOnWaterBlockItem extends Internal.BlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        getLightColor(arg0: Internal.Player_, arg1: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PlaceOnWaterBlockItem_ = PlaceOnWaterBlockItem;
    abstract class AbstractBogeyBlock <T extends Internal.AbstractBogeyBlockEntity> extends Internal.Block implements Internal.ProperWaterloggedBlock, Internal.ISpecialBlockItemRequirement, Internal.IWrenchable, Internal.IBE<T> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_, size: Internal.BogeySizes$BogeySize_)
        allowsSingleBogeyCarriage(): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, te: Internal.BlockEntity_): Internal.ItemRequirement;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): T;
        isUpsideDown(state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<T>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getVersion(base: Internal.BlockState_, upsideDown: boolean): Internal.BlockState;
        isOnIncompatibleTrack(carriage: Internal.Carriage_, leading: boolean): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<T>;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getNextStyle(level: Internal.Level_, pos: BlockPos_): Internal.BogeyStyle;
        setDestroySpeed(v: number): void;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        playRemoveSound(world: Internal.Level_, pos: BlockPos_): void;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getStateOfSize(sbte: Internal.AbstractBogeyBlockEntity_, size: Internal.BogeySizes$BogeySize_): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getStickySurfaces(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.EnumSet<Internal.Direction>;
        getNextSize(sbte: Internal.AbstractBogeyBlockEntity_): Internal.BlockState;
        getValidPathfindingTypes(style: Internal.BogeyStyle_): Internal.Set<Internal.TrackMaterial$TrackType>;
        getBlockEntityType(): Internal.BlockEntityType<T>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getWheelRadius(): number;
        playRotateSound(world: Internal.Level_, pos: BlockPos_): void;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getTrackType(arg0: Internal.BogeyStyle_): Internal.TrackMaterial$TrackType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<T, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        /**
         * @deprecated
        */
        static registerStandardBogey(block: ResourceLocation_): void;
        getBlockEntityClass(): T;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getConnectorAnchorOffset(upsideDown: boolean): Vec3d;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        arch$registryName(): ResourceLocation;
        getNextStyle(style: Internal.BogeyStyle_): Internal.BogeyStyle;
        isTrackAxisAlongFirstCoordinate(state: Internal.BlockState_): boolean;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        render(state: Internal.BlockState_, wheelAngle: number, ms: Internal.PoseStack_, partialTicks: number, buffers: Internal.MultiBufferSource_, light: number, overlay: number, style: Internal.BogeyStyle_, bogeyData: Internal.CompoundTag_): void;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(state: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        getWheelPointSpacing(): number;
        getMatchingBogey(upDirection: Internal.Direction_, axisAlongFirst: boolean): Internal.BlockState;
        getDefaultStyle(): Internal.BogeyStyle;
        getSize(): Internal.BogeySizes$BogeySize;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        propertiesToCopy(): Internal.List<Internal.Property<any>>;
        captureBlockEntityForTrain(): boolean;
        getNextSize(level: Internal.Level_, pos: BlockPos_): Internal.BlockState;
        canBeUpsideDown(): boolean;
        getBogeyUpDirection(): Internal.Direction;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<T>
        get wheelRadius(): number
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): T
        set requiresTool(v: boolean)
        get mod(): string
        get wheelPointSpacing(): number
        get defaultStyle(): Internal.BogeyStyle
        get size(): Internal.BogeySizes$BogeySize
        get bogeyUpDirection(): Internal.Direction
        size: Internal.BogeySizes$BogeySize;
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type AbstractBogeyBlock_<T extends Internal.AbstractBogeyBlockEntity> = AbstractBogeyBlock<T>;
    interface ChunkGeneratorAccessor {
        bcl_setBiomeSource(arg0: Internal.BiomeSource_): void;
        bcl_setFeaturesPerStep(arg0: Internal.Supplier_<Internal.List<Internal.FeatureSorter$StepFeatureData>>): void;
    }
    type ChunkGeneratorAccessor_ = ChunkGeneratorAccessor;
    abstract class FastMapKey <T extends Internal.Comparable<T>> {
        getProperty(): Internal.Property<T>;
        getValue(arg0: number): T;
        numValues(): number;
        get property(): Internal.Property<T>
    }
    type FastMapKey_<T extends Internal.Comparable<T>> = FastMapKey<T>;
    abstract class GlslPreprocessor {
        constructor()
        process($$0: string): Internal.List<string>;
        applyImport(arg0: boolean, arg1: string): string;
    }
    type GlslPreprocessor_ = GlslPreprocessor;
    class HoverEvent$ItemStackInfo {
        constructor($$0: Internal.ItemStack_)
        getItemStack(): Internal.ItemStack;
        get itemStack(): Internal.ItemStack
    }
    type HoverEvent$ItemStackInfo_ = HoverEvent$ItemStackInfo;
    interface AccessorBlockEntityType {
        setValidBlocks(arg0: Internal.Set_<Internal.Block>): void;
        getValidBlocks(): Internal.Set<Internal.Block>;
        set validBlocks(arg0: Internal.Set_<Internal.Block>)
        get validBlocks(): Internal.Set<Internal.Block>
    }
    type AccessorBlockEntityType_ = AccessorBlockEntityType;
    interface Reference2IntFunction <K> extends Internal.ToIntFunction<K>, it.unimi.dsi.fastutil.Function<K, number> {
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        removeInt(arg0: any): number;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Reference2ByteFunction<K>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2IntFunction<T>;
        apply(arg0: K): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Reference2ShortFunction<K>;
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2IntFunction;
        getInt(arg0: any): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Reference2LongFunction<K>;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2IntFunction;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2IntFunction;
        applyAsInt(arg0: K): number;
        size(): number;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2IntFunction<T>;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Reference2CharFunction<K>;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        identity<T>(): Internal.Function<T, T>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Reference2FloatFunction<K>;
        (arg0: any): number;
    }
    type Reference2IntFunction_<K> = Reference2IntFunction<K>;
    class ClientboundSetCameraPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntity($$0: Internal.Level_): Internal.Entity;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundSetCameraPacket_ = ClientboundSetCameraPacket;
    /**
     * Invoked when a player sends a chat message.
     * 
     * If cancelled (`PlayerEvents.chat`), the message will not be sent.
    */
    class PlayerChatDecorateEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.ServerPlayer_, chatComponent: Internal.ChatEvent$ChatComponent_)
        /**
         * Gets the message that the player sent.
        */
        getMessage(): string;
        /**
         * Gets the player that sent the message.
        */
        getEntity(): Internal.Entity;
        /**
         * Gets the username of the player that sent the message.
        */
        getUsername(): string;
        /**
         * Sets the message that the player sent.
        */
        setMessage(text: Internal.Component_): void;
        /**
         * Gets the message that the player sent.
        */
        getComponent(): Internal.Component;
        /**
         * Sets the message that the player sent.
        */
        setComponent(text: Internal.Component_): void;
        /**
         * Gets the message that the player sent.
        */
        get message(): string
        /**
         * Gets the player that sent the message.
        */
        get entity(): Internal.Entity
        /**
         * Gets the username of the player that sent the message.
        */
        get username(): string
        /**
         * Sets the message that the player sent.
        */
        set message(text: Internal.Component_)
        /**
         * Gets the message that the player sent.
        */
        get component(): Internal.Component
        /**
         * Sets the message that the player sent.
        */
        set component(text: Internal.Component_)
        chatComponent: Internal.ChatEvent$ChatComponent;
    }
    type PlayerChatDecorateEventJS_ = PlayerChatDecorateEventJS;
    class BeehiveBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getOccupantCount(): number;
        invalidateCaps(): void;
        static getHoneyLevel($$0: Internal.BlockState_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isFull(): boolean;
        emptyAllLivingFromHive($$0: Internal.Player_, $$1: Internal.BlockState_, $$2: Internal.BeehiveBlockEntity$BeeReleaseStatus_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isDynamicLightEnabled(): boolean;
        isEmpty(): boolean;
        isSedated(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BeehiveBlockEntity_): void;
        addOccupantWithPresetTicks($$0: Internal.Entity_, $$1: boolean, $$2: number): void;
        isFireNearby(): boolean;
        addOccupant($$0: Internal.Entity_, $$1: boolean): void;
        onLoad(): void;
        setDynamicLightEnabled(enabled: boolean): void;
        storeBee($$0: Internal.CompoundTag_, $$1: number, $$2: boolean): void;
        writeBees(): Internal.ListTag;
        get occupantCount(): number
        get full(): boolean
        get dynamicLightEnabled(): boolean
        get empty(): boolean
        get sedated(): boolean
        get fireNearby(): boolean
        set dynamicLightEnabled(enabled: boolean)
        static readonly TICKS_IN_HIVE: "TicksInHive";
        static readonly BEES: "Bees";
        static readonly HAS_NECTAR: "HasNectar";
        static readonly TAG_FLOWER_POS: "FlowerPos";
        static readonly MIN_OCCUPATION_TICKS_NECTARLESS: 600;
        static readonly MIN_OCCUPATION_TICKS: "MinOccupationTicks";
        static readonly ENTITY_DATA: "EntityData";
        static readonly MAX_OCCUPANTS: 3;
    }
    type BeehiveBlockEntity_ = BeehiveBlockEntity;
    abstract class EnumSet <E extends Internal.Enum<E>> extends Internal.AbstractSet<E> implements Internal.Cloneable, Internal.Serializable {
        static of<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        parallelStream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.Collection_<E>): Internal.EnumSet<E>;
        static allOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        static noneOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        clone(): this;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, ...arg1: E[]): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.EnumSet<E>;
        toArray<T>(arg0: T[]): T[];
        static complementOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E): Internal.EnumSet<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static range<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
    }
    type EnumSet_<E extends Internal.Enum<E>> = EnumSet<E>;
    interface IBufferBuilder {
        immediatelyFast$isReleased(): boolean;
        immediatelyFast$release(): void;
    }
    type IBufferBuilder_ = IBufferBuilder;
    interface LithiumInventory extends Internal.Container {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        setInventoryLithium(arg0: Internal.NonNullList_<Internal.ItemStack>): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        setItem(arg0: number, arg1: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): Internal.Container;
        kjs$self(): Internal.Container;
        getInventoryLithium(): Internal.NonNullList<Internal.ItemStack>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        generateLootLithium(): void;
        canTakeItem($$0: Internal.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        getItem(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        set inventoryLithium(arg0: Internal.NonNullList_<Internal.ItemStack>)
        get containerSize(): number
        get height(): number
        get inventoryLithium(): Internal.NonNullList<Internal.ItemStack>
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type LithiumInventory_ = LithiumInventory;
    class Type$FieldNotFoundException extends Internal.Type$TypeError {
        constructor(arg0: string)
    }
    type Type$FieldNotFoundException_ = Type$FieldNotFoundException;
    class ArmorItemBuilder$Boots extends Internal.ArmorItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): any;
    }
    type ArmorItemBuilder$Boots_ = ArmorItemBuilder$Boots;
    interface SlotAccessor {
        owo$setY(arg0: number): void;
        owo$setX(arg0: number): void;
    }
    type SlotAccessor_ = SlotAccessor;
    interface RuleBlockEntityModifierType <P extends Internal.RuleBlockEntityModifier> {
        codec(): Internal.Codec<P>;
        readonly PASSTHROUGH: Internal.RuleBlockEntityModifierType<Internal.Passthrough>;
        readonly CLEAR: Internal.RuleBlockEntityModifierType<Internal.Clear>;
        readonly APPEND_LOOT: Internal.RuleBlockEntityModifierType<Internal.AppendLoot>;
        readonly APPEND_STATIC: Internal.RuleBlockEntityModifierType<Internal.AppendStatic>;
    }
    type RuleBlockEntityModifierType_<P extends Internal.RuleBlockEntityModifier> = RuleBlockEntityModifierType<P> | Special.RuleBlockEntityModifier;
    class SpriteFinderImpl implements Internal.SpriteFinder {
        constructor(sprites: Internal.Map_<ResourceLocation, Internal.TextureAtlasSprite>, spriteAtlasTexture: Internal.TextureAtlas_)
        /**
         * @deprecated
        */
        find(quad: Internal.QuadView_, textureIndex: number): Internal.TextureAtlasSprite;
        find(u: number, v: number): Internal.TextureAtlasSprite;
        find(quad: Internal.QuadView_): Internal.TextureAtlasSprite;
        static get(atlas: Internal.TextureAtlas_): Internal.SpriteFinderImpl;
    }
    type SpriteFinderImpl_ = SpriteFinderImpl;
    interface ProfilerFiller {
        markForCharting(arg0: Internal.MetricCategory_): void;
        push(arg0: Internal.Supplier_<string>): void;
        tee($$0: Internal.ProfilerFiller_, $$1: Internal.ProfilerFiller_): this;
        incrementCounter(arg0: string, arg1: number): void;
        popPush(arg0: string): void;
        push(arg0: string): void;
        incrementCounter($$0: Internal.Supplier_<string>): void;
        pop(): void;
        incrementCounter(arg0: Internal.Supplier_<string>, arg1: number): void;
        incrementCounter($$0: string): void;
        endTick(): void;
        popPush(arg0: Internal.Supplier_<string>): void;
        startTick(): void;
        readonly ROOT: "root";
    }
    type ProfilerFiller_ = ProfilerFiller;
    interface DoubleList extends Internal.DoubleCollection, Internal.List<number>, Internal.Comparable<Internal.List<number>> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        getDouble(arg0: number): number;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        addAll(arg0: Internal.DoubleCollection_): boolean;
        addAll(arg0: number, arg1: Internal.DoubleList_): boolean;
        containsAll(arg0: Internal.DoubleCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        of<E>(arg0: E): Internal.List<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        replaceAll(arg0: it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator_): void;
        addElements(arg0: number, arg1: number[]): void;
        of(...arg0: number[]): this;
        rem(arg0: number): boolean;
        listIterator(): Internal.ListIterator<any>;
        removeDouble(arg0: number): number;
        size(arg0: number): void;
        add(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        removeAll(arg0: Internal.DoubleCollection_): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        toDoubleArray(arg0: number[]): number[];
        addAll(arg0: number, arg1: Internal.DoubleCollection_): boolean;
        of(): this;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        spliterator(): Internal.Spliterator<any>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        unstableSort(arg0: Internal.DoubleComparator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        sort(arg0: Internal.DoubleComparator_): void;
        iterator(): Internal.DoubleIterator;
        set(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        addAll(arg0: Internal.DoubleList_): boolean;
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        get(arg0: number): number;
        removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        retainAll(arg0: Internal.DoubleCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        isEmpty(): boolean;
        addAll(arg0: Internal.Collection_<number>): boolean;
        of(arg0: number, arg1: number): this;
        setElements(arg0: number, arg1: number[]): void;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        doubleParallelStream(): Internal.DoubleStream;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        of(arg0: number): this;
        doubleStream(): Internal.DoubleStream;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        toArray(arg0: number[]): number[];
        addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        of(arg0: number, arg1: number, arg2: number): this;
        indexOf(arg0: number): number;
        replaceAll(arg0: Internal.DoubleUnaryOperator_): void;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        removeIf(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        contains(arg0: number): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        doubleIterator(): Internal.DoubleIterator;
        toArray(): any[];
        lastIndexOf(arg0: number): number;
        subList(arg0: number, arg1: number): Internal.List<any>;
        hashCode(): number;
        size(): number;
        doubleSpliterator(): Internal.DoubleSpliterator;
        compareTo(arg0: Internal.List_<number>): number;
        setElements(arg0: number[]): void;
        clear(): void;
        toDoubleArray(): number[];
        forEach(arg0: Internal.DoubleConsumer_): void;
        equals(arg0: any): boolean;
        get empty(): boolean
        set elements(arg0: number[])
    }
    type DoubleList_ = DoubleList;
    class LootTable$Builder implements Internal.FunctionUserBuilder<Internal.LootTable$Builder>, Internal.LootTableBuilderAccessor, Internal.FabricLootTableBuilder {
        constructor()
        unwrap(): Internal.FunctionUserBuilder<any>;
        build(): Internal.LootTable;
        setParamSet($$0: Internal.LootContextParamSet_): this;
        withPool($$0: Internal.LootPool$Builder_): this;
        unwrap(): this;
        apply($$0: Internal.LootItemFunction$Builder_): this;
        apply<E>($$0: E[], $$1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        setRandomSequence($$0: ResourceLocation_): this;
        modifyPools(modifier: Internal.Consumer_<any>): this;
        getFunctions(): Internal.List<any>;
        apply(function_: Internal.LootItemFunction_): this;
        pools(pools: Internal.Collection_<any>): this;
        apply(arg0: Internal.LootItemFunction$Builder_): Internal.FunctionUserBuilder<any>;
        pool(pool: Internal.LootPool_): this;
        apply<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        apply(functions: Internal.Collection_<any>): this;
        getPools(): Internal.List<any>;
        static copyOf(table: Internal.LootTable_): Internal.LootTable$Builder;
        set paramSet($$0: Internal.LootContextParamSet_)
        set randomSequence($$0: ResourceLocation_)
        get functions(): Internal.List<any>
        get pools(): Internal.List<any>
    }
    type LootTable$Builder_ = LootTable$Builder;
    class DataStorage {
        constructor()
        save(): Internal.CompoundTag;
        load(compound: Internal.CompoundTag_): void;
        get<T extends Internal.DataObject>(key: Internal.DataObjectKey_<T>): T;
        getOrCreate<T extends Internal.DataObject>(key: Internal.DataObjectKey_<T>): T;
    }
    type DataStorage_ = DataStorage;
    class GpuWarnlistManager extends Internal.SimplePreparableReloadListener<any> {
        constructor()
        showWarning(): void;
        getRendererWarnings(): string;
        hasWarnings(): boolean;
        resetWarnings(): void;
        getVersionWarnings(): string;
        willShowWarning(): boolean;
        getVendorWarnings(): string;
        getAllWarnings(): string;
        getName(): string;
        isSkippingFabulous(): boolean;
        dismissWarning(): void;
        dismissWarningAndSkipFabulous(): void;
        isShowingWarning(): boolean;
        get rendererWarnings(): string
        get versionWarnings(): string
        get vendorWarnings(): string
        get allWarnings(): string
        get name(): string
        get skippingFabulous(): boolean
        get showingWarning(): boolean
    }
    type GpuWarnlistManager_ = GpuWarnlistManager;
    class Style {
        applyFormats(...$$0: Internal.ChatFormatting_[]): this;
        getInsertion(): string;
        withHoverEvent($$0: Internal.HoverEvent_): this;
        isBold(): boolean;
        isEmpty(): boolean;
        isStrikethrough(): boolean;
        isObfuscated(): boolean;
        withBold($$0: boolean): this;
        getFont(): ResourceLocation;
        getHoverEvent(): Internal.HoverEvent;
        isItalic(): boolean;
        isUnderlined(): boolean;
        withStrikethrough($$0: boolean): this;
        withObfuscated($$0: boolean): this;
        withColor($$0: Internal.ChatFormatting_): this;
        applyTo($$0: Internal.Style_): this;
        withInsertion($$0: string): this;
        getColor(): Internal.TextColor;
        withColor($$0: number): this;
        getClickEvent(): Internal.ClickEvent;
        withUnderlined($$0: boolean): this;
        withFont($$0: ResourceLocation_): this;
        withColor($$0: Internal.TextColor_): this;
        withClickEvent($$0: Internal.ClickEvent_): this;
        withItalic($$0: boolean): this;
        applyLegacyFormat($$0: Internal.ChatFormatting_): this;
        applyFormat($$0: Internal.ChatFormatting_): this;
        get insertion(): string
        get bold(): boolean
        get empty(): boolean
        get strikethrough(): boolean
        get obfuscated(): boolean
        get font(): ResourceLocation
        get hoverEvent(): Internal.HoverEvent
        get italic(): boolean
        get underlined(): boolean
        get color(): Internal.TextColor
        get clickEvent(): Internal.ClickEvent
        static readonly EMPTY: Internal.Style;
        static readonly DEFAULT_FONT: ResourceLocation;
        static readonly FORMATTING_CODEC: Internal.Codec<Internal.Style>;
    }
    type Style_ = Style;
    interface TypeTemplate {
        toSimpleType(): com.mojang.datafixers.types.Type<any>;
        size(): number;
        apply(arg0: Internal.TypeFamily_): Internal.TypeFamily;
        findFieldOrType<A, B>(arg0: number, arg1: string, arg2: com.mojang.datafixers.types.Type_<A>, arg3: com.mojang.datafixers.types.Type_<B>): Internal.Either<Internal.TypeTemplate, Internal.Type$FieldNotFoundException>;
        applyO<A, B>(arg0: Internal.FamilyOptic_<A, B>, arg1: com.mojang.datafixers.types.Type_<A>, arg2: com.mojang.datafixers.types.Type_<B>): Internal.FamilyOptic<A, B>;
        hmap(arg0: Internal.TypeFamily_, arg1: Internal.IntFunction_<Internal.RewriteResult<any, any>>): Internal.IntFunction<Internal.RewriteResult<any, any>>;
    }
    type TypeTemplate_ = TypeTemplate;
    class BlastingRecipe extends Internal.AbstractCookingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CookingBookCategory_, $$3: Internal.Ingredient_, $$4: Internal.ItemStack_, $$5: number, $$6: number)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        "handler$fab000$fabric-item-api-v1$captureStack"(inventory: Internal.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        handler$zpp000$bclib$bcl_getRemainingItems(container: Internal.Container_, cir: Internal.CallbackInfoReturnable_<any>): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: Internal.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type BlastingRecipe_ = BlastingRecipe;
    class SmithingTrimRecipe$Serializer implements Internal.RecipeSerializer<Internal.SmithingTrimRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): Internal.SmithingTrimRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): Internal.SmithingTrimRecipe;
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: Internal.SmithingTrimRecipe_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SmithingTrimRecipe$Serializer_ = SmithingTrimRecipe$Serializer;
    class BlockStateMatchTest extends Internal.RuleTest {
        constructor($$0: Internal.BlockState_)
        static readonly CODEC: Internal.Codec<Internal.BlockStateMatchTest>;
    }
    type BlockStateMatchTest_ = BlockStateMatchTest;
    interface EventListener {
    }
    type EventListener_ = EventListener;
    interface WorldPresetAccessor {
        bcl_setDimensions(arg0: Internal.Map_<Internal.ResourceKey<Internal.LevelStem>, Internal.LevelStem>): void;
        bcl_getDimensions(): Internal.Map<Internal.ResourceKey<Internal.LevelStem>, Internal.LevelStem>;
    }
    type WorldPresetAccessor_ = WorldPresetAccessor;
    class TargetBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TargetBlock_ = TargetBlock;
    interface RenderContext {
        itemTransformationMode(): Internal.ItemDisplayContext;
        pushTransform(arg0: Internal.RenderContext$QuadTransform_): void;
        hasTransform(): boolean;
        getEmitter(): Internal.QuadEmitter;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        bakedModelConsumer(): Internal.RenderContext$BakedModelConsumer;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        fallbackConsumer(): Internal.Consumer<Internal.BakedModel>;
        isFaceCulled(face: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        meshConsumer(): Internal.Consumer<Internal.Mesh>;
        popTransform(): void;
        get emitter(): Internal.QuadEmitter
    }
    type RenderContext_ = RenderContext;
    interface Object2IntSortedMap <K> extends Internal.SortedMap<K, number>, Internal.Object2IntMap<K> {
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        /**
         * @deprecated
        */
        mergeInt(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        defaultReturnValue(): number;
        removeInt(arg0: any): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        comparator(): Internal.Comparator<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        object2IntEntrySet(): Internal.ObjectSortedSet<Internal.Object2IntMap$Entry<K>>;
        getInt(arg0: any): number;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        computeIntIfAbsentPartial(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        subMap(arg0: any, arg1: any): Internal.SortedMap<any, any>;
        replace(arg0: K, arg1: number, arg2: number): boolean;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<any>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        replace(arg0: K, arg1: number): number;
        applyAsInt(arg0: K): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        put(arg0: K, arg1: number): number;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        /**
         * @deprecated
        */
        computeIntIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        of<K, V>(): Internal.Map<K, V>;
        mergeInt(arg0: K, arg1: number, arg2: Internal.IntBinaryOperator_): number;
        isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        containsKey(arg0: any): boolean;
        computeIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        containsValue(arg0: number): boolean;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        computeInt(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        tailMap(arg0: any): Internal.SortedMap<any, any>;
        remove(arg0: any, arg1: number): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        headMap(arg0: any): Internal.SortedMap<any, any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        computeIntIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        keySet(): Internal.ObjectSet<any>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        mergeInt(arg0: K, arg1: number, arg2: it.unimi.dsi.fastutil.ints.IntBinaryOperator_): number;
        lastKey(): K;
        size(): number;
        putIfAbsent(arg0: K, arg1: number): number;
        hashCode(): number;
        putAll(arg0: Internal.Map_<K, number>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        defaultReturnValue(arg0: number): void;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        equals(arg0: any): boolean;
        firstKey(): K;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        get empty(): boolean
    }
    type Object2IntSortedMap_<K> = Object2IntSortedMap<K>;
    class ClientboundHorseScreenOpenPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number, $$2: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSize(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntityId(): number;
        getContainerId(): number;
        isSkippable(): boolean;
        get size(): number
        get entityId(): number
        get containerId(): number
        get skippable(): boolean
    }
    type ClientboundHorseScreenOpenPacket_ = ClientboundHorseScreenOpenPacket;
    abstract class ArgumentBuilder <S, T extends Internal.ArgumentBuilder<S, T>> {
        constructor()
        redirect(arg0: Internal.CommandNode_<S>): T;
        build(): Internal.CommandNode<S>;
        then(arg0: Internal.CommandNode_<S>): T;
        redirect(arg0: Internal.CommandNode_<S>, arg1: Internal.SingleRedirectModifier_<S>): T;
        getArguments(): Internal.Collection<Internal.CommandNode<S>>;
        then(arg0: Internal.ArgumentBuilder_<S, any>): T;
        fork(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>): T;
        getRedirectModifier(): Internal.RedirectModifier<S>;
        getRequirement(): Internal.Predicate<S>;
        requires(arg0: Internal.Predicate_<S>): T;
        forward(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>, arg2: boolean): T;
        executes(arg0: Internal.Command_<S>): T;
        getRedirect(): Internal.CommandNode<S>;
        isFork(): boolean;
        getCommand(): Internal.Command<S>;
        get "arguments"(): Internal.Collection<Internal.CommandNode<S>>
        get redirectModifier(): Internal.RedirectModifier<S>
        get requirement(): Internal.Predicate<S>
        get redirect(): Internal.CommandNode<S>
        get fork(): boolean
        get command(): Internal.Command<S>
    }
    type ArgumentBuilder_<S, T extends Internal.ArgumentBuilder<S, T>> = ArgumentBuilder<S, T>;
    class BiolithFittestNodes <T> extends Internal.Record {
        constructor(ultimate: Internal.Climate$RTree$Leaf_<T>, ultimateDistance: number)
        constructor(ultimate: Internal.Climate$RTree$Leaf_<T>, ultimateDistance: number, penultimate: Internal.Climate$RTree$Leaf_<T>, penultimateDistance: number)
        ultimateDistance(): number;
        penultimateDistance(): number;
        ultimate(): Internal.Climate$RTree$Leaf<T>;
        withPenultimate(penultimate: Internal.Climate$RTree$Leaf_<T>, penultimateDistance: number): this;
        of(ultimate: Internal.Climate$RTree$Leaf_<T>, ultimateDistance: number, penultimate: Internal.Climate$RTree$Leaf_<T>, penultimateDistance: number): this;
        penultimate(): Internal.Climate$RTree$Leaf<T>;
    }
    type BiolithFittestNodes_<T> = BiolithFittestNodes<T>;
    interface FilenameFilter {
        accept(arg0: Internal.File_, arg1: string): boolean;
        (arg0: Internal.File_, arg1: string): boolean;
    }
    type FilenameFilter_ = FilenameFilter;
    class WaypointsManager {
        constructor(modMain: Internal.AXaeroMinimap_, minimapSession: Internal.XaeroMinimapSession_)
        isMultiplayer(containerId: string): boolean;
        getDimensionKeyForDirectoryName(dirName: string): Internal.ResourceKey<Internal.Level>;
        createDeathpoint(p: Internal.Player_): void;
        containerExists(id: string): boolean;
        getAutoWorldID(): string;
        getWaypoints(): Internal.WaypointSet;
        getWorldContainerNullable(id: string): Internal.WaypointWorldContainer;
        setCustomWorldID(customWorldID: string): void;
        getNewAutoWorldID(dimId: Internal.ResourceKey_<Internal.Level>, useWorldmap: boolean): string;
        getAutoRootContainerID(): string;
        getWorldContainer(id: string): Internal.WaypointWorldContainer;
        getCurrentContainerID(): string;
        onLoad(connection: Internal.ClientPacketListener_): void;
        findDimensionKey(validatedName: string): Internal.ResourceKey<Internal.Level>;
        onServerLevelId(id: number): void;
        getCurrentWorldID(autoWorldID: string): string;
        teleportToWaypoint(selected: Internal.Waypoint_, displayedWorld: Internal.WaypointWorld_, screen: Internal.Screen_): void;
        setCustomContainerID(customContainerID: string): void;
        getServerWaypoints(): Internal.List<Internal.Waypoint>;
        static getCustomWaypoints(modName: string): Internal.Hashtable<number, Internal.Waypoint>;
        getCustomWorldID(): string;
        getCurrentWorldID(): string;
        teleportAnyway(): void;
        updateWaypoints(): void;
        isWorldTeleportable(displayedWorld: Internal.WaypointWorld_): boolean;
        getCurrentOriginContainerID(): string;
        getWaypointMap(): Internal.HashMap<string, Internal.WaypointWorldContainer>;
        addWorld(container: string, world: string): Internal.WaypointWorld;
        getCurrentOriginContainerID(autoContainer: string): string;
        getCurrentContainerAndWorldID(autoContainer: string, autoWorldID: string): string;
        getDimensionDirectoryName(dimKey: Internal.ResourceKey_<Internal.Level>): string;
        canTeleport(displayingTeleportableWorld: boolean, displayedWorld: Internal.WaypointWorld_): boolean;
        createTemporaryWaypoints(waypointWorld: Internal.WaypointWorld_, x: number, y: number, z: number, yIncluded: boolean): void;
        createTemporaryWaypoints(waypointWorld: Internal.WaypointWorld_, x: number, y: number, z: number): void;
        isTeleportationSafe(displayedWorld: Internal.WaypointWorld_): boolean;
        getAutoContainerID(): string;
        removeContainer(id: string): void;
        setCurrentSpawn(currentSpawn: BlockPos_, clientWorld: Internal.ClientLevel_): void;
        addWorldContainer(id: string): Internal.WaypointWorldContainer;
        updateWorldIds(): void;
        ignoreContainerCase(potentialContainerID: string, current: string): string;
        getDimensionDivision(worldContainerID: string): number;
        getCurrentWorld(autoContainer: string, autoWorldID: string): Internal.WaypointWorld;
        getWorld(container: string, world: string): Internal.WaypointWorld;
        teleportToWaypoint(selected: Internal.Waypoint_, displayedWorld: Internal.WaypointWorld_, screen: Internal.Screen_, respectHiddenCoords: boolean): void;
        getCurrentWorld(): Internal.WaypointWorld;
        setWaypoints(waypoints: Internal.WaypointSet_): void;
        getCurrentContainerID(autoContainer: string): string;
        getAutoWorld(): Internal.WaypointWorld;
        getCustomContainerID(): string;
        getCurrentContainerAndWorldID(): string;
        get autoWorldID(): string
        get waypoints(): Internal.WaypointSet
        set customWorldID(customWorldID: string)
        get autoRootContainerID(): string
        get currentContainerID(): string
        set customContainerID(customContainerID: string)
        get serverWaypoints(): Internal.List<Internal.Waypoint>
        get customWorldID(): string
        get currentWorldID(): string
        get currentOriginContainerID(): string
        get waypointMap(): Internal.HashMap<string, Internal.WaypointWorldContainer>
        get autoContainerID(): string
        get currentWorld(): Internal.WaypointWorld
        set waypoints(waypoints: Internal.WaypointSet_)
        get autoWorld(): Internal.WaypointWorld
        get customContainerID(): string
        get currentContainerAndWorldID(): string
        static readonly customWaypoints: {};
        setChanged: number;
        static readonly TELEPORT_ANYWAY_COMMAND: "xaero_tp_anyway";
    }
    type WaypointsManager_ = WaypointsManager;
    interface ICoordinate {
        get(arg0: BlockPos_): number;
        (arg0: BlockPos_): number;
    }
    type ICoordinate_ = ICoordinate;
    class ClientboundSetExperiencePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number, $$2: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getExperienceLevel(): number;
        isSkippable(): boolean;
        getExperienceProgress(): number;
        getTotalExperience(): number;
        get experienceLevel(): number
        get skippable(): boolean
        get experienceProgress(): number
        get totalExperience(): number
    }
    type ClientboundSetExperiencePacket_ = ClientboundSetExperiencePacket;
    class LeverBlock extends Internal.FaceAttachedHorizontalDirectionalBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        pull($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): Internal.BlockState;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type LeverBlock_ = LeverBlock;
    interface ResourceLocationExtensions {
        compareNamespaced(o: ResourceLocation_): number;
    }
    type ResourceLocationExtensions_ = ResourceLocationExtensions;
    class LecternBlockEntity extends Internal.BlockEntity implements Internal.MenuProvider, Internal.Clearable {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getDisplayName(): Internal.Component;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        static tryClear($$0: any): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isDynamicLightEnabled(): boolean;
        setBook($$0: Internal.ItemStack_, $$1: Internal.Player_): void;
        getPage(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        createMenu($$0: number, $$1: Internal.Inventory_, $$2: Internal.Player_): Internal.AbstractContainerMenu;
        getBook(): Internal.ItemStack;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        setBook($$0: Internal.ItemStack_): void;
        getRedstoneSignal(): number;
        setDynamicLightEnabled(enabled: boolean): void;
        clearContent(): void;
        hasBook(): boolean;
        get displayName(): Internal.Component
        get dynamicLightEnabled(): boolean
        get page(): number
        get book(): Internal.ItemStack
        set book($$0: Internal.ItemStack_)
        get redstoneSignal(): number
        set dynamicLightEnabled(enabled: boolean)
        static readonly NUM_DATA: 1;
        static readonly DATA_PAGE: 0;
        static readonly NUM_SLOTS: 1;
        static readonly SLOT_BOOK: 0;
    }
    type LecternBlockEntity_ = LecternBlockEntity;
    class NetherSproutsBlock extends Internal.BushBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        usesCustomShouldDrawFace(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        customShouldDrawFace(view: Internal.BlockGetter_, thisState: Internal.BlockState_, sideState: Internal.BlockState_, thisPos: BlockPos_, sidePos: BlockPos_, side: Internal.Direction_): Internal.Optional<boolean>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type NetherSproutsBlock_ = NetherSproutsBlock;
    class UserBanList extends Internal.StoredUserList<Internal.GameProfile, any> {
        constructor($$0: Internal.File_)
        isBanned($$0: Internal.GameProfile_): boolean;
    }
    type UserBanList_ = UserBanList;
    interface IMsgWriteCtx extends Internal.IMsgCtx {
        getConnection(): Internal.ActiveConnection;
        assertServerSide(): void;
        isServerSide(): boolean;
        assertClientSide(): void;
        isClientSide(): boolean;
        getNetSide(): Internal.EnumNetSide;
        getNetId(): Internal.NetIdBase;
        get connection(): Internal.ActiveConnection
        get serverSide(): boolean
        get clientSide(): boolean
        get netSide(): Internal.EnumNetSide
        get netId(): Internal.NetIdBase
    }
    type IMsgWriteCtx_ = IMsgWriteCtx;
    class EndDragonFight implements Internal.IDragonFight {
        constructor($$0: Internal.ServerLevel_, $$1: number, $$2: Internal.EndDragonFight$Data_)
        constructor($$0: Internal.ServerLevel_, $$1: number, $$2: Internal.EndDragonFight$Data_, $$3: BlockPos_)
        betterendisland$tickBellSound(): void;
        betterendisland$clearVanillaPillars(): void;
        handler$bfj000$betterendisland$resetSpikeCrystals(ci: Internal.CallbackInfo_): void;
        betterendisland$setFirstExitPortalSpawn(bl: boolean): void;
        betterendisland$reset(forcePortalPosReset: boolean): void;
        betterendisland$setDragonRespawnStage(stage: Internal.DragonRespawnStage_): void;
        getCrystalsAlive(): number;
        resetSpikeCrystals(): void;
        betterendisland$initialRespawn(): void;
        handler$bfj000$betterendisland$onCrystalDestroyed(crystal: Internal.EndCrystal_, damageSource: DamageSource_, ci: Internal.CallbackInfo_): void;
        handler$bfj000$betterendisland$tryRespawn(ci: Internal.CallbackInfo_): void;
        getDragonUUID(): Internal.UUID;
        betterendisland$numTimesDragonKilled(): number;
        handler$bfj000$betterendisland$setDragonKilled(dragon: Internal.EnderDragon_, ci: Internal.CallbackInfo_): void;
        betterendisland$setHasDragonEverSpawned(bl: boolean): void;
        /**
         * @deprecated
        */
        removeAllGateways(): void;
        saveData(): Internal.EndDragonFight$Data;
        handler$bfj000$betterendisland$tickFight(ci: Internal.CallbackInfo_): void;
        setDragonKilled($$0: Internal.EnderDragon_): void;
        tick(): void;
        hasPreviouslyKilledDragon(): boolean;
        /**
         * @deprecated
        */
        skipArenaLoadedCheck(): void;
        betterendisland$hasDragonEverSpawned(): boolean;
        updateDragon($$0: Internal.EnderDragon_): void;
        handler$bfj000$betterendisland$EndDragonFight(level: Internal.ServerLevel_, seed: number, data: Internal.EndDragonFight$Data_, origin: BlockPos_, ci: Internal.CallbackInfo_): void;
        betterendisland$getDragonRespawnStage(): Internal.DragonRespawnStage;
        betterendisland$firstExitPortalSpawn(): boolean;
        betterendisland$setNumTimesDragonKilled(i: number): void;
        onCrystalDestroyed($$0: Internal.EndCrystal_, $$1: DamageSource_): void;
        tryRespawn(): void;
        get crystalsAlive(): number
        get dragonUUID(): Internal.UUID
        set dragonKilled($$0: Internal.EnderDragon_)
        static readonly DRAGON_SPAWN_Y: 128;
        static readonly TIME_BETWEEN_PLAYER_SCANS: 20;
        static readonly ARENA_TICKET_LEVEL: 9;
        respawnStage: Internal.DragonRespawnAnimation;
    }
    type EndDragonFight_ = EndDragonFight;
    class Dolphin extends Internal.WaterAnimal {
        constructor($$0: Internal.EntityType_<Internal.Dolphin>, $$1: Internal.Level_)
        gotFish(): boolean;
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getSILENT(): Internal.EntityDataAccessor<boolean>;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        static getSPRINTING_FLAG_INDEX(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setMoisntessLevel($$0: number): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static getAIR(): Internal.EntityDataAccessor<number>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        static getGLOWING_FLAG_INDEX(): number;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        static getON_FIRE_FLAG_INDEX(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        static getNO_GRAVITY(): Internal.EntityDataAccessor<boolean>;
        attack(hp: number): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        static getINVISIBLE_FLAG_INDEX(): number;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        static getFROZEN_TICKS(): Internal.EntityDataAccessor<number>;
        static getFLAGS(): Internal.EntityDataAccessor<number>;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static getPOSE(): Internal.EntityDataAccessor<Internal.Pose>;
        static getNAME_VISIBLE(): Internal.EntityDataAccessor<boolean>;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setTreasurePos($$0: BlockPos_): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static invokeAdjustMovementForCollisions(movement: Vec3d_, entityBounds: Internal.AABB_, collisions: Internal.List_<Internal.VoxelShape>): Vec3d;
        static getFALL_FLYING_FLAG_INDEX(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        getMoistnessLevel(): number;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getCUSTOM_NAME(): Internal.EntityDataAccessor<Internal.Optional<Internal.Compone