/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.network.fabric;

import com.copycatsplus.copycats.network.PacketSystem;
import com.copycatsplus.copycats.network.PlayerSelection;
import com.copycatsplus.copycats.network.fabric.PlayerSelectionImpl;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.pepperbell.simplenetworking.C2SPacket;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class PacketSystemImpl
extends PacketSystem {
    public static final Map<class_2960, PacketSystem> HANDLERS = new HashMap<class_2960, PacketSystem>();

    protected PacketSystemImpl(String id, int version, List<Function<class_2540, PacketSystem.S2CPacket>> s2cPackets, Object2IntMap<Class<? extends PacketSystem.S2CPacket>> s2cTypes, List<Function<class_2540, PacketSystem.C2SPacket>> c2sPackets, Object2IntMap<Class<? extends PacketSystem.C2SPacket>> c2sTypes) {
        super(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerS2CListener() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.s2cPacket, this::handleClientPacket);
    }

    @Environment(value=EnvType.CLIENT)
    private void handleClientPacket(class_310 mc, class_634 listener, class_2540 buf, PacketSender sender) {
        this.handleS2CPacket(mc, buf);
    }

    @Override
    public void registerC2SListener() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.c2sPacket, this::handleServerPacket);
    }

    private void handleServerPacket(MinecraftServer server, class_3222 player, class_3244 listener, class_2540 buf, PacketSender sender) {
        this.handleC2SPacket(player, buf);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void doSendC2S(class_2540 buf) {
        ClientPlayNetworking.send((class_2960)this.c2sPacket, (class_2540)buf);
    }

    @Override
    public void send(SimplePacketBase packet) {
        AllPackets.getChannel().sendToServer((C2SPacket)packet);
    }

    @Override
    public void sendTo(class_3222 player, SimplePacketBase packet) {
        AllPackets.getChannel().sendToClient((S2CPacket)packet, player);
    }

    @Override
    public void sendTo(PlayerSelection selection, SimplePacketBase packet) {
        AllPackets.getChannel().sendToClients((S2CPacket)packet, ((PlayerSelectionImpl)selection).players);
    }

    @ApiStatus.Internal
    public static PacketSystem create(String id, int version, List<Function<class_2540, PacketSystem.S2CPacket>> s2cPackets, Object2IntMap<Class<? extends PacketSystem.S2CPacket>> s2cTypes, List<Function<class_2540, PacketSystem.C2SPacket>> c2sPackets, Object2IntMap<Class<? extends PacketSystem.C2SPacket>> c2sTypes) {
        return new PacketSystemImpl(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }
}

