/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v3.datagen.DatapackRecipeBuilder;
import org.betterx.bclib.api.v3.datagen.RecipeDataProvider;
import org.betterx.bclib.util.RecipeHelper;

public abstract class AbstractBaseRecipeBuilder<T extends AbstractBaseRecipeBuilder>
implements DatapackRecipeBuilder {
    protected final class_2960 id;
    protected final class_1799 output;
    protected String group;
    protected class_7800 category;
    protected boolean alright;

    protected AbstractBaseRecipeBuilder(class_2960 id, class_1799 output) {
        this.id = id;
        this.output = output;
        this.category = class_7800.field_40642;
        this.alright = RecipeHelper.exists((class_1935)output.method_7909());
    }

    protected AbstractBaseRecipeBuilder(class_2960 id, class_1935 output) {
        this(id, new class_1799(output, 1));
    }

    public T setCategory(class_7800 category) {
        this.category = category;
        return (T)this;
    }

    protected T setGroup(String group) {
        this.group = group;
        return (T)this;
    }

    protected T setOutputCount(int count) {
        this.output.method_7939(count);
        return (T)this;
    }

    protected T setOutputTag(class_2487 tag) {
        this.output.method_7980(tag);
        return (T)this;
    }

    protected T unlockedBy(class_1935 item) {
        this.unlocks("has_" + item.method_8389().method_7876(), (class_184)class_2446.method_10426((class_1935)item.method_8389()));
        return (T)this;
    }

    protected T unlockedBy(class_6862<class_1792> tag) {
        this.unlocks("has_tag_" + tag.comp_327().method_12836() + "_" + tag.comp_327().method_12832(), (class_184)class_2446.method_10420(tag));
        return (T)this;
    }

    protected T unlockedBy(class_1935 ... items) {
        Object name = "has_" + Arrays.stream(items).map(block -> block instanceof class_2248 ? class_7923.field_41175.method_10221((Object)((class_2248)block)) : class_7923.field_41178.method_10221((Object)((class_1792)block))).filter(id -> id != null).map(id -> id.method_12832()).collect(Collectors.joining("_"));
        if (((String)name).length() > 45) {
            name = ((String)name).substring(0, 42);
        }
        return this.unlocks((String)name, items);
    }

    protected T unlocks(String name, class_1935 ... items) {
        return this.unlocks(name, (class_184)class_2066.class_2068.method_8959((class_1935[])items));
    }

    protected T unlockedBy(class_1799 ... stacks) {
        class_1935[] items = (class_1935[])Arrays.stream(stacks).filter(stack -> stack.method_7947() > 0).map(stack -> stack.method_7909()).toArray(class_1935[]::new);
        return this.unlockedBy(items);
    }

    protected abstract T unlocks(String var1, class_184 var2);

    public final T build() {
        if (!this.checkRecipe()) {
            return (T)this;
        }
        RecipeDataProvider.register(this);
        return (T)this;
    }

    protected boolean checkRecipe() {
        if (this.output == null) {
            BCLib.LOGGER.warning("Output for Recipe can't be 'null', recipe {} will be ignored!", this.id);
            return false;
        }
        if (this.output.method_31574(class_1802.field_8162)) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id + ": Result is AIR", new Object[0]);
            return false;
        }
        if (!this.alright) {
            BCLib.LOGGER.debug("Can't add recipe {}! Ingeredient or output do not exists.", this.id);
            return false;
        }
        return true;
    }

    protected abstract void buildRecipe(Consumer<class_2444> var1);

    @Override
    public final void build(Consumer<class_2444> cc) {
        if (!this.checkRecipe()) {
            return;
        }
        this.buildRecipe(cc);
    }

    @Override
    public final class_2960 getId() {
        return this.id;
    }
}

