/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.spawning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2902;
import org.betterx.bclib.api.v2.spawning.SpawnRuleEntry;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.interfaces.SpawnRule;
import org.betterx.bclib.util.BlocksHelper;

public class SpawnRuleBuilder<M extends class_1308> {
    private static final Map<String, SpawnRuleEntry> RULES_CACHE = Maps.newHashMap();
    private static final SpawnRuleBuilder INSTANCE = new SpawnRuleBuilder();
    private final List<SpawnRuleEntry> rules = Lists.newArrayList();
    private SpawnRuleEntry entryInstance;
    private class_1299<M> entityType;

    private SpawnRuleBuilder() {
    }

    public static SpawnRuleBuilder start(class_1299<? extends class_1308> entityType) {
        SpawnRuleBuilder.INSTANCE.entityType = entityType;
        SpawnRuleBuilder.INSTANCE.rules.clear();
        return INSTANCE;
    }

    public static SpawnRuleBuilder start(BCLEntityWrapper<? extends class_1308> wrapper) {
        SpawnRuleBuilder builder = SpawnRuleBuilder.start(wrapper.type());
        if (!wrapper.canSpawn()) {
            builder.preventSpawn();
        }
        return builder;
    }

    public SpawnRuleBuilder preventSpawn() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("prevent", () -> new SpawnRuleEntry(-1, (type, world, spawnReason, pos, random) -> false, "Prevent Spawn"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder notPeaceful() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("not_peaceful", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> world.method_8407() != class_1267.field_5801, "Not Peaceful"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder aboveGround(int minHeight) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("above_ground", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            if (pos.method_10264() < world.method_31607() + 2) {
                return false;
            }
            return BlocksHelper.findSurfaceBelow(world, pos, pos.method_10264() - minHeight, bs -> !BlocksHelper.isFree(bs)).isEmpty();
        }, "Above Ground"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder belowMaxHeight() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("below_max_height", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> pos.method_10264() < world.method_8597().comp_653(), "Below Max Height"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder onlyOnValidBlocks() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("only_on_valid_blocks", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            class_2338 below = pos.method_10074();
            return world.method_8320(below).method_26170((class_1922)world, below, type);
        }, "Only On Valid Blocks"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder onlyOnBlocks(class_2248 ... blocks) {
        class_2248[] floorBlocks = blocks;
        Arrays.sort(floorBlocks, Comparator.comparing(class_2248::method_9539));
        StringBuilder builder = new StringBuilder("only_on_blocks");
        for (class_2248 block : floorBlocks) {
            builder.append('_');
            builder.append(block.method_9539());
        }
        this.entryInstance = SpawnRuleBuilder.getFromCache(builder.toString(), () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            class_2248 below = world.method_8320(pos.method_10074()).method_26204();
            for (class_2248 floor : floorBlocks) {
                if (floor != below) continue;
                return true;
            }
            return false;
        }, "Only On Blocks"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder withChance(int chance) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("with_chance_" + chance, () -> new SpawnRuleEntry(1, (type, world, spawnReason, pos, random) -> random.method_43048(chance) == 0, "With Chance"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder belowBrightness(int lightLevel) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("below_brightness_" + lightLevel, () -> new SpawnRuleEntry(2, (type, world, spawnReason, pos, random) -> world.method_22339(pos) <= lightLevel, "Below Brightness"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder aboveBrightness(int lightLevel) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("above_brightness_" + lightLevel, () -> new SpawnRuleEntry(2, (type, world, spawnReason, pos, random) -> world.method_22339(pos) >= lightLevel, "Above Brightness"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder hostile(int lightLevel) {
        return this.notPeaceful().belowBrightness(lightLevel);
    }

    public SpawnRuleBuilder vanillaHostile() {
        return this.hostile(7);
    }

    public SpawnRuleBuilder maxNearby(class_1299<?> selectorType, int count, int side) {
        Class baseClass = selectorType.method_31794();
        this.entryInstance = SpawnRuleBuilder.getFromCache("max_nearby_" + selectorType.method_5882() + "_" + count + "_" + side, () -> new SpawnRuleEntry(3, (type, world, spawnReason, pos, random) -> {
            try {
                class_238 box = new class_238(pos).method_1009((double)side, (double)world.method_31605(), (double)side);
                List list = world.method_8390(baseClass, box, entity -> true);
                return list.size() < count;
            }
            catch (Exception e) {
                return true;
            }
        }, "Max Nearby " + count + "/" + side));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder maxNearby(int count, int side) {
        return this.maxNearby(this.entityType, count, side);
    }

    public SpawnRuleBuilder maxNearby(int count) {
        return this.maxNearby(this.entityType, count, 256);
    }

    public SpawnRuleBuilder customRule(SpawnRule rule) {
        this.rules.add(new SpawnRuleEntry(7, rule, "Custom Rule"));
        return this;
    }

    public void build(class_1317.class_1319 spawnType, class_2902.class_2903 heightmapType) {
        ArrayList rulesCopy = Lists.newArrayList(this.rules);
        Collections.sort(rulesCopy);
        class_1317.class_4306 predicate = (entityType, serverLevelAccessor, mobSpawnType, blockPos, random) -> {
            for (SpawnRuleEntry rule : rulesCopy) {
                if (rule.canSpawn(entityType, (class_1936)serverLevelAccessor, mobSpawnType, blockPos, random)) continue;
                return false;
            }
            return true;
        };
        class_1317.method_20637(this.entityType, (class_1317.class_1319)spawnType, (class_2902.class_2903)heightmapType, (class_1317.class_4306)predicate);
    }

    public void buildNoRestrictions(class_2902.class_2903 heightmapType) {
        this.build(class_1317.class_1319.field_19350, heightmapType);
    }

    public void buildOnGround(class_2902.class_2903 heightmapType) {
        this.build(class_1317.class_1319.field_6317, heightmapType);
    }

    public void buildInWater(class_2902.class_2903 heightmapType) {
        this.build(class_1317.class_1319.field_6318, heightmapType);
    }

    public void buildInLava(class_2902.class_2903 heightmapType) {
        this.build(class_1317.class_1319.field_23221, heightmapType);
    }

    private static SpawnRuleEntry getFromCache(String name, Supplier<SpawnRuleEntry> supplier) {
        return supplier.get();
    }
}

