/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_6731;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeContainer;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.UnboundBCLBiome;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.betterx.bclib.util.CollectionsUtil;
import org.betterx.bclib.util.Pair;
import org.betterx.ui.ColorUtil;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;

public class BCLBiomeBuilder {
    static final ConcurrentLinkedQueue<UnboundBCLBiome<?>> UNBOUND_BIOMES = new ConcurrentLinkedQueue();
    public static int DEFAULT_NETHER_WATER_COLOR;
    public static int DEFAULT_END_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_FOG_COLOR;
    public static int DEFAULT_END_WATER_FOG_COLOR;
    public static int DEFAULT_END_FOG_COLOR;
    public static int DEFAULT_END_SKY_COLOR;
    public static float DEFAULT_NETHER_TEMPERATURE;
    public static float DEFAULT_END_TEMPERATURE;
    public static float DEFAULT_NETHER_WETNESS;
    public static float DEFAULT_END_WETNESS;
    private static final class_6686.class_6693 SURFACE_NOISE;
    private final List<FeatureSupplier> featureSupliers = new LinkedList<FeatureSupplier>();
    private final List<Pair<class_2893.class_2894, class_6880<? extends class_2922<?>>>> carvers = new ArrayList(1);
    private class_5485.class_5495 generationSettings;
    private class_4763.class_4764 effectsBuilder;
    private class_5483.class_5496 spawnSettings;
    private class_6686.class_6708 surfaceRule;
    private boolean hasPrecipitation;
    private final class_2960 biomeID;
    private final Set<class_6862<class_1959>> tags = Sets.newHashSet();
    private final List<class_6544.class_4762> parameters = Lists.newArrayList();
    private float temperature;
    private float fogDensity;
    private float genChance;
    private float downfall;
    private float height;
    private int edgeSize;
    private BCLBiome edge;
    private BCLBiome parent;
    private boolean vertical;
    private BiomeAPI.BiomeType biomeType;

    public static int calculateSkyColor(float temperature) {
        return class_5478.method_30932((float)temperature);
    }

    BCLBiomeBuilder(class_2960 biomeID) {
        this.biomeID = biomeID;
        this.hasPrecipitation = false;
        this.generationSettings = null;
        this.effectsBuilder = null;
        this.spawnSettings = null;
        this.temperature = 1.0f;
        this.fogDensity = 1.0f;
        this.edgeSize = 0;
        this.downfall = 1.0f;
        this.genChance = 1.0f;
        this.height = 0.1f;
        this.vertical = false;
        this.edge = null;
        this.parent = null;
        this.biomeType = null;
    }

    public static BCLBiomeBuilder start(class_2960 biomeID) {
        return new BCLBiomeBuilder(biomeID);
    }

    public BCLBiomeBuilder addNetherClimateParamater(float temperature, float humidity, float offset) {
        this.parameters.add(class_6544.method_38117((float)temperature, (float)humidity, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)offset));
        return this;
    }

    public BCLBiomeBuilder addNetherClimateParamater(float temperature, float humidity) {
        return this.addNetherClimateParamater(temperature, humidity, 0.0f);
    }

    public BCLBiomeBuilder parentBiome(BCLBiome parent) {
        this.parent = parent;
        return this;
    }

    public BCLBiomeBuilder type(BiomeAPI.BiomeType type) {
        this.biomeType = type;
        return this;
    }

    @Deprecated(forRemoval=true)
    public BCLBiomeBuilder precipitation(class_1959.class_1963 precipitation) {
        return this.hasPrecipitation(precipitation != class_1959.class_1963.field_9384);
    }

    public BCLBiomeBuilder hasPrecipitation(boolean precipitation) {
        this.hasPrecipitation = precipitation;
        return this;
    }

    public BCLBiomeBuilder temperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BCLBiomeBuilder wetness(float wetness) {
        this.downfall = wetness;
        return this;
    }

    public <M extends class_1308> BCLBiomeBuilder spawn(class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        this.getSpawns().method_31011(entityType.method_5891(), new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        return this;
    }

    public <M extends class_1308> BCLBiomeBuilder spawn(BCLEntityWrapper<M> wrapper, int weight, int minGroupCount, int maxGroupCount) {
        if (wrapper.canSpawn()) {
            return this.spawn(wrapper.type(), weight, minGroupCount, maxGroupCount);
        }
        return this;
    }

    public BCLBiomeBuilder particles(class_2394 particle, float probability) {
        this.getEffects().method_24393(new class_4761(particle, probability));
        return this;
    }

    public BCLBiomeBuilder skyColor(int color) {
        this.getEffects().method_30820(color);
        return this;
    }

    public BCLBiomeBuilder skyColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.skyColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogColor(int color) {
        this.getEffects().method_24392(color);
        return this;
    }

    public BCLBiomeBuilder fogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.fogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogDensity(float density) {
        this.fogDensity = density;
        return this;
    }

    public BCLBiomeBuilder genChance(float genChance) {
        this.genChance = genChance;
        return this;
    }

    public BCLBiomeBuilder edgeSize(int edgeSize) {
        this.edgeSize = edgeSize;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge) {
        this.edge = edge;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge, int edgeSize) {
        this.edge(edge);
        this.edgeSize(edgeSize);
        return this;
    }

    public BCLBiomeBuilder waterColor(int color) {
        this.getEffects().method_24395(color);
        return this;
    }

    public BCLBiomeBuilder waterColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterFogColor(int color) {
        this.getEffects().method_24397(color);
        return this;
    }

    public BCLBiomeBuilder waterFogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterAndFogColor(int color) {
        return this.waterColor(color).waterFogColor(color);
    }

    public BCLBiomeBuilder waterAndFogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterAndFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder grassColor(int color) {
        this.getEffects().method_30822(color);
        return this;
    }

    public BCLBiomeBuilder grassColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.grassColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder foliageColor(int color) {
        this.getEffects().method_30821(color);
        return this;
    }

    public BCLBiomeBuilder foliageColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.foliageColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder plantsColor(int color) {
        return this.grassColor(color).foliageColor(color);
    }

    public BCLBiomeBuilder plantsColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.plantsColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder music(class_5195 music) {
        this.getEffects().method_27346(music);
        return this;
    }

    public BCLBiomeBuilder music(class_6880<class_3414> music) {
        return this.music(new class_5195(music, 600, 2400, true));
    }

    public BCLBiomeBuilder loop(class_6880<class_3414> loopSound) {
        this.getEffects().method_24942(loopSound);
        return this;
    }

    public BCLBiomeBuilder mood(class_6880<class_3414> mood, int tickDelay, int blockSearchExtent, float soundPositionOffset) {
        this.getEffects().method_24943(new class_4968(mood, tickDelay, blockSearchExtent, (double)soundPositionOffset));
        return this;
    }

    public BCLBiomeBuilder mood(class_6880<class_3414> mood) {
        return this.mood(mood, 6000, 8, 2.0f);
    }

    public BCLBiomeBuilder additions(class_6880<class_3414> additions, float intensity) {
        this.getEffects().method_24944(new class_4967(additions, (double)intensity));
        return this;
    }

    public BCLBiomeBuilder additions(class_6880<class_3414> additions) {
        return this.additions(additions, 0.0111f);
    }

    public BCLBiomeBuilder feature(class_2893.class_2895 decoration, class_6880<class_6796> feature) {
        this.featureSupliers.add(gen -> gen.method_46676(decoration, feature));
        return this;
    }

    public BCLBiomeBuilder feature(class_2893.class_2895 decoration, class_5321<class_6796> feature) {
        this.featureSupliers.add(gen -> gen.method_30992(decoration, feature));
        return this;
    }

    public BCLBiomeBuilder defaultMushrooms() {
        return this.feature(class_3864::method_16982);
    }

    public BCLBiomeBuilder netherDefaultOres() {
        return this.feature(class_3864::method_24382);
    }

    public BCLBiomeBuilder feature(Consumer<class_5485.class_5495> featureAdd) {
        this.featureSupliers.add(gen -> featureAdd.accept((class_5485.class_5495)gen));
        return this;
    }

    public BCLBiomeBuilder feature(BCLFeature feature) {
        return this.feature(feature.decoration, feature.placedFeature);
    }

    public BCLBiomeBuilder structure(class_6862<class_1959> structureTag) {
        this.tags.add(structureTag);
        return this;
    }

    public BCLBiomeBuilder structure(BCLStructure structure) {
        structure.addInternalBiome(this.biomeID);
        return this.structure(structure.biomeTag);
    }

    public BCLBiomeBuilder carver(class_2893.class_2894 step, class_6880<class_2922<?>> carver) {
        Optional oKey = carver.method_40230();
        if (oKey.isPresent()) {
            return this.carver(step, (class_5321)oKey.get());
        }
        return this;
    }

    public BCLBiomeBuilder carver(class_2893.class_2894 step, class_5321<class_2922<?>> carverKey) {
        BiomeModifications.addCarver(ctx -> ctx.getBiomeKey().method_29177().equals((Object)this.biomeID), (class_2893.class_2894)step, carverKey);
        return this;
    }

    public BCLBiomeBuilder surface(class_2248 surfaceBlock) {
        return this.surface(surfaceBlock.method_9564());
    }

    public BCLBiomeBuilder surface(class_2680 surfaceBlock) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock).build());
    }

    public BCLBiomeBuilder surface(class_2248 surfaceBlock, class_2248 subterrainBlock, int depth) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock.method_9564()).subsurface(subterrainBlock.method_9564(), depth).build());
    }

    public BCLBiomeBuilder surface(class_6686.class_6708 newSurfaceRule) {
        this.surfaceRule = newSurfaceRule;
        return this;
    }

    public BCLBiomeBuilder intendedType(BiomeAPI.BiomeType type) {
        this.biomeType = type;
        return this;
    }

    public BCLBiomeBuilder endLandBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_LAND);
    }

    public BCLBiomeBuilder endVoidBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_VOID);
    }

    public BCLBiomeBuilder endBarrensBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_BARRENS);
    }

    public BCLBiomeBuilder endCenterBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_CENTER);
    }

    public BCLBiomeBuilder netherBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_NETHER);
    }

    public BCLBiomeBuilder tag(class_6862<class_1959> ... tag) {
        for (class_6862<class_1959> t : tag) {
            this.tags.add(t);
        }
        return this;
    }

    public BCLBiomeBuilder terrainHeight(float height) {
        this.height = height;
        return this;
    }

    public BCLBiomeBuilder vertical() {
        this.vertical = true;
        return this;
    }

    private static class_5485 fixGenerationSettings(class_5485 settings) {
        if (settings instanceof BiomeGenerationSettingsAccessor) {
            BiomeGenerationSettingsAccessor acc = (BiomeGenerationSettingsAccessor)settings;
            Map<class_2893.class_2894, class_6885<class_2922<?>>> carvers = CollectionsUtil.getMutable(acc.bclib_getCarvers());
            for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                carvers.computeIfAbsent(step, __ -> class_6885.method_40242((List)Lists.newArrayList()));
            }
            acc.bclib_setCarvers(carvers);
        }
        return settings;
    }

    private class_4763.class_4764 getEffects() {
        if (this.effectsBuilder == null) {
            this.effectsBuilder = new class_4763.class_4764();
        }
        return this.effectsBuilder;
    }

    private class_5483.class_5496 getSpawns() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new class_5483.class_5496();
        }
        return this.spawnSettings;
    }

    private class_5485.class_5495 getGeneration(class_7891<class_1959> bootstrapContext) {
        if (this.generationSettings == null) {
            this.generationSettings = new class_5485.class_5495(bootstrapContext.method_46799(class_7924.field_41245), bootstrapContext.method_46799(class_7924.field_41238));
        }
        return this.generationSettings;
    }

    public BCLBiomeContainer<BCLBiome> build() {
        return this.build(BCLBiome::new);
    }

    public <T extends BCLBiome> BCLBiomeContainer<T> build(BiomeSupplier<T> biomeConstructor) {
        Object settings = ((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)BCLBiomeSettings.createBCL().setTerrainHeight(this.height)).setFogDensity(this.fogDensity)).setGenChance(this.genChance)).setEdgeSize(this.edgeSize)).setVertical(this.vertical)).build();
        BCLBiome bclBiome = (BCLBiome)biomeConstructor.apply(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)this.biomeID), settings);
        this.tags.forEach(tagKey -> TagManager.BIOMES.add((class_6862<class_1959>)tagKey, bclBiome.getBiomeKey()));
        SurfaceRuleRegistry.registerRule(this.biomeID, this.surfaceRule, this.biomeID);
        bclBiome.addClimateParameters(this.parameters);
        if (this.biomeType != null) {
            bclBiome._setIntendedType(this.biomeType);
        }
        class_1959.class_1960 builder = new class_1959.class_1960().method_48164(this.hasPrecipitation).method_8747(this.temperature).method_8727(this.downfall);
        builder.method_30974(this.getSpawns().method_31007());
        builder.method_24379(this.getEffects().method_24391());
        if (this.edge != null) {
            bclBiome._setEdge(this.edge);
        }
        UnboundBCLBiome<BCLBiome> unbound = new UnboundBCLBiome<BCLBiome>(bclBiome, this.parent, ctx -> {
            class_5485.class_5495 genBuilder = this.getGeneration((class_7891<class_1959>)ctx);
            this.featureSupliers.forEach(s -> s.accept(genBuilder));
            return builder.method_30973(BCLBiomeBuilder.fixGenerationSettings(genBuilder.method_46671())).method_30972();
        });
        UNBOUND_BIOMES.add(unbound);
        return unbound;
    }

    public static void registerUnbound(class_7891<class_1959> context) {
        UNBOUND_BIOMES.forEach((Consumer<UnboundBCLBiome<?>>)((Consumer<UnboundBCLBiome>)u -> u.register(context)));
        UNBOUND_BIOMES.clear();
    }

    static {
        DEFAULT_END_WATER_COLOR = DEFAULT_NETHER_WATER_COLOR = 4159204;
        DEFAULT_END_WATER_FOG_COLOR = DEFAULT_NETHER_WATER_FOG_COLOR = 329011;
        DEFAULT_END_FOG_COLOR = 0xA080A0;
        DEFAULT_END_SKY_COLOR = 0;
        DEFAULT_NETHER_TEMPERATURE = 2.0f;
        DEFAULT_END_TEMPERATURE = 0.5f;
        DEFAULT_NETHER_WETNESS = 0.0f;
        DEFAULT_END_WETNESS = 0.5f;
        SURFACE_NOISE = class_6686.method_39052((class_5321)class_6731.field_35383, (double)-0.012);
    }

    @FunctionalInterface
    private static interface FeatureSupplier
    extends Consumer<class_5485.class_5495> {
    }

    @FunctionalInterface
    public static interface BiomeSupplier<T>
    extends BiFunction<class_5321<class_1959>, BCLBiomeSettings, T> {
    }

    @FunctionalInterface
    static interface BuildCompletion
    extends Function<class_7891<class_1959>, class_1959> {
    }
}

