/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.builders;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.builders.CategoryBuilder;
import dev.kikugie.commandconfig.api.builders.CommandConfigBuilder;
import dev.kikugie.commandconfig.api.builders.OptionBuilder;
import dev.kikugie.commandconfig.impl.builders.CategoryBuilderImpl;
import dev.kikugie.commandconfig.impl.builders.CommandNodeImpl;
import dev.kikugie.commandconfig.impl.builders.OptionBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CommandConfigBuilderImpl<S extends class_2172>
extends CommandNodeImpl<S>
implements CommandConfigBuilder<S> {
    protected final List<Consumer<LiteralArgumentBuilder<S>>> extraNodes = new ArrayList<Consumer<LiteralArgumentBuilder<S>>>();
    private final List<CategoryBuilderImpl<S>> categories = new ArrayList<CategoryBuilderImpl<S>>();
    private final List<OptionBuilderImpl<?, S>> options = new ArrayList();

    public CommandConfigBuilderImpl(String command, Class<S> type) {
        super(command, type);
        Validate.matchesPattern((CharSequence)command, (String)"^[a-zA-Z0-9-_]+$", (String)Reference.baseError(this.name, "Invalid name for %s: \"%s\".\nOption and category names can only contain letters, numbers, dashes and underscores without spaces."), (Object[])new Object[0]);
    }

    @Override
    public CommandConfigBuilder<S> node(@NotNull Consumer<LiteralArgumentBuilder<S>> node) {
        Validate.notNull(node, (String)Reference.baseError(this.name, "Custom node can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.extraNodes.add(node);
        return this;
    }

    @Override
    public CommandConfigBuilder<S> category(@NotNull Function<Class<S>, CategoryBuilder<S>> category) {
        Validate.notNull(category, (String)Reference.baseError(this.name, "Category can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.categories.add((CategoryBuilderImpl)category.apply(this.type));
        return this;
    }

    @Override
    public CommandConfigBuilder<S> option(@NotNull Function<Class<S>, OptionBuilder<?, S>> option) {
        Validate.notNull(option, (String)Reference.baseError(this.name, "Option can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.options.add((OptionBuilderImpl)option.apply(this.type));
        return this;
    }

    @Override
    public CommandConfigBuilder<S> printFunc(@NotNull BiFunction<CommandContext<S>, class_2561, Integer> printFunc) {
        super.printFunc(printFunc);
        return this;
    }

    @Override
    public CommandConfigBuilder<S> saveFunc(@NotNull Runnable saveFunc) {
        super.saveFunc(saveFunc);
        return this;
    }

    @Override
    public CommandConfigBuilder<S> helpFunc(@NotNull Supplier<class_2561> helpFunc) {
        super.helpFunc(helpFunc);
        return this;
    }

    @Override
    @Nullable
    public LiteralArgumentBuilder<S> buildHelpFunc() {
        Validate.notNull((Object)this.printFunc, (String)Reference.baseError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)"help");
        this.buildHelpers(command, this.options);
        this.buildHelpers(command, this.categories);
        command.executes(context -> this.print(context, this.helpFunc != null ? (class_2561)this.helpFunc.get() : Reference.NO_HELP_SAD.get()));
        return command.getArguments().isEmpty() && this.helpFunc == null ? null : command;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<S> build() {
        LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)this.name);
        this.extraNodes.forEach(it -> it.accept(command));
        this.buildNodes(command, this.options);
        this.buildNodes(command, this.categories);
        LiteralArgumentBuilder<S> helpNode = this.buildHelpFunc();
        if (helpNode != null) {
            command.then(helpNode);
        }
        return command;
    }
}

