/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.api.util;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.option.access.ListElementAccess;
import dev.kikugie.commandconfig.api.option.access.OptionValueAccess;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.slf4j.Logger;

public class Defaults {
    public static <T, S extends class_2172> OptionValueAccess<T, S> defaultValueAccess(Supplier<T> getter, Consumer<T> setter) {
        return new OptionValueAccess(context -> Reference.translated("commandconfig.response.option.get", getter.get()), (context, val) -> {
            setter.accept(val);
            return Reference.translated("commandconfig.response.option.set", val);
        });
    }

    public static <L extends List<T>, T, S extends class_2172> ListElementAccess<T, S> defaultElementAccess(Supplier<L> listSupplier) {
        return Defaults.defaultElementAccess("commandconfig.response.option.element", listSupplier);
    }

    public static <L extends List<T>, T, S extends class_2172> ListElementAccess<T, S> defaultElementAccess(String baseTranslationKey, Supplier<L> listSupplier) {
        return new ListElementAccess((context, index) -> {
            List list = (List)listSupplier.get();
            return index >= 0 && index < list.size() ? Reference.translated(baseTranslationKey + ".get", list.get((int)index)) : Reference.translated("commandconfig.response.error.invalid_index", index, list.size());
        }, (context, index, value) -> {
            List list = (List)listSupplier.get();
            if (index >= 0 && index < list.size()) {
                list.set((int)index, value);
                return Reference.translated(baseTranslationKey + ".set", value, index);
            }
            return Reference.translated("commandconfig.response.error.invalid_index", index, list.size());
        }, (context, value) -> {
            List list = (List)listSupplier.get();
            list.add(value);
            return Reference.translated(baseTranslationKey + ".add", value, list.size());
        }, (context, index) -> {
            List list = (List)listSupplier.get();
            if (index >= 0 && index < list.size()) {
                Object value = list.get((int)index);
                list.removeAll(List.of(value));
                return new Pair(value, (Object)Reference.translated(baseTranslationKey + ".remove", value, index));
            }
            return new Pair(null, (Object)Reference.translated("commandconfig.response.error.invalid_index", index, list.size()));
        });
    }

    public static BiFunction<CommandContext<FabricClientCommandSource>, class_2561, Integer> clientPrintFunc() {
        return (context, text) -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(text);
            return 1;
        };
    }

    public static BiFunction<CommandContext<class_2168>, class_2561, Integer> serverPrintFunc() {
        return (context, text) -> {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        };
    }

    public static BiFunction<CommandContext<class_2168>, class_2561, Integer> broadcastPrintFunc() {
        return (context, text) -> {
            ((class_2168)context.getSource()).method_9226(() -> text, true);
            return 1;
        };
    }

    public static BiFunction<CommandContext<CommandContext<?>>, class_2561, Integer> loggerPrintFunc(Logger logger) {
        return (context, text) -> {
            logger.info(text.toString());
            return 1;
        };
    }
}

