/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.DisplayableBoolean;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_459;
import net.minecraft.class_6599;

public class NewKeyBindsScreen
extends class_6599 {
    private AutoCompletingEditBox<class_459.class_461> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private class_4185 buttonNone;
    private class_4185 buttonConflicting;
    private class_4185 buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, (class_2561)ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, (class_2561)ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    private final class_4185.class_4241 PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = this;
        class_310 minecraft = Objects.requireNonNull(screen.field_22787);
        if (!this.confirmingReset.toggle()) {
            for (class_304 keybinding : minecraft.field_1690.field_1839) {
                Services.PLATFORM.setToDefault(minecraft.field_1690, keybinding);
            }
            this.getKeyBindsList().method_49006();
        }
        btn.method_25355(this.confirmingReset.currentDisplay());
    };
    private final class_4185.class_4241 PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.method_25355(this.sortOrder.getDisplay());
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_CONFLICTING = btn -> {
        if (this.displayMode == DisplayMode.CONFLICTING) {
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.CONFLICTING;
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_FREE = btn -> {
        this.method_37066((class_364)this.getKeyBindsList());
        if (this.showFree) {
            this.buttonSort.field_22763 = true;
            this.buttonNone.field_22763 = true;
            this.buttonConflicting.field_22763 = true;
            this.resetButton().field_22763 = true;
            this.setKeyBindsList(this.newKeyList.get());
        } else {
            this.freeKeyList.get().recalculate();
            this.buttonSort.field_22763 = false;
            this.buttonNone.field_22763 = false;
            this.buttonConflicting.field_22763 = false;
            this.resetButton().field_22763 = false;
            this.setKeyBindsList(this.freeKeyList.get());
        }
        this.filterKeys();
        this.method_25429((class_364)this.getKeyBindsList());
        this.method_25395((class_364)this.getKeyBindsList());
        this.showFree = !this.showFree;
    };

    public NewKeyBindsScreen(class_437 screen, class_315 settings) {
        super(screen, settings);
    }

    protected void method_25426() {
        super.method_25426();
        int searchX = this.getKeyBindsList().method_25322();
        int btnWidth = 74;
        int groupPadding = 5;
        int centerX = this.field_22789 / 2;
        int leftX = centerX - 150 - groupPadding;
        int rightX = centerX + groupPadding;
        int bottomY = this.field_22790 - 29;
        int rowSpacing = 24;
        int topRowY = bottomY - rowSpacing;
        Supplier<List> listSupplier = () -> this.getCustomList().getAllEntries();
        this.search = (AutoCompletingEditBox)this.method_37063((class_364)new AutoCompletingEditBox(this.field_22793, centerX - searchX / 2, 22, searchX, 20, this.search, (class_2561)class_2561.method_43471((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier));
        this.search.addResponder(this::filterKeys);
        this.method_37060((class_4068)this.search.autoComplete());
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.field_22787));
        this.freeKeyList = Suppliers.memoize(() -> new FreeKeysList(this, this.field_22787));
        this.method_37066((class_364)this.getKeyBindsList());
        this.setKeyBindsList(this.showFree ? (class_459)this.freeKeyList.get() : (class_459)this.newKeyList.get());
        this.method_25429((class_364)this.getKeyBindsList());
        this.method_37066((class_364)this.resetButton());
        this.resetButton((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.confirmingReset.currentDisplay(), (class_4185.class_4241)this.PRESS_RESET).method_46434(leftX, bottomY, 150, 20).method_46431()));
        this.method_37063((class_364)class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, (class_4185.class_4241)this.PRESS_FREE).method_46434(leftX, topRowY, btnWidth, 20).method_46431());
        this.buttonSort = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.sortOrder.getDisplay(), (class_4185.class_4241)this.PRESS_SORT).method_46434(leftX + btnWidth + 2, topRowY, btnWidth, 20).method_46431());
        this.buttonNone = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (class_4185.class_4241)this.PRESS_NONE).method_46434(rightX, topRowY, btnWidth, 20).method_46431());
        this.buttonConflicting = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, (class_4185.class_4241)this.PRESS_CONFLICTING).method_46434(rightX + btnWidth + 2, topRowY, btnWidth, 20).method_46431());
        this.displayMode = DisplayMode.ALL;
        this.method_48265((class_364)this.search);
        this.search.method_1855(0);
        this.method_25396().sort(Comparator.comparingInt(value -> value.method_48202().method_49618()).thenComparingInt(listener -> listener.method_48202().method_49620()));
    }

    public class_4185 resetButton() {
        return this.getAccess().controlling$getResetButton();
    }

    public void resetButton(class_4185 button) {
        this.getAccess().controlling$setResetButton(button);
    }

    public void filterKeys() {
        this.filterKeys(this.search.method_1882());
    }

    public void filterKeys(String lastSearch) {
        this.getKeyBindsList().method_25396().clear();
        this.getKeyBindsList().method_25307(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.getKeyBindsList().method_25396().addAll(this.getCustomList().getAllEntries());
            return;
        }
        Predicate<class_459.class_461> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        CustomList list = this.getCustomList();
        if (list instanceof NewKeyBindsList) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> this.sortOrder.sort((List<class_459.class_461>)entries);
        }
        list.method_25396().addAll(ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.method_25396());
    }

    public void method_25393() {
        this.search.method_1865();
    }

    public boolean method_25401(double xpos, double ypos, double delta) {
        if (this.search.autoComplete().method_25401(xpos, ypos, delta)) {
            return true;
        }
        return super.method_25401(xpos, ypos, delta);
    }

    public boolean method_25404(int key, int scancode, int mods) {
        if (!this.search.method_25370() && this.field_34799 == null && NewKeyBindsScreen.method_25441() && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)70)) {
            this.search.method_25365(true);
            return true;
        }
        if (this.search.method_25370() && key == 256) {
            this.search.method_25365(false);
            return true;
        }
        if (this.field_34799 != null) {
            if (key == 256) {
                Services.PLATFORM.setKey(this.field_21336, this.field_34799, class_3675.field_16237);
            } else {
                Services.PLATFORM.setKey(this.field_21336, this.field_34799, class_3675.method_15985((int)key, (int)scancode));
            }
            if (!Services.PLATFORM.isKeyCodeModifier(((AccessKeyMapping)this.field_34799).controlling$getKey())) {
                this.field_34799 = null;
            }
            this.field_34800 = class_156.method_658();
            this.getKeyBindsList().method_49006();
            return true;
        }
        return super.method_25404(key, scancode, mods);
    }

    private CustomList getCustomList() {
        class_459 class_4592 = this.getKeyBindsList();
        if (class_4592 instanceof CustomList) {
            CustomList cl = (CustomList)class_4592;
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList().getClass()));
    }

    private class_459 getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    private void setKeyBindsList(class_459 newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }
}

