/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.motors.MotorScrollValueBehaviour;
import org.antarcticgardens.newage.content.motors.extension.MotorExtensionBlockEntity;
import org.antarcticgardens.newage.content.motors.variants.IMotorVariant;
import org.antarcticgardens.newage.energy.InsertOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class MotorBlockEntity
extends GeneratingKineticBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer>,
IHaveGoggleInformation {
    public boolean needsPower = false;
    public WrappedBlockEnergyContainer energy;
    private final IMotorVariant variant;
    public MotorScrollValueBehaviour speedBehavior;
    public boolean powered = false;
    private float actualSpeed = 0.0f;
    private float actualStress = 0.0f;
    private long prvEnergy = -100000L;
    private int energySpam = 0;
    private float speed = 0.0f;
    private float stress = 0.0f;
    private InsertOnlyResizableEnergyContainer mut;
    private long e;

    public MotorBlockEntity(class_2591<?> arg, class_2338 arg2, class_2680 arg3, IMotorVariant variant) {
        super(arg, arg2, arg3);
        this.variant = variant;
        if (this.mut == null) {
            this.getEnergyStorage();
        }
        this.mut.setMaxCapacity(variant.getMaxCapacity());
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorBlockEntity> create(IMotorVariant variant) {
        return (type, pos, state) -> new MotorBlockEntity(type, pos, state, variant);
    }

    public void initialize() {
        this.powered = this.method_10997().method_49803(this.method_11016());
        super.initialize();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.speedBehavior = new MotorScrollValueBehaviour((class_2561)Lang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.speedBehavior.requiresWrench();
        this.speedBehavior.value = this.getDefaultSpeed();
        this.speedBehavior.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.speedBehavior);
    }

    public int getDefaultSpeed() {
        return 16;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.energy.setEnergy(compound.method_10537("energy"));
        this.actualSpeed = compound.method_10583("aSpeed");
        this.needsPower = compound.method_10577("needsPower");
        this.stress = compound.method_10583("lastGeneratedStress");
        this.speed = compound.method_10583("lastGeneratedSpeed");
        this.e = compound.method_10537("eUse");
        super.read(compound, clientPacket);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10544("energy", this.energy.getStoredEnergy());
        compound.method_10548("aSpeed", this.actualSpeed);
        compound.method_10556("needsPower", this.needsPower);
        compound.method_10548("lastGeneratedStress", this.stress);
        compound.method_10548("lastGeneratedSpeed", this.speed);
        compound.method_10548("eUse", (float)this.e);
        super.write(compound, clientPacket);
    }

    public float calculateStressApplied() {
        return 0.0f;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(class_124.field_1075).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormattingTool.formatLong(this.e)}).style(class_124.field_1075).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public float calculateAddedStressCapacity() {
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return this.lastCapacityProvided;
        }
        this.lastCapacityProvided = this.actualStress / this.actualSpeed;
        this.lastCapacityProvided = Float.isNaN(this.lastCapacityProvided) || Float.isInfinite(this.lastCapacityProvided) ? 0.0f : Math.abs(this.lastCapacityProvided);
        return this.lastCapacityProvided;
    }

    public float getGeneratedSpeed() {
        return this.actualSpeed;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            network.updateCapacityFor((KineticBlockEntity)this, this.stress);
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void tick() {
        class_2586 class_25862;
        super.tick();
        if (this.field_11863 == null) {
            return;
        }
        float stressMultiplier = 1.0f;
        long extraEnergy = 0L;
        class_2350 dir = (class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING);
        if (this.field_11863.method_8320(this.method_11016().method_10093(dir.method_10153())).method_28500((class_2769)DirectionalKineticBlock.FACING).orElse(dir.method_10153()) == dir && (class_25862 = this.field_11863.method_8321(this.method_11016().method_10093(dir.method_10153()))) instanceof MotorExtensionBlockEntity) {
            MotorExtensionBlockEntity extension = (MotorExtensionBlockEntity)class_25862;
            stressMultiplier = extension.getMultiplier();
            extraEnergy = extension.getVariant().getExtraCapacity();
        }
        this.mut.setMaxCapacity(extraEnergy + this.variant.getMaxCapacity());
        this.speedBehavior.betweenValidated((int)(-this.variant.getSpeed()), (int)this.variant.getSpeed());
        if (!this.field_11863.method_8608()) {
            int needed = (int)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)NewAgeConfig.getCommon().motorSUMultiplier.get() * (Double)NewAgeConfig.getCommon().suToEnergy.get());
            long l = this.e = this.needsPower == this.powered ? this.energy.internalExtract((long)needed, false) : 0L;
            if (this.e > 0L) {
                this.actualSpeed = this.speedBehavior.value;
                this.actualStress = (float)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)NewAgeConfig.getCommon().motorSUMultiplier.get() * (double)((float)this.e / (float)needed));
            } else {
                this.actualSpeed = 0.0f;
                this.actualStress = 0.0f;
            }
            if (this.actualSpeed != this.speed || this.actualStress != this.stress) {
                this.updateGeneratedRotation();
                this.speed = this.actualSpeed;
                this.stress = this.actualStress;
            } else if (this.energy.getStoredEnergy() != this.prvEnergy && this.energySpam > 10) {
                this.sendData();
                this.prvEnergy = this.energy.getStoredEnergy();
                this.energySpam = 0;
            }
        }
        ++this.energySpam;
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        WrappedBlockEnergyContainer wrappedBlockEnergyContainer;
        if (this.energy == null) {
            this.mut = new InsertOnlyResizableEnergyContainer(this.variant.getMaxCapacity());
            wrappedBlockEnergyContainer = this.energy = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)this.mut);
        } else {
            wrappedBlockEnergyContainer = this.energy;
        }
        return wrappedBlockEnergyContainer;
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public class_243 getLocalOffset(class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            return super.getLocalOffset(state).method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021(-0.0625));
        }

        public void rotate(class_2680 state, class_4587 ms) {
            super.rotate(state, ms);
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                return;
            }
            if (this.getSide() != class_2350.field_11036) {
                return;
            }
            TransformStack.cast((class_4587)ms).rotateZ((double)(-AngleHelper.horizontalAngle((class_2350)facing) + 180.0f));
        }

        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() != class_2350.class_2351.field_11052 && direction == class_2350.field_11033) {
                return false;
            }
            return direction.method_10166() != facing.method_10166();
        }
    }
}

