/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create.mechanical_chisel;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.create.RechiseledCreate;
import com.supermartijn642.rechiseled.create.mechanical_chisel.MechanicalChiselBlock;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class MechanicalChiselBlockEntity
extends KineticBlockEntity
implements SidedStorageBlockEntity {
    public ProcessingInventory inventory;
    private int recipeIndex;
    private FilteringBehaviour filtering;
    private class_1799 playEvent;

    public MechanicalChiselBlockEntity(class_2338 pos, class_2680 state) {
        super(RechiseledCreate.mechanical_chisel_entity, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = class_1799.field_8037;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SawFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(this::canProcess));
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10569("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.method_7960()) {
            return;
        }
        compound.method_10566("PlayEvent", NBTSerializer.serializeNBT((Object)this.playEvent));
        this.playEvent = class_1799.field_8037;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.recipeIndex = compound.method_10550("RecipeIndex");
        if (compound.method_10545("PlayEvent")) {
            this.playEvent = class_1799.method_7915((class_2487)compound.method_10562("PlayEvent"));
        }
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(0.125);
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.method_7960()) {
            boolean isWood = false;
            class_1792 item = this.playEvent.method_7909();
            if (item instanceof class_1747) {
                class_2248 block = ((class_1747)item).method_7711();
                isWood = block.method_9573(block.method_9564()) == class_2498.field_11547;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = class_1799.field_8037;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.method_5442() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        class_243 itemMovement = this.getItemMovementVec();
        class_2350 itemMovementFacing = class_2350.method_10142((double)itemMovement.field_1352, (double)itemMovement.field_1351, (double)itemMovement.field_1350);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 tryExportingToBeltFunnel;
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.method_10153(), false)) == null) continue;
            if (tryExportingToBeltFunnel.method_7947() != stack.method_7947()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.method_7960()) continue;
            return;
        }
        class_2338 nextPos = this.field_11867.method_10069((int)itemMovement.field_1352, (int)itemMovement.field_1351, (int)itemMovement.field_1350);
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
                class_1799 remainder;
                class_1799 stack = this.inventory.getStackInSlot(slot);
                if (stack.method_7960() || class_1799.method_7973((class_1799)(remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)), (class_1799)stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
            return;
        }
        class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(itemMovement.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
        class_243 outMotion = itemMovement.method_1021(0.0625).method_1031(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
            entityIn.method_18799(outMotion);
            this.field_11863.method_8649((class_1297)entityIn);
        }
        this.inventory.clear();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((class_1937)this.field_11863, (class_2338)this.field_11867, (Storage)this.inventory);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return face == class_2350.field_11033 ? null : this.inventory;
    }

    protected void spawnEventParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        Object particleData = stack.method_7909() instanceof class_1747 ? new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564()) : new class_2392(class_2398.field_11218, stack);
        class_5819 r = this.field_11863.field_9229;
        class_243 v = VecHelper.getCenterOf((class_2382)this.field_11867).method_1031(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            class_243 m = VecHelper.offsetRandomly((class_243)new class_243(0.0, 0.25, 0.0), (class_5819)r, (float)0.125f);
            this.field_11863.method_8406((class_2394)particleData, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1351);
        }
    }

    public class_243 getItemMovementVec() {
        boolean alongX = (Boolean)this.method_11010().method_11654((class_2769)MechanicalChiselBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new class_243((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        List<class_1799> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        class_1799 recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).method_7947();
        this.inventory.clear();
        class_1799 output = recipe.method_7972();
        output.method_7939(rolls);
        this.inventory.setStackInSlot(1, output);
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private List<class_1799> getRecipes() {
        class_1799 input = this.inventory.getStackInSlot(0);
        ChiselingRecipe recipe = ChiselingRecipes.getRecipe((class_1799)input);
        if (recipe == null) {
            return Collections.emptyList();
        }
        if (this.filtering.isActive() && !this.filtering.getFilter().method_7960()) {
            return recipe.getEntries().stream().flatMap(entry -> entry.hasConnectingItem() ? (entry.hasRegularItem() ? Stream.of(entry.getConnectingItem(), entry.getRegularItem()) : Stream.of(entry.getConnectingItem())) : Stream.of(entry.getRegularItem())).map(class_1792::method_7854).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
        }
        boolean connecting = false;
        for (ChiselingEntry entry2 : recipe.getEntries()) {
            if (entry2.getConnectingItem() == input.method_7909()) {
                connecting = true;
                break;
            }
            if (entry2.getRegularItem() != input.method_7909()) continue;
            break;
        }
        return recipe.getEntries().stream().filter(connecting ? ChiselingEntry::hasConnectingItem : ChiselingEntry::hasRegularItem).map(connecting ? ChiselingEntry::getConnectingItem : ChiselingEntry::getRegularItem).map(class_1792::method_7854).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
    }

    public void insertItem(class_1542 entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.method_5442()) {
            return;
        }
        if (!entity.method_5805()) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        this.inventory.clear();
        try (Transaction transaction = TransferUtil.getTransaction();){
            class_1799 stack = entity.method_6983();
            long inserted = this.inventory.insert(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            if ((long)stack.method_7947() == inserted) {
                entity.method_31472();
            } else {
                entity.method_6979(ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)((int)((long)stack.method_7947() - inserted))));
            }
            transaction.commit();
        }
    }

    public void start(class_1799 inserted) {
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.method_5442()) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<class_1799> recipes = this.getRecipes();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        this.recipeIndex = this.field_11863.method_8409().method_43048(recipes.size());
        if (inserted.method_7909() == recipes.get(this.recipeIndex).method_7909()) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.method_7947() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.method_11010().method_11654((class_2769)MechanicalChiselBlock.FACING) == class_2350.field_11036;
    }
}

