/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.enchantedshulkers.mixin;

import de.rubixdev.enchantedshulkers.Mod;
import de.rubixdev.enchantedshulkers.Utils;
import de.rubixdev.enchantedshulkers.config.WorldConfig;
import de.rubixdev.enchantedshulkers.interfaces.EnchantableBlockEntity;
import de.rubixdev.enchantedshulkers.mixin.BlockEntityMixin;
import de.rubixdev.enchantedshulkers.screen.AugmentedShulkerBoxScreenHandler;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2627;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2627.class})
public abstract class ShulkerBoxBlockEntityMixin
extends BlockEntityMixin
implements EnchantableBlockEntity,
class_3908 {
    @Shadow
    private class_2371<class_1799> field_12054;
    @Unique
    private class_2499 enchantments = new class_2499();

    @Shadow
    @Nullable
    public abstract class_1767 method_11320();

    @Override
    @NotNull
    public class_2499 enchantedShulkers$getEnchantments() {
        return this.enchantments;
    }

    @Override
    public void enchantedShulkers$setEnchantments(@NotNull class_2499 enchantments) {
        this.enchantments = enchantments;
        this.updateInventorySize();
    }

    @Unique
    private void updateInventorySize() {
        int newSize = 9 * Utils.getInvRows(Utils.getLevelFromNbt(Mod.AUGMENT_ENCHANTMENT, this.enchantments));
        if (this.field_12054.size() >= newSize) {
            return;
        }
        class_2371 newInv = class_2371.method_10213((int)newSize, (Object)class_1799.field_8037);
        for (int i = 0; i < this.field_12054.size(); ++i) {
            newInv.set(i, (Object)((class_1799)this.field_12054.get(i)));
        }
        this.field_12054 = newInv;
    }

    @Override
    @Inject(method={"readNbt"}, at={@At(value="HEAD")})
    public void readNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("Enchantments", 9)) {
            this.enchantedShulkers$setEnchantments(nbt.method_10554("Enchantments", 10));
        }
    }

    @Override
    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    public void writeNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10566("Enchantments", (class_2520)this.enchantments);
    }

    @Override
    public void toInitialChunkDataNbt(CallbackInfoReturnable<class_2487> cir) {
        cir.setReturnValue((Object)this.enchantedShulkers$toClientNbt());
    }

    @Override
    public void toUpdatePacket(CallbackInfoReturnable<@Nullable class_2596<class_2602>> cir) {
        cir.setReturnValue((Object)class_2622.method_38585((class_2586)((class_2586)this)));
    }

    @Inject(method={"getContainerName"}, at={@At(value="RETURN")}, cancellable=true)
    public void getContainerName(CallbackInfoReturnable<class_2561> cir) {
        class_5250 text = ((class_2561)cir.getReturnValue()).method_27661();
        if (WorldConfig.coloredNames() && !this.enchantments.isEmpty()) {
            text.method_10862(class_2583.field_24360.method_27706(class_124.field_1075));
        }
        cir.setReturnValue((Object)text);
    }

    @Inject(method={"createScreenHandler"}, at={@At(value="HEAD")}, cancellable=true)
    private void augmentedScreenHandler(int syncId, class_1661 playerInventory, CallbackInfoReturnable<class_1703> cir) {
        int level = Utils.getLevelFromNbt(Mod.AUGMENT_ENCHANTMENT, this.enchantments);
        if (level != 0) {
            cir.setReturnValue((Object)AugmentedShulkerBoxScreenHandler.create(syncId, playerInventory, (class_1263)this, level, this.method_5476(), this.method_11320()));
        }
    }

    @Inject(method={"getAvailableSlots"}, at={@At(value="HEAD")}, cancellable=true)
    private void augmentedInvSize(class_2350 side, CallbackInfoReturnable<int[]> cir) {
        int level = Utils.getLevelFromNbt(Mod.AUGMENT_ENCHANTMENT, this.enchantments);
        if (level != 0) {
            cir.setReturnValue((Object)IntStream.range(0, 9 * Utils.getInvRows(level)).toArray());
        }
    }
}

