/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.enchantedshulkers.enchantment;

import de.rubixdev.enchantedshulkers.Mod;
import de.rubixdev.enchantedshulkers.Utils;
import de.rubixdev.enchantedshulkers.config.WorldConfig;
import de.rubixdev.enchantedshulkers.enchantment.ContainerEnchantment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lde/rubixdev/enchantedshulkers/enchantment/SiphonEnchantment;", "Lde/rubixdev/enchantedshulkers/enchantment/ContainerEnchantment;", "<init>", "()V", "", "generate", "()Z", "Companion", "enchantedshulkers-mc1.20.1"})
public final class SiphonEnchantment
extends ContainerEnchantment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SiphonEnchantment() {
        super(Mod.PORTABLE_CONTAINER_TARGET);
    }

    @Override
    protected boolean generate() {
        return WorldConfig.generateSiphon();
    }

    @JvmStatic
    public static final boolean onItemPickup(@NotNull class_3222 player, @NotNull class_1799 stack) {
        return Companion.onItemPickup(player, stack);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000fJ'\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J5\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lde/rubixdev/enchantedshulkers/enchantment/SiphonEnchantment$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_1799;", "stack", "", "onItemPickup", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;)Z", "Lnet/minecraft/class_1887;", "enchantment", "requireStack", "strongerSiphon", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lnet/minecraft/class_1887;ZZ)Z", "onItemPickupStrongerSiphon", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lnet/minecraft/class_1887;)Z", "from", "to", "Lnet/minecraft/class_2371;", "containerInventory", "", "toIndex", "trySiphonStack", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1799;Lnet/minecraft/class_2371;I)Z", "enchantedshulkers-mc1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean onItemPickup(@NotNull class_3222 player, @NotNull class_1799 stack) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return (!player.method_7337() || WorldConfig.creativeSiphon()) && this.onItemPickup(player, stack, Mod.SIPHON_ENCHANTMENT, true, WorldConfig.strongerSiphon());
        }

        public final boolean onItemPickup(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull class_1887 enchantment, boolean requireStack, boolean strongerSiphon) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
            if (strongerSiphon) {
                return this.onItemPickupStrongerSiphon(player, stack, enchantment);
            }
            List<class_1799> containerSlots = Utils.getContainers(player, enchantment);
            boolean usedSiphon = false;
            for (class_1799 container : containerSlots) {
                if (stack.method_7960()) {
                    return usedSiphon;
                }
                class_2371<class_1799> containerInventory = Utils.getContainerInventory(container, player);
                boolean updateContainer = false;
                int n = containerInventory.size();
                for (int i = 0; i < n; ++i) {
                    Object object = containerInventory.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containerInventory[i]");
                    class_1799 innerStack = (class_1799)object;
                    if (innerStack.method_7960() && requireStack || !this.trySiphonStack(stack, innerStack, containerInventory, i)) continue;
                    updateContainer = true;
                    if (stack.method_7960()) break;
                }
                if (!updateContainer) continue;
                usedSiphon = true;
                Utils.setContainerInventory(container, containerInventory);
            }
            return usedSiphon;
        }

        private final boolean onItemPickupStrongerSiphon(class_3222 player, class_1799 stack, class_1887 enchantment) {
            List<class_1799> containerSlots = Utils.getContainers(player, enchantment);
            boolean usedSiphon = false;
            for (class_1799 container : containerSlots) {
                if (stack.method_7960()) {
                    return usedSiphon;
                }
                class_1792 item = stack.method_7909();
                List foundItemSlots = new ArrayList();
                List emptyItemSlots = new ArrayList();
                class_2371<class_1799> containerInventory = Utils.getContainerInventory(container, player);
                int n = containerInventory.size();
                for (int i = 0; i < n; ++i) {
                    Object object = containerInventory.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containerInventory[i]");
                    class_1799 innerStack = (class_1799)object;
                    if (innerStack.method_7960()) {
                        emptyItemSlots.add(i);
                        continue;
                    }
                    if (!innerStack.method_31574(item)) continue;
                    foundItemSlots.add(i);
                }
                if (foundItemSlots.isEmpty()) continue;
                boolean updateContainer = false;
                Iterator iterator = foundItemSlots.iterator();
                while (iterator.hasNext()) {
                    int slotId = ((Number)iterator.next()).intValue();
                    if (stack.method_7960()) break;
                    Object object = containerInventory.get(slotId);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containerInventory[slotId]");
                    if (!this.trySiphonStack(stack, (class_1799)object, containerInventory, slotId)) continue;
                    updateContainer = true;
                }
                iterator = emptyItemSlots.iterator();
                while (iterator.hasNext()) {
                    int slotId = ((Number)iterator.next()).intValue();
                    if (stack.method_7960()) break;
                    Object object = containerInventory.get(slotId);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containerInventory[slotId]");
                    if (!this.trySiphonStack(stack, (class_1799)object, containerInventory, slotId)) continue;
                    updateContainer = true;
                }
                if (!updateContainer) continue;
                usedSiphon = true;
                Utils.setContainerInventory(container, containerInventory);
            }
            return usedSiphon;
        }

        private final boolean trySiphonStack(class_1799 from, class_1799 to, class_2371<class_1799> containerInventory, int toIndex) {
            if (to.method_7960()) {
                containerInventory.set(toIndex, (Object)from.method_7972());
                from.method_7939(0);
                return true;
            }
            if (!class_1799.method_31577((class_1799)from, (class_1799)to)) {
                return false;
            }
            int transferCount = Math.min(to.method_7914() - to.method_7947(), from.method_7947());
            if (transferCount <= 0) {
                return false;
            }
            to.method_7933(transferCount);
            from.method_7934(transferCount);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

