/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.enchantedshulkers.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.rubixdev.enchantedshulkers.config.InvalidOptionValueException;
import de.rubixdev.enchantedshulkers.config.WorldConfig;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0018\u001a\u00020\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\t\u00a8\u0006\u001f"}, d2={"Lde/rubixdev/enchantedshulkers/config/ConfigCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "", "displayOptionMenu", "(Lcom/mojang/brigadier/context/CommandContext;)I", "listAllOptions", "", "option", "value", "", "brackets", "Lnet/minecraft/class_2561;", "makeSetOptionButton", "(Ljava/lang/String;Ljava/lang/String;Z)Lnet/minecraft/class_2561;", "optionFromContext", "(Lcom/mojang/brigadier/context/CommandContext;)Ljava/lang/String;", "Lcom/mojang/brigadier/CommandDispatcher;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "source", "text", "sendFeedback", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_2561;)V", "setOption", "enchantedshulkers-mc1.20.1"})
@SourceDebugExtension(value={"SMAP\nConfigCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigCommand.kt\nde/rubixdev/enchantedshulkers/config/ConfigCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1855#2,2:203\n*S KotlinDebug\n*F\n+ 1 ConfigCommand.kt\nde/rubixdev/enchantedshulkers/config/ConfigCommand\n*L\n70#1:203,2\n*E\n"})
public final class ConfigCommand {
    @NotNull
    public static final ConfigCommand INSTANCE = new ConfigCommand();

    private ConfigCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"enchantedshulkers").requires(ConfigCommand::register$lambda$0);
        ((LiteralArgumentBuilder)builder.executes(this::listAllOptions)).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"option", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(ConfigCommand::register$lambda$1).executes(this::displayOptionMenu)).then(RequiredArgumentBuilder.argument((String)"value", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).suggests(ConfigCommand::register$lambda$2).executes(this::setOption)));
        dispatcher.register(builder);
    }

    private final void sendFeedback(class_2168 source, class_2561 text) {
        source.method_9226(() -> ConfigCommand.sendFeedback$lambda$3(text), false);
    }

    private final String optionFromContext(CommandContext<class_2168> context) {
        String optionName = StringArgumentType.getString(context, (String)"option");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)optionName, (String)"optionName");
            WorldConfig.INSTANCE.getOption(optionName);
        }
        catch (NoSuchElementException e) {
            Object[] objectArray = new Object[]{optionName};
            CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"commands.enchantedshulkers.unknown_option", (Object[])objectArray).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)))).create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"SimpleCommandExceptionTy\u2026),\n            ).create()");
            throw (Throwable)commandSyntaxException;
        }
        return optionName;
    }

    private final int listAllOptions(CommandContext<class_2168> context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.source");
        class_2168 class_21682 = (class_2168)object;
        class_5250 class_52502 = class_2561.method_43473();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"empty()");
        this.sendFeedback(class_21682, (class_2561)class_52502);
        Object object2 = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.source");
        class_2168 class_21683 = (class_2168)object2;
        class_5250 class_52503 = class_2561.method_43471((String)"commands.enchantedshulkers.all_options_title").method_10862(class_2583.field_24360.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(true)));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(\"commands.$\u2026ng.WHITE).withBold(true))");
        this.sendFeedback(class_21683, (class_2561)class_52503);
        Iterable $this$forEach$iv = WorldConfig.INSTANCE.getOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String option = (String)element$iv;
            boolean bl = false;
            class_5250 text = class_2561.method_43473();
            text.method_10852((class_2561)class_2561.method_43470((String)("- " + option)).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/enchantedshulkers " + option)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)("enchantedshulkers.options." + option + ".desc")).method_10862(class_2583.field_24360.method_10977(class_124.field_1054))))));
            for (String suggestion : WorldConfig.INSTANCE.suggestions(option)) {
                text.method_10852(INSTANCE.makeSetOptionButton(option, suggestion, true));
            }
            Object object3 = context.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.source");
            class_2168 class_21684 = (class_2168)object3;
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            INSTANCE.sendFeedback(class_21684, (class_2561)text);
        }
        return 1;
    }

    private final class_2561 makeSetOptionButton(String option, String value, boolean brackets) {
        class_2583 style;
        class_5250 text = class_2561.method_43470((String)((brackets ? "[" : "") + value + (brackets ? "]" : "")));
        boolean optionIsDefault = Intrinsics.areEqual((Object)WorldConfig.INSTANCE.getOption(option), (Object)WorldConfig.INSTANCE.getOptionDefault(option));
        boolean valueIsOptionDefault = StringsKt.equals((String)String.valueOf(WorldConfig.INSTANCE.getOptionDefault(option)), (String)value, (boolean)true);
        boolean valueIsOptionCurrent = StringsKt.equals((String)String.valueOf(WorldConfig.INSTANCE.getOption(option)), (String)value, (boolean)true);
        class_2583 class_25832 = optionIsDefault ? class_2583.field_24360.method_10977(class_124.field_1080) : (style = valueIsOptionDefault ? class_2583.field_24360.method_10977(class_124.field_1060) : class_2583.field_24360.method_10977(class_124.field_1054));
        if (valueIsOptionCurrent) {
            style = style.method_30938(Boolean.valueOf(true));
            if (valueIsOptionDefault) {
                style = style.method_10982(Boolean.valueOf(true));
            }
        }
        if (!valueIsOptionCurrent) {
            style = style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/enchantedshulkers " + option + " " + value));
            Object[] objectArray = new Object[]{value + (valueIsOptionDefault ? " (default)" : "")};
            style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"commands.enchantedshulkers.switch_to", (Object[])objectArray).method_10862(class_2583.field_24360.method_10977(class_124.field_1080))));
        }
        class_5250 class_52502 = class_2561.method_43470((String)" ").method_10852((class_2561)text.method_10862(style));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(\" \").append(text.setStyle(style))");
        return (class_2561)class_52502;
    }

    private final int displayOptionMenu(CommandContext<class_2168> context) {
        String option = this.optionFromContext(context);
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.source");
        class_2168 class_21682 = (class_2168)object;
        class_5250 class_52502 = class_2561.method_43473();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"empty()");
        this.sendFeedback(class_21682, (class_2561)class_52502);
        Object object2 = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.source");
        class_2168 class_21683 = (class_2168)object2;
        class_5250 class_52503 = class_2561.method_43470((String)option).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1068).method_10958(new class_2558(class_2558.class_2559.field_11750, "/enchantedshulkers " + option)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"commands.enchantedshulkers.refresh").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)))));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(option).setStyle\u2026         ),\n            )");
        this.sendFeedback(class_21683, (class_2561)class_52503);
        Object object3 = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.source");
        class_2168 class_21684 = (class_2168)object3;
        class_5250 class_52504 = class_2561.method_43471((String)("enchantedshulkers.options." + option + ".desc")).method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"translatable(\"$MOD_ID.op\u2026thColor(Formatting.GRAY))");
        this.sendFeedback(class_21684, (class_2561)class_52504);
        Object object4 = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.source");
        class_2168 class_21685 = (class_2168)object4;
        class_5250 class_52505 = class_2561.method_43471((String)"commands.enchantedshulkers.current_value").method_10852((class_2561)class_2561.method_43470((String)(WorldConfig.INSTANCE.getOption(option) + (Intrinsics.areEqual((Object)WorldConfig.INSTANCE.getOption(option), (Object)WorldConfig.INSTANCE.getOptionDefault(option)) ? " (default)" : " (modified)"))).method_10862(class_2583.field_24360.method_10977(WorldConfig.INSTANCE.getBooleanValue(option) ? class_124.field_1060 : class_124.field_1079).method_10982(Boolean.valueOf(true))));
        Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(\"commands.$\u2026         ),\n            )");
        this.sendFeedback(class_21685, (class_2561)class_52505);
        class_5250 optionsText = class_2561.method_43470((String)"[").method_10862(class_2583.field_24360.method_10977(class_124.field_1054));
        for (String suggestion : WorldConfig.INSTANCE.suggestions(option)) {
            optionsText.method_10852(this.makeSetOptionButton(option, suggestion, false));
        }
        optionsText.method_10852((class_2561)class_2561.method_43470((String)" ]"));
        Object object5 = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"context.source");
        class_2168 class_21686 = (class_2168)object5;
        class_5250 class_52506 = class_2561.method_43471((String)"commands.enchantedshulkers.options").method_10852((class_2561)optionsText);
        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"translatable(\"commands.$\u2026ons\").append(optionsText)");
        this.sendFeedback(class_21686, (class_2561)class_52506);
        return 1;
    }

    private final int setOption(CommandContext<class_2168> context) {
        String option = this.optionFromContext(context);
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            WorldConfig.INSTANCE.setOption(option, value);
            Object object = context.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.source");
            class_2168 class_21682 = (class_2168)object;
            Object[] objectArray = new Object[]{option, value};
            class_5250 class_52502 = class_2561.method_43469((String)"commands.enchantedshulkers.set", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\"commands.$\u2026D_ID.set\", option, value)");
            this.sendFeedback(class_21682, (class_2561)class_52502);
        }
        catch (InvalidOptionValueException e) {
            ((class_2168)context.getSource()).method_9213(e.getText());
        }
        return 1;
    }

    private static final boolean register$lambda$0(class_2168 it) {
        return it.method_9259(2);
    }

    private static final CompletableFuture register$lambda$1(CommandContext commandContext, SuggestionsBuilder b) {
        return class_2172.method_9265((Iterable)CollectionsKt.sorted((Iterable)WorldConfig.INSTANCE.getOptions()), (SuggestionsBuilder)b);
    }

    private static final CompletableFuture register$lambda$2(CommandContext ctx, SuggestionsBuilder b) {
        Intrinsics.checkNotNullExpressionValue((Object)ctx, (String)"ctx");
        return class_2172.method_9253((String[])WorldConfig.INSTANCE.suggestions(INSTANCE.optionFromContext((CommandContext<class_2168>)ctx)), (SuggestionsBuilder)b);
    }

    private static final class_2561 sendFeedback$lambda$3(class_2561 $text) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        return $text;
    }
}

