/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.mixin;

import io.github.kosmx.bendylib.ICuboidBuilder;
import io.github.kosmx.bendylib.MutableCuboid;
import io.github.kosmx.bendylib.impl.ICuboid;
import io.github.kosmx.bendylib.impl.accessors.CuboidSideAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_630.class_628.class})
public class CuboidMutator
implements MutableCuboid,
CuboidSideAccessor {
    @Shadow
    @Final
    public float field_3645;
    @Shadow
    @Final
    public float field_3644;
    @Shadow
    @Final
    public float field_3643;
    @Mutable
    @Shadow
    @Final
    private class_630.class_593[] field_3649;
    @Unique
    private HashMap<String, ICuboid> mutators = new HashMap();
    @Unique
    private HashMap<String, ICuboidBuilder> mutatorBuilders = new HashMap();
    @Unique
    private class_630.class_593[] originalQuads;
    @Unique
    private boolean isSidesSwapped = false;
    @Unique
    private ICuboidBuilder.Data partData;
    @Unique
    @Nullable
    private ICuboid activeMutator;
    @Unique
    @Nullable
    private String activeMutatorID;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void constructor(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Set set, CallbackInfo ci) {
        this.partData = new ICuboidBuilder.Data(u, v, this.field_3645, this.field_3644, this.field_3643, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirror, textureWidth, textureHeight);
        this.originalQuads = this.field_3649;
    }

    @Override
    public boolean registerMutator(String name, ICuboidBuilder<ICuboid> builder) {
        if (this.mutatorBuilders.containsKey(name)) {
            return false;
        }
        if (builder == null) {
            throw new NullPointerException("builder can not be null");
        }
        this.mutatorBuilders.put(name, builder);
        return true;
    }

    @Override
    public boolean unregisterMutator(String name) {
        if (this.mutatorBuilders.remove(name) != null) {
            if (name.equals(this.activeMutatorID)) {
                this.activeMutator = null;
                this.activeMutatorID = null;
            }
            this.mutators.remove(name);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public class_3545<String, ICuboid> getActiveMutator() {
        return this.activeMutator == null ? null : new class_3545((Object)this.activeMutatorID, (Object)this.activeMutator);
    }

    @Override
    public boolean hasMutator(String key) {
        return this.mutators.containsKey(key) || this.mutatorBuilders.containsKey(key);
    }

    @Override
    @Nullable
    public ICuboidBuilder<ICuboid> getCuboidBuilder(String key) {
        return this.mutatorBuilders.get(key);
    }

    @Override
    @Nullable
    public ICuboid getMutator(String name) {
        return this.mutators.get(name);
    }

    @Override
    @Nullable
    public ICuboid getAndActivateMutator(@Nullable String name) {
        if (name == null) {
            this.activeMutatorID = null;
            this.activeMutator = null;
            return null;
        }
        if (this.mutatorBuilders.containsKey(name)) {
            if (!this.mutators.containsKey(name)) {
                this.mutators.put(name, (ICuboid)this.mutatorBuilders.get(name).build(this.partData));
            }
            this.activeMutatorID = name;
            this.activeMutator = this.mutators.get(name);
            return this.activeMutator;
        }
        return null;
    }

    @Override
    public void copyStateFrom(MutableCuboid other) {
        if (other.getActiveMutator() == null) {
            this.activeMutator = null;
            this.activeMutatorID = null;
        } else if (this.getAndActivateMutator((String)other.getActiveMutator().method_15442()) != null) {
            this.activeMutator.copyState((ICuboid)other.getActiveMutator().method_15441());
        }
    }

    @Inject(method={"renderCuboid"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderRedirect(class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (this.getActiveMutator() != null) {
            ((ICuboid)this.getActiveMutator().method_15441()).render(entry, vertexConsumer, red, green, blue, alpha, light, overlay);
            if (((ICuboid)this.getActiveMutator().method_15441()).disableAfterDraw()) {
                this.activeMutator = null;
                this.activeMutatorID = null;
            }
            ci.cancel();
        }
    }

    @Override
    public void doSideSwapping() {
        List<class_630.class_593> sides;
        if (this.getActiveMutator() != null && (sides = ((ICuboid)this.getActiveMutator().method_15441()).getQuads()) != null) {
            this.isSidesSwapped = true;
            this.field_3649 = sides.toArray(new class_630.class_593[4]);
        }
    }

    @Override
    public class_630.class_593[] getSides() {
        return this.field_3649;
    }

    @Override
    public void setSides(class_630.class_593[] sides) {
        this.isSidesSwapped = true;
        this.field_3649 = sides;
    }

    @Override
    public void resetSides() {
        this.field_3649 = this.originalQuads;
        this.isSidesSwapped = false;
    }
}

