/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphPacketDistributor;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.common.PolymorphFabricNetwork;
import com.illusivesoulworks.polymorph.common.network.client.CPacketBlockEntityListener;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPersistentRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPlayerRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketStackRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.server.SPacketBlockEntityRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketHighlightRecipe;
import com.illusivesoulworks.polymorph.common.network.server.SPacketPlayerRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketRecipesList;
import java.util.SortedSet;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PolymorphFabricPacketDistributor
implements IPolymorphPacketDistributor {
    @Override
    public void sendPlayerRecipeSelectionC2S(class_2960 resourceLocation) {
        class_2540 buf = PacketByteBufs.create();
        CPacketPlayerRecipeSelection.encode(new CPacketPlayerRecipeSelection(resourceLocation), buf);
        ClientPlayNetworking.send((class_2960)PolymorphFabricNetwork.PLAYER_SELECT, (class_2540)buf);
    }

    @Override
    public void sendPersistentRecipeSelectionC2S(class_2960 resourceLocation) {
        class_2540 buf = PacketByteBufs.create();
        CPacketPersistentRecipeSelection.encode(new CPacketPersistentRecipeSelection(resourceLocation), buf);
        ClientPlayNetworking.send((class_2960)PolymorphFabricNetwork.PERSISTENT_SELECT, (class_2540)buf);
    }

    @Override
    public void sendStackRecipeSelectionC2S(class_2960 resourceLocation) {
        class_2540 buf = PacketByteBufs.create();
        CPacketStackRecipeSelection.encode(new CPacketStackRecipeSelection(resourceLocation), buf);
        ClientPlayNetworking.send((class_2960)PolymorphFabricNetwork.STACK_SELECT, (class_2540)buf);
    }

    @Override
    public void sendRecipesListS2C(class_3222 player) {
        this.sendRecipesListS2C(player, null);
    }

    @Override
    public void sendRecipesListS2C(class_3222 player, SortedSet<IRecipePair> recipesList) {
        this.sendRecipesListS2C(player, recipesList, null);
    }

    @Override
    public void sendRecipesListS2C(class_3222 player, SortedSet<IRecipePair> recipesList, class_2960 selected) {
        class_2540 buf = PacketByteBufs.create();
        SPacketRecipesList.encode(new SPacketRecipesList(recipesList, selected), buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PolymorphFabricNetwork.RECIPES_LIST, (class_2540)buf);
    }

    @Override
    public void sendHighlightRecipeS2C(class_3222 player, class_2960 resourceLocation) {
        class_2540 buf = PacketByteBufs.create();
        SPacketHighlightRecipe.encode(new SPacketHighlightRecipe(resourceLocation), buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PolymorphFabricNetwork.HIGHLIGHT_RECIPE, (class_2540)buf);
    }

    @Override
    public void sendPlayerSyncS2C(class_3222 player, SortedSet<IRecipePair> recipesList, class_2960 selected) {
        class_2540 buf = PacketByteBufs.create();
        SPacketPlayerRecipeSync.encode(new SPacketPlayerRecipeSync(recipesList, selected), buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PolymorphFabricNetwork.RECIPE_SYNC, (class_2540)buf);
    }

    @Override
    public void sendBlockEntitySyncS2C(class_2338 blockPos, class_2960 selected) {
        class_2540 buf = PacketByteBufs.create();
        SPacketBlockEntityRecipeSync.encode(new SPacketBlockEntityRecipeSync(blockPos, selected), buf);
        PolymorphApi.common().getServer().ifPresent(server -> PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)PolymorphFabricNetwork.BLOCK_ENTITY_SYNC, (class_2540)buf)));
    }

    @Override
    public void sendBlockEntityListenerC2S(boolean add) {
        class_2540 buf = PacketByteBufs.create();
        CPacketBlockEntityListener.encode(new CPacketBlockEntityListener(add), buf);
        ClientPlayNetworking.send((class_2960)PolymorphFabricNetwork.BLOCK_ENTITY_LISTENER, (class_2540)buf);
    }
}

