/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.stats.panel.StatsSummaryPanel;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.betterstats.client.gui.panel.PageChooserPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
abstract class BSStatsTab<S extends SUStat<?>>
extends StatsTab {
    @ApiStatus.Internal
    BSStatsTab() {
    }

    @Override
    public final void initFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initDefaultFilters(initContext);
        StatsTabUtils.initShowEmptyStatsFilter(initContext);
        this.initExtraFilters(initContext);
    }

    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
    }

    @Virtual
    protected Predicate<S> getPredicate(StatFilterSettings filterSettings) {
        String sq = (String)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SEARCH, "");
        boolean se = (Boolean)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SHOWEMPTY, false);
        return stat -> stat.matchesSearchQuery(sq) && (se || !stat.isEmpty());
    }

    protected final AtomicInteger getPageFilter(StatFilterSettings filters) {
        class_2960 fid = new class_2960(BetterStats.getModID(), this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH).replace('$', '.') + "_page");
        AtomicInteger f = (AtomicInteger)filters.getPropertyOrDefault(fid, new AtomicInteger(1));
        filters.setProperty(fid, new AtomicInteger[]{f});
        return f;
    }

    @ApiStatus.Internal
    @Nullable
    static StatsSummaryPanel initStatsSummary(TPanelElement panel) {
        if (panel.getChildren().size() < 1) {
            return null;
        }
        TLabelElement lbl = StatsTabUtils.initGroupLabel(panel, (class_2561)TextUtils.literal((String)"\u2190 \u2022 \u2192"));
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        StatsSummaryPanel summary = new StatsSummaryPanel(n1.x, n1.y + 3, n1.width);
        panel.addChild((TElement)summary, false);
        return summary;
    }

    @Virtual
    protected void initPageChooser(StatsTab.StatsInitContext initContext, int totalItemCount, int itemsPerPage) {
        final AtomicInteger filter_page = this.getPageFilter(initContext.getFilterSettings());
        final int filter_maxPages = Math.max((int)Math.ceil((double)totalItemCount / (double)Math.max(itemsPerPage, 1)), 1);
        TPanelElement panel = initContext.getStatsPanel();
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        if (panel.getChildren().size() != 0) {
            n1.y += 3;
        }
        final Runnable triggerRefresh = () -> {
            panel.clearChildren();
            this.initStats(initContext);
        };
        PageChooserPanel pc = new PageChooserPanel(n1.x, n1.y, n1.width, new PageChooserPanel.PageChooserPanelProxy(){

            @Override
            public int getPage() {
                return filter_page.get();
            }

            @Override
            public int getPageCount() {
                return filter_maxPages;
            }

            @Override
            public void setPage(int page) {
                filter_page.set(page);
                triggerRefresh.run();
            }
        });
        panel.addChild((TElement)pc, false);
    }
}

