/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.google.common.collect.ImmutableList;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1422;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractThievesFish<T extends FishData>
extends class_1422
implements ThievesFish<T> {
    private static final class_2940<Boolean> TROPHY = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_FED = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> NO_FLIP = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    protected static final ImmutableList<class_4149<? extends class_4148<? super AbstractThievesFish<?>>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, FOTSensorTypes.NEAREST_MAGMA_BLOCK, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22474, (Object)class_4140.field_18444, (Object)class_4140.field_22357, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object)class_4140.field_28325, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_39408});

    public AbstractThievesFish(class_1299<? extends class_1422> entityType, class_1937 level) {
        super(entityType, level);
        this.method_18382();
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    protected void method_5959() {
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TROPHY, (Object)false);
        this.field_6011.method_12784(HAS_FED, (Object)false);
        this.field_6011.method_12784(NO_FLIP, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("variant", this.getRegistry().method_10221((Object)this.getVariant()).toString());
        compound.method_10556("Trophy", this.isTrophy());
        compound.method_10556("HasFed", this.hasFed());
        compound.method_10556("NoFlip", this.isNoFlip());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        ThievesFish.fixData(compound, this.getDataFix());
        FishData variant = (FishData)this.getRegistry().method_10223(class_2960.method_12829((String)compound.method_10558("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
        this.setTrophy(compound.method_10577("Trophy"));
        this.setHasFed(compound.method_10577("HasFed"));
        this.setNoFlip(compound.method_10577("NoFlip"));
    }

    public void method_6455(class_1799 itemStack) {
        super.method_6455(itemStack);
        this.saveToBucket(itemStack.method_7948());
    }

    public void method_35170(class_2487 compound) {
        super.method_35170(compound);
        this.loadFromBucket(compound);
    }

    public float method_6144(class_2338 blockPos, class_4538 level) {
        if (AbstractThievesFishAi.isPosNearNearestRepellent(this, blockPos)) {
            return -1.0f;
        }
        return super.method_6144(blockPos, level);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed()) {
            if (!this.method_37908().method_8608()) {
                this.growUp(player, itemStack);
            }
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        return this.defaultFinalizeSpawn((class_1309)this, reason, spawnData, dataTag);
    }

    public void method_5674(class_2940<?> key) {
        if (TROPHY.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.field_6011.method_12789(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23716).method_6192((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.field_6011.method_12778(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.field_6011.method_12789(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.field_6011.method_12778(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.field_6011.method_12778(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.field_6011.method_12789(NO_FLIP);
    }

    private void growUp(class_1657 player, class_1799 itemStack) {
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        if (this.field_5974.method_43048(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

