/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.command;

import com.hlysine.create_power_loader.command.EnumArgument;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.hlysine.create_power_loader.content.trains.TrainChunkLoader;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ListLoadersCommand {
    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(cs -> cs.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", EnumArgument.enumArgument(LoaderMode.class)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"active").then(class_2170.method_9247((String)"limit").then(class_2170.method_9244((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(true, true, true))))).executes(ListLoadersCommand.handler(true, false, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(class_2170.method_9247((String)"limit").then(class_2170.method_9244((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(true, true, false))))).executes(ListLoadersCommand.handler(true, false, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"active").then(class_2170.method_9247((String)"limit").then(class_2170.method_9244((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(false, true, true))))).executes(ListLoadersCommand.handler(false, false, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(class_2170.method_9247((String)"limit").then(class_2170.method_9244((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(false, true, false))))).executes(ListLoadersCommand.handler(false, false, false))));
    }

    private static Command<class_2168> handler(boolean hasMode, boolean hasLimit, boolean activeOnly) {
        return ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            ListLoadersCommand.fillReport(source.method_9225(), source.method_9222(), hasMode ? (LoaderMode)((Object)((Object)ctx.getArgument("type", LoaderMode.class))) : null, hasLimit ? (Integer)ctx.getArgument("limit", Integer.class) : 20, activeOnly, (s, f) -> source.method_9226(() -> Components.literal((String)s).method_27694(st -> st.method_36139(f.intValue())), false), c -> source.method_9226(() -> c, false));
            return 1;
        };
    }

    private static void fillReport(class_3218 level, class_243 location, @Nullable LoaderMode mode, int limit, boolean activeOnly, BiConsumer<String, Integer> chat, Consumer<class_2561> chatRaw) {
        int white = class_124.field_1068.method_532();
        int gray = class_124.field_1080.method_532();
        int blue = 13885148;
        int darkBlue = 5854625;
        int orange = 16756064;
        LinkedList<ChunkLoader> loaders = new LinkedList<ChunkLoader>();
        if (mode == null) {
            for (WeakCollection<ChunkLoader> list : ChunkLoadManager.allLoaders.values()) {
                loaders.addAll(list);
            }
        } else {
            loaders.addAll((Collection)ChunkLoadManager.allLoaders.get((Object)mode));
        }
        loaders.removeIf(loader -> {
            if (loader instanceof TrainChunkLoader) {
                TrainChunkLoader trainLoader = (TrainChunkLoader)loader;
                for (CarriageChunkLoader carriageLoader : trainLoader.carriageLoaders) {
                    if (!carriageLoader.known || !carriageLoader.brass && !carriageLoader.andesite) continue;
                    return false;
                }
                return true;
            }
            if (loader instanceof StationChunkLoader) {
                StationChunkLoader stationLoader = (StationChunkLoader)loader;
                return stationLoader.attachments.size() == 0;
            }
            return false;
        });
        if (activeOnly) {
            loaders.removeIf(loader -> loader.getForcedChunks().size() == 0);
        }
        HashMap typeCache = new HashMap();
        MinecraftServer server = level.method_8503();
        Function<class_2960, class_2874> computeType = key -> server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key)).method_8597();
        List<Pair> pairs = loaders.stream().map(loader -> Pair.of((Object)loader, loader.getLocation())).map(pair -> Pair.of((Object)((ChunkLoader)pair.getFirst()), (Object)Pair.of((Object)((class_2960)((Pair)pair.getSecond()).getFirst()), (Object)class_243.method_24953((class_2382)((class_2382)((Pair)pair.getSecond()).getSecond()))))).sorted(Comparator.comparingInt(p -> ((class_2960)((Pair)p.getSecond()).getFirst()).equals((Object)level.method_27983().method_29177()) ? 0 : 1).thenComparingDouble(p -> ((class_243)((Pair)p.getSecond()).getSecond()).method_1021(class_2874.method_31109((class_2874)((class_2874)typeCache.computeIfAbsent((class_2960)((Pair)p.getSecond()).getFirst(), computeType)), (class_2874)level.method_8597())).method_1025(location))).limit(limit).toList();
        chat.accept("", white);
        chat.accept("-+------<< Chunk Loader List >>------+-", white);
        chat.accept(pairs.size() + " out of " + loaders.size() + " nearest" + (activeOnly ? " active" : "") + (String)(mode != null ? " " + mode.method_15434() : "") + " loaders", blue);
        chat.accept("", white);
        for (Pair pair2 : pairs) {
            ChunkLoader loader2 = (ChunkLoader)pair2.getFirst();
            class_2960 dimension = (class_2960)((Pair)pair2.getSecond()).getFirst();
            class_2338 pos = class_2338.method_49638((class_2374)((class_2374)((Pair)pair2.getSecond()).getSecond()));
            chatRaw.accept((class_2561)ListLoadersCommand.text((String)(mode == null ? loader2.getLoaderMode().method_15434() + " - " : ""), white).method_10852((class_2561)ListLoadersCommand.text(loader2.getLoaderType().method_15434() + " - ", orange)).method_10852((class_2561)ListLoadersCommand.text(loader2.getForcedChunks().size() + " chunks", ListLoadersCommand.colorForCount(loader2.getForcedChunks().size()))));
            chatRaw.accept((class_2561)ListLoadersCommand.text("                    \u21b3 ", darkBlue).method_10852((class_2561)ListLoadersCommand.createTpButton(level.method_27983().method_29177(), dimension, pos, darkBlue)));
            if (loader2 instanceof TrainChunkLoader) {
                TrainChunkLoader trainLoader = (TrainChunkLoader)loader2;
                for (int i = 0; i < trainLoader.carriageLoaders.size(); ++i) {
                    CarriageChunkLoader carriageLoader = trainLoader.carriageLoaders.get(i);
                    if (carriageLoader.getForcedChunks().isEmpty()) continue;
                    Pair<class_2960, class_2338> carriageLocation = carriageLoader.getLocation();
                    chatRaw.accept((class_2561)ListLoadersCommand.text("    Carriage " + (i + 1) + " - ", gray).method_10852((class_2561)ListLoadersCommand.text(carriageLoader.getLoaderType().method_15434() + " - ", orange)).method_10852((class_2561)ListLoadersCommand.text(carriageLoader.getForcedChunks().size() + " chunks", ListLoadersCommand.colorForCount(carriageLoader.getForcedChunks().size()))));
                    chatRaw.accept((class_2561)ListLoadersCommand.text("                    \u21b3 ", darkBlue).method_10852((class_2561)ListLoadersCommand.createTpButton(level.method_27983().method_29177(), (class_2960)carriageLocation.getFirst(), (class_2338)carriageLocation.getSecond(), darkBlue)));
                }
                continue;
            }
            if (!(loader2 instanceof StationChunkLoader)) continue;
            StationChunkLoader stationLoader = (StationChunkLoader)loader2;
            for (StationChunkLoader.AttachedLoader attachment : stationLoader.attachments) {
                chatRaw.accept((class_2561)ListLoadersCommand.text("    ", gray).method_10852((class_2561)ListLoadersCommand.text("Attached - ", gray)).method_10852((class_2561)ListLoadersCommand.text(attachment.type().method_15434(), orange)));
                chatRaw.accept((class_2561)ListLoadersCommand.text("                    \u21b3 ", darkBlue).method_10852((class_2561)ListLoadersCommand.createTpButton(level.method_27983().method_29177(), (class_2960)stationLoader.getLocation().getFirst(), attachment.pos(), darkBlue)));
            }
        }
        chat.accept("-+--------------------------------+-", white);
    }

    private static int colorForCount(int count) {
        if (count == 0) {
            return class_124.field_1063.method_532();
        }
        if (count < 5) {
            return class_124.field_1080.method_532();
        }
        if (count < 10) {
            return class_124.field_1054.method_532();
        }
        return class_124.field_1061.method_532();
    }

    private static String shortString(class_2960 location) {
        if (location.method_12836().equals("minecraft")) {
            return location.method_12832();
        }
        return location.toString();
    }

    private static class_5250 text(String text, int color) {
        return Components.literal((String)text).method_27694(style -> style.method_36139(color));
    }

    private static class_5250 createTpButton(class_2960 origin, class_2960 dimension, class_2338 blockPos, int color) {
        String teleport = "/execute in " + dimension.toString() + " run tp @s " + blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260();
        return Components.literal((String)("[" + blockPos.method_23854() + "]" + (String)(!origin.equals((Object)dimension) ? " in " + ListLoadersCommand.shortString(dimension) : ""))).method_27694(style -> style.method_36139(color).method_10958(new class_2558(class_2558.class_2559.field_11750, teleport)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Components.literal((String)"Click to teleport"))).method_10975(teleport));
    }
}

