/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.util.json;

import com.google.gson.JsonArray;
import com.probejs.util.json.IJsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class JArray
implements IJsonBuilder<JsonArray> {
    private final List<IJsonBuilder<?>> members = new ArrayList();

    public static JArray create() {
        return new JArray();
    }

    private JArray() {
    }

    public JArray ifThen(boolean condition, Consumer<JArray> action) {
        if (condition) {
            action.accept(this);
        }
        return this;
    }

    public JArray add(IJsonBuilder<?> member) {
        this.members.add(member);
        return this;
    }

    public JArray addAll(Iterable<IJsonBuilder<?>> members) {
        for (IJsonBuilder<?> member : members) {
            this.members.add(member);
        }
        return this;
    }

    public JArray addAll(Stream<IJsonBuilder<?>> members) {
        members.forEach(this.members::add);
        return this;
    }

    @Override
    public JsonArray serialize() {
        JsonArray array = new JsonArray();
        for (IJsonBuilder<?> member : this.members) {
            array.add(member.serialize());
        }
        return array;
    }

    public String toString() {
        return this.serialize().toString();
    }
}

