/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.rich.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.rich.ImageHelper;
import com.probejs.rich.item.ItemAttribute;
import com.probejs.rich.item.ItemTagAttribute;
import com.probejs.util.json.JArray;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_276;

public class RichItemCompiler {
    public static void compile() throws IOException {
        JArray itemArray = JArray.create().addAll(RegistryInfo.ITEM.entrySet().stream().map(Map.Entry::getValue).map(class_1792::method_7854).map(ItemAttribute::new).map(ItemAttribute::serialize));
        Path richFile = ProbePaths.WORKSPACE_SETTINGS.resolve("item-attributes.json");
        BufferedWriter writer = Files.newBufferedWriter(richFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)itemArray.serialize()));
        writer.close();
        JArray tagArray = JArray.create().addAll(RegistryInfo.ITEM.getVanillaRegistry().method_40272().map(Pair::getFirst).map(ItemTagAttribute::new).map(ItemTagAttribute::serialize));
        Path richTagFile = ProbePaths.WORKSPACE_SETTINGS.resolve("item-tag-attributes.json");
        BufferedWriter tagWriter = Files.newBufferedWriter(richTagFile, new OpenOption[0]);
        tagWriter.write(ProbeJS.GSON.toJson((JsonElement)tagArray.serialize()));
        tagWriter.close();
    }

    public static void render(List<Pair<class_1799, Path>> items) throws IOException {
        class_276 frameBuffer = ImageHelper.init();
        for (Pair<class_1799, Path> pair : items) {
            class_1011 image = ImageHelper.getFromItem((class_1799)pair.getFirst(), frameBuffer);
            image.method_4314((Path)pair.getSecond());
            image.close();
            frameBuffer.method_1230(false);
        }
        frameBuffer.method_1238();
    }

    public static List<Pair<class_1799, Path>> resolve() {
        ArrayList<Pair<class_1799, Path>> items = new ArrayList<Pair<class_1799, Path>>();
        for (class_1799 itemStack : RegistryInfo.ITEM.entrySet().stream().map(Map.Entry::getValue).map(class_1792::method_7854).toList()) {
            String name;
            Path path = ProbePaths.RICH_ITEM.resolve(itemStack.kjs$getIdLocation().method_12836());
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (path.resolve((name = itemStack.kjs$getIdLocation().method_12832().replace("/", "_")) + ".png").toFile().exists()) continue;
            items.add((Pair<class_1799, Path>)Pair.of((Object)itemStack, (Object)path.resolve(name + ".png")));
        }
        return items;
    }
}

