/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.rich.fluid;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.rich.ImageHelper;
import com.probejs.rich.fluid.FluidAttribute;
import com.probejs.util.json.JArray;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_2378;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class RichFluidCompiler {
    public static void compile() throws IOException {
        JArray fluidArray = JArray.create().addAll(RegistryInfo.FLUID.entrySet().stream().map(Map.Entry::getValue).map(FluidAttribute::new).map(FluidAttribute::serialize));
        Path richFile = ProbePaths.WORKSPACE_SETTINGS.resolve("fluid-attributes.json");
        BufferedWriter writer = Files.newBufferedWriter(richFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)fluidArray.serialize()));
        writer.close();
    }

    public static void render(List<Pair<class_3611, Path>> fluids) throws IOException {
        class_276 frameBuffer = ImageHelper.init();
        for (Pair<class_3611, Path> pair : fluids) {
            class_1011 image = ImageHelper.getFromFluid((class_3611)pair.getFirst(), frameBuffer);
            image.method_4314((Path)pair.getSecond());
            image.close();
            frameBuffer.method_1230(false);
        }
        frameBuffer.method_1238();
    }

    public static List<Pair<class_3611, Path>> resolve() {
        ArrayList<Pair<class_3611, Path>> fluids = new ArrayList<Pair<class_3611, Path>>();
        class_2378 registry = RegistryInfo.FLUID.getVanillaRegistry();
        for (class_3611 fluid : registry) {
            String name;
            class_2960 id = registry.method_10221((Object)fluid);
            if (id == null) continue;
            Path path = ProbePaths.RICH_FLUID.resolve(id.method_12836());
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (path.resolve((name = id.method_12832().replace("/", "_")) + ".png").toFile().exists()) continue;
            fluids.add((Pair<class_3611, Path>)Pair.of((Object)fluid, (Object)path.resolve(name + ".png")));
        }
        return fluids;
    }
}

