/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyType;

public class PropertyModify
extends AbstractProperty<PropertyModify> {
    private int ordinal;
    private String name;
    private PropertyType<?> newType;

    public PropertyModify() {
    }

    public PropertyModify(int ordinal, PropertyType<?> newType, String name) {
        this.ordinal = ordinal;
        this.newType = newType;
        this.name = name;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("index", (Number)this.ordinal);
        if (this.newType != null) {
            object.add("newType", (JsonElement)this.newType.serialize());
        }
        if (this.name != null) {
            object.addProperty("name", this.name);
        }
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        this.ordinal = object.get("index").getAsInt();
        if (object.has("newType")) {
            this.newType = (PropertyType)Serde.deserializeProperty(object.get("newType").getAsJsonObject());
        }
        if (object.has("name")) {
            this.name = object.get("name").getAsString();
        }
    }

    @Override
    public PropertyModify copy() {
        return new PropertyModify(this.ordinal, this.newType, this.name);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public PropertyType<?> getNewType() {
        return this.newType;
    }

    public String getName() {
        return this.name;
    }
}

