/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java;

import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.TypeInfoParameterized;
import com.probejs.jdoc.java.type.TypeInfoVariable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Walker {
    private final Set<Class<?>> initial;
    private boolean walkMethod = true;
    private boolean walkField = true;
    private boolean walkSuper = true;
    private boolean walkType = true;

    public Walker(Set<Class<?>> initial) {
        this.initial = initial;
    }

    public void setWalkField(boolean walkField) {
        this.walkField = walkField;
    }

    public void setWalkMethod(boolean walkMethod) {
        this.walkMethod = walkMethod;
    }

    public void setWalkSuper(boolean walkSuper) {
        this.walkSuper = walkSuper;
    }

    public void setWalkType(boolean walkType) {
        this.walkType = walkType;
    }

    private Set<Class<?>> walkType(ITypeInfo type) {
        HashSet result = new HashSet();
        if (type instanceof TypeInfoParameterized) {
            TypeInfoParameterized parType = (TypeInfoParameterized)type;
            if (this.walkType) {
                parType.getParamTypes().forEach(info -> result.addAll(this.walkType((ITypeInfo)info)));
            }
        }
        if (type instanceof TypeInfoVariable) {
            TypeInfoVariable variable = (TypeInfoVariable)type;
            for (ITypeInfo bound : variable.getBounds()) {
                result.add(bound.getResolvedClass());
            }
        } else {
            result.add(type.getResolvedClass());
        }
        result.removeIf(Objects::isNull);
        return result;
    }

    private Set<Class<?>> touch(Set<Class<?>> classes) {
        HashSet result = new HashSet();
        for (Class<?> clazz : classes) {
            ClassInfo info = ClassInfo.getOrCache(clazz);
            if (this.walkSuper) {
                ClassInfo superclass = info.getSuperClass();
                if (superclass != null) {
                    result.add(superclass.getClazzRaw());
                }
                info.getInterfaces().stream().map(ClassInfo::getClazzRaw).forEach(result::add);
            }
            if (this.walkField) {
                info.getFieldInfo().forEach(f -> {
                    Class<?> valueClazz;
                    Object value;
                    result.addAll(this.walkType(f.getType()));
                    if (f.isStatic() && (value = f.getStaticValue()) != null && !(valueClazz = value.getClass()).isAnonymousClass() && !valueClazz.isSynthetic() && !valueClazz.isArray()) {
                        result.add(value.getClass());
                    }
                });
            }
            if (!this.walkMethod) continue;
            info.getMethodInfo().forEach(m -> {
                result.addAll(this.walkType(m.getReturnType()));
                m.getParams().forEach(p -> result.addAll(this.walkType(p.getType())));
            });
        }
        result.removeIf(Objects::isNull);
        return result;
    }

    public Set<Class<?>> walk() {
        HashSet result = new HashSet(this.initial);
        Set<Class<Object>> current = this.touch(result);
        while (!current.isEmpty()) {
            result.addAll(current);
            current = this.touch(current).parallelStream().filter(c -> !result.contains(c)).collect(Collectors.toSet());
        }
        result.removeIf(Class::isSynthetic);
        return result;
    }
}

