/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.probejs.ProbeCommands;
import com.probejs.ProbeConfig;
import com.probejs.repl.EvalManager;
import com.probejs.repl.REPLServer;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ProbeJSEvents {
    public static REPLServer SERVER;
    public static MinecraftServer CURRENT_SERVER;

    private static void computeKubeJSObjectHash(MessageDigest digest) {
        RegistryInfo.MAP.values().stream().flatMap(info -> info.objects.keySet().stream().map(class_2960::toString).map(s -> info.key.method_29177() + "/" + s)).sorted().forEach(key -> digest.update(key.getBytes()));
    }

    private static void computeModHash(Mod mod, MessageDigest digest) {
        String idVersion = mod.getModId() + mod.getVersion();
        digest.update(idVersion.getBytes());
    }

    private static String byte2Hex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void worldCleanup(MinecraftServer server) {
        if (SERVER != null) {
            try {
                SERVER.stop();
                EvalManager.SERVER_SCRIPTS.reset();
                SERVER = null;
                CURRENT_SERVER = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void playerJoined(class_3222 player) {
        if (player.field_13995.method_3724() && player.method_5687(2)) {
            if (ProbeConfig.INSTANCE.enabled && ProbeConfig.INSTANCE.interactive == 1) {
                try {
                    SERVER = new REPLServer(ProbeConfig.INSTANCE.interactivePort);
                    SERVER.start();
                    player.method_43496((class_2561)class_2561.method_43470((String)"ProbeJS Websocket Server started."));
                }
                catch (Exception e) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Failed to start WebSocket server, probably the port is in use."));
                }
                CURRENT_SERVER = player.field_13995;
            }
            if (!ProbeConfig.INSTANCE.shouldProbingAggressive()) {
                return;
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                for (Mod mod : Platform.getMods().stream().sorted(Comparator.comparing(Mod::getModId)).toList()) {
                    ProbeJSEvents.computeModHash(mod, digest);
                }
                ProbeJSEvents.computeKubeJSObjectHash(digest);
                String hash = ProbeJSEvents.byte2Hex(digest.digest());
                if (!hash.equals(ProbeConfig.getModHash())) {
                    ProbeConfig.writeModHash(hash);
                    ProbeConfig.INSTANCE.modChanged = true;
                    player.method_43496((class_2561)class_2561.method_43470((String)"Mod list has changed, dumping new docs..."));
                    ProbeCommands.triggerDump(player);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (ProbeConfig.INSTANCE.firstLoad) {
                player.method_43496((class_2561)class_2561.method_43470((String)"This is the first time you are running ProbeJS. An automatic dump will be triggered."));
                player.method_43496((class_2561)class_2561.method_43470((String)"ProbeJS now supports downloading of recipe schema scripts. These scripts are for adding recipe support for mods that don't have recipe support yet."));
                player.method_43496((class_2561)class_2561.method_43470((String)"To configure ProbeJS, open ").method_10852((class_2561)class_2561.method_43470((String)"this file").kjs$underlined().kjs$aqua().kjs$clickOpenFile(KubeJSPaths.CONFIG.resolve("probejs.json").toString())).method_10852((class_2561)class_2561.method_43470((String)".")));
                ProbeConfig.INSTANCE.noAggressiveProbing = true;
                ProbeConfig.INSTANCE.firstLoad = false;
                if (Platform.getMods().size() > 350) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"There are more than 350 mods installed. Disabling some features to prevent lag..."));
                    ProbeConfig.INSTANCE.disableRecipeJsonDump = true;
                    player.method_43496((class_2561)class_2561.method_43470((String)"Recipe JSON dumps are disabled."));
                }
                ProbeConfig.INSTANCE.save();
            } else {
                player.method_43496((class_2561)class_2561.method_43470((String)"Aggressive probing is on. Remember to disable it in release!").kjs$red().kjs$underlined());
                player.method_43496((class_2561)class_2561.method_43470((String)"Use ").method_10852((class_2561)class_2561.method_43470((String)"/probejs configure toggle_aggressive").kjs$underlined().kjs$green().kjs$clickSuggestCommand("/probejs configure toggle_aggressive")).method_10852((class_2561)class_2561.method_43470((String)" to disable.").kjs$white()));
            }
        }
    }
}

