/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.buffer.TrackBuffer;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.fuel.LiquidFuelTrainHandler;
import com.railwayteam.railways.mixin.AccessorNavigation;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain;
import com.railwayteam.railways.mixin_interfaces.ICrashAdvancement;
import com.railwayteam.railways.mixin_interfaces.IFuelInventory;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.mixin_interfaces.IOccupiedCouplers;
import com.railwayteam.railways.mixin_interfaces.IStrictSignalTrain;
import com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Train.class}, remap=false)
public abstract class MixinTrain
implements IOccupiedCouplers,
IIndexedSchedule,
IHandcarTrain,
IStrictSignalTrain,
IBufferBlockedTrain,
ICrashAdvancement {
    @Shadow
    public TrackGraph graph;
    @Shadow
    public Navigation navigation;
    @Shadow
    public List<Carriage> carriages;
    @Shadow
    public boolean invalid;
    @Shadow
    public double speed;
    @Shadow
    public int fuelTicks;
    @Shadow
    public class_1657 backwardsDriver;
    @Unique
    public Set<UUID> railways$occupiedCouplers;
    @Unique
    protected int railways$index = 0;
    @Unique
    protected boolean railways$isHandcar = false;
    @Unique
    protected boolean railways$isStrictSignalTrain = false;
    @Unique
    protected int railways$controlBlockedTicks = -1;
    @Unique
    protected int railways$controlBlockedSign = 0;

    @Shadow
    public abstract void arriveAt(GlobalStation var1);

    @Override
    public boolean railways$isControlBlocked() {
        return this.railways$controlBlockedTicks > 0;
    }

    @Override
    public void railways$setControlBlocked(boolean controlBlocked, boolean forceBackwards) {
        this.railways$controlBlockedTicks = controlBlocked ? 3 : -1;
        this.railways$controlBlockedSign = forceBackwards ? -1 : class_3532.method_17822((double)this.speed);
    }

    @Override
    public int railways$getBlockedSign() {
        return this.railways$controlBlockedSign;
    }

    @Override
    public void railways$setStrictSignals(boolean strictSignals) {
        this.railways$isStrictSignalTrain = strictSignals;
    }

    @Override
    public boolean railways$isHandcar() {
        return this.railways$isHandcar;
    }

    @Override
    public void railways$setHandcar(boolean handcar) {
        this.railways$isHandcar = handcar;
    }

    @Override
    public int railways$getIndex() {
        return this.railways$index;
    }

    @Override
    public void railways$setIndex(int index) {
        this.railways$index = index;
    }

    @Override
    public Set<UUID> railways$getOccupiedCouplers() {
        return this.railways$occupiedCouplers;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initCouplers(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded, CallbackInfo ci) {
        this.railways$occupiedCouplers = new HashSet<UUID>();
    }

    @Inject(method={"earlyTick"}, at={@At(value="HEAD")})
    private void killEmptyTrains(class_1937 level, CallbackInfo ci) {
        if (this.carriages.isEmpty()) {
            this.invalid = true;
        }
        if (this.railways$controlBlockedTicks > 0) {
            --this.railways$controlBlockedTicks;
        }
    }

    @Inject(method={"earlyTick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;addToSignalGroups(Ljava/util/Collection;)V", ordinal=2)})
    private void tickOccupiedCouplers(class_1937 level, CallbackInfo ci) {
        for (UUID uuid : this.railways$occupiedCouplers) {
            TrackCoupler coupler = (TrackCoupler)this.graph.getPoint(CREdgePointTypes.COUPLER, uuid);
            if (coupler == null) continue;
            coupler.keepAlive((Train)this);
        }
    }

    @Inject(method={"frontSignalListener"}, at={@At(value="RETURN")}, cancellable=true)
    private void frontCouplerListener(CallbackInfoReturnable<TravellingPoint.IEdgePointListener> cir) {
        TravellingPoint.IEdgePointListener originalListener = (TravellingPoint.IEdgePointListener)cir.getReturnValue();
        cir.setReturnValue((distance, couple) -> {
            SignalBoundary signal;
            UUID groupId;
            SignalEdgeGroup signalEdgeGroup;
            Object patt6945$temp;
            Object patt6354$temp;
            Object patt5926$temp = couple.getFirst();
            if (patt5926$temp instanceof TrackCoupler) {
                TrackCoupler trackCoupler = (TrackCoupler)((Object)((Object)patt5926$temp));
                this.railways$occupiedCouplers.add(trackCoupler.getId());
                return false;
            }
            if (couple.getFirst() instanceof TrackBuffer) {
                this.speed = 0.0;
                return true;
            }
            if (((IWaypointableNavigation)this.navigation).railways$isWaypointMode() && (patt6354$temp = couple.getFirst()) instanceof GlobalStation) {
                GlobalStation station = (GlobalStation)patt6354$temp;
                if (!station.canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) || this.navigation.destination != station) {
                    return false;
                }
                this.navigation.distanceToDestination = 0.0;
                ((AccessorNavigation)this.navigation).getCurrentPath().clear();
                this.arriveAt(this.navigation.destination);
                this.navigation.destination = null;
                return true;
            }
            if (this.railways$isStrictSignalTrain && (patt6945$temp = couple.getFirst()) instanceof SignalBoundary && (signalEdgeGroup = (SignalEdgeGroup)Create.RAILWAYS.signalEdgeGroups.get(groupId = (signal = (SignalBoundary)patt6945$temp).getGroup((TrackNode)((Couple)couple.getSecond()).getSecond()))) != null && signalEdgeGroup.isOccupiedUnless((Train)this)) {
                return true;
            }
            return originalListener.test(distance, couple);
        });
    }

    @Inject(method={"lambda$backSignalListener$12", "lambda$backSignalListener$10"}, at={@At(value="HEAD")}, cancellable=true)
    private void backCouplerListener(Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TrackCoupler) {
            TrackCoupler coupler = (TrackCoupler)((Object)object);
            this.railways$occupiedCouplers.remove(coupler.getId());
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"collectInitiallyOccupiedSignalBlocks"}, at={@At(value="INVOKE", target="Ljava/util/Set;clear()V", ordinal=0)})
    private void clearOccupiedCouplers(CallbackInfo ci) {
        this.railways$occupiedCouplers.clear();
    }

    @Inject(method={"lambda$collectInitiallyOccupiedSignalBlocks$20", "lambda$collectInitiallyOccupiedSignalBlocks$18"}, at={@At(value="HEAD")}, cancellable=true)
    private void reAddOccupiedCouplers(MutableObject<UUID> prevGroup, Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TrackCoupler) {
            TrackCoupler coupler = (TrackCoupler)((Object)object);
            this.railways$occupiedCouplers.add(coupler.getId());
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeOccupiedCouplers(DimensionPalette dimensions, CallbackInfoReturnable<class_2487> cir) {
        class_2487 tag = (class_2487)cir.getReturnValue();
        tag.method_10566("OccupiedCouplers", (class_2520)NBTHelper.writeCompoundList(this.railways$occupiedCouplers, uid -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_25927("Id", uid);
            return compoundTag;
        }));
        tag.method_10569("ScheduleHolderIndex", this.railways$index);
        tag.method_10556("IsHandcar", this.railways$isHandcar);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void readOccupiedCouplers(class_2487 tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions, CallbackInfoReturnable<Train> cir, UUID id, UUID owner, UUID graphId, TrackGraph graph, List<Carriage> carriages, List<Double> carriageSpacing, boolean doubleEnded, Train train) {
        NBTHelper.iterateCompoundList((class_2499)tag.method_10554("OccupiedCouplers", 10), c -> ((IOccupiedCouplers)train).railways$getOccupiedCouplers().add(c.method_25926("Id")));
        ((IIndexedSchedule)train).railways$setIndex(tag.method_10550("ScheduleHolderIndex"));
        ((IHandcarTrain)train).railways$setHandcar(tag.method_10577("IsHandcar"));
    }

    @Inject(method={"collideWithOtherTrains"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;crash()V", ordinal=0)}, cancellable=true)
    private void railways$handcarCollision(class_1937 level, Carriage carriage, CallbackInfo ci, @Local(name={"train"}) Train train, @Local Pair<Train, class_243> collision) {
        class_243 v = (class_243)collision.getSecond();
        if (this.railways$isHandcar()) {
            if (!this.invalid) {
                TrainUtils.discardTrain((Train)this);
                class_1264.method_5449((class_1937)level, (double)v.field_1352, (double)v.field_1351, (double)v.field_1350, (class_1799)CRBlocks.HANDCAR.asStack());
            }
            this.railways$awardCrashAdvancements();
            ci.cancel();
        }
        if (((IHandcarTrain)train).railways$isHandcar()) {
            if (!train.invalid) {
                TrainUtils.discardTrain(train);
                class_1264.method_5449((class_1937)level, (double)v.field_1352, (double)v.field_1351, (double)v.field_1350, (class_1799)CRBlocks.HANDCAR.asStack());
            }
            ((ICrashAdvancement)train).railways$awardCrashAdvancements();
            ci.cancel();
        }
    }

    @Inject(method={"burnFuel"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", shift=At.Shift.AFTER)})
    private void railways$fluidFuelsSystem(CallbackInfo ci) {
        boolean iterateFromBack = this.speed < 0.0;
        int carriageCount = this.carriages.size();
        for (int index = 0; index < carriageCount; ++index) {
            int i = iterateFromBack ? carriageCount - 1 - index : index;
            Carriage carriage = this.carriages.get(i);
            CombinedTankWrapper fuelFluids = ((IFuelInventory)carriage.storage).railways$getFuelFluids();
            if (fuelFluids == null) continue;
            this.fuelTicks += LiquidFuelTrainHandler.handleFuelDraining(fuelFluids);
        }
    }

    @Inject(method={"maxSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void maxSpeed(CallbackInfoReturnable<Float> cir) {
        if (this.railways$isHandcar) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * 0.5f));
        } else if (((Boolean)CRConfigs.server().realism.realisticTrains.get()).booleanValue() && this.fuelTicks <= 0) {
            cir.setReturnValue((Object)Float.valueOf(AllConfigs.server().trains.trainTopSpeed.getF() / 400.0f));
        }
    }

    @Inject(method={"maxTurnSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void maxTurnSpeed(CallbackInfoReturnable<Float> cir) {
        if (this.railways$isHandcar) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * 0.75f));
        } else if (((Boolean)CRConfigs.server().realism.realisticTrains.get()).booleanValue() && this.fuelTicks <= 0) {
            cir.setReturnValue((Object)Float.valueOf(AllConfigs.server().trains.trainTurningTopSpeed.getF() / 400.0f));
        }
    }

    @Inject(method={"acceleration"}, at={@At(value="HEAD")}, cancellable=true)
    public void acceleration(CallbackInfoReturnable<Float> cir) {
        if (!this.railways$isHandcar && ((Boolean)CRConfigs.server().realism.realisticTrains.get()).booleanValue() && this.fuelTicks <= 0) {
            cir.setReturnValue((Object)Float.valueOf(AllConfigs.server().trains.trainAcceleration.getF() / 8000.0f));
        }
    }

    @Override
    public void railways$awardCrashAdvancements() {
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.method_5736().forEach(entity -> {
                if (!(entity instanceof class_1657)) {
                    return;
                }
                class_1657 p = (class_1657)entity;
                Optional controllingPlayer = e.getControllingPlayer();
                if (controllingPlayer.isPresent() && ((UUID)controllingPlayer.get()).equals(p.method_5667())) {
                    return;
                }
                AllAdvancements.TRAIN_CRASH.awardTo(p);
            }));
        }
        if (this.backwardsDriver != null) {
            AllAdvancements.TRAIN_CRASH_BACKWARDS.awardTo(this.backwardsDriver);
        }
    }
}

