/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.status.playerstate;

import de.maxhenkel.status.Status;
import de.maxhenkel.status.events.PlayerEvents;
import de.maxhenkel.status.net.NetManager;
import de.maxhenkel.status.net.PlayerStatePacket;
import de.maxhenkel.status.net.PlayerStatesPacket;
import de.maxhenkel.status.playerstate.PlayerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.server.MinecraftServer;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();

    public PlayerStateManager() {
        PlayerEvents.PLAYER_LOGGED_OUT.register(this::removePlayer);
        PlayerEvents.PLAYER_LOGGED_IN.register(this::notifyPlayer);
        PlayerEvents.PLAYER_SLEEP.register(this::onSleep);
        NetManager.registerServerReceiver(PlayerStatePacket.class, (server, player, handler, responseSender, packet) -> {
            PlayerState state = packet.getPlayerState();
            state.setPlayer(player.method_5667());
            this.states.put(player.method_5667(), state);
            this.broadcastState(server, state);
        });
    }

    private void onSleep(class_3222 player) {
        List<class_3222> noSleepPlayers = this.getNoSleepPlayers(player.field_13995);
        if (noSleepPlayers.isEmpty()) {
            return;
        }
        player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)Status.SERVER_CONFIG.noSleepTitle.get())));
        if (noSleepPlayers.size() > 1) {
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)Status.SERVER_CONFIG.noSleepMultipleSubtitle.get())));
        } else {
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)String.format(Status.SERVER_CONFIG.noSleepPlayerSubtitle.get(), noSleepPlayers.get(0).method_5476().getString()))));
        }
    }

    private List<class_3222> getNoSleepPlayers(MinecraftServer server) {
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (Map.Entry<UUID, PlayerState> entry : this.states.entrySet()) {
            class_3222 player;
            if (!entry.getValue().isNoSleep() || (player = server.method_3760().method_14602(entry.getKey())) == null) continue;
            players.add(player);
        }
        return players;
    }

    private void broadcastState(MinecraftServer server, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        server.method_3760().method_14571().forEach(p -> NetManager.sendToClient(p, packet));
    }

    private void notifyPlayer(class_3222 player) {
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        this.broadcastState(player.field_13995, new PlayerState(player.method_5667()));
    }

    private void removePlayer(class_3222 player) {
        this.states.remove(player.method_5667());
        this.broadcastState(player.field_13995, new PlayerState(player.method_5667()));
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

