/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import com.google.common.base.Strings;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketNameSync
extends PacketBase {
    private UUID uuid;
    private String teamID;
    private String name;

    public PacketNameSync() {
    }

    public PacketNameSync(UUID uuid, String name) {
        this.uuid = uuid;
        this.teamID = null;
        this.name = name;
    }

    public PacketNameSync(String teamID, String name) {
        this.uuid = null;
        this.teamID = teamID;
        this.name = name;
    }

    @Override
    public void toBytes(class_2540 buffer) {
        if (this.uuid != null) {
            buffer.writeBoolean(true);
            PacketNameSync.writeString(buffer, this.uuid.toString());
        } else {
            buffer.writeBoolean(false);
            PacketNameSync.writeString(buffer, this.teamID);
        }
        PacketNameSync.writeString(buffer, this.name);
    }

    @Override
    public void fromBytes(class_2540 buffer) {
        if (buffer.readBoolean()) {
            try {
                this.uuid = UUID.fromString(PacketNameSync.readString(buffer));
            }
            catch (Exception exception) {}
        } else {
            this.teamID = PacketNameSync.readString(buffer);
        }
        this.name = PacketNameSync.readString(buffer);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handleClientSide(class_310 client, class_746 player) {
        if (!Strings.isNullOrEmpty((String)this.name)) {
            if (this.uuid != null) {
                NameHelper.setPlayerName(this.uuid, this.name);
            } else if (!Strings.isNullOrEmpty((String)this.teamID)) {
                NameHelper.setTeamName(this.teamID, this.name);
            }
        }
    }

    @Override
    public void handleServerSide(MinecraftServer server, class_3222 player) {
        if (this.uuid != null) {
            String display = NameHelper.getLastKnownUsername(server, this.uuid);
            if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                NetworkHandler.sendToPlayer(new PacketNameSync(this.uuid, display), player);
            }
        } else if (!Strings.isNullOrEmpty((String)this.teamID)) {
            String display = NameHelper.getLastKnownTeamName(this.teamID, true);
            if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                NetworkHandler.sendToPlayer(new PacketNameSync(this.teamID, display), player);
            }
        }
    }
}

