/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.map;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.class_1921;
import team.creative.creativecore.common.util.type.itr.ComputeNextIterator;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.list.Tuple;

public class ChunkLayerMap<T>
implements Iterable<T> {
    private static final int LAYERS_COUNT = class_1921.method_22720().size();
    private static final Object2IntMap<class_1921> LAYERS_INDEX_MAP = new Object2IntArrayMap();
    private final T[] content;

    public ChunkLayerMap(ChunkLayerMap<T> map) {
        this.content = Arrays.copyOf(map.content, LAYERS_COUNT);
    }

    public ChunkLayerMap(Function<class_1921, T> factory) {
        this.content = new Object[LAYERS_COUNT];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = factory.apply((class_1921)class_1921.method_22720().get(i));
        }
    }

    public ChunkLayerMap() {
        this.content = new Object[LAYERS_COUNT];
    }

    private int index(class_1921 layer) {
        return LAYERS_INDEX_MAP.getInt((Object)layer);
    }

    public T get(class_1921 layer) {
        return this.content[this.index(layer)];
    }

    public T put(class_1921 layer, T element) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = element;
        return result;
    }

    public T remove(class_1921 layer) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = null;
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = null;
        }
    }

    public Iterable<Tuple<class_1921, T>> tuples() {
        return new ComputeNextIterator<Tuple<class_1921, T>>(){
            private int index;
            private Tuple<class_1921, T> pair = new Tuple<Object, Object>(null, null);

            @Override
            protected Tuple<class_1921, T> computeNext() {
                while (this.index < ChunkLayerMap.this.content.length && ChunkLayerMap.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMap.this.content.length) {
                    return (Tuple)this.end();
                }
                this.pair.key = class_1921.method_22720().get(this.index);
                this.pair.value = ChunkLayerMap.this.content[this.index];
                ++this.index;
                return this.pair;
            }
        };
    }

    public boolean containsKey(class_1921 layer) {
        return this.get(layer) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new ComputeNextIterator<T>(){
            private int index;

            @Override
            protected T computeNext() {
                while (this.index < ChunkLayerMap.this.content.length && ChunkLayerMap.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMap.this.content.length) {
                    return this.end();
                }
                Object result = ChunkLayerMap.this.content[this.index];
                ++this.index;
                return result;
            }
        };
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content == null) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[" + String.join((CharSequence)",", () -> new FunctionIterator<CharSequence>(this, x -> x.toString())) + "]";
    }

    static {
        int i = 0;
        for (class_1921 layer : class_1921.method_22720()) {
            LAYERS_INDEX_MAP.put((Object)layer, i);
            ++i;
        }
    }
}

