/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioConverter;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.PlayerManager;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;

public class AudioManager {
    public static class_5218 AUDIO_DATA = new class_5218("audio_player_data");

    public static short[] getSound(MinecraftServer server, UUID id) throws Exception {
        return AudioPlayer.AUDIO_CACHE.get(id, () -> AudioConverter.convert(AudioManager.getExistingSoundFile(server, id)));
    }

    public static Path getSoundFile(MinecraftServer server, UUID id, String extension) {
        return AudioManager.getAudioDataFolder(server).resolve(id.toString() + "." + extension);
    }

    public static Path getAudioDataFolder(MinecraftServer server) {
        return server.method_27050(AUDIO_DATA);
    }

    public static Path getExistingSoundFile(MinecraftServer server, UUID id) throws FileNotFoundException {
        Path file = AudioManager.getSoundFile(server, id, AudioConverter.AudioType.MP3.getExtension());
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        file = AudioManager.getSoundFile(server, id, AudioConverter.AudioType.WAV.getExtension());
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        throw new FileNotFoundException("Audio does not exist");
    }

    public static Path getUploadFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("audioplayer_uploads");
    }

    public static void saveSound(MinecraftServer server, UUID id, String url) throws UnsupportedAudioFileException, IOException {
        byte[] data = AudioManager.download(new URL(url), AudioPlayer.SERVER_CONFIG.maxUploadSize.get());
        AudioConverter.AudioType audioType = AudioConverter.getAudioType(data);
        AudioManager.checkExtensionAllowed(audioType);
        Path soundFile = AudioManager.getSoundFile(server, id, audioType.getExtension());
        if (Files.exists(soundFile, new LinkOption[0])) {
            throw new FileAlreadyExistsException("This audio already exists");
        }
        Files.createDirectories(soundFile.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(soundFile, new OpenOption[0]);){
            IOUtils.write((byte[])data, (OutputStream)outputStream);
        }
        FileNameManager.instance().ifPresent(mgr -> mgr.addFileName(id, FileNameManager.getFileNameFromUrl(url)));
    }

    public static void saveSound(MinecraftServer server, UUID id, Path file) throws UnsupportedAudioFileException, IOException {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0])) {
            throw new NoSuchFileException("The file %s does not exist".formatted(file.toString()));
        }
        long size = Files.size(file);
        if (size > AudioPlayer.SERVER_CONFIG.maxUploadSize.get()) {
            throw new IOException("Maximum file size exceeded (%sMB>%sMB)".formatted(Math.round((float)size / 1000000.0f), Math.round(AudioPlayer.SERVER_CONFIG.maxUploadSize.get().floatValue() / 1000000.0f)));
        }
        AudioConverter.AudioType audioType = AudioConverter.getAudioType(file);
        AudioManager.checkExtensionAllowed(audioType);
        Path soundFile = AudioManager.getSoundFile(server, id, audioType.getExtension());
        if (Files.exists(soundFile, new LinkOption[0])) {
            throw new FileAlreadyExistsException("This audio already exists");
        }
        Files.createDirectories(soundFile.getParent(), new FileAttribute[0]);
        Files.move(file, soundFile, new CopyOption[0]);
        FileNameManager.instance().ifPresent(mgr -> mgr.addFileName(id, FileNameManager.getFileNameFromPath(file)));
    }

    public static void checkExtensionAllowed(@Nullable AudioConverter.AudioType audioType) throws UnsupportedAudioFileException {
        if (audioType == null) {
            throw new UnsupportedAudioFileException("Unsupported audio format");
        }
        if (audioType.equals((Object)AudioConverter.AudioType.MP3) && !AudioPlayer.SERVER_CONFIG.allowMp3Upload.get().booleanValue()) {
            throw new UnsupportedAudioFileException("Uploading mp3 files is not allowed on this server");
        }
        if (audioType.equals((Object)AudioConverter.AudioType.WAV) && !AudioPlayer.SERVER_CONFIG.allowWavUpload.get().booleanValue()) {
            throw new UnsupportedAudioFileException("Uploading wav files is not allowed on this server");
        }
    }

    private static byte[] download(URL url, long limit) throws IOException {
        int nRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(url.openStream());
        byte[] data = new byte[32768];
        while ((nRead = bis.read(data, 0, data.length)) != -1) {
            bos.write(data, 0, nRead);
            if ((long)bos.size() <= limit) continue;
            bis.close();
            throw new IOException("Maximum file size of %sMB exceeded".formatted((int)((float)limit / 1000000.0f)));
        }
        bis.close();
        return bos.toByteArray();
    }

    @Nullable
    public static UUID play(class_3218 level, class_2338 pos, PlayerType type, CustomSound sound, @Nullable class_1657 player) {
        UUID channelID;
        float range = sound.getRange(type);
        VoicechatServerApi api = Plugin.voicechatServerApi;
        if (api == null) {
            return null;
        }
        if (type.equals((Object)PlayerType.GOAT_HORN)) {
            class_3222 p;
            class_243 playerPos = player == null ? new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) : player.method_19538();
            channelID = PlayerManager.instance().playLocational(api, level, playerPos, sound.getSoundId(), player instanceof class_3222 ? (p = (class_3222)player) : null, range, type.getCategory(), type.getMaxDuration().get());
        } else {
            class_3222 p;
            channelID = sound.isStaticSound() && AudioPlayer.SERVER_CONFIG.allowStaticAudio.get() != false ? PlayerManager.instance().playStatic(api, level, new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), sound.getSoundId(), player instanceof class_3222 ? (p = (class_3222)player) : null, range, type.getCategory(), type.getMaxDuration().get()) : PlayerManager.instance().playLocational(api, level, new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), sound.getSoundId(), player instanceof class_3222 ? (p = (class_3222)player) : null, range, type.getCategory(), type.getMaxDuration().get());
        }
        return channelID;
    }

    public static float getLengthSeconds(short[] audio) {
        return (float)audio.length / AudioConverter.FORMAT.getSampleRate();
    }
}

