/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.voicechat.api.mp3.Mp3Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioConverter {
    private static final byte[][] MP3_MAGIC_BYTES = new byte[][]{{-1, -5}, {-1, -13}, {-1, -14}, {73, 68, 51}};
    public static AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);

    @Nullable
    public static AudioType getAudioType(byte[] data) throws UnsupportedAudioFileException, IOException {
        if (AudioConverter.hasMp3MagicBytes(data)) {
            return AudioType.MP3;
        }
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(data));
        if (AudioConverter.isWav(audioInputStream.getFormat())) {
            return AudioType.WAV;
        }
        return null;
    }

    @Nullable
    public static AudioType getAudioType(Path path) throws UnsupportedAudioFileException, IOException {
        block9: {
            if (AudioType.WAV.isValidFileName(path)) {
                try (AudioInputStream ais = AudioSystem.getAudioInputStream(path.toFile());){
                    if (AudioConverter.isWav(ais.getFormat())) {
                        AudioType audioType = AudioType.WAV;
                        return audioType;
                    }
                    break block9;
                }
            }
            if (AudioType.MP3.isValidFileName(path) && AudioConverter.isMp3File(path)) {
                return AudioType.MP3;
            }
        }
        return null;
    }

    public static boolean isWav(AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_FLOAT) || encoding.equals(AudioFormat.Encoding.ALAW) || encoding.equals(AudioFormat.Encoding.ULAW);
    }

    public static short[] convert(Path file) throws IOException, UnsupportedAudioFileException {
        return AudioConverter.convert(file, AudioConverter.getAudioType(file));
    }

    public static short[] convert(Path file, AudioType audioType) throws IOException, UnsupportedAudioFileException {
        if (audioType == AudioType.WAV) {
            return AudioConverter.convertWav(file);
        }
        if (audioType == AudioType.MP3) {
            return AudioConverter.convertMp3(file);
        }
        throw new UnsupportedAudioFileException("Unsupported audio type");
    }

    public static short[] convertWav(Path file) throws IOException, UnsupportedAudioFileException {
        try (AudioInputStream source = AudioSystem.getAudioInputStream(file.toFile());){
            short[] sArray = AudioConverter.convert(source);
            return sArray;
        }
    }

    private static short[] convert(AudioInputStream source) throws IOException {
        AudioFormat sourceFormat = source.getFormat();
        AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
        AudioInputStream stream1 = AudioSystem.getAudioInputStream(convertFormat, source);
        AudioInputStream stream2 = AudioSystem.getAudioInputStream(FORMAT, stream1);
        return Plugin.voicechatApi.getAudioConverter().bytesToShorts(stream2.readAllBytes());
    }

    public static short[] convertMp3(Path file) throws IOException, UnsupportedAudioFileException {
        try {
            Mp3Decoder mp3Decoder = Plugin.voicechatApi.createMp3Decoder(Files.newInputStream(file, new OpenOption[0]));
            if (mp3Decoder == null) {
                throw new IOException("Error creating mp3 decoder");
            }
            byte[] data = Plugin.voicechatApi.getAudioConverter().shortsToBytes(mp3Decoder.decode());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            AudioFormat audioFormat = mp3Decoder.getAudioFormat();
            AudioInputStream source = new AudioInputStream(byteArrayInputStream, audioFormat, data.length / audioFormat.getFrameSize());
            return AudioConverter.convert(source);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.warn("Error converting mp3 file with native decoder");
            return AudioConverter.convert(AudioSystem.getAudioInputStream(file.toFile()));
        }
    }

    public static boolean isMp3File(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl = AudioConverter.hasMp3MagicBytes(is.readNBytes(3));
            return bl;
        }
    }

    private static boolean hasMp3MagicBytes(byte[] data) {
        for (byte[] magicBytes : MP3_MAGIC_BYTES) {
            if (data.length < magicBytes.length) {
                return false;
            }
            boolean valid = true;
            for (int i = 0; i < magicBytes.length; ++i) {
                if (data[i] == magicBytes[i]) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public static enum AudioType {
        MP3("mp3"),
        WAV("wav");

        private final String extension;

        private AudioType(String fileName) {
            this.extension = fileName;
        }

        public boolean isValidFileName(Path path) {
            return path.toString().toLowerCase().endsWith(".%s".formatted(this.extension));
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

