/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public enum WarpMode {
    INVENTORY_BUTTON(() -> WaystonesConfig.getActive().xpCost.inventoryButtonXpCostMultiplier, WarpMode::waystoneIsActivatedOrNamed, false),
    WARP_SCROLL(() -> 0.0, WarpMode::waystoneIsActivated, true),
    RETURN_SCROLL(() -> 0.0, WarpMode::waystoneIsActivated, true),
    BOUND_SCROLL(() -> 0.0, WarpMode::always, true),
    WARP_STONE(() -> WaystonesConfig.getActive().xpCost.warpStoneXpCostMultiplier, WarpMode::waystoneIsActivated, false),
    WAYSTONE_TO_WAYSTONE(() -> WaystonesConfig.getActive().xpCost.waystoneXpCostMultiplier, WarpMode::waystoneIsActivated, false),
    SHARESTONE_TO_SHARESTONE(() -> WaystonesConfig.getActive().xpCost.sharestoneXpCostMultiplier, WarpMode::sharestonesOnly, false),
    WARP_PLATE(() -> WaystonesConfig.getActive().xpCost.warpPlateXpCostMultiplier, WarpMode::warpPlatesOnly, false),
    PORTSTONE_TO_WAYSTONE(() -> WaystonesConfig.getActive().xpCost.portstoneXpCostMultiplier, WarpMode::waystoneIsActivated, false),
    CUSTOM(() -> 0.0, WarpMode::always, false);

    public static WarpMode[] values;
    private final Supplier<Double> xpCostMultiplierSupplier;
    private final BiPredicate<class_1297, IWaystone> allowTeleportPredicate;
    private final boolean consumesItem;

    private WarpMode(Supplier<Double> xpCostMultiplierSupplier, BiPredicate<class_1297, IWaystone> allowTeleportPredicate, boolean consumesItem) {
        this.xpCostMultiplierSupplier = xpCostMultiplierSupplier;
        this.allowTeleportPredicate = allowTeleportPredicate;
        this.consumesItem = consumesItem;
    }

    public double getXpCostMultiplier() {
        return this.xpCostMultiplierSupplier.get();
    }

    public boolean consumesItem() {
        return this.consumesItem;
    }

    private static boolean always(class_1297 player, IWaystone waystone) {
        return true;
    }

    private static boolean waystoneIsActivatedOrNamed(class_1297 player, IWaystone waystone) {
        return WaystonesConfig.getActive().getInventoryButtonMode().hasNamedTarget() || waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) && player instanceof class_1657 && PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone);
    }

    private static boolean waystoneIsActivated(class_1297 player, IWaystone waystone) {
        return waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) && player instanceof class_1657 && PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone);
    }

    private static boolean sharestonesOnly(class_1297 player, IWaystone waystone) {
        return WaystoneTypes.isSharestone(waystone.getWaystoneType());
    }

    private static boolean warpPlatesOnly(class_1297 player, IWaystone waystone) {
        return waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE);
    }

    public BiPredicate<class_1297, IWaystone> getAllowTeleportPredicate() {
        return this.allowTeleportPredicate;
    }

    static {
        values = WarpMode.values();
    }
}

